/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.certificates;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.email.configuration.EmailConfiguration;
import com.suncode.pwfl.administration.email.configuration.EmailConfigurationService;
import com.suncode.pwfl.administration.user.Domain;
import com.suncode.pwfl.administration.user.DomainService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.certificates.CertificateService;
import com.suncode.pwfl.certificates.exceptions.CertificateBaseException;
import com.suncode.pwfl.certificates.exceptions.CertificateSourceException;
import com.suncode.pwfl.certificates.exceptions.alias.AliasPresenceException;
import com.suncode.pwfl.certificates.exceptions.alias.NoSuchAliasException;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.Maps;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.controller.api.certificates.CertificateControllerHelper;
import com.suncode.pwfl.web.controller.api.certificates.CertificateProtocol;
import com.suncode.pwfl.web.controller.api.certificates.dto.CertificateDto;
import com.suncode.pwfl.web.controller.api.certificates.dto.CheckLDAPCertificatesDto;
import com.suncode.pwfl.web.controller.api.certificates.dto.CheckServerCertificatesDto;
import com.suncode.pwfl.web.controller.api.certificates.dto.ImportCertificateDto;
import com.suncode.pwfl.web.controller.api.certificates.dto.RenameAliasDto;
import com.suncode.pwfl.web.controller.api.certificates.fetchers.CertificateFetcher;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.util.JsonMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/certificates/cache"})
public class CertificateCacheController {
    private static final Logger log = LoggerFactory.getLogger(CertificateCacheController.class);
    @Autowired
    private EmailConfigurationService emailConfigurationService;
    @Autowired
    private CertificateService certificateService;
    @Autowired
    private CertificateControllerHelper helper;
    @Autowired
    private DomainService domainService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    private Cache<UUID, Map<String, Certificate>> cache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();

    @RequestMapping(method={RequestMethod.POST}, value={"import"})
    @ResponseBody
    public JsonMessage importCerts(HttpServletRequest request, @RequestBody ImportCertificateDto importDto) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CERTIFICATES_ADDED);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            Map<String, Certificate> certs = this.tryGetMap(importDto.getUuid());
            auditBuilder.params((Map)ImmutableMap.of((Object)"certificate_new_aliases", (Object)certs.keySet().stream().collect(Collectors.joining(", "))));
            this.certificateService.importCertificates(certs, false);
        }
        catch (CertificateBaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            return new JsonMessage(false, MessageHelper.getMessage((String)e.getMessageKey()));
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            return new JsonMessage(false, MessageHelper.getMessage((String)"Blad_przy_dodawaniu_certyfikatow"));
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new JsonMessage();
    }

    @RequestMapping(method={RequestMethod.POST}, value={"fetchFromLDAP"})
    @ResponseBody
    public JsonMessage fetchFromLDAP(@RequestBody CheckLDAPCertificatesDto ldapDto) throws IOException {
        Domain domain = this.domainService.getDomain(ldapDto.getTargetId());
        if (domain == null) {
            return new JsonMessage(false, MessageHelper.getMessage((String)"Blad_przy_pobieraniu_serwera_LDAP"));
        }
        CheckServerCertificatesDto checkDto = new CheckServerCertificatesDto(domain.getDomainServerAdres(), domain.getDomainServerPort().intValue(), CertificateProtocol.LDAP);
        return this.fetchFromServer(checkDto);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"fetchFromEmail"})
    @ResponseBody
    public JsonMessage fetchFromEmail() throws IOException {
        EmailConfiguration emailConfiguration = this.emailConfigurationService.getDefaultConfiguration();
        CheckServerCertificatesDto checkDto = new CheckServerCertificatesDto(emailConfiguration.getSmtpMailServer(), emailConfiguration.getSmtpPortNumber(), CertificateProtocol.SMTP);
        return this.fetchFromServer(checkDto);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"fetchFromServer"})
    @ResponseBody
    public JsonMessage fetchFromServer(@RequestBody CheckServerCertificatesDto requestBody) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        HashMap<String, Certificate> certs = new HashMap<String, Certificate>(2);
        String host = requestBody.getHost();
        int port = requestBody.getPort();
        log.info("Fetching certificates from server {}:{}", (Object)host, (Object)port);
        CertificateFetcher certFetcher = requestBody.getProtocol().createFetcher(host, port);
        try {
            Certificate[] serverCerts = certFetcher.tryFetch(3000);
            Map internalCerts = this.certificateService.getCertificates();
            if (serverCerts.length > 0) {
                this.addUniquelyToMap(host, serverCerts[0], certs, internalCerts);
                for (int i = 1; i < serverCerts.length; ++i) {
                    this.addUniquelyToMap(host + '-' + i, serverCerts[i], certs, internalCerts);
                }
            }
        }
        catch (CertificateBaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JsonMessage(false, MessageHelper.getMessage((String)e.getMessageKey()));
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JsonMessage(false, MessageHelper.getMessage((String)"Blad_przy_dodawaniu_certyfikatow"));
        }
        UUID uuid = UUID.randomUUID();
        this.cache.put((Object)uuid, certs);
        JsonMessage message = new JsonMessage();
        message.setData((Object)ImmutableMap.of((Object)"uuid", (Object)uuid));
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(method={RequestMethod.POST}, value={"fetchFromKeyStore"})
    @ResponseBody
    public JsonMessage fetchFromKeyStore(@RequestParam String password, @RequestParam MultipartFile file) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        log.info("Fetching certificates from uploaded KeyStore file");
        try (InputStream fileStream = file.getInputStream();){
            Map<String, Certificate> certs = this.filterUniquely(this.certificateService.readCertificatesFromKeyStore(fileStream, password.toCharArray()));
            UUID uuid = UUID.randomUUID();
            this.cache.put((Object)uuid, certs);
            JsonMessage message = new JsonMessage();
            message.setData((Object)ImmutableMap.of((Object)"uuid", (Object)uuid));
            JsonMessage jsonMessage = message;
            return jsonMessage;
        }
        catch (CertificateBaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JsonMessage(false, MessageHelper.getMessage((String)e.getMessageKey()));
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JsonMessage(false, MessageHelper.getMessage((String)"Blad_przy_dodawaniu_certyfikatow"));
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"fetchFromCert"})
    @ResponseBody
    public JsonMessage fetchFromCert(@RequestParam MultipartFile[] files) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        log.info("Fetching certificates from uploaded certificate files");
        HashMap<String, Certificate> certs = new HashMap<String, Certificate>(4);
        try {
            Map internalCerts = this.certificateService.getCertificates();
            for (MultipartFile file : files) {
                Certificate cert;
                try (InputStream fileStream = file.getInputStream();){
                    cert = this.certificateService.readCertificateFromStream(fileStream);
                }
                catch (CertificateSourceException ignored) {
                    continue;
                }
                String fileName = file.getOriginalFilename();
                int dotIndex = fileName.lastIndexOf(46);
                if (dotIndex != -1) {
                    fileName = fileName.substring(0, dotIndex);
                }
                this.addUniquelyToMap(fileName, cert, certs, internalCerts);
            }
        }
        catch (CertificateBaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JsonMessage(false, MessageHelper.getMessage((String)e.getMessageKey()));
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JsonMessage(false, MessageHelper.getMessage((String)"Blad_przy_dodawaniu_certyfikatow"));
        }
        UUID uuid = UUID.randomUUID();
        this.cache.put((Object)uuid, certs);
        JsonMessage message = new JsonMessage();
        message.setData((Object)ImmutableMap.of((Object)"uuid", (Object)uuid));
        return message;
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<CertificateDto> getCertificates(@RequestParam UUID uuid) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        log.info("Reading certificates from cache");
        Map<String, Certificate> certificates = this.tryGetMap(uuid);
        List certificateDtos = certificates.entrySet().stream().map(Maps.entryFold(CertificateDto::new)).sorted(Comparator.comparing(CertificateDto::getAlias)).collect(Collectors.toList());
        return new CountedResult((long)certificates.size(), certificateDtos);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"extended"})
    @ResponseBody
    public CountedResult<CertificateDto> getCertificatesExtended(@RequestParam UUID uuid, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="alias") String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        log.info("Reading certificates from cache");
        return this.helper.getExtended(this.tryGetMap(uuid), start, limit, orderBy, orderDirection);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"export"})
    @ResponseBody
    public void exportCertificate(HttpServletResponse response, @RequestParam UUID uuid, @RequestParam String alias) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        log.info("Exporting certificate from cache");
        Map<String, Certificate> certs = this.tryGetMap(uuid);
        Certificate cert = certs.get(alias);
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s.pem\"", alias));
        this.certificateService.exportCertificateToStream(cert, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(method={RequestMethod.PUT})
    @ResponseBody
    public JsonMessage renameCertificateAlias(@RequestBody RenameAliasDto renameDto) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        log.info("Renaming certificate alias in cache from {} to {}", (Object)renameDto.getAlias(), (Object)renameDto.getNewAlias());
        try {
            Map<String, Certificate> certs = this.tryGetMap(renameDto.getUuid());
            String alias = renameDto.getAlias();
            Certificate cert = certs.get(alias);
            if (cert == null) {
                throw new NoSuchAliasException("Certificate with alias " + alias + " does not exists");
            }
            String newAlias = renameDto.getNewAlias();
            this.certificateService.validateAlias(newAlias);
            if (this.aliasExists(newAlias) || certs.containsKey(newAlias)) {
                throw new AliasPresenceException("Certificate with alias " + newAlias + " already exists");
            }
            certs.remove(alias);
            certs.put(newAlias, cert);
        }
        catch (CertificateBaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JsonMessage(false, MessageHelper.getMessage((String)e.getMessageKey()));
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JsonMessage(false, MessageHelper.getMessage((String)"Blad_przy_zmianie_aliasu_certyfikatu"));
        }
        return new JsonMessage();
    }

    @RequestMapping(method={RequestMethod.DELETE})
    @ResponseBody
    public JsonMessage deleteCertificate(@RequestParam UUID uuid, @RequestParam String alias) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        log.info("Removing certificate with alias {} from cache", (Object)alias);
        try {
            Map<String, Certificate> certs = this.tryGetMap(uuid);
            if (!certs.containsKey(alias)) {
                throw new NoSuchAliasException("Certificate with alias " + alias + " does not exists");
            }
            certs.remove(alias);
        }
        catch (CertificateBaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JsonMessage(false, MessageHelper.getMessage((String)e.getMessageKey()));
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JsonMessage(false, MessageHelper.getMessage((String)"Blad_przy_usuwaniu_certyfikatu"));
        }
        return new JsonMessage();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"exportTable/{extension}"})
    public void exportCertificatesTable(HttpServletResponse response, @RequestParam UUID uuid, @PathVariable String extension, @RequestParam(required=false, defaultValue="alias") String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        log.info("Exporting certificates table from cache");
        this.helper.exportCertificatesDto(response, extension, MessageHelper.getMessage((String)"Certyfikaty_wlasne"), this.getCertificatesExtended(uuid, null, null, orderBy, orderDirection));
    }

    private Map<String, Certificate> tryGetMap(UUID uuid) {
        Map certs = (Map)this.cache.getIfPresent((Object)uuid);
        if (certs == null) {
            throw new CertificateSourceException("Requested certificates (UUID: " + uuid + ") does not exist in a cache");
        }
        return certs;
    }

    private boolean aliasExists(String alias) {
        return this.certificateService.getCertificate(alias) != null;
    }

    private Map<String, Certificate> filterUniquely(Map<String, Certificate> certs) {
        Map internalCerts = this.certificateService.getCertificates();
        HashMap<String, Certificate> filteredCerts = new HashMap<String, Certificate>();
        for (Map.Entry<String, Certificate> entry : certs.entrySet()) {
            this.addUniquelyToMap(entry.getKey(), entry.getValue(), filteredCerts, internalCerts);
        }
        return filteredCerts;
    }

    void addUniquelyToMap(String alias, Certificate cert, Map<String, Certificate> certs, Map<String, Certificate> internalCerts) {
        if (internalCerts.containsValue(cert) || certs.containsValue(cert)) {
            return;
        }
        String validAlias = this.certificateService.trimInvalidAliasChars(alias);
        if (!internalCerts.containsKey(validAlias) && !certs.containsKey(validAlias)) {
            certs.put(validAlias, cert);
            return;
        }
        int i = 1;
        String tempAlias = validAlias + "(1)";
        while (internalCerts.containsKey(tempAlias) || certs.containsKey(tempAlias)) {
            tempAlias = validAlias + '(' + ++i + ')';
        }
        certs.put(tempAlias, cert);
    }
}

