/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.UsersManagement;
import com.suncode.pwfl.administration.scheduledtask.info.ScheduledTaskInfoService;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.structure.role.RoleFilter;
import com.suncode.pwfl.administration.user.Domain;
import com.suncode.pwfl.administration.user.DomainService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.administration.user.UserInfoCache;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.UserValidator;
import com.suncode.pwfl.administration.user.exception.EmptyUserNameException;
import com.suncode.pwfl.administration.user.exception.GroupNotFoundException;
import com.suncode.pwfl.administration.user.exception.InvalidUserException;
import com.suncode.pwfl.administration.user.exception.UserAlreadyExistException;
import com.suncode.pwfl.administration.user.search.SimpleHibernateUserFilter;
import com.suncode.pwfl.administration.user.search.UserPropertyFilter;
import com.suncode.pwfl.administration.user.search.UserSortProperty;
import com.suncode.pwfl.administration.user.search.UserSorter;
import com.suncode.pwfl.administration.user.security.exception.EmailConfigurationException;
import com.suncode.pwfl.administration.user.security.exception.MissingEmailAddressException;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.datasource.rest.SortDto;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.license.LicenseAccessor;
import com.suncode.pwfl.license.LicenseVerificator;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.LogicOperator;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.search.hibernate.GroupHibernateFilter;
import com.suncode.pwfl.search.hibernate.HibernateFilter;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.CollatorInstance;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.controller.api.administration.user.ChangeUserDto;
import com.suncode.pwfl.web.controller.api.administration.user.NewUserDto;
import com.suncode.pwfl.web.controller.api.administration.user.SubstituteFinder;
import com.suncode.pwfl.web.controller.api.administration.user.UserQueryParameters;
import com.suncode.pwfl.web.controller.api.administration.user.UserSearchFilters;
import com.suncode.pwfl.web.dto.administration.GroupDto;
import com.suncode.pwfl.web.dto.administration.structure.position.PositionDto;
import com.suncode.pwfl.web.dto.administration.user.BasicUserInfoDto;
import com.suncode.pwfl.web.dto.administration.user.UserDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.UserCriteriaHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.util.JsonMessage;
import com.suncode.pwfl.web.util.SessionUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"users"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private UserService userService;
    @Autowired
    private DomainService domainService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private TransactionWrapper transactionWrapper;
    @Autowired
    private ExportService exportService;
    @Autowired
    private StructureService structureService;
    @Autowired
    private ScheduledTaskInfoService scheduledTaskInfoService;
    @Autowired
    private UserCriteriaHelper userCriteriaHelper;
    @Autowired
    private SubstituteFinder substituteFinder;
    @Autowired
    private MessageHelperBean messageHelper;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"query"})
    public CountedResult<BasicUserInfoDto> getUsers(@RequestParam(required=false) String query, @RequestParam(required=false) String firstNameQuery, @RequestParam(required=false) String lastNameQuery, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String sortBy, @RequestParam(required=false) boolean inactive) {
        start = (Integer)ObjectUtils.defaultIfNull((Object)start, (Object)0);
        limit = (Integer)ObjectUtils.defaultIfNull((Object)limit, (Object)Integer.MAX_VALUE);
        DetachedCriteria criteria = this.userCriteriaHelper.createQueryCriteria(query, firstNameQuery, lastNameQuery);
        long total = this.userFinder.count(criteria, inactive);
        try {
            if (StringUtils.isNotBlank((String)sortBy)) {
                SortDto[] sorters = this.parseJson(sortBy);
                this.addOrders(sorters, criteria);
            }
        }
        catch (Exception ex) {
            log.error("Couldn't add order to user list - error while parsing json.");
        }
        criteria.setProjection(null);
        List users = this.userFinder.findByCriteria(criteria, start, limit, !inactive).stream().map(BasicUserInfoDto::fromEntity).collect(Collectors.toList());
        return new CountedResult(total, users);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"filter"})
    public CountedResult<UserDto> getUsersFiltered(HttpServletRequest request, UserSearchFilters userSearchFilters, @RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false, defaultValue="username") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        if (userSearchFilters.getIsSearch() == null || userSearchFilters.getIsSearch().booleanValue()) {
            AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SEARCH_USERS);
            ImmutableMap params = new ImmutableMap.Builder().put((Object)"username", (Object)StringUtils.defaultString((String)userSearchFilters.getUsername())).put((Object)"firstName", (Object)StringUtils.defaultString((String)userSearchFilters.getFirstName())).put((Object)"lastName", (Object)StringUtils.defaultString((String)userSearchFilters.getLastName())).put((Object)"groupName", (Object)StringUtils.defaultString((String)userSearchFilters.getGroupName())).put((Object)"position", (Object)StringUtils.defaultString((String)userSearchFilters.getPosition())).put((Object)"positionSymbol", (Object)StringUtils.defaultString((String)userSearchFilters.getPositionSymbol())).put((Object)"email", (Object)StringUtils.defaultString((String)userSearchFilters.getEmail())).put((Object)"number", (Object)StringUtils.defaultString((String)userSearchFilters.getNumber())).put((Object)"active", (Object)(userSearchFilters.getActive() != null ? String.valueOf(userSearchFilters.getActive()) : "")).build();
            auditBuilder.params((Map)params).buildSuccess(request);
        }
        return this.getFilteredUserCountedResult(userSearchFilters, start, limit, sortBy, sortDirection);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"current"})
    public ResponseEntity<UserInfo> getCurrentUser() {
        UserInfo userInfo = UserContext.current().getUser();
        return new ResponseEntity((Object)userInfo, HttpStatus.OK);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"substitutions"})
    public CountedResult<BasicUserInfoDto> getUsersForDelegation(UserQueryParameters userQueryParameters, @RequestParam String substitutedLogin, @RequestParam(required=false, defaultValue="0") Integer start, @RequestParam(required=false, defaultValue="20") Integer limit, @RequestParam(required=false, defaultValue="userName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        return this.substituteFinder.findSubstitutesForUser(userQueryParameters, UserContext.current().getUser().getUserName(), substitutedLogin, start, limit, sortBy, sortDirection);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"by/login"})
    public ResponseEntity<UserInfo> getUserByLogin(@RequestParam String username) {
        boolean hasNoAdminRights;
        UserInfo userInfo = UserInfo.of((User)this.userService.getUser(username, new String[0]), (boolean)false);
        if (userInfo == null) {
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
        boolean bl = hasNoAdminRights = Authorization.checkRight((String)RightTreeBuilder.builder().system().admin().build(), (String)SessionUtils.getLoggedUserName(), (boolean)false, (boolean)false) != 0;
        if (hasNoAdminRights) {
            return new ResponseEntity((Object)new UserInfo(userInfo.getUserName(), userInfo.getFirstName(), userInfo.getLastName()), HttpStatus.OK);
        }
        return new ResponseEntity((Object)userInfo, HttpStatus.OK);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"by/roles"})
    public List<User> getUsers(@RequestBody List<RoleFilter> filters) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.userFinder.findByRoles(filters);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"by/group"})
    public CountedResult<User> getUsers(@RequestParam Long groupId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="userName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        UserGroup group = this.userService.getGroup(groupId, new String[0]);
        String groupName = group.getName();
        return this.userFinder.findByGroups(Collections.singletonList(groupName), new Sorter(sortBy, sortDirection), start.intValue(), limit.intValue());
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(method={RequestMethod.POST}, value={"group/attach"})
    public void attachToGroup(HttpServletRequest request, @RequestParam Long groupId, @RequestParam Long userId) throws GroupNotFoundException {
        String groupName = this.userService.getGroup(groupId, new String[0]).getName();
        String userName = this.userService.getUser(userId, new String[0]).getUserName();
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_USER_TO_GROUP).params((Map)ImmutableMap.of((Object)"groupId", (Object)groupName, (Object)"userId", (Object)userName));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        try {
            this.userService.addUserToGroup(userName, groupName);
            UserInfoCache.get().clear(new String[]{userName});
        }
        catch (Throwable ex) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            throw ex;
        }
        request.setAttribute("audit", (Object)builder.buildSuccess());
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"group/detach"})
    public JsonMessage detachFromGroup(HttpServletRequest request, @RequestParam Long groupId, @RequestParam Long userId) {
        String groupName = this.userService.getGroup(groupId, new String[0]).getName();
        String userName = this.userService.getUser(userId, new String[0]).getUserName();
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_USER_FROM_GROUP).params((Map)ImmutableMap.of((Object)"groupId", (Object)groupName, (Object)"userId", (Object)userName));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        try {
            JsonMessage result = (JsonMessage)this.transactionWrapper.doInHibernateTransaction(session -> {
                if (this.userService.getUser(userId, new String[0]).getGroups().size() <= 1) {
                    return new JsonMessage(false, MessageHelper.getMessage((String)"user.detachlastgroup"));
                }
                this.userService.removeUserFromGroup(userName, groupName);
                UserInfoCache.get().clear(new String[]{userName});
                return new JsonMessage();
            });
            request.setAttribute("audit", (Object)builder.buildSuccess());
            return result;
        }
        catch (Throwable ex) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            return new JsonMessage(false, ex.getMessage());
        }
    }

    @RequestMapping(value={"export/fromGroup/{extension}"})
    public void exportFromGroup(HttpServletResponse response, @PathVariable String extension, @RequestParam Long groupId, @RequestParam(required=false, defaultValue="userName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        UserGroup group = this.userService.getGroup(groupId, new String[0]);
        String groupName = group.getName();
        List users = this.userFinder.findByGroups(Collections.singletonList(groupName), new Sorter(sortBy, sortDirection), 0, Integer.MAX_VALUE).getData();
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Nazwa")).data(users).by(User::getUserName).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Imie")).data(users).by(User::getFirstName).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Nazwisko")).data(users).by(User::getLastName).build());
        ExportModel model = ExportModel.builder().title(MessageHelper.getMessage((String)"Uzytkownicy")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @ResponseBody
    @Transactional
    @RequestMapping(method={RequestMethod.POST})
    public RestResult create(HttpServletRequest request, @RequestBody NewUserDto newUserDto) {
        String password;
        List groupNames = newUserDto.getGroupIds().stream().map(groupId -> this.userService.getGroup(groupId, new String[0])).map(UserGroup::getName).collect(Collectors.toList());
        List positionNames = newUserDto.getPositionIds().stream().map(positionId -> this.structureService.getPosition(positionId, new String[0])).map(Position::getName).collect(Collectors.toList());
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_USER).params((Map)new ImmutableMap.Builder().put((Object)"userId", (Object)newUserDto.getUsername()).put((Object)"userFirstName", (Object)newUserDto.getFirstName()).put((Object)"userLastName", (Object)newUserDto.getLastName()).put((Object)"userEmail", (Object)newUserDto.getEmail()).put((Object)"userNumber", (Object)newUserDto.getNumber()).put((Object)"userGroupName", groupNames).put((Object)"userPositionsName", positionNames).put((Object)"selfPasswordAssign", (Object)newUserDto.isWaitingForPasswordAssign()).put((Object)"onlySsoLogin", (Object)newUserDto.isOnlySsoLogin()).put((Object)"anonymous", (Object)newUserDto.isAnonymous()).build());
        request.setAttribute("audit", (Object)builder.buildFailure());
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        if (!LicenseVerificator.isNextUserAllowed()) {
            return new RestResult(false, MessageHelper.getMessage((String)"Licencja_systemu_nie_pozwala_na_liczbe_uzytkownikow_powyzej") + " " + LicenseAccessor.getInstance().getMaxUsers() + ".");
        }
        String username = newUserDto.getUsername().trim().toLowerCase();
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)username), (String)"Username cannot be blank");
        if (!UserValidator.isUserNameValid((String)username)) {
            return new RestResult(false, MessageHelper.getMessage((String)"Nazwa_uzytkownika_zawiera_nieodpowiednie_znaki").replace("\"/\" , ", ""));
        }
        boolean isDomainUser = newUserDto.getDomainId() != null;
        String string = password = newUserDto.isWaitingForPasswordAssign() || isDomainUser ? "" : newUserDto.getPassword();
        if (isDomainUser) {
            Domain domain = this.domainService.getDomain(newUserDto.getDomainId());
            username = domain.getDomainName() + "/" + username;
        }
        User newUserDomain = new User(username, password);
        newUserDomain.setFirstName(newUserDto.getFirstName().trim());
        newUserDomain.setLastName(newUserDto.getLastName().trim());
        newUserDomain.setEmail(newUserDto.getEmail().trim());
        newUserDomain.setNumber(newUserDto.getNumber().trim());
        newUserDomain.setWaitingForPasswordAssign(newUserDto.isWaitingForPasswordAssign());
        newUserDomain.setLanguage(newUserDto.getLanguage());
        newUserDomain.setOnlySsoLogin(newUserDto.isOnlySsoLogin());
        newUserDomain.setAnonymous(newUserDto.isAnonymous());
        try {
            this.userService.createUser(newUserDomain, newUserDto.getGroupIds(), newUserDto.getPositionIds());
            request.setAttribute("audit", (Object)builder.buildSuccess());
            return new RestResult(true, MessageHelper.getMessage((String)"Uzytkownik") + " " + newUserDto.getUsername() + " " + MessageHelper.getMessage((String)"zostal_dodany") + ".");
        }
        catch (UserAlreadyExistException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return new RestResult(false, ex.getMessageTranslated());
        }
        catch (InvalidUserException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return new RestResult(false, ex.getMessageTranslated());
        }
        catch (EmailConfigurationException ex) {
            return new RestResult(false, MessageHelper.getMessage((String)"Niepoprawna_konfiguracja_wysylania_powiadomien"));
        }
        catch (MissingEmailAddressException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return new RestResult(false, MessageHelper.getMessage((String)"Uzytkownik_nie_ma_nadanego_adresu_email"));
        }
        catch (IllegalArgumentException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            EmptyUserNameException emptyException = new EmptyUserNameException("Nazwa u\u017cytkownika nie mo\u017ce by\u0107 pusta.");
            return new RestResult(false, emptyException.getMessageTranslated());
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return new RestResult(false, MessageHelper.getMessage((String)"Wystapil_nieoczekiwany_blad"));
        }
    }

    @ResponseBody
    @RequestMapping(value={"{userId}"}, method={RequestMethod.POST})
    public Object change(HttpServletRequest request, @PathVariable Long userId, @RequestBody ChangeUserDto changeUserDto) {
        String fullUsername;
        User userEntity = this.userService.getUser(userId, new String[0]);
        String oldUserFirstName = userEntity.getFirstName() != null ? userEntity.getFirstName() : "";
        String oldUserLastName = userEntity.getLastName() != null ? userEntity.getLastName() : "";
        String oldUserEmail = userEntity.getEmail() != null ? userEntity.getEmail() : "";
        String oldUserNumber = userEntity.getNumber() != null ? userEntity.getNumber() : "";
        boolean oldOnlySsoLogin = userEntity.isOnlySsoLogin();
        boolean oldAnonymous = userEntity.isAnonymous();
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_USER).params((Map)new ImmutableMap.Builder().put((Object)"userId", (Object)userEntity.getUserName()).put((Object)"userNewName", (Object)changeUserDto.getUsername()).put((Object)"userFirstName", (Object)(oldUserFirstName + " > " + changeUserDto.getFirstName())).put((Object)"userLastName", (Object)(oldUserLastName + " > " + changeUserDto.getLastName())).put((Object)"userEmail", (Object)(oldUserEmail + " > " + changeUserDto.getEmail())).put((Object)"userNumber", (Object)(oldUserNumber + " > " + changeUserDto.getNumber())).put((Object)"onlySsoLogin", (Object)(oldOnlySsoLogin + " > " + changeUserDto.isOnlySsoLogin())).put((Object)"anonymous", (Object)(oldAnonymous + " > " + changeUserDto.isAnonymous())).build());
        request.setAttribute("audit", (Object)builder.buildFailure());
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        String username = fullUsername = userEntity.getUserName();
        if (fullUsername.contains("/")) {
            username = fullUsername.split("/")[1];
        }
        String currentLoggedUsername = UserContext.current().getUser().getUserName();
        boolean isDomainUser = changeUserDto.getDomainId() != null;
        String newUsername = changeUserDto.getUsername().trim().toLowerCase();
        if (StringUtils.isEmpty((String)newUsername)) {
            newUsername = username;
        }
        String newFullUsername = newUsername;
        if (isDomainUser) {
            String domainName = this.domainService.getDomain(changeUserDto.getDomainId()).getDomainName();
            newFullUsername = domainName + "/" + newUsername;
        }
        String newEmail = changeUserDto.getEmail().trim();
        String newFirstName = changeUserDto.getFirstName().trim();
        String newLastName = changeUserDto.getLastName().trim();
        String newNumber = changeUserDto.getNumber().trim();
        String newPassword = changeUserDto.getPassword();
        boolean newOnlySsoLogin = changeUserDto.isOnlySsoLogin();
        boolean newAnonymous = changeUserDto.isAnonymous();
        Assert.isTrue((boolean)UserValidator.isEmailValid((String)newEmail), (String)"Email is not valid");
        Assert.isTrue((boolean)UserValidator.isUserFirstNameValid((String)newFirstName), (String)"First name is not valid");
        Assert.isTrue((boolean)UserValidator.isUserLastNameValid((String)newLastName), (String)"Last name is not valid");
        if (!fullUsername.equals(newFullUsername)) {
            Assert.isTrue((boolean)UserValidator.isUserNameValid((String)newUsername));
            if (UserValidator.doesUserExists((User)this.userService.getUser(newFullUsername, new String[0]))) {
                return new RestResult(false, MessageHelper.getMessage((String)"Uzytkownik_juz_istnieje", (Object[])new Object[]{newFullUsername}) + ".");
            }
            this.createChangeUsernameScheduledTask(currentLoggedUsername, fullUsername, newFullUsername);
        }
        if (isDomainUser || changeUserDto.getDeletePassword().booleanValue()) {
            newPassword = "";
        }
        boolean needsPageReload = false;
        boolean isPasswordChanged = false;
        if (StringUtils.isNotBlank((String)newPassword) || changeUserDto.getDeletePassword().booleanValue()) {
            log.info("Changing password for user {}", (Object)fullUsername);
            try {
                this.userService.changeUserPassword(fullUsername, newPassword);
                isPasswordChanged = true;
            }
            catch (IllegalArgumentException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                return new RestResult(false, ex.getMessage());
            }
            if (currentLoggedUsername.equals(fullUsername)) {
                needsPageReload = true;
            }
        }
        User changedUser = this.userService.getUser(userId, new String[0]);
        changedUser.setNumber(newNumber);
        changedUser.setFirstName(newFirstName);
        changedUser.setLastName(newLastName);
        changedUser.setEmail(newEmail);
        changedUser.setOnlySsoLogin(newOnlySsoLogin);
        changedUser.setAnonymous(newAnonymous);
        if (isPasswordChanged && changedUser.isWaitingForPasswordAssign()) {
            changedUser.setWaitingForPasswordAssign(false);
        }
        log.info("Updating user {}", (Object)changedUser.getUserName());
        this.userService.updateUser(changedUser);
        log.info("User {} updated", (Object)changedUser.getUserName());
        request.setAttribute("audit", (Object)builder.buildSuccess());
        return ImmutableMap.builder().put((Object)"success", (Object)true).put((Object)"needsPageReload", (Object)needsPageReload).put((Object)"message", (Object)MessageHelper.getMessage((String)"Dane_uzytkownika_zostaly_zmienione")).build();
    }

    public void createChangeUsernameScheduledTask(String loggedUsername, String fullName, String newFullName) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        this.scheduledTaskInfoService.beginTaskCreation().fromMethod(UsersManagement.class, "ChangeUserLogin", new Class[]{String.class, String.class, String.class}).withFirstRun(calendar.getTime()).withPeriodDays(360L).withName(MessageHelper.getMessage((String)"Zmiana_loginu_uzytkownika")).withDescription(MessageHelper.getMessage((String)"Zaplanowana_zmiana_nazwy_uzytkownika")).withActive(true).withRunOnce(true).withCategory("System").withParameter(0).withValue(fullName).withParameter(1).withValue(newFullName).withParameter(2).withValue(loggedUsername).createTask();
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"{userId}"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest request, @PathVariable Long userId) {
        String userName = this.userService.getUser(userId, new String[0]).getUserName();
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_USER).params((Map)ImmutableMap.of((Object)"userId", (Object)userName));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        try {
            this.userService.deleteUser(userName);
            request.setAttribute("audit", (Object)builder.buildSuccess());
        }
        catch (Exception ex) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            throw ex;
        }
    }

    @RequestMapping(value={"filter/export/{extension}"})
    public void exportByFilters(HttpServletResponse response, @PathVariable String extension, UserSearchFilters userSearchFilters, @RequestParam(required=false, defaultValue="username") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        CountedResult<UserDto> users = this.getFilteredUserCountedResult(userSearchFilters, 0, Integer.MAX_VALUE, sortBy, sortDirection);
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Nazwa")).data(users.getData()).by(UserDto::getUserName).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Imie")).data(users.getData()).by(UserDto::getFirstName).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Nazwisko")).data(users.getData()).by(UserDto::getLastName).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Numer")).data(users.getData()).by(UserDto::getNumber).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Email")).data(users.getData()).by(UserDto::getEmail).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Grupy")).data(users.getData()).by(item -> item.getGroups().stream().map(GroupDto::getName).collect(Collectors.joining(", "))).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Stanowiska")).data(users.getData()).by(item -> item.getPositions().stream().map(positionDto -> positionDto.getSymbol() + " - " + positionDto.getName()).collect(Collectors.joining(", "))).build());
        ExportModel model = ExportModel.builder().title(MessageHelper.getMessage((String)"Uzytkownicy")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private CountedResult<UserDto> getFilteredUserCountedResult(UserSearchFilters userSearchFilters, Integer start, Integer limit, String sortBy, SortDirection sortDirection) {
        ArrayList<HibernateFilter> filters = new ArrayList<HibernateFilter>();
        UserController.addFilter(filters, UserPropertyFilter.USERNAME, userSearchFilters.getUsername());
        UserController.addFilter(filters, UserPropertyFilter.FIRSTNAME, userSearchFilters.getFirstName());
        UserController.addFilter(filters, UserPropertyFilter.LASTNAME, userSearchFilters.getLastName());
        UserController.addFilter(filters, UserPropertyFilter.GROUP_NAME, userSearchFilters.getGroupName());
        UserController.addFilter(filters, UserPropertyFilter.POSITION_NAME, userSearchFilters.getPosition());
        UserController.addFilter(filters, UserPropertyFilter.POSITION_SYMBOL, userSearchFilters.getPositionSymbol());
        UserController.addFilter(filters, UserPropertyFilter.EMAIL, userSearchFilters.getEmail());
        UserController.addFilter(filters, UserPropertyFilter.NUMBER, userSearchFilters.getNumber());
        UserController.addFilter(filters, UserPropertyFilter.ACTIVE, userSearchFilters.getActive());
        UserSorter sorter = new UserSorter(UserSortProperty.valueOf((String)sortBy.toUpperCase()), sortDirection);
        return (CountedResult)this.transactionWrapper.doInHibernateTransaction(session -> {
            CountedResult result = this.userFinder.findByFilters(filters, sorter, start.intValue(), limit.intValue());
            List userDtos = result.getData().stream().map(user -> UserDto.builder().objectId(user.getObjectId()).userName(user.getUserName()).email(user.getEmail()).firstName(user.getFirstName()).lastName(user.getLastName()).number(user.getNumber()).active(user.isActive()).onlySsoLogin(user.isOnlySsoLogin()).anonymous(user.isAnonymous()).groups(user.getGroups().stream().map(GroupDto::fromDomain).sorted(Comparator.comparing(GroupDto::getName, CollatorInstance.get())).collect(Collectors.toList())).positions(user.getPositions().stream().map(PositionDto::fromDomain).sorted(Comparator.comparing(PositionDto::getName, CollatorInstance.get())).collect(Collectors.toList())).build()).collect(Collectors.toList());
            return new CountedResult(result.getTotal(), userDtos);
        });
    }

    private SortDto[] parseJson(String sortBy) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        return (SortDto[])objectMapper.readValue(sortBy, SortDto[].class);
    }

    private void addOrders(SortDto[] sorters, DetachedCriteria dc) {
        for (SortDto sorter : sorters) {
            if (StringUtils.isBlank((String)sorter.getProperty())) {
                return;
            }
            if (sorter.getDirection().equalsIgnoreCase("DESC")) {
                dc.addOrder(Order.desc((String)sorter.getProperty()));
                return;
            }
            dc.addOrder(Order.asc((String)sorter.getProperty()));
        }
    }

    private static void addFilter(List<HibernateFilter> filters, UserPropertyFilter property, Object value) {
        if (!(value instanceof String) && value != null) {
            filters.add((HibernateFilter)new SimpleHibernateUserFilter(property, value, FilterOperator.EQ));
            return;
        }
        String sValue = (String)value;
        if (StringUtils.isBlank((String)sValue)) {
            return;
        }
        if (DBUtils.isExactQuery((String)sValue)) {
            filters.add((HibernateFilter)new SimpleHibernateUserFilter(property, (Object)DBUtils.getExactQueryValue((String)sValue), FilterOperator.EQ));
            return;
        }
        if (DBUtils.isConjunctionSearch((String)sValue)) {
            GroupHibernateFilter conjunctionFilter = new GroupHibernateFilter(LogicOperator.AND);
            List searchValues = DBUtils.searchCriteriaForConjunctionLike((List)DBUtils.conjunctionValuesForLike((String)sValue));
            List searchFilters = searchValues.stream().map(filterValue -> new SimpleHibernateUserFilter(property, filterValue, FilterOperator.ILIKE)).collect(Collectors.toList());
            conjunctionFilter.setFilters(searchFilters);
            filters.add((HibernateFilter)conjunctionFilter);
            return;
        }
        filters.add((HibernateFilter)new SimpleHibernateUserFilter(property, (Object)DBUtils.searchCriteriaForLike((String)sValue), FilterOperator.ILIKE));
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(ServiceException e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }
}

