/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.organizationalUnit;

import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.structure.exception.OrganizationalUnitAlreadyExistException;
import com.suncode.pwfl.administration.structure.exception.OrganizationalUnitNotFoundException;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.util.exception.EmptyPropertyException;
import com.suncode.pwfl.web.controller.api.administration.organizationalUnit.OrganizationalUnitSearchFilters;
import com.suncode.pwfl.web.dto.administration.structure.organizationalUnit.AddOrganizationalUnitDto;
import com.suncode.pwfl.web.dto.administration.structure.organizationalUnit.StructureOrganizationalUnitDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"organizationalUnits"})
public class OrganizationalUnitController {
    @Autowired
    private StructureService structureService;
    @Autowired
    private ExportService exportService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private MessageHelperBean messageHelper;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<StructureOrganizationalUnitDto> getOrganizationalUnits(HttpServletRequest request, OrganizationalUnitSearchFilters filters, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false, defaultValue="true") boolean isSearch) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SEARCH_ORG_UNIT);
        auditBuilder.params(this.createSearchAudit(filters));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        CountedResult organizationalUnits = this.structureService.getOrganizationalUnits(filters.getName(), filters.getSymbol(), filters.getHighOuName(), filters.getHighOuSymbol(), filters.getDirectorName(), filters.getDirectorSymbol(), Pagination.create((Sorter)new Sorter(sortBy, sortDirection), (Integer)start, (Integer)limit));
        if (isSearch) {
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        List organizationalUnitsDtos = organizationalUnits.getData().stream().map(StructureOrganizationalUnitDto::from).collect(Collectors.toList());
        return new CountedResult(organizationalUnits.getTotal(), organizationalUnitsDtos);
    }

    private Map<String, Object> createSearchAudit(OrganizationalUnitSearchFilters filters) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        String orgUnitDirectorValue = StringUtils.defaultString((String)filters.getDirectorName());
        orgUnitDirectorValue = orgUnitDirectorValue.isEmpty() ? orgUnitDirectorValue + StringUtils.defaultString((String)filters.getDirectorSymbol()) : orgUnitDirectorValue + " - " + StringUtils.defaultString((String)filters.getDirectorSymbol());
        String orgUnitHigherOrgUnitValue = StringUtils.defaultString((String)filters.getHighOuName());
        orgUnitHigherOrgUnitValue = orgUnitHigherOrgUnitValue.isEmpty() ? StringUtils.defaultString((String)filters.getHighOuSymbol()) : orgUnitHigherOrgUnitValue + " - " + StringUtils.defaultString((String)filters.getHighOuSymbol());
        auditParams.put("orgUnitName", StringUtils.defaultString((String)filters.getName()));
        auditParams.put("orgUnitSymbol", StringUtils.defaultString((String)filters.getSymbol()));
        auditParams.put("orgUnitHigherOrgUnit", orgUnitHigherOrgUnitValue);
        auditParams.put("orgUnitDirector", orgUnitDirectorValue);
        return auditParams;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteOrganizationalUnit(HttpServletRequest request, @PathVariable Long id) throws OrganizationalUnitNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_ORG_UNIT);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("orgUnitId", id);
        auditBuilder.params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        if (Objects.isNull(this.structureService.getOrganizationalUnit(id, new String[0]))) {
            throw new OrganizationalUnitNotFoundException(this.messageHelper.getMessage("Jednostka_organizacyjna_o_podanym_id_nie_istnieje"));
        }
        auditParams.putAll(this.createAddAndDeleteOrgUnitAuditParams(AddOrganizationalUnitDto.from(this.structureService.getOrganizationalUnit(id, new String[0]))));
        auditBuilder.params(auditParams);
        try {
            this.structureService.deleteOrganizationalUnit(id);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public RestResult addOrganizationalUnit(HttpServletRequest request, @RequestBody AddOrganizationalUnitDto unit) throws OrganizationalUnitAlreadyExistException, EmptyPropertyException {
        Long orgUnitId;
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_ORG_UNIT);
        Map<String, Object> auditParams = this.createAddAndDeleteOrgUnitAuditParams(unit);
        auditBuilder.params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            OrganizationalUnit organizationalUnit = new OrganizationalUnit(unit.getOrganizationalUnitName().trim(), unit.getOrganizationalUnitSymbol().trim());
            this.addHigherOrganizationalUnitAndDirector(unit, organizationalUnit);
            this.structureService.validateOrganizationalUnit(organizationalUnit);
            orgUnitId = this.structureService.createOrganizationalUnit(organizationalUnit);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        auditParams.put("orgUnitId", orgUnitId);
        auditBuilder.params(auditParams);
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResult changeOrganizationalUnit(HttpServletRequest request, @PathVariable Long id, @RequestBody AddOrganizationalUnitDto unit) throws OrganizationalUnitAlreadyExistException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_ORG_UNIT);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("orgUnitId", id);
        auditBuilder.params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        OrganizationalUnit oldOrgUnit = this.structureService.getOrganizationalUnit(id, new String[]{"directorPosition", "higherOrganizationalUnit"});
        try {
            OrganizationalUnit ou = new OrganizationalUnit(unit.getOrganizationalUnitName().trim(), unit.getOrganizationalUnitSymbol().trim());
            ou.setId(id);
            this.addHigherOrganizationalUnitAndDirector(unit, ou);
            this.structureService.changeOrganizationalUnit(ou);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        auditParams.putAll(this.updateOrgUnitAuditParams(unit, oldOrgUnit));
        auditBuilder.params(auditParams);
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @RequestMapping(value={"export/{extension}"}, method={RequestMethod.GET})
    public void export(HttpServletResponse response, @PathVariable String extension, OrganizationalUnitSearchFilters filters, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<StructureOrganizationalUnitDto> organizationalUnitDtos = this.structureService.getOrganizationalUnits(filters.getName(), filters.getSymbol(), filters.getHighOuName(), filters.getHighOuSymbol(), filters.getDirectorName(), filters.getDirectorSymbol(), Pagination.create((Sorter)new Sorter(sortBy, sortDirection), null, null)).getData().stream().map(StructureOrganizationalUnitDto::from).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(this.buildExportColumn(this.messageHelper.getMessage("Nazwa"), organizationalUnitDtos, StructureOrganizationalUnitDto::getName), this.buildExportColumn(this.messageHelper.getMessage("Symbol"), organizationalUnitDtos, StructureOrganizationalUnitDto::getSymbol), this.buildExportColumn(this.messageHelper.getMessage("Jednostka_nadrzedna"), organizationalUnitDtos, structureOrganizationalUnitDto -> !Objects.isNull(structureOrganizationalUnitDto.getHigherOrganizationalUnit()) ? structureOrganizationalUnitDto.getHigherOrganizationalUnit().getSymbol() + " - " + structureOrganizationalUnitDto.getHigherOrganizationalUnit().getName() : ""), this.buildExportColumn(this.messageHelper.getMessage("Stanowisko_kierownicze"), organizationalUnitDtos, structureOrganizationalUnitDto -> !Objects.isNull(structureOrganizationalUnitDto.getDirector()) ? structureOrganizationalUnitDto.getDirector().getSymbol() + " - " + structureOrganizationalUnitDto.getDirector().getName() : ""));
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Jednostki_organizacyjne")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private ExportColumn buildExportColumn(String name, List<StructureOrganizationalUnitDto> data, Function<StructureOrganizationalUnitDto, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    private void addHigherOrganizationalUnitAndDirector(AddOrganizationalUnitDto unit, OrganizationalUnit ou) {
        if (!Objects.isNull(unit.getHigherOrganizationalUnitId())) {
            ou.setHigherOrganizationalUnit(this.structureService.getOrganizationalUnit(unit.getHigherOrganizationalUnitId(), new String[0]));
        }
        if (!Objects.isNull(unit.getDirectorPositionId())) {
            ou.setDirectorPosition(this.structureService.getPosition(unit.getDirectorPositionId(), new String[0]));
        }
    }

    private Map<String, Object> createAddAndDeleteOrgUnitAuditParams(AddOrganizationalUnitDto unit) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        OrganizationalUnit higherOu = null;
        Position director = null;
        if (Objects.nonNull(unit.getHigherOrganizationalUnitId())) {
            higherOu = this.structureService.getOrganizationalUnit(unit.getHigherOrganizationalUnitId(), new String[0]);
        }
        if (Objects.nonNull(unit.getDirectorPositionId())) {
            director = this.structureService.getPosition(unit.getDirectorPositionId(), new String[0]);
        }
        String higherOuId = higherOu != null ? String.valueOf(higherOu.getId()) : "";
        String directorId = director != null ? String.valueOf(director.getId()) : "";
        String higherUnitName = higherOu != null ? higherOu.getSymbol() + " - " + higherOu.getName() : "";
        String directorName = director != null ? director.getSymbol() + " - " + director.getName() : "";
        auditParams.put("orgUnitName", unit.getOrganizationalUnitName());
        auditParams.put("orgUnitSymbol", unit.getOrganizationalUnitSymbol());
        auditParams.put("orgUnitHigherOrgUnit", higherOuId);
        auditParams.put("orgUnitHigherOrgUnitName", higherUnitName);
        auditParams.put("orgUnitDirector", directorId);
        auditParams.put("orgUnitDirectorName", directorName);
        return auditParams;
    }

    private Map<String, Object> updateOrgUnitAuditParams(AddOrganizationalUnitDto unit, OrganizationalUnit oldUnit) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        OrganizationalUnit higherOrgUnit = null;
        Position director = null;
        if (!Objects.isNull(unit.getHigherOrganizationalUnitId())) {
            higherOrgUnit = this.structureService.getOrganizationalUnit(unit.getHigherOrganizationalUnitId(), new String[0]);
        }
        if (!Objects.isNull(unit.getDirectorPositionId())) {
            director = this.structureService.getPosition(unit.getDirectorPositionId(), new String[0]);
        }
        String oldOrgUnitHigherOrgUnitName = oldUnit.getHigherOrganizationalUnit() != null ? oldUnit.getHigherOrganizationalUnit().getSymbol() + " - " + oldUnit.getHigherOrganizationalUnit().getName() : "";
        String oldOrgUnitDirectorName = oldUnit.getDirectorPosition() != null ? oldUnit.getDirectorPosition().getSymbol() + " - " + oldUnit.getDirectorPosition().getName() : "";
        String orgUnitDirectorName = director != null ? director.getSymbol() + " - " + director.getName() : "";
        String orgUnitHigherOuName = higherOrgUnit != null ? higherOrgUnit.getSymbol() + " - " + higherOrgUnit.getName() : "";
        auditParams.put("orgUnitName", oldUnit.getName() + " > " + unit.getOrganizationalUnitName());
        auditParams.put("orgUnitSymbol", oldUnit.getSymbol() + " > " + unit.getOrganizationalUnitSymbol());
        auditParams.put("orgUnitHigherOrgUnit", oldOrgUnitHigherOrgUnitName + ";" + orgUnitHigherOuName);
        auditParams.put("orgUnitDirector", oldOrgUnitDirectorName + ";" + orgUnitDirectorName);
        return auditParams;
    }

    @ExceptionHandler(value={OrganizationalUnitAlreadyExistException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleOrganizationalUnitAlreadyExistException(OrganizationalUnitAlreadyExistException e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={EmptyPropertyException.class})
    @ResponseStatus(value=HttpStatus.PARTIAL_CONTENT)
    @ResponseBody
    public RestResult handleEmptyPropertyException(EmptyPropertyException e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={OrganizationalUnitNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleOrganizationalUnitNotFoundException(OrganizationalUnitNotFoundException e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }
}

