/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.email;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.email.oauth.OAuth2Response;
import com.suncode.pwfl.administration.email.oauth.OAuth2Service;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2Client;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2ClientService;
import com.suncode.pwfl.administration.email.oauth.connection.OAuth2Connection;
import com.suncode.pwfl.administration.email.oauth.connection.OAuth2ConnectionService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@RequestMapping(value={"/oauth"})
public class OAuth2Controller {
    private static final Logger log = LoggerFactory.getLogger(OAuth2Controller.class);
    @Autowired
    private OAuth2Service oAuth2Service;
    @Autowired
    private OAuth2ClientService oAuth2ClientService;
    @Autowired
    private OAuth2ConnectionService oAuth2ConnectionService;
    @Autowired
    private AuthorizationHelper authorizationHelper;

    @RequestMapping(value={"redirect"}, method={RequestMethod.GET})
    public RedirectView redirect(@RequestParam String code, @CookieValue(value="oauth_client_id", required=false) Long clientId, @CookieValue(value="oauth_email", required=false) String email, @CookieValue(value="oauth_connection_id", required=false) Long connectionId, HttpServletResponse response, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_OAUTH2_REDIRECT);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        ImmutableMap.Builder auditParamsBuilder = ImmutableMap.builder().put((Object)"OAUTH2_REDIRECT_CLIENT_ID", (Object)Objects.toString(clientId, "")).put((Object)"OAUTH2_REDIRECT_EMAIL", (Object)Objects.toString(email, "")).put((Object)"OAUTH2_REDIRECT_CONNECTION_ID", (Object)Objects.toString(connectionId, ""));
        boolean success = true;
        String message = "";
        String baseUrl = ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString();
        try {
            OAuth2Connection oAuth2Connection;
            OAuth2Client oAuth2Client;
            if (clientId != null) {
                oAuth2Client = (OAuth2Client)this.oAuth2ClientService.get((Serializable)clientId);
                oAuth2Connection = new OAuth2Connection();
            } else {
                oAuth2Connection = (OAuth2Connection)this.oAuth2ConnectionService.get((Serializable)connectionId);
                oAuth2Client = (OAuth2Client)this.oAuth2ClientService.get((Serializable)oAuth2Connection.getClientId());
            }
            String redirectUrl = StringUtils.isNotBlank((CharSequence)oAuth2Client.getRedirectUrl()) ? oAuth2Client.getRedirectUrl() : UriComponentsBuilder.fromHttpUrl((String)baseUrl).path("/api/oauth/redirect").build().toUriString();
            log.info("Wymienianie kodu na access token");
            log.info("Email: " + email);
            log.info("Client id: " + oAuth2Client.getClientId());
            log.info("Scope: " + oAuth2Client.getScope());
            log.info("Authorization url: " + oAuth2Client.getAuthorizationUrl());
            log.info("Token url: " + oAuth2Client.getTokenUrl());
            log.info("Redirect url: " + redirectUrl);
            this.setCookie("redirectClientId", oAuth2Client.getId().toString(), response);
            OAuth2Response oAuth2Response = this.oAuth2Service.exchangeCode(oAuth2Client, code, redirectUrl);
            this.updateConnectionFromResponse(oAuth2Connection, oAuth2Response);
            if (clientId != null) {
                oAuth2Connection.setClientId(clientId);
                oAuth2Connection.setEmail(email);
                this.oAuth2ConnectionService.save((Object)oAuth2Connection);
                message = "oauth_added_new_connection";
            } else {
                this.oAuth2ConnectionService.update((Object)oAuth2Connection);
                message = "oauth_connection_refreshed";
            }
        }
        catch (HttpClientErrorException e) {
            success = false;
            message = "oauth_exchange_error";
            log.error("B\u0142\u0105d podczas redirectu", (Throwable)e);
            log.error(e.getResponseBodyAsString());
        }
        catch (Exception e) {
            success = false;
            message = "oauth_redirect_error";
            log.error("B\u0142\u0105d podczas redirectu", (Throwable)e);
        }
        this.setCookie("redirectSuccess", String.valueOf(success), response);
        this.setCookie("tokenExchangeMessage", message, response);
        String redirectUrl = UriComponentsBuilder.fromHttpUrl((String)baseUrl).path("/Admin.do").queryParam("tab", new Object[]{"configuration"}).fragment("emailconfiguration").build().toUriString();
        RedirectView redirectView = new RedirectView();
        redirectView.setUrl(redirectUrl);
        auditParamsBuilder.put((Object)"OAUTH2_REDIRECT_MESSAGE", (Object)message);
        auditBuilder.params((Map)auditParamsBuilder.build());
        request.setAttribute("audit", (Object)auditBuilder.success(success).build());
        return redirectView;
    }

    private void setCookie(String name, String value, HttpServletResponse response) {
        UriComponents uriComponents = ServletUriComponentsBuilder.fromCurrentContextPath().build();
        String domain = uriComponents.getHost();
        Cookie cookie = new Cookie(name, value);
        cookie.setDomain(domain);
        cookie.setPath("/");
        cookie.setMaxAge((int)Duration.ofDays(1L).getSeconds());
        response.addCookie(cookie);
    }

    private void updateConnectionFromResponse(OAuth2Connection connection, OAuth2Response response) {
        connection.setAccessToken(response.getAccess_token());
        connection.setRefreshToken(response.getRefresh_token());
        connection.setScope(response.getScope());
        connection.setExpires(response.getExpires_in());
    }
}

