/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.detail;

import com.suncode.pwfl.audit.AuditParam;
import com.suncode.pwfl.audit.form.AuditDetailsHandler;
import com.suncode.pwfl.audit.formatter.AcceptActivityFormatter;
import com.suncode.pwfl.audit.formatter.AcceptManyActivitiesFormatter;
import com.suncode.pwfl.audit.formatter.ActivateTrialLicenseFormatter;
import com.suncode.pwfl.audit.formatter.ActivityDetailsFormatter;
import com.suncode.pwfl.audit.formatter.ActivityStateChangeFormatter;
import com.suncode.pwfl.audit.formatter.AddAndDeleteOrgUnitFormatter;
import com.suncode.pwfl.audit.formatter.AddAndDeleteRolesFromPositionFormatter;
import com.suncode.pwfl.audit.formatter.AddCommentToActivityFormatter;
import com.suncode.pwfl.audit.formatter.AddDeleteModuleRightFormatter;
import com.suncode.pwfl.audit.formatter.AddDocClassFormatter;
import com.suncode.pwfl.audit.formatter.AddDocClassProtectionConditionFormatter;
import com.suncode.pwfl.audit.formatter.AddDocumentClassAssociationFormatter;
import com.suncode.pwfl.audit.formatter.AddDocumentTemplateFormatter;
import com.suncode.pwfl.audit.formatter.AddEmailConfigurationFormatter;
import com.suncode.pwfl.audit.formatter.AddLinkConnectionFormatter;
import com.suncode.pwfl.audit.formatter.AddOrDeleteDelegationFormatter;
import com.suncode.pwfl.audit.formatter.AddPositionFormatter;
import com.suncode.pwfl.audit.formatter.AddReplacementVariableFormatter;
import com.suncode.pwfl.audit.formatter.AddScheduledTaskFormatter;
import com.suncode.pwfl.audit.formatter.AddSystemProtectionFormatter;
import com.suncode.pwfl.audit.formatter.AddUserFormatter;
import com.suncode.pwfl.audit.formatter.AddViewProtectionFormatter;
import com.suncode.pwfl.audit.formatter.AddViewSqlReportFormatter;
import com.suncode.pwfl.audit.formatter.BaseLinkFormatter;
import com.suncode.pwfl.audit.formatter.CalendarShareFormatter;
import com.suncode.pwfl.audit.formatter.ChangeDomainFormatter;
import com.suncode.pwfl.audit.formatter.ChangeOrgUnitFormatter;
import com.suncode.pwfl.audit.formatter.ChangePositionFormatter;
import com.suncode.pwfl.audit.formatter.ChangeReplacementVariableTypeFormatter;
import com.suncode.pwfl.audit.formatter.ChangeSystemParameterFormatter;
import com.suncode.pwfl.audit.formatter.ChangeViewProtectionFormatter;
import com.suncode.pwfl.audit.formatter.CheckInDocumentFormatter;
import com.suncode.pwfl.audit.formatter.CheckoutFileFromArchiveFormatter;
import com.suncode.pwfl.audit.formatter.CheckoutFileFromProcessFormatter;
import com.suncode.pwfl.audit.formatter.CreateProcessFormatter;
import com.suncode.pwfl.audit.formatter.CreateSystemParameterFormatter;
import com.suncode.pwfl.audit.formatter.DeactivateUserFormatter;
import com.suncode.pwfl.audit.formatter.DefaultProcessFieldsFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocClassActionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocClassIndexFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocClassProtectionConditionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocClassProtectionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocumentClassAssociationFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocumentFromProcessFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocumentTemplateFormatter;
import com.suncode.pwfl.audit.formatter.DeleteDocumentViewFormatter;
import com.suncode.pwfl.audit.formatter.DeleteLinkConnectionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteLinkIndexFormatter;
import com.suncode.pwfl.audit.formatter.DeleteLinkProtectionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteOrAbortProcessFormatter;
import com.suncode.pwfl.audit.formatter.DeletePanelParameterFormatter;
import com.suncode.pwfl.audit.formatter.DeletePositionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteProcessProtectionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteReplacementVariableFormatter;
import com.suncode.pwfl.audit.formatter.DeleteSearchedDocumentsFormatter;
import com.suncode.pwfl.audit.formatter.DeleteSystemProtectionFormatter;
import com.suncode.pwfl.audit.formatter.DeleteVariableDistinguishFormatter;
import com.suncode.pwfl.audit.formatter.DeleteViewFormatter;
import com.suncode.pwfl.audit.formatter.DeleteViewProtectionFormatter;
import com.suncode.pwfl.audit.formatter.DeviceFormatter;
import com.suncode.pwfl.audit.formatter.DirectoryFormatter;
import com.suncode.pwfl.audit.formatter.EditDeactivatedUserFormatter;
import com.suncode.pwfl.audit.formatter.EditDocumentIndexesFormatter;
import com.suncode.pwfl.audit.formatter.EditDocumentTemplateFormatter;
import com.suncode.pwfl.audit.formatter.EditUserNotificationsFormatter;
import com.suncode.pwfl.audit.formatter.FavouriteElementFormatter;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.formatter.ImportTranslationsFormatter;
import com.suncode.pwfl.audit.formatter.InstallModuleFormatter;
import com.suncode.pwfl.audit.formatter.ManageScheduledTaskFormatter;
import com.suncode.pwfl.audit.formatter.ManageUserPositionFormatter;
import com.suncode.pwfl.audit.formatter.MappingFormatter;
import com.suncode.pwfl.audit.formatter.OpenActivitiesFormatter;
import com.suncode.pwfl.audit.formatter.OpenActivityFormatter;
import com.suncode.pwfl.audit.formatter.PasswordPolicyUpdateFormatter;
import com.suncode.pwfl.audit.formatter.PasswordProfileAssignedFormatter;
import com.suncode.pwfl.audit.formatter.PluginUpdateFormatter;
import com.suncode.pwfl.audit.formatter.ProcessDetailsFormatter;
import com.suncode.pwfl.audit.formatter.RemoveSystemParameterFormatter;
import com.suncode.pwfl.audit.formatter.RunViewFormatter;
import com.suncode.pwfl.audit.formatter.SaveActivityFormatter;
import com.suncode.pwfl.audit.formatter.SaveProcessSettingsFormatter;
import com.suncode.pwfl.audit.formatter.SaveViewFormatter;
import com.suncode.pwfl.audit.formatter.SearchDocClassFormatter;
import com.suncode.pwfl.audit.formatter.SearchFormatter;
import com.suncode.pwfl.audit.formatter.SearchLinkFormatter;
import com.suncode.pwfl.audit.formatter.SearchOrgUnitFormatter;
import com.suncode.pwfl.audit.formatter.SearchPositionFormatter;
import com.suncode.pwfl.audit.formatter.SendEmailFormatter;
import com.suncode.pwfl.audit.formatter.StatsFormatter;
import com.suncode.pwfl.audit.formatter.UpdateDocClassFormatter;
import com.suncode.pwfl.audit.formatter.UpdateDocumentClassAssociationFormatter;
import com.suncode.pwfl.audit.formatter.UpdateEmailConfigurationFormatter;
import com.suncode.pwfl.audit.formatter.UpdateOAuth2ClientFormatter;
import com.suncode.pwfl.audit.formatter.UpdateUserPanelFormatter;
import com.suncode.pwfl.audit.formatter.UpdateUserSettingsFormatter;
import com.suncode.pwfl.audit.formatter.UpdateUserViewFormatter;
import com.suncode.pwfl.audit.formatter.UploadFileFromArchiveFormatter;
import com.suncode.pwfl.audit.formatter.UploadFileFromProcessFormatter;
import com.suncode.pwfl.audit.formatter.UpsertDocClassActionFormatter;
import com.suncode.pwfl.audit.formatter.UpsertDocClassIndexFormatter;
import com.suncode.pwfl.audit.formatter.UpsertDocClassProtectionFormatter;
import com.suncode.pwfl.audit.formatter.UpsertDocumentViewFormatter;
import com.suncode.pwfl.audit.formatter.UpsertLinkIndexFormatter;
import com.suncode.pwfl.audit.formatter.UpsertLinkProtectionFormatter;
import com.suncode.pwfl.audit.formatter.UpsertNotificationFormatter;
import com.suncode.pwfl.audit.formatter.UpsertPanelParameterFormatter;
import com.suncode.pwfl.audit.formatter.UpsertProcessProtectionFormatter;
import com.suncode.pwfl.audit.formatter.UpsertVariableDistinguishFormatter;
import com.suncode.pwfl.audit.formatter.UserSearchFormatter;
import com.suncode.pwfl.audit.formatter.ValidateActivityFormatter;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.audit.util.AuditTypes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AuditDetails
implements AuditDetailsHandler {
    private AuditTypes auditType;

    public AuditDetails(AuditTypes auditType) {
        this.auditType = auditType;
    }

    @Override
    public List<AuditParam> decompose(String auditParams) {
        LinkedHashMap<String, String> formattedMap;
        String[] tab;
        ArrayList<AuditParam> decomposition = new ArrayList<AuditParam>();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String key : tab = StringUtils.defaultString((String)auditParams).split("@AUDIT_PARAM@")) {
            String[] equalSplit = key.split("=", -1);
            map.put(equalSplit[0], AuditTools.joinTabValue(equalSplit, "="));
        }
        switch (this.auditType) {
            case AUDIT_OPEN_ACTIVITY: {
                Formatter formatter = new OpenActivityFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_SAVE_ACTIVITY: {
                Formatter formatter = new SaveActivityFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ACCEPT_ACTIVITY: {
                Formatter formatter = new AcceptActivityFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_VALIDATE_ACTIVITY: {
                Formatter formatter = new ValidateActivityFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_SEARCH_DOCCLASS: {
                Formatter formatter = new SearchDocClassFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_SEARCH_LINK: {
                Formatter formatter = new SearchLinkFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_SYSTEM_PROTECTION: {
                Formatter formatter = new AddSystemProtectionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_SYSTEM_PROTECTION: {
                Formatter formatter = new DeleteSystemProtectionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_DELEGATION: 
            case AUDIT_DELETE_DELEGATION: 
            case AUDIT_ADD_DELEGATION_BY_USER: 
            case AUDIT_DELETE_DELEGATION_BY_USER: 
            case AUDIT_UPDATE_DELEGATION: 
            case AUDIT_UPDATE_DELEGATION_BY_USER: 
            case AUDIT_SEARCH_SUBSTITUTIONS: {
                Formatter formatter = new AddOrDeleteDelegationFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_STATS: {
                Formatter formatter = new StatsFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_UPLOAD_FILE_FROM_PROCESS: {
                Formatter formatter = new UploadFileFromProcessFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_UPLOAD_FILE_FROM_ARCHIVE: {
                Formatter formatter = new UploadFileFromArchiveFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_CHECKOUT_FILE_FROM_ARCHIVE: {
                Formatter formatter = new CheckoutFileFromArchiveFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_CHECKOUT_FILE_FROM_PROCESS: {
                Formatter formatter = new CheckoutFileFromProcessFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_CREATE_PROCESS: {
                Formatter formatter = new CreateProcessFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_DOCCLASS: {
                Formatter formatter = new AddDocClassFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_ROLE_TO_POSITION: 
            case AUDIT_DELETE_ROLE_FROM_POSITION: {
                Formatter formatter = new AddAndDeleteRolesFromPositionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_NOTIFICATION: 
            case AUDIT_EDIT_NOTIFICATION: {
                Formatter formatter = new UpsertNotificationFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_DOCUMENT_TEMPLATE: {
                Formatter formatter = new AddDocumentTemplateFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_EDIT_DOCUMENT_TEMPLATE: {
                Formatter formatter = new EditDocumentTemplateFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_DOCUMENT_TEMPLATE: {
                Formatter formatter = new DeleteDocumentTemplateFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_DOC_CLASS_INDEX: 
            case AUDIT_UPDATE_DOC_CLASS_INDEX: {
                Formatter formatter = new UpsertDocClassIndexFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_DOC_CLASS_INDEX: {
                Formatter formatter = new DeleteDocClassIndexFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_DOC_CLASS_ACTION: 
            case AUDIT_EDIT_DOC_CLASS_ACTION: {
                Formatter formatter = new UpsertDocClassActionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_DOC_CLASS_ACTION: {
                Formatter formatter = new DeleteDocClassActionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_PROCESS_PROTECTION: 
            case AUDIT_EDIT_PROCESS_PROTECTION: {
                Formatter formatter = new UpsertProcessProtectionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_PROCESS_PROTECTION: {
                Formatter formatter = new DeleteProcessProtectionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_INSTALL_MODULE: {
                Formatter formatter = new InstallModuleFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_COMMENT_TO_ACTIVITY: {
                Formatter formatter = new AddCommentToActivityFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_DOCUMENT_FROM_PROCESS: {
                Formatter formatter = new DeleteDocumentFromProcessFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_PROCESS_DETAILS: {
                Formatter formatter = new ProcessDetailsFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ACTIVITY_DETAILS: {
                Formatter formatter = new ActivityDetailsFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_CHECK_IN_DOCUMENT_FROM_ACTIVITY: 
            case AUDIT_CHECK_IN_DOCUMENT_FROM_ARCHIVE: {
                Formatter formatter = new CheckInDocumentFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_EDIT_DOCUMENT_INDEXES: {
                Formatter formatter = new EditDocumentIndexesFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_SUSPEND_ACTIVITY: 
            case AUDIT_ABORT_ACTIVITY: 
            case AUDIT_RESUME_ACTIVITY: 
            case AUDIT_RESUME_ACTIVITIES: 
            case AUDIT_SUSPEND_ACTIVITIES: {
                Formatter formatter = new ActivityStateChangeFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_SAVE_VIEW: {
                Formatter formatter = new SaveViewFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_VIEW: {
                Formatter formatter = new DeleteViewFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ACCEPT_MANY_ACTIVITIES: {
                Formatter formatter = new AcceptManyActivitiesFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_DOCUMENT_VIEW: 
            case AUDIT_EDIT_DOCUMENT_VIEW: {
                Formatter formatter = new UpsertDocumentViewFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_DOCUMENT_VIEW: {
                Formatter formatter = new DeleteDocumentViewFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_SAVE_PROCESS_SETTINGS: {
                Formatter formatter = new SaveProcessSettingsFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_DOC_CLASS_PROTECTION: 
            case AUDIT_EDIT_DOC_CLASS_PROTECTION: {
                Formatter formatter = new UpsertDocClassProtectionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_DOC_CLASS_PROTECTION: {
                Formatter formatter = new DeleteDocClassProtectionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_DOC_CLASS_PROTECTION_CONDITION: {
                Formatter formatter = new AddDocClassProtectionConditionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_DOC_CLASS_PROTECTION_CONDITION: {
                Formatter formatter = new DeleteDocClassProtectionConditionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_LINK_INDEX: 
            case AUDIT_EDIT_LINK_INDEX: {
                Formatter formatter = new UpsertLinkIndexFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_LINK_INDEX: {
                Formatter formatter = new DeleteLinkIndexFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_LINK_CONNECTION: 
            case AUDIT_EDIT_LINK_CONNECTION: {
                Formatter formatter = new AddLinkConnectionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_LINK_CONNECTION: {
                Formatter formatter = new DeleteLinkConnectionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_LINK_PROTECTION: 
            case AUDIT_EDIT_LINK_PROTECTION: {
                Formatter formatter = new UpsertLinkProtectionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_LINK_PROTECTION: {
                Formatter formatter = new DeleteLinkProtectionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_EDIT_USER_NOTIFICATIONS: {
                Formatter formatter = new EditUserNotificationsFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_VIEW_REPORT: 
            case AUDIT_ADD_SQL_QUERY_REPORT: {
                Formatter formatter = new AddViewSqlReportFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_MODULE_RIGHT: 
            case AUDIT_DELETE_MODULE_RIGHT: {
                Formatter formatter = new AddDeleteModuleRightFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_SCHEDULED_TASK: {
                Formatter formatter = new AddScheduledTaskFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_UPDATE_SCHEDULED_TASK: 
            case AUDIT_DELETE_SCHEDULED_TASK: 
            case AUDIT_RUN_SCHEDULED_TASK: 
            case AUDIT_MANUAL_RUN_SCHEDULED_TASK: 
            case AUDIT_STOP_SCHEDULED_TASK: {
                Formatter formatter = new ManageScheduledTaskFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_SEARCHED_DOCUMENTS: {
                Formatter formatter = new DeleteSearchedDocumentsFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DEACTIVATE_USER: {
                Formatter formatter = new DeactivateUserFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_EDIT_DEACTIVATED_USER: {
                Formatter formatter = new EditDeactivatedUserFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_SYSTEM_PARAMETER_CREATED: {
                Formatter formatter = new CreateSystemParameterFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_SYSTEM_PARAMETER_CHANGED: {
                Formatter formatter = new ChangeSystemParameterFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_SYSTEM_PARAMETER_REMOVED: {
                Formatter formatter = new RemoveSystemParameterFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_SEND_EMAIL: {
                Formatter formatter = new SendEmailFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_PROCESSES: 
            case AUDIT_DELETE_PROCESS: 
            case AUDIT_ABORT_PROCESSES: 
            case AUDIT_ABORT_PROCESS: {
                Formatter formatter = new DeleteOrAbortProcessFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_UPDATE_PLUGIN: {
                Formatter formatter = new PluginUpdateFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_UPDATE_DOCCLASS: {
                Formatter formatter = new UpdateDocClassFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_PASSWORD_PROFILE_CHANGED: 
            case AUDIT_PASSWORD_PROFILE_CREATED: {
                Formatter formatter = new PasswordPolicyUpdateFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADMIN_ADD_DOC_CLASS_ASSOCIATION: {
                Formatter formatter = new AddDocumentClassAssociationFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADMIN_UPDATE_DOC_CLASS_ASSOCIATION: {
                Formatter formatter = new UpdateDocumentClassAssociationFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADMIN_DELETE_DOC_CLASS_ASSOCIATION: {
                Formatter formatter = new DeleteDocumentClassAssociationFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_UPDATE_POSITION: {
                Formatter formatter = new ChangePositionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_POSITION: {
                Formatter formatter = new AddPositionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_POSITION: {
                Formatter formatter = new DeletePositionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_SEARCH_POSITION: {
                Formatter formatter = new SearchPositionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_UPDATE_ORG_UNIT: {
                Formatter formatter = new ChangeOrgUnitFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_ORG_UNIT: 
            case AUDIT_ADD_ORG_UNIT: {
                Formatter formatter = new AddAndDeleteOrgUnitFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_SEARCH_ORG_UNIT: {
                Formatter formatter = new SearchOrgUnitFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_USER: {
                Formatter formatter = new AddUserFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ASSIGN_POSITION_TO_USER: 
            case AUDIT_DETACH_POSITION: {
                Formatter formatter = new ManageUserPositionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_UPDATE_LINK: 
            case AUDIT_ADD_LINK: 
            case AUDIT_DELETE_LINK: {
                Formatter formatter = new BaseLinkFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_PASSWORD_PROFILES_ASSIGNED: {
                Formatter formatter = new PasswordProfileAssignedFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_UPDATE_LDAP_SERVER: {
                Formatter formatter = new ChangeDomainFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_REPLACEMENT_VARIABLE: {
                Formatter formatter = new AddReplacementVariableFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_REPLACEMENT_VARIABLE: {
                Formatter formatter = new DeleteReplacementVariableFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_CHANGE_REPLACEMENT_VAR_TYPE: {
                Formatter formatter = new ChangeReplacementVariableTypeFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_EMAIL_CONFIGURATION: {
                Formatter formatter = new AddEmailConfigurationFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_UPDATE_EMAIL_CONFIGURATION: {
                Formatter formatter = new UpdateEmailConfigurationFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_UPDATE_OAUTH2_CLIENT: {
                Formatter formatter = new UpdateOAuth2ClientFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_PANEL_PARAMETER: 
            case AUDIT_UPDATE_PANEL_PARAMETER: {
                Formatter formatter = new UpsertPanelParameterFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_PANEL_PARAMETER: {
                Formatter formatter = new DeletePanelParameterFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_UPDATE_PANEL: {
                Formatter formatter = new UpdateUserPanelFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_UPDATE_VIEW: {
                Formatter formatter = new UpdateUserViewFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_VIEW_PROTECTION: {
                Formatter formatter = new AddViewProtectionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_EDIT_VIEW_PROTECTION: {
                Formatter formatter = new ChangeViewProtectionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_VIEW_PROTECTION: {
                Formatter formatter = new DeleteViewProtectionFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_VARIABLE_DISTINGUISH: {
                Formatter formatter = new DeleteVariableDistinguishFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_VARIABLE_DISTINGUISH: 
            case AUDIT_UPDATE_VARIABLE_DISTINGUISH: {
                Formatter formatter = new UpsertVariableDistinguishFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_DELETE_DEVICE: 
            case AUDIT_ADD_DEVICE: 
            case AUDIT_UPDATE_DEVICE: {
                Formatter formatter = new DeviceFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_DIRECTORY: 
            case AUDIT_DELETE_DIRECTORY: 
            case AUDIT_UPDATE_DIRECTORY: {
                Formatter formatter = new DirectoryFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_CALENDAR_SHARE: 
            case AUDIT_DELETE_CALENDAR_SHARE: {
                Formatter formatter = new CalendarShareFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_SEARCH_PROCESSES_OR_ACTIVITIES: {
                Formatter formatter = new SearchFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_SEARCH_USERS: {
                Formatter formatter = new UserSearchFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_SEARCH_MAPPINGS: {
                Formatter formatter = new MappingFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_RUN_VIEW: {
                Formatter formatter = new RunViewFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_OPEN_USER_ACTIVITIES: 
            case AUDIT_OPEN_USER_FINISHED_ACTIVITIES: {
                Formatter formatter = new OpenActivitiesFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_UPDATE_USER_SETTINGS: 
            case AUDIT_UPDATE_USER_SETTINGS_GLOBAL: {
                Formatter formatter = new UpdateUserSettingsFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ACTIVATE_TRIAL_LICENSE: {
                Formatter formatter = new ActivateTrialLicenseFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_IMPORT_TRANSLATIONS: {
                Formatter formatter = new ImportTranslationsFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_ADD_FAVOURITE_ELEMENT: 
            case AUDIT_UPDATE_FAVOURITE_ELEMENT: {
                Formatter formatter = new FavouriteElementFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            case AUDIT_CHANGE_SELECTED_TASK_FIELDS: 
            case AUDIT_CHANGE_SELECTED_PROCESS_FIELDS: 
            case AUDIT_CHANGE_SELECTED_PROCESS_HEADER_FIELDS: {
                Formatter formatter = new DefaultProcessFieldsFormatter();
                formattedMap = formatter.format(map);
                break;
            }
            default: {
                Formatter formatter = new Formatter();
                map = formatter.format(map);
                formattedMap = new LinkedHashMap<String, String>(map);
            }
        }
        for (String key : formattedMap.keySet()) {
            AuditParam param = new AuditParam();
            param.setParamName("AUDIT_PARAM_".concat(key.toUpperCase()));
            param.setParamValue(formattedMap.get(key));
            decomposition.add(param);
        }
        return decomposition;
    }
}

