/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.search.AdvanceProcessSearchDBHelper;
import com.suncode.pwfl.search.ViewVariablesToSearchModelMapper;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.view.ViewService;
import com.suncode.pwfl.view.dto.ViewDto;
import com.suncode.pwfl.view.exception.ViewDoesNotExistException;
import com.suncode.pwfl.view.service.viewRights.ViewRightsService;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.support.form.cache.SearchFormCache;
import com.suncode.pwfl.web.util.SessionUtils;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewAdvanceProcessSearchViewAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(NewAdvanceProcessSearchViewAction.class);
    private static final SearchFormCache searchFormCache = (SearchFormCache)SpringContext.getBean(SearchFormCache.class);
    private static final AdvanceProcessSearchDBHelper advanceProcessSearchDBHelper = (AdvanceProcessSearchDBHelper)SpringContext.getBean(AdvanceProcessSearchDBHelper.class);
    private static final ViewVariablesToSearchModelMapper viewVariablesToSearchModelMapper = (ViewVariablesToSearchModelMapper)SpringContext.getBean(ViewVariablesToSearchModelMapper.class);
    private static final ViewService viewService = (ViewService)SpringContext.getBean(ViewService.class);
    private static final ViewRightsService viewRightsService = (ViewRightsService)SpringContext.getBean(ViewRightsService.class);
    private String viewId;
    private String searchId;
    private String forwardName;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Date auditStartDate = new Date();
        ManualAuditBuilder manualAuditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_RUN_VIEW).started(auditStartDate).username(SessionUtils.getLoggedUserNameOrUnknown());
        request.setAttribute("activeTab", (Object)"WorkflowViews.do");
        String viewId = this.viewId != null ? this.viewId : request.getParameter("viewId");
        String searchId = this.searchId != null ? this.searchId : request.getParameter("searchId");
        manualAuditBuilder.params((Map)ImmutableMap.of((Object)"viewId", (Object)viewId));
        if (StringUtils.isBlank((String)searchId) || StringUtils.isBlank((String)viewId)) {
            request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Niepoprawne_kryteria_wyszukiwania"));
            this.logAuditFail(manualAuditBuilder);
            return mapping.findForward("showErrorMessage");
        }
        log.info("Wyszukiwanie widoku o id: " + viewId);
        try {
            String username;
            ViewDto viewDto;
            Cache<String, String> cache = searchFormCache.getCache(request.getSession(false));
            ConcurrentMap sessionCache = cache.asMap();
            if (!sessionCache.containsKey(searchId)) {
                List searchVariablesForView = advanceProcessSearchDBHelper.getSearchVariablesForView(Long.valueOf(viewId));
                SearchFormModelDto searchFormModel = viewVariablesToSearchModelMapper.map(searchVariablesForView);
                ObjectMapper mapper = new ObjectMapper();
                String encodedSearchFormModel = Base64.getEncoder().encodeToString(mapper.writeValueAsString((Object)searchFormModel).getBytes(StandardCharsets.UTF_8));
                searchFormCache.cacheSearchForm(request.getSession(false), searchId, encodedSearchFormModel);
            }
            if (!viewRightsService.hasRightsToView(viewDto = viewService.getView(Long.valueOf(viewId)), username = UserContext.current().getUser().getUserName())) {
                request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Brak_uprawnien_do_widoku"));
                this.logAuditFail(manualAuditBuilder);
                return mapping.findForward("showErrorMessage");
            }
            SearchFormModelDto searchFormModelDto = searchFormCache.getSearchFormFromCache(searchId).get();
            String processDefId = searchFormModelDto.getProcessVariablesSearchModel().getProcessDefinitionId();
            if (!viewRightsService.hasRightsToProcessInView(processDefId, viewDto.getOwnerUsername(), username)) {
                request.setAttribute("message", (Object)MessageHelper.getMessage((String)"brak_uprawnien_do_procesu_w_widoku", (Object[])new Object[]{username, processDefId}));
                this.logAuditFail(manualAuditBuilder);
                return mapping.findForward("showErrorMessage");
            }
            String redirectUrl = request.getRequestURL() + "?" + request.getQueryString();
            request.setAttribute("redirectUrl", (Object)redirectUrl);
            request.setAttribute("searchId", (Object)searchId);
            request.setAttribute("viewId", (Object)viewId);
            request.setAttribute("encodedSearchFormModel", sessionCache.get(searchId));
            request.setAttribute("auditStartDate", (Object)this.getFormattedDate(auditStartDate));
        }
        catch (ViewDoesNotExistException e) {
            request.setAttribute("message", (Object)e.getMessage());
            this.logAuditFail(manualAuditBuilder);
            return mapping.findForward("showErrorMessage");
        }
        catch (JsonProcessingException e) {
            log.error("B\u0142\u0105d podczas parsowania formularza wyszukiwania", (Throwable)e);
            request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Niepoprawne_kryteria_wyszukiwania"));
            this.logAuditFail(manualAuditBuilder);
            return mapping.findForward("showErrorMessage");
        }
        catch (Exception e) {
            log.error("B\u0142\u0105d podczas parsowania formularza wyszukiwania", (Throwable)e);
            request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Nieoczekiwany_blad"));
            this.logAuditFail(manualAuditBuilder);
            return mapping.findForward("showErrorMessage");
        }
        return mapping.findForward(this.forwardName != null ? this.forwardName : "showResult");
    }

    private void logAuditFail(ManualAuditBuilder manualAuditBuilder) {
        manualAuditBuilder.success(false).build().log();
    }

    private String getFormattedDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(date);
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public void setSearchId(String searchId) {
        this.searchId = searchId;
    }

    public void setForwardName(String forwardName) {
        this.forwardName = forwardName;
    }
}

