/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.suncode.pwfl.security.Authenticator;
import com.suncode.pwfl.security.AuthenticatorRegistry;
import com.suncode.pwfl.security.RedirectEvent;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.controller.api.security.sso.SsoAuthenticationController;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(LogoutAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.info("******************************LogoutAction********************");
        HttpSession session = request.getSession(false);
        String username = (String)session.getAttribute("username");
        log.info("Wylogowywanie uzytkownika: {}", (Object)username);
        String ssoProvider = (String)session.getAttribute("ssoProvider");
        Boolean logoutBySSO = (Boolean)session.getAttribute(SsoAuthenticationController.LOGOUT_BY_SSO_SESSION_KEY);
        String manualLogOutUrl = null;
        if (StringUtils.isNotBlank((CharSequence)ssoProvider) && !ssoProvider.equals("plusworkflow")) {
            AuthenticatorRegistry authenticatorRegistry = (AuthenticatorRegistry)SpringContext.getBean(AuthenticatorRegistry.class);
            Authenticator authenticator = authenticatorRegistry.getAuthenticator(ssoProvider);
            if (logoutBySSO == null || !logoutBySSO.booleanValue()) {
                try {
                    boolean requestSent = authenticator.sendLogoutRequest(request, response, username);
                    if (requestSent) {
                        return mapping.findForward("");
                    }
                }
                catch (Exception e) {
                    request.setAttribute("auditSuccess", (Object)false);
                    throw new Exception("Send SSO logout request failed", e);
                }
            }
            manualLogOutUrl = (String)authenticator.getRedirections().get(RedirectEvent.MANUAL_LOGOUT);
        }
        session.setAttribute("isManualLogout", (Object)true);
        session.invalidate();
        log.info("Wylogowywanie u\u017cytkownika {} przebieglo poprawnie", (Object)username);
        request.setAttribute("auditSuccess", (Object)true);
        if (StringUtils.isNotBlank(manualLogOutUrl)) {
            response.sendRedirect(request.getContextPath() + manualLogOutUrl);
            return mapping.findForward("");
        }
        return mapping.findForward("logManual");
    }
}

