/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.i18n.I18NCustom;
import com.plusmpm.struts.action.ShowArchiveViewsAction;
import com.plusmpm.struts.form.FullTextSearchForm;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.DocumentData;
import com.plusmpm.util.FullTextSearch.Dokumenty;
import com.plusmpm.util.FullTextSearch.Results;
import com.plusmpm.util.FullTextSearch.SearchFiles;
import com.plusmpm.util.FullTextSearch.meta.SearchMeta;
import com.plusmpm.util.Tools;
import com.plusmpm.util.UsersManagement;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.context.i18n.LocaleContextHolder;

public class FullTextSearchResultAction
extends Action {
    private static final Logger log = Logger.getLogger(FullTextSearchResultAction.class);
    private Boolean fullTextSearchSource;
    private DBManagement dbManagement = new DBManagement();
    private DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Results foundDocument;
        log.info((Object)"******************************FullTextSearchResultAction start********************");
        HttpSession session = request.getSession(false);
        String username = (String)session.getAttribute("username");
        if (session == null || StringUtils.isEmpty((CharSequence)username)) {
            log.info((Object)"******************************FullTextSearchResultAction end: no user logged on********************");
            return mapping.findForward("disconnect");
        }
        HashSet searchResults = new HashSet();
        HashSet contentSearchResults = new HashSet();
        HashSet indexSearchResults = new HashSet();
        FullTextSearchForm searchForm = (FullTextSearchForm)form;
        if (this.isSearchFormEmpty(searchForm)) {
            searchForm = (FullTextSearchForm)session.getAttribute("fullTextSearchForm");
            this.fullTextSearchSource = true;
        } else {
            session.setAttribute("fullTextSearchForm", (Object)searchForm);
            if (this.fullTextSearchSource == null) {
                this.fullTextSearchSource = false;
            }
        }
        String phrase = this.getPhrase(searchForm);
        String sourcePhrase = new String(phrase);
        if (StringUtils.isEmpty((CharSequence)phrase)) {
            log.info((Object)"******************************FullTextSearchResultAction end: nothing to search********************");
            request.getSession().setAttribute("message", (Object)true);
            ShowArchiveViewsAction archiveViewsAction = this.createEmptyPhraseAction();
            return archiveViewsAction.execute(mapping, form, request, response);
        }
        phrase = this.fixQuotes(phrase);
        String[] documentClasses = searchForm.getWybrane_klasy();
        ArrayList<String> directories = new ArrayList<String>();
        int definedPageSize = UsersManagement.getUserDefinedPageSize((String)username);
        request.setAttribute("iPageSize", (Object)definedPageSize);
        SearchMeta meta = new SearchMeta();
        meta.setPhrase(phrase);
        meta.setShowContent(this.hasShowFilesContent(searchForm).booleanValue());
        if (documentClasses != null) {
            try {
                for (int i = 0; i < documentClasses.length; ++i) {
                    if (!documentClasses[i].equals("on") && !documentClasses[i].equals("true")) continue;
                    DocClassTable documentClassEntity = DBManagement.getDocClass((String)documentClasses[i - 1]);
                    File documentClassPath = new File(documentClassEntity.getDocClassIndexPath());
                    if (!documentClassPath.exists() || documentClassPath.listFiles().length <= 0) continue;
                    directories.add(documentClassEntity.getDocClassIndexPath());
                }
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (directories.size() > 0) {
            try {
                contentSearchResults.addAll(SearchFiles.Search(directories, (String)"content", (SearchMeta)meta));
                indexSearchResults.addAll(SearchFiles.Search(directories, (String)"index", (SearchMeta)meta));
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            log.info((Object)"******************************FullTextSearchResultAction end: empty document class********************");
            request.getSession().setAttribute("message", (Object)true);
            ShowArchiveViewsAction showArchiveViewsAction = this.createEmptyDocumentClassAction();
            return showArchiveViewsAction.execute(mapping, form, request, response);
        }
        ArrayList<Results> results = new ArrayList<Results>();
        HashMap<Long, String> conditionQueryCache = new HashMap<Long, String>();
        HashMap<String, Boolean> modifyRightCache = new HashMap<String, Boolean>();
        HashMap<String, Boolean> deleteRightCache = new HashMap<String, Boolean>();
        I18NCustom i18NCustom = new I18NCustom(LocaleContextHolder.getLocale());
        if (contentSearchResults != null && !contentSearchResults.isEmpty()) {
            for (Dokumenty document : contentSearchResults) {
                foundDocument = this.prepareFullTextSearchResults(document, true, username, conditionQueryCache, modifyRightCache, deleteRightCache, i18NCustom);
                if (foundDocument == null) continue;
                results.add(foundDocument);
            }
        }
        if (indexSearchResults != null && !indexSearchResults.isEmpty()) {
            for (Dokumenty document : indexSearchResults) {
                if (contentSearchResults.contains(document) || (foundDocument = this.prepareFullTextSearchResults(document, false, username, conditionQueryCache, modifyRightCache, deleteRightCache, i18NCustom)) == null) continue;
                results.add(foundDocument);
            }
        }
        request.setAttribute("trafienia", (Object)results.size());
        request.setAttribute("fraza", (Object)sourcePhrase);
        request.setAttribute("wyniki_szukania", results);
        request.setAttribute("showContent", (Object)meta.isShowContent());
        log.info((Object)"******************************FullTextSearchResultAction end********************");
        if (this.fullTextSearchSource.booleanValue()) {
            this.fullTextSearchSource = null;
            return mapping.findForward("showSearchResultBody");
        }
        return mapping.findForward("showSearchResult");
    }

    private Results prepareFullTextSearchResults(Dokumenty document, boolean isContentSearch, String username, Map<Long, String> conditionQueryCache, Map<String, Boolean> modifyRightCache, Map<String, Boolean> deleteRightCache, I18NCustom i18NCustom) {
        Results result = null;
        DocClassTable documentClassEntity = DBManagement.getDocClass((String)document.getType_id());
        String conditionQuery = this.getConditionQuery(username, conditionQueryCache, documentClassEntity.getId());
        DocumentData documentData = this.dbManagement.GetDocument(document.getType_id(), document.getDocument_id(), conditionQuery);
        if (documentData != null) {
            result = new Results();
            result.setClass_name(this.documentClassService.getDocumentClassTranslation(documentClassEntity.getId(), TranslatedFieldType.NAME));
            result.setScore(document.getScore() * 100.0f);
            Boolean hasModifyRight = this.getModifyRight(username, modifyRightCache, document);
            Boolean hasDeleteRight = this.getDeleteRight(username, deleteRightCache, document);
            result.setTool_tip_link(this.createToolTip(documentData));
            result.setAction_link(this.createFullLink(username, document, documentData, hasModifyRight, hasDeleteRight));
            result.setHidden_document_link(this.createHiddenDocumentLink(documentData));
            String extract = isContentSearch ? document.getContent() : documentData.getAlIndecies().stream().filter(documentIndexes -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{documentIndexes.getValue()})).map(documentIndexes -> this.documentClassService.getDocumentClassIndexTranslation(Long.valueOf(documentIndexes.getId()), TranslatedFieldType.NAME) + " : " + documentIndexes.getValue()).collect(Collectors.joining(", "));
            try {
                result.setExtract(new String(extract.getBytes("UTF-8"), "UTF-8"));
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                result.setExtract(extract);
            }
        }
        return result;
    }

    private Boolean getModifyRight(String username, Map<String, Boolean> modifyRightCache, Dokumenty document) {
        Boolean hasModifyRight = false;
        String documentType = document.getType_id();
        if (!modifyRightCache.containsKey(documentType)) {
            hasModifyRight = this.hasModifyRight(document, username);
            modifyRightCache.put(documentType, hasModifyRight);
        } else {
            hasModifyRight = modifyRightCache.get(documentType);
        }
        return hasModifyRight;
    }

    private Boolean getDeleteRight(String username, Map<String, Boolean> deleteRightCache, Dokumenty document) {
        Boolean hasDeleteRight = false;
        String documentType = document.getType_id();
        if (!deleteRightCache.containsKey(documentType)) {
            hasDeleteRight = this.hasDeleteRight(document, username);
            deleteRightCache.put(documentType, hasDeleteRight);
        } else {
            hasDeleteRight = deleteRightCache.get(documentType);
        }
        return hasDeleteRight;
    }

    private String getConditionQuery(String username, Map<Long, String> conditionQueryCache, Long docClassEntityId) {
        String conditionQuery = "";
        if (!conditionQueryCache.containsKey(docClassEntityId)) {
            conditionQuery = Authorization.GetDocClassConditionProtection((String)" ", (String)username, (String)String.valueOf(docClassEntityId));
            conditionQueryCache.put(docClassEntityId, conditionQuery);
        } else {
            conditionQuery = conditionQueryCache.get(docClassEntityId);
        }
        return conditionQuery;
    }

    public void setSource(String source) {
        if (source.compareToIgnoreCase("fts") == 0) {
            this.fullTextSearchSource = true;
        }
    }

    private String createHiddenDocumentLink(DocumentData documentData) {
        String hiddenDocumentLink = "fileName=" + Tools.encodeStringBase64((String)String.valueOf(documentData.getLFileId()));
        return hiddenDocumentLink;
    }

    private String createFullLink(String username, Dokumenty document, DocumentData documentData, boolean hasModifyRight, boolean hasDeleteRight) {
        String link = this.createLink(documentData);
        if (hasModifyRight) {
            link = this.addModifyLink(document, documentData, link);
        }
        if (hasDeleteRight) {
            link = this.addDeleteLink(document, documentData, link);
        }
        return link;
    }

    private String addDeleteLink(Dokumenty document, DocumentData documentData, String link) {
        return link + " | <a href=\"javascript://nop/\" onclick='FreezeScreen(); new AjaxJspTag.PreFunctionUpdateInvoke({href: \"DeleteDocument.do?documentId=" + documentData.getLDocumentId() + "&docClassId=" + document.getType_id() + "&source=fts&fileId=" + documentData.getLFileId() + "\",\tid: \"documentsTable\", postFunction: FreezeScreenAndClose() }); return false;'>" + MessageHelper.getMessage((String)"Usun") + "</a>";
    }

    private String addModifyLink(Dokumenty document, DocumentData documentData, String link) {
        return link + " | <a href=\"javascript://nop/\" onclick='PW.ui.ModalWindow.show( \"" + MessageHelper.getMessage((String)"Zmiana_dokumentu") + "\",\"EditDocument.do?documentId=" + documentData.getLDocumentId() + "&docClassId=" + document.getType_id() + "&source=fts\"); return false;'>" + MessageHelper.getMessage((String)"Zmien") + "</a>";
    }

    private boolean hasDeleteRight(Dokumenty document, String username) {
        String rightType = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)document.getType_id()).delete().build();
        return Authorization.CheckRight((String)rightType, (String)username, (boolean)false) == 0;
    }

    private boolean hasModifyRight(Dokumenty document, String username) {
        String rightType = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)document.getType_id()).modify().build();
        return Authorization.CheckRight((String)rightType, (String)username, (boolean)false) == 0;
    }

    private String createLink(DocumentData documentData) {
        return "<a href=javascript:Viewer('ShowFile.do?fileName=" + Tools.encodeStringBase64((String)String.valueOf(documentData.getLFileId())) + "')> " + MessageHelper.getMessage((String)"Pokaz") + "</A>";
    }

    private String createToolTip(DocumentData documentData) {
        String url = this.createUrl(documentData);
        String script = this.createScript(url);
        String link = "<a href=\"javascript:void(0)\" onclick=\"" + script + "\"><div class=\"dvnt-icon-info-circle dvnt-blue-icon info-link\"></div></a>";
        return link;
    }

    private String createScript(String url) {
        String script = "showPopup('" + url + "', '" + MessageHelper.getMessage((String)"Informacje_o_dokumencie") + "', event.pageX, event.pageY, {width: 330}); return false;";
        return script;
    }

    private String createUrl(DocumentData documentData) {
        String url = "ShowDocumentInformation.do?fileId=" + Tools.encodeStringBase64((String)String.valueOf(documentData.getLFileId())) + "&docClassId=" + documentData.getLDocClassId();
        return url;
    }

    private boolean isSearchFormEmpty(FullTextSearchForm searchForm) {
        return searchForm.getWybrane_klasy() == null && searchForm.getFraza() == null;
    }

    private ShowArchiveViewsAction createEmptyDocumentClassAction() {
        ShowArchiveViewsAction showArchiveViewsAction = new ShowArchiveViewsAction();
        showArchiveViewsAction.m_bDefaultTab = true;
        showArchiveViewsAction.m_sDefaultTab = "search";
        showArchiveViewsAction.m_sMessage = MessageHelper.getMessage((String)"Nie_wybrano_zadnej_klasy_dokumentow_lub_w_wybranych_klasach_nie_ma_indeksow");
        showArchiveViewsAction.m_sMessageType = "error";
        return showArchiveViewsAction;
    }

    private Boolean hasShowFilesContent(FullTextSearchForm searchForm) {
        if (searchForm.getShowContent() != null) {
            return searchForm.getShowContent().equals("true") || searchForm.getShowContent().equals("on");
        }
        return false;
    }

    private ShowArchiveViewsAction createEmptyPhraseAction() {
        ShowArchiveViewsAction archiveViewsAction = new ShowArchiveViewsAction();
        archiveViewsAction.m_bDefaultTab = true;
        archiveViewsAction.m_sDefaultTab = "search";
        archiveViewsAction.m_sMessage = MessageHelper.getMessage((String)"Nie_wprowadzono_szukanej_frazy") + " " + MessageHelper.getMessage((String)"Prosze_wprowadzic_zapytanie");
        archiveViewsAction.m_sMessageType = "error";
        return archiveViewsAction;
    }

    private String getPhrase(FullTextSearchForm searchForm) {
        try {
            return searchForm.getFraza().trim();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return "";
        }
    }

    private String fixQuotes(String phrase) {
        int countQ = StringUtils.countMatches((CharSequence)phrase, (CharSequence)"\"");
        if (countQ == 1 && (phrase.indexOf("\"") == 0 || phrase.charAt(phrase.indexOf("\"") - 1) != '\\')) {
            return phrase.replace("\"", "\\\"");
        }
        return phrase;
    }
}

