/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.notifications.NotificationDefTable;
import com.plusmpm.struts.action.ProcessEmailNotificatonAction;
import com.plusmpm.struts.form.NotificationForm;
import com.plusmpm.util.ActivityVariable;
import com.plusmpm.util.NotificationInfo;
import com.plusmpm.util.ProcessVariableHelper;
import com.plusmpm.util.SharkFunctions;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class ChangeNotificationAction
extends Action {
    public static Logger log = Logger.getLogger(ChangeNotificationAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info((Object)"****************************** ChangeNotificationAction *********************************");
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_NOTIFICATION);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        boolean isChangeFormValid = true;
        String message = MessageHelper.getMessage((String)"Powiadomienie_zostalo_zmienione");
        try {
            HttpSession session = request.getSession(false);
            if (session == null || session.getAttribute("username") == null) {
                return mapping.findForward("disconnect");
            }
            NotificationForm notificationForm = (NotificationForm)form;
            DBManagement dbManagement = new DBManagement();
            String procTypeId = notificationForm.getProcDefId();
            String notificationId = notificationForm.getId();
            String notificationName = notificationForm.getName();
            String notificationSubject = notificationForm.getSubject();
            String notificationCondition = notificationForm.getCondition();
            String notificationVariable = notificationForm.getVariable();
            String notificationValue = notificationForm.getValue();
            String notificationPath = notificationForm.getPath();
            NotificationDefTable oldNotification = dbManagement.getNotificationDefById(notificationId);
            if (StringUtils.isBlank((CharSequence)notificationName)) {
                isChangeFormValid = false;
                message = MessageHelper.getMessage((String)"Prosze_uzupelnic_nastepujace_pole") + " : " + MessageHelper.getMessage((String)"Nazwa");
            } else if (StringUtils.isBlank((CharSequence)notificationSubject)) {
                isChangeFormValid = false;
                message = MessageHelper.getMessage((String)"Prosze_uzupelnic_nastepujace_pole") + " : " + MessageHelper.getMessage((String)"Temat");
            } else if (StringUtils.isBlank((CharSequence)notificationPath)) {
                isChangeFormValid = false;
                message = MessageHelper.getMessage((String)"Prosze_uzupelnic_nastepujace_pole") + " : " + MessageHelper.getMessage((String)"Sciezka_szablonu");
            } else if (!StringUtils.isNumeric((CharSequence)notificationValue) || StringUtils.isBlank((CharSequence)notificationValue)) {
                isChangeFormValid = false;
                message = MessageHelper.getMessage((String)"Prosze_uzupelnic_nastepujace_pole") + " : " + MessageHelper.getMessage((String)"Opoznienie_powiadomienia");
            }
            NotificationDefTable notificationDefTable = new NotificationDefTable(notificationName, notificationSubject, notificationPath, notificationCondition, notificationVariable, notificationValue);
            notificationDefTable.setRecipientPerformer(notificationForm.getRecipientPerformer());
            notificationDefTable.setDontSendOnWeekends(notificationForm.getDontSendOnWeekends());
            notificationDefTable.setDontSendOnHolidaysAndDaysOff(notificationForm.getDontSendOnHolidaysAndDaysOff());
            notificationDefTable.setId(Long.valueOf(Long.parseLong(notificationId)));
            params.put("procDefId", procTypeId);
            params.put("name", oldNotification.getName() + " > " + notificationName);
            params.put("subject", oldNotification.getSubject() + " > " + notificationSubject);
            params.put("path", oldNotification.getTemplatePath() + " > " + notificationPath);
            params.put("condition", oldNotification.getConditionType() + ";" + notificationCondition);
            String oldConditionVal = oldNotification.getConditionVal() != null ? oldNotification.getConditionVal() : "";
            params.put("value", oldConditionVal + " > " + notificationValue);
            params.put("recipientPerformer", oldNotification.getRecipientPerformer() + ";" + notificationDefTable.getRecipientPerformer());
            params.put("dontSendOnWeekends", oldNotification.getDontSendOnWeekends() + ";" + notificationDefTable.getDontSendOnWeekends());
            params.put("dontSendOnHolidaysAndDaysOff", oldNotification.getDontSendOnHolidaysAndDaysOff() + ";" + notificationDefTable.getDontSendOnHolidaysAndDaysOff());
            if (isChangeFormValid) {
                dbManagement.changeNotificationDef(notificationDefTable);
            }
            WorkflowProcess wp = SharkFunctions.getWorkflowProcessByDefId((String)procTypeId);
            Activities activities = wp.getActivities();
            ArrayList<String[]> alActi = new ArrayList<String[]>();
            for (int i = 0; i < activities.size(); ++i) {
                Activity activity = (Activity)activities.get(i);
                alActi.add(new String[]{activity.getId(), activity.getName()});
            }
            ProcessVariableHelper processVariableHelper = new ProcessVariableHelper();
            ArrayList<ActivityVariable> alVars = processVariableHelper.getVariablesForProcess(procTypeId);
            ArrayList<NotificationInfo> alNotificationInfo = ProcessEmailNotificatonAction.getNotificationInfo(procTypeId, wp);
            request.setAttribute("alNotificationInfo", alNotificationInfo);
            request.setAttribute("procTypeId", (Object)procTypeId);
            request.setAttribute("activities", alActi);
            request.setAttribute("variables", alVars);
            builder.params(params);
            if (isChangeFormValid) {
                request.setAttribute("audit", (Object)builder.buildSuccess());
            } else {
                request.setAttribute("audit", (Object)builder.buildFailure());
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            request.setAttribute("audit", (Object)builder.buildFailure());
        }
        request.setAttribute("message", (Object)message);
        String messageType = isChangeFormValid ? "success" : "error";
        request.setAttribute("messageType", (Object)messageType);
        return mapping.findForward("processEmailNotification");
    }
}

