/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.ui;

import com.google.common.base.Charsets;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import com.suncode.pwfl.web.ui.DebugMode;
import org.springframework.stereotype.Component;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.CacheValue;

@Component
class WebScriptsCache
implements CacheStrategy<CacheKey, CacheValue> {
    private static final long MAX_SIZE = 0x1400000L;
    private final Cache<CacheKey, CacheValue> cache = CacheBuilder.newBuilder().maximumWeight(0x1400000L).weigher((Weigher)new ScriptWeighter()).removalListener((RemovalListener)new RemovalListener<CacheKey, CacheValue>(){

        public void onRemoval(RemovalNotification<CacheKey, CacheValue> notification) {
            notification.toString();
        }
    }).build();

    public void invalidate(CacheKey key) {
        this.cache.invalidate((Object)key);
    }

    public CacheValue get(CacheKey key) {
        if (DebugMode.isDebug()) {
            return null;
        }
        return (CacheValue)this.cache.getIfPresent((Object)key);
    }

    public void put(CacheKey key, CacheValue value) {
        if (!DebugMode.isDebug()) {
            this.cache.put((Object)key, (Object)value);
        }
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public void destroy() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    private static class ScriptWeighter
    implements Weigher<CacheKey, CacheValue> {
        private ScriptWeighter() {
        }

        public int weigh(CacheKey key, CacheValue value) {
            int size = 0;
            size += value.getGzippedContent() != null ? value.getGzippedContent().length : 0;
            return size += value.getRawContent().getBytes(Charsets.UTF_8).length;
        }
    }
}

