/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support;

import com.plusmpm.database.AdvanceSearchVariableDto;
import com.plusmpm.database.AdvanceSearchVariableTable;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.XpdlKey;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.i18n.MessageHelperBean;
import java.util.HashMap;
import java.util.Map;
import org.enhydra.shark.xpdl.elements.Package;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class AdvanceSearchVariableMapper {
    @Autowired
    private MessageHelperBean messageHelper;

    public AdvanceSearchVariableDto fromEntity(AdvanceSearchVariableTable searchVariable, String procDefId) {
        XpdlPackageManager xpdlPackageManager = XpdlPackageManager.getInstance();
        I18Nxpdl xpdlTranslator = new I18Nxpdl(LocaleContextHolder.getLocale());
        Map<String, String> standardVariablesMap = this.getStandardVariablesTranslationMap();
        Package pack = xpdlPackageManager.getPackageByProcessDefinitionId(procDefId);
        String translatedName = standardVariablesMap.getOrDefault(searchVariable.getName(), searchVariable.getName());
        if (pack != null) {
            translatedName = xpdlTranslator.getStringWithDefault(XpdlKey.forPackage((String)pack.getId()).forProcess(procDefId).forDataField(searchVariable.getName()).getKey(), translatedName);
        }
        return AdvanceSearchVariableDto.builder().id(searchVariable.getId()).viewId(searchVariable.getViewid()).name(searchVariable.getName()).translatedName(translatedName).build();
    }

    private Map<String, String> getStandardVariablesTranslationMap() {
        HashMap<String, String> variablesViewName = new HashMap<String, String>();
        variablesViewName.put("procDefId", this.messageHelper.getMessage("n_a"));
        variablesViewName.put("processType", this.messageHelper.getMessage("Typ_procesu"));
        variablesViewName.put("procName", this.messageHelper.getMessage("Nazwa_procesu"));
        variablesViewName.put("procDescr", this.messageHelper.getMessage("Opis_procesu"));
        variablesViewName.put("procInitiator", this.messageHelper.getMessage("Inicjator"));
        variablesViewName.put("procStateSelect", this.messageHelper.getMessage("Status_procesu"));
        variablesViewName.put("realizationPercent", this.messageHelper.getMessage("Procent_realizacji"));
        variablesViewName.put("procStart", this.messageHelper.getMessage("Data_rozpoczecia"));
        variablesViewName.put("procFinish", this.messageHelper.getMessage("Data_zakonczenia"));
        variablesViewName.put("processDeadline", this.messageHelper.getMessage("Przekroczenie_terminu_w_dn"));
        variablesViewName.put("taskName", this.messageHelper.getMessage("Nazwa_zadania"));
        variablesViewName.put("taskStateSelect", this.messageHelper.getMessage("Status_zadania"));
        variablesViewName.put("taskUser", this.messageHelper.getMessage("Uzytkownik"));
        variablesViewName.put("taskStart", this.messageHelper.getMessage("Data_rozpoczecia"));
        variablesViewName.put("taskFinish", this.messageHelper.getMessage("Data_zakonczenia"));
        variablesViewName.put("taskDeadline", this.messageHelper.getMessage("Przekroczenie_terminu_zadania_w_dn"));
        variablesViewName.put("onlyActiveTask", this.messageHelper.getMessage("Tylko_zadania_do_wykonania"));
        variablesViewName.put("onlyLoggedUserTask", this.messageHelper.getMessage("Tylko_moje_zadania"));
        return variablesViewName;
    }
}

