/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.administration.user;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.dto.administration.GroupDto;
import com.suncode.pwfl.web.dto.administration.structure.position.PositionDto;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class UserDto {
    private Long objectId;
    private String userName;
    private String firstName;
    private String lastName;
    private String email;
    private String number;
    private Boolean active;
    private Boolean onlySsoLogin;
    private List<PositionDto> positions;
    private List<GroupDto> groups;
    private boolean anonymous;
    private static LoadingCache<String, UserDto> loadingCache = CacheBuilder.newBuilder().refreshAfterWrite(10L, TimeUnit.SECONDS).maximumSize(100L).build((CacheLoader)new CacheLoader<String, UserDto>(){

        public UserDto load(String userId) throws Exception {
            UserService userService = ServiceFactory.getUserService();
            User user = userService.getUser(userId, new String[0]);
            if (user != null) {
                return new UserDto(user);
            }
            return null;
        }
    });

    public static UserDto get(String userId) {
        try {
            return (UserDto)loadingCache.get((Object)userId);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    private UserDto(User user) {
        this.setObjectId(user.getObjectId());
        this.setUserName(user.getUserName());
        this.setFirstName(user.getFirstName());
        this.setLastName(user.getLastName());
        this.setEmail(user.getEmail());
        this.setNumber(user.getNumber());
        this.setActive(user.isActive());
        this.setOnlySsoLogin(user.isOnlySsoLogin());
        this.setAnonymous(user.isAnonymous());
    }

    public static UserDto from(User user) {
        return UserDto.builder().objectId(user.getObjectId()).userName(user.getUserName()).firstName(user.getFirstName()).lastName(user.getLastName()).email(user.getEmail()).number(user.getNumber()).active(user.isActive()).onlySsoLogin(user.isOnlySsoLogin()).anonymous(user.isAnonymous()).build();
    }

    public static UserDtoBuilder builder() {
        return new UserDtoBuilder();
    }

    public Long getObjectId() {
        return this.objectId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getNumber() {
        return this.number;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Boolean getOnlySsoLogin() {
        return this.onlySsoLogin;
    }

    public List<PositionDto> getPositions() {
        return this.positions;
    }

    public List<GroupDto> getGroups() {
        return this.groups;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setOnlySsoLogin(Boolean onlySsoLogin) {
        this.onlySsoLogin = onlySsoLogin;
    }

    public void setPositions(List<PositionDto> positions) {
        this.positions = positions;
    }

    public void setGroups(List<GroupDto> groups) {
        this.groups = groups;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @ConstructorProperties(value={"objectId", "userName", "firstName", "lastName", "email", "number", "active", "onlySsoLogin", "positions", "groups", "anonymous"})
    public UserDto(Long objectId, String userName, String firstName, String lastName, String email, String number, Boolean active, Boolean onlySsoLogin, List<PositionDto> positions, List<GroupDto> groups, boolean anonymous) {
        this.objectId = objectId;
        this.userName = userName;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.number = number;
        this.active = active;
        this.onlySsoLogin = onlySsoLogin;
        this.positions = positions;
        this.groups = groups;
        this.anonymous = anonymous;
    }

    public UserDto() {
    }

    public static class UserDtoBuilder {
        private Long objectId;
        private String userName;
        private String firstName;
        private String lastName;
        private String email;
        private String number;
        private Boolean active;
        private Boolean onlySsoLogin;
        private List<PositionDto> positions;
        private List<GroupDto> groups;
        private boolean anonymous;

        UserDtoBuilder() {
        }

        public UserDtoBuilder objectId(Long objectId) {
            this.objectId = objectId;
            return this;
        }

        public UserDtoBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public UserDtoBuilder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public UserDtoBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public UserDtoBuilder email(String email) {
            this.email = email;
            return this;
        }

        public UserDtoBuilder number(String number) {
            this.number = number;
            return this;
        }

        public UserDtoBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public UserDtoBuilder onlySsoLogin(Boolean onlySsoLogin) {
            this.onlySsoLogin = onlySsoLogin;
            return this;
        }

        public UserDtoBuilder positions(List<PositionDto> positions) {
            this.positions = positions;
            return this;
        }

        public UserDtoBuilder groups(List<GroupDto> groups) {
            this.groups = groups;
            return this;
        }

        public UserDtoBuilder anonymous(boolean anonymous) {
            this.anonymous = anonymous;
            return this;
        }

        public UserDto build() {
            return new UserDto(this.objectId, this.userName, this.firstName, this.lastName, this.email, this.number, this.active, this.onlySsoLogin, this.positions, this.groups, this.anonymous);
        }

        public String toString() {
            return "UserDto.UserDtoBuilder(objectId=" + this.objectId + ", userName=" + this.userName + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", email=" + this.email + ", number=" + this.number + ", active=" + this.active + ", onlySsoLogin=" + this.onlySsoLogin + ", positions=" + this.positions + ", groups=" + this.groups + ", anonymous=" + this.anonymous + ")";
        }
    }
}

