/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.activity;

import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.process.ProcessEntity;
import com.suncode.pwfl.workflow.process.ProcessState;
import java.util.ArrayList;
import java.util.Date;

public class ActivityDto {
    private String activityId;
    private String activityDefId;
    private String activityName;
    private String activityDescription;
    private ActivityState activityState;
    private String processName;
    private String processId;
    private String processDefId;
    private String processDescription;
    private ProcessState processState;
    private Date comingDate;
    private Date finishDate;

    public static CountedResult<ActivityDto> build(CountedResult<Activity> activities) {
        CountedResult result = new CountedResult();
        ArrayList<ActivityDto> list = new ArrayList<ActivityDto>();
        for (Activity activity : activities.getData()) {
            list.add(ActivityDto.build(activity));
        }
        result.setData(list);
        result.setTotal(activities.getTotal());
        return result;
    }

    public static ActivityDto build(Activity activity) {
        ActivityDto dto = new ActivityDto();
        ProcessEntity process = activity.getProcess();
        String processDefId = process.getProcessDefinition().getProcessDefinitionId();
        dto.setActivityId(activity.getActivityId());
        dto.setActivityDefId(activity.getActivityDefinitionId());
        dto.setActivityName(activity.getName());
        dto.setActivityDescription(activity.getDescription());
        dto.setProcessDefId(processDefId);
        dto.setProcessName(process.getName());
        dto.setProcessId(process.getProcessId());
        dto.setProcessDescription(process.getDescription());
        dto.setActivityState(activity.getState());
        dto.setComingDate(activity.getCreatedTime());
        if (!ActivityState.isOpen((ActivityState)dto.getActivityState())) {
            dto.setFinishDate(activity.getLastStateTime());
        }
        dto.setProcessState(process.getState());
        return dto;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getActivityDefId() {
        return this.activityDefId;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public String getActivityDescription() {
        return this.activityDescription;
    }

    public ActivityState getActivityState() {
        return this.activityState;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public String getProcessDescription() {
        return this.processDescription;
    }

    public ProcessState getProcessState() {
        return this.processState;
    }

    public Date getComingDate() {
        return this.comingDate;
    }

    public Date getFinishDate() {
        return this.finishDate;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public void setActivityDefId(String activityDefId) {
        this.activityDefId = activityDefId;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public void setActivityDescription(String activityDescription) {
        this.activityDescription = activityDescription;
    }

    public void setActivityState(ActivityState activityState) {
        this.activityState = activityState;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }

    public void setProcessDescription(String processDescription) {
        this.processDescription = processDescription;
    }

    public void setProcessState(ProcessState processState) {
        this.processState = processState;
    }

    public void setComingDate(Date comingDate) {
        this.comingDate = comingDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }
}

