/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.summary;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.i18n.utils.SupportedLanguagesProvider;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.view.ViewFetchType;
import com.suncode.pwfl.view.ViewService;
import com.suncode.pwfl.view.dto.ViewDto;
import com.suncode.pwfl.web.dto.workflow.summary.ActivityDto;
import com.suncode.pwfl.web.dto.workflow.summary.DocumentClassDto;
import com.suncode.pwfl.web.dto.workflow.summary.LocaleDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.workflow.process.ProcessIndex;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.summary.SummaryService;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"summary"})
public class SummaryController {
    @Autowired
    private ViewService viewService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private SupportedLanguagesProvider supportedLanguagesProvider;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private SummaryService summaryService;

    @ResponseBody
    @RequestMapping(value={"activities"})
    public CountedResult<ActivityDto> getActiviesByView(@RequestParam String viewId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String query) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        if (StringUtils.isBlank((CharSequence)viewId)) {
            return new CountedResult();
        }
        Optional processDefIdOptional = this.summaryService.getProcessDefIdFromView(viewId);
        if (processDefIdOptional.isPresent()) {
            String processDefId = (String)processDefIdOptional.get();
            XpdlPackageManager xpdlPackageManager = XpdlPackageManager.getInstance();
            Package processPackage = xpdlPackageManager.getPackageByProcessDefinitionId(processDefId);
            WorkflowProcess workflowProcess = processPackage.getWorkflowProcess(processDefId);
            Activities activities = workflowProcess.getActivities();
            List<ActivityDto> activityDtos = new LinkedList<ActivityDto>();
            for (Object activityObject : activities.toElements()) {
                Activity activity = (Activity)activityObject;
                if (activity.getActivityType() != 1) continue;
                activityDtos.add(new ActivityDto(activity));
            }
            if (StringUtils.isNotBlank((CharSequence)query)) {
                activityDtos = activityDtos.stream().filter(activityDto -> activityDto.getName().toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList());
            }
            return Paginator.forAll(activityDtos).viewPageByOffset(start, limit);
        }
        throw new IllegalArgumentException("Zosta\u0142 poddany widok kt\u00f3ry nie ma wybranego jednego procesu");
    }

    @ResponseBody
    @RequestMapping(value={"locale"})
    public CountedResult<LocaleDto> getSupportedLocales(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String query) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List supportedLocales = Arrays.stream(this.supportedLanguagesProvider.getSupportedLocalesParam().split(";")).map(locale -> new LocaleDto((String)locale, (String)locale)).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)query)) {
            supportedLocales = supportedLocales.stream().filter(localeDto -> localeDto.getName().toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList());
        }
        return Paginator.forAll(supportedLocales).viewPageByOffset(start, limit);
    }

    @ResponseBody
    @RequestMapping(value={"/view"})
    public List<ViewDto> getAllViewsWithProcessSelected() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List viewDtos = this.viewService.getViews(ViewFetchType.ALL);
        viewDtos.sort(Comparator.comparing(ViewDto::getId));
        return viewDtos.stream().filter(viewDto -> this.summaryService.getProcessDefIdFromView(viewDto.getId().toString()).isPresent()).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(value={"/view/{viewId}"})
    public ViewDto getAllViewsWithProcessSelected(@PathVariable String viewId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.viewService.getUserSearchView(viewId);
    }

    @ResponseBody
    @RequestMapping(value={"/process/variables"})
    public List<ProcessIndex> getProcessVariablesFromView(@RequestParam String viewId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Optional processDefIdOptional = this.summaryService.getProcessDefIdFromView(viewId);
        if (processDefIdOptional.isPresent()) {
            String processDefId = (String)processDefIdOptional.get();
            return this.processService.getProcessIndexes(processDefId);
        }
        throw new IllegalArgumentException("Zosta\u0142 poddany widok kt\u00f3ry nie ma wybranego jednego procesu");
    }

    @ResponseBody
    @RequestMapping(value={"documentclass"})
    public CountedResult<DocumentClassDto> getDocumentClasses(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String query) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List documentClasses = this.documentClassService.getAll(new String[0]);
        documentClasses.sort(Comparator.comparing(DocumentClass::getId));
        List translatedDocClasses = documentClasses.stream().map(documentClass -> new DocumentClassDto(documentClass.getId(), this.documentClassService.getDocumentClassTranslation(documentClass.getId(), TranslatedFieldType.NAME))).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)query)) {
            translatedDocClasses = translatedDocClasses.stream().filter(documentClassDto -> documentClassDto.getTranslatedName().toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList());
        }
        return Paginator.forAll(translatedDocClasses).viewPageByOffset(start, limit);
    }
}

