/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.database;

import com.suncode.pwfl.database.DatabaseType;
import com.suncode.pwfl.database.NativeSqlUtils;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.controller.api.database.dto.ViewVariableDatabaseConfigDto;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"database/configs"})
public class DatabaseConfigController {
    @Autowired
    private MessageHelperBean messageHelper;

    @ResponseBody
    @RequestMapping(value={"/views/variables/columns"})
    public ViewVariableDatabaseConfigDto getViewVariableValueMaxLength() {
        return (ViewVariableDatabaseConfigDto)TransactionWrapper.get().doInJdbcConnection(connection -> {
            try {
                DatabaseMetaData metadata = connection.getMetaData();
                boolean isOracle = NativeSqlUtils.getDatabaseType() == DatabaseType.Oracle;
                String tableName = isOracle ? "pm_advancesearchvariables".toUpperCase() : "pm_advancesearchvariables";
                String columnName = isOracle ? "value".toUpperCase() : "value";
                ResultSet columns = metadata.getColumns(null, null, tableName, columnName);
                if (columns.next()) {
                    return new ViewVariableDatabaseConfigDto(columns.getInt("COLUMN_SIZE"));
                }
                throw new ServiceException(this.messageHelper.getMessage("Nie_znaleziono_kolumny"));
            }
            catch (SQLException e) {
                throw new ServiceException(e.getMessage());
            }
        });
    }
}

