/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user.security;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.security.PasswordPolicyProfile;
import com.suncode.pwfl.administration.user.security.domain.UserPasswordPolicyProfile;
import com.suncode.pwfl.administration.user.security.service.PasswordPolicyResolverService;
import com.suncode.pwfl.administration.user.security.service.PasswordPolicyService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.customform.ControllerResult;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"password/policy"})
public class PasswordPolicyController {
    private static final Logger log = LoggerFactory.getLogger(PasswordPolicyController.class);
    private final PasswordPolicyService passwordPolicyService;
    private final PasswordPolicyResolverService resolverService;
    private final UserService userService;
    private final MessageHelperBean messageHelper;
    private final AuthorizationHelper authorizationHelper;

    @ResponseBody
    @RequestMapping(value={"profile"}, method={RequestMethod.GET})
    public ResponseEntity<PasswordPolicyProfile> getProfileForUser(@RequestParam(value="username") String username) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        User user = this.userService.getUser(username, new String[]{"groups"});
        Assert.notNull((Object)user, (String)this.messageHelper.getMessage("Nie_znaleziono_uzytkownika_o_loginie", new Object[]{username}));
        Optional profile = this.resolverService.getForUser(user);
        if (profile.isPresent()) {
            return new ResponseEntity(profile.get(), HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @ResponseBody
    @RequestMapping(value={"profiles"}, method={RequestMethod.GET})
    public List<PasswordPolicyProfile> getAllProfiles() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.passwordPolicyService.getAllPolicies();
    }

    @ResponseBody
    @RequestMapping(value={"profile/create"}, method={RequestMethod.POST})
    public ResponseEntity<ControllerResult> createProfile(HttpServletRequest request, @RequestBody PasswordPolicyProfile passwordProfileDto) {
        AuditBuilder profileCreatedAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_PASSWORD_PROFILE_CREATED).params(passwordProfileDto.getAuditParams());
        this.authorizationHelper.assertFullAdministrationRights(() -> profileCreatedAudit.buildFailure(request));
        try {
            UserPasswordPolicyProfile profile = passwordProfileDto.toNewEntity();
            this.passwordPolicyService.create(profile);
            request.setAttribute("audit", (Object)profileCreatedAudit.success(true).build());
            return new ResponseEntity((Object)new ControllerResult(true), HttpStatus.CREATED);
        }
        catch (IllegalArgumentException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            request.setAttribute("audit", (Object)profileCreatedAudit.success(false).build());
            return new ResponseEntity((Object)new ControllerResult(false, ex.getMessage()), HttpStatus.NOT_ACCEPTABLE);
        }
    }

    @ResponseBody
    @RequestMapping(value={"profile/update"}, method={RequestMethod.POST})
    public ResponseEntity<ControllerResult> updateProfile(HttpServletRequest request, @RequestBody PasswordPolicyProfile passwordProfileDto) {
        AuditBuilder profileChangedAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_PASSWORD_PROFILE_CHANGED);
        this.authorizationHelper.assertFullAdministrationRights(() -> profileChangedAudit.buildFailure(request));
        try {
            UserPasswordPolicyProfile profile = this.passwordPolicyService.get(passwordProfileDto.getId());
            Assert.notNull((Object)profile, (String)("Profile " + passwordProfileDto.getId() + " does not exist"));
            profileChangedAudit.params(passwordProfileDto.getChangedAuditParams(profile));
            passwordProfileDto.fillEntity(profile);
            this.passwordPolicyService.update(profile);
            request.setAttribute("audit", (Object)profileChangedAudit.success(true).build());
            return new ResponseEntity((Object)new ControllerResult(true), HttpStatus.OK);
        }
        catch (IllegalArgumentException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            request.setAttribute("audit", (Object)profileChangedAudit.success(false).build());
            return new ResponseEntity((Object)new ControllerResult(false, ex.getMessage()), HttpStatus.NOT_ACCEPTABLE);
        }
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"profile/{profileId}"}, method={RequestMethod.DELETE})
    public void deleteProfile(HttpServletRequest request, @PathVariable(value="profileId") Long profileId) {
        AuditBuilder profileChangedAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_PASSWORD_PROFILE_REMOVED).params((Map)ImmutableMap.of((Object)"passwordProfileId", (Object)profileId));
        this.authorizationHelper.assertFullAdministrationRights(() -> profileChangedAudit.buildFailure(request));
        try {
            PasswordPolicyProfile toRemove = PasswordPolicyProfile.create((UserPasswordPolicyProfile)this.passwordPolicyService.get(profileId));
            this.passwordPolicyService.remove(toRemove.getId());
            request.setAttribute("audit", (Object)profileChangedAudit.params(toRemove.getAuditParams()).success(true).build());
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            request.setAttribute("audit", (Object)profileChangedAudit.success(false).build());
            throw ex;
        }
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"profiles/priorities/update"}, method={RequestMethod.POST})
    public void updateProfilesPriority(HttpServletRequest request, @RequestBody List<Long> profileIds) {
        AuditBuilder prioritiesUpdatedAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_PASSWORD_PROFILE_PRIORITY_CHANGED);
        this.authorizationHelper.assertFullAdministrationRights(() -> prioritiesUpdatedAudit.buildFailure(request));
        try {
            TransactionTemplate template = new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager());
            List updated = (List)template.execute(transactionStatus -> {
                List profilesList = profileIds.stream().map(arg_0 -> ((PasswordPolicyService)this.passwordPolicyService).get(arg_0)).collect(Collectors.toList());
                LinkedList<UserPasswordPolicyProfile> toUpdate = new LinkedList<UserPasswordPolicyProfile>();
                for (int i = 0; i < profilesList.size(); ++i) {
                    UserPasswordPolicyProfile profile = (UserPasswordPolicyProfile)profilesList.get(i);
                    if (profile.getPriority().intValue() == i) continue;
                    profile.setPriority(Long.valueOf(i));
                    toUpdate.add(profile);
                }
                toUpdate.forEach(arg_0 -> ((PasswordPolicyService)this.passwordPolicyService).update(arg_0));
                return toUpdate;
            });
            String prioritiesParam = updated.stream().map(profile -> profile.getProfileKey() + "->" + profile.getPriority()).collect(Collectors.joining("</br>"));
            request.setAttribute("audit", (Object)prioritiesUpdatedAudit.params((Map)ImmutableMap.of((Object)"changedPriorities", (Object)prioritiesParam)).success(true).build());
        }
        catch (Exception ex) {
            request.setAttribute("audit", (Object)prioritiesUpdatedAudit.success(false).build());
            log.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleIllegalArgumentException(IllegalArgumentException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"passwordPolicyService", "resolverService", "userService", "messageHelper", "authorizationHelper"})
    @Autowired
    public PasswordPolicyController(PasswordPolicyService passwordPolicyService, PasswordPolicyResolverService resolverService, UserService userService, MessageHelperBean messageHelper, AuthorizationHelper authorizationHelper) {
        this.passwordPolicyService = passwordPolicyService;
        this.resolverService = resolverService;
        this.userService = userService;
        this.messageHelper = messageHelper;
        this.authorizationHelper = authorizationHelper;
    }
}

