/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.scheduledtask.info.ScheduledTaskFactory;
import com.suncode.pwfl.administration.scheduledtask.info.parameter.ComponentFileCandidate;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleFinder;
import com.suncode.pwfl.administration.user.Deactivation;
import com.suncode.pwfl.administration.user.DeactivationHook;
import com.suncode.pwfl.administration.user.DeactivationUtils;
import com.suncode.pwfl.administration.user.ExtraTransfer;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.deactivation.DeactivationParamDto;
import com.suncode.pwfl.hook.HookRegistry;
import com.suncode.pwfl.i18n.xpdl.PackageTranslationHelper;
import com.suncode.pwfl.util.exception.CouldNotTransferOtherActivitiesException;
import com.suncode.pwfl.web.dto.userdeactivation.ActivityTypeDto;
import com.suncode.pwfl.web.dto.userdeactivation.DeactivationDto;
import com.suncode.pwfl.web.dto.userdeactivation.ParticipantDto;
import com.suncode.pwfl.web.dto.userdeactivation.ProcessTypeDto;
import com.suncode.pwfl.web.util.JsonMessage;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityRedirection;
import com.suncode.pwfl.workflow.activity.ActivityRedirectionService;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityType;
import com.suncode.pwfl.workflow.assignment.AssignmentService;
import com.suncode.pwfl.workflow.assignment.WfParticipant;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessType;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/userdeactivation"})
public class UserDeactivationController {
    private static final Logger log = LoggerFactory.getLogger(UserDeactivationController.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityRedirectionService activityRedirectonService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private UserService userService;
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private UserGroupFinder userGroupFinder;
    @Autowired
    private RoleFinder roleFinder;
    @Autowired
    private HookRegistry hookRegistry;
    @Autowired
    private ScheduledTaskFactory scheduledTaskFactory;

    @ResponseBody
    @RequestMapping(value={"deactivate"}, method={RequestMethod.POST})
    @Transactional
    public JsonMessage deactive(HttpServletRequest request, @RequestBody DeactivationDto deactivation) {
        JsonMessage msg = new JsonMessage();
        if (deactivation.getRunInScheduledTask().booleanValue()) {
            this.createDeactivationScheduledTask(deactivation);
            String auditExtraParams = this.prepareUserDeactivationAuditExtraParams(deactivation);
            request.setAttribute("auditExtraParam", (Object)auditExtraParams);
            request.setAttribute("auditSuccess", (Object)true);
            return msg;
        }
        Deactivation convertedDeactivation = DeactivationDto.convertToDeactivation(deactivation);
        try {
            this.userService.deactivateUser(convertedDeactivation);
        }
        catch (CouldNotTransferOtherActivitiesException e) {
            msg.setData((Object)"otherTransferFailed");
        }
        String auditExtraParams = this.prepareUserDeactivationAuditExtraParams(deactivation);
        request.setAttribute("auditExtraParam", (Object)auditExtraParams);
        request.setAttribute("auditSuccess", (Object)true);
        return msg;
    }

    private void createDeactivationScheduledTask(DeactivationDto deactivationDto) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        calendar.set(12, 30);
        ObjectMapper objectMapper = new ObjectMapper();
        DeactivationParamDto deactivationParamDto = DeactivationDto.convertToDeactivationParamDto(deactivationDto);
        byte[] serializedDeactivationParamDto = objectMapper.writeValueAsBytes((Object)deactivationParamDto);
        this.scheduledTaskFactory.beginTaskCreation().fromComponentWithId("deactivate-user-task").withFirstRun(calendar.getTime()).withPeriodDays(360L).withActive(true).withRunOnce(true).withSaveHistory(true).withCategory("System").withParameter("deactivationDtoFile").withValue(new ComponentFileCandidate("deactivation-dto.json", () -> new ByteArrayInputStream(serializedDeactivationParamDto))).createTask();
    }

    private String prepareUserDeactivationAuditExtraParams(DeactivationDto deactivation) {
        StringBuilder message = new StringBuilder();
        message.append(this.addParam("isScheduledDeactivation", deactivation.getRunInScheduledTask()));
        message.append(this.addParam("deactivatedUsername", deactivation.getUserName()));
        message.append(this.addParam("delegationUser", deactivation.getDelegationUser()));
        message.append(this.addParam("notificationUser", deactivation.getNotificationUser()));
        message.append(this.addParam("reportUser", deactivation.getReportUser()));
        message.append(this.addParam("viewUser", deactivation.getViewUser()));
        message.append(this.addParam("otherAcitivitiesUser", deactivation.getOtherAcitivitiesUser()));
        message.append(this.addParam("favouriteSetsUser", deactivation.getFavouriteSetsUser()));
        message.append(this.addParam("skipSubstitutions", deactivation.getSkipSubstitutions()));
        message.append(this.addParam("skipNotifications", deactivation.getSkipNotifications()));
        message.append(this.addParam("performConcurrently", deactivation.getPerformConcurrently()));
        List<ProcessTypeDto> processes = deactivation.getProcesses();
        message.append(this.addParam("processAssignment", this.prepareProcessAssignmentField(processes)));
        return message.toString();
    }

    private String prepareProcessAssignmentField(List<ProcessTypeDto> processList) {
        StringBuilder builder = new StringBuilder();
        for (ProcessTypeDto processType : processList) {
            String processName = processType.getName();
            for (ParticipantDto participant : processType.getChildren()) {
                String participantName = participant.getName();
                for (ActivityTypeDto activityType : participant.getChildren()) {
                    String activityName = activityType.getName();
                    for (String assignment : activityType.getAssignments()) {
                        builder.append(processName).append(" > ");
                        builder.append(participantName).append(" > ");
                        builder.append(activityName).append(" > ");
                        builder.append(assignment).append("</br></br>");
                    }
                }
            }
        }
        return builder.toString();
    }

    private String addParam(String param, Object object) {
        StringBuilder builder = new StringBuilder();
        builder.append(param).append("=").append(object).append("@AUDIT_PARAM@");
        return builder.toString();
    }

    @ResponseBody
    @RequestMapping(value={"change"}, method={RequestMethod.POST})
    public JsonMessage change(HttpServletRequest request, @RequestBody DeactivationDto deactivation) {
        this.transferActivities(deactivation);
        this.updateActivityRedirections(deactivation);
        String auditExtraParams = this.prepareEditDeactivatedUserAuditExtraParams(deactivation);
        request.setAttribute("auditExtraParam", (Object)auditExtraParams);
        request.setAttribute("auditSuccess", (Object)true);
        return new JsonMessage();
    }

    private String prepareEditDeactivatedUserAuditExtraParams(DeactivationDto deactivation) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.addParam("deactivatedUsername", deactivation.getUserName()));
        builder.append(this.addParam("skipSubstitutions", deactivation.getSkipSubstitutions()));
        builder.append(this.addParam("skipNotifications", deactivation.getSkipNotifications()));
        builder.append(this.addParam("processAssignment", this.prepareProcessAssignmentField(deactivation.getProcesses())));
        return builder.toString();
    }

    @Deprecated
    @ResponseBody
    @RequestMapping(value={"deactivate"}, method={RequestMethod.GET})
    public List<ProcessTypeDto> getDeactivations(@RequestParam String userName) {
        return this.getProcesses(userName);
    }

    @ResponseBody
    @RequestMapping(value={"deactivate/processes"}, method={RequestMethod.GET})
    public List<ProcessTypeDto> getProcesses(@RequestParam String userName) {
        List list = this.activityRedirectonService.getRedirections(userName);
        List<ProcessTypeDto> processes = this.buildDto(userName, list);
        return processes;
    }

    private List<ProcessTypeDto> buildDto(String userName, List<ActivityRedirection> list) {
        List<ProcessTypeDto> procs = this.getProcessTypesForUser(userName);
        for (ActivityRedirection activityRedirection : list) {
            ActivityTypeDto atd;
            Role role;
            String processDefId = activityRedirection.getProcessDefId();
            String packageId = XpdlPackageManager.getInstance().getPackageIdByProcessDefinitionId(processDefId);
            String activityDefId = activityRedirection.getActivityDefId();
            String activityName = this.activityService.getActivityName(processDefId, activityDefId);
            if (activityName == null) continue;
            ProcessTypeDto ptd = this.getByProcDefId(processDefId, procs);
            if (ptd == null) {
                ptd = new ProcessTypeDto();
                ptd.setProcessDefId(processDefId);
                ptd.setPackageId(XpdlPackageManager.getInstance().getPackageIdByProcessDefinitionId(processDefId));
                ptd.setName(PackageTranslationHelper.getProcessName((String)packageId, (String)processDefId));
                procs.add(ptd);
            }
            if (ptd.getChildren() == null) {
                ptd.setChildren(new ArrayList<ParticipantDto>());
            }
            if ((role = this.roleFinder.findByActivity(packageId, processDefId, activityDefId)) == null) continue;
            ParticipantDto pdto = this.getPart(ptd, role);
            if (pdto == null) {
                String roleName = role.getRoleName();
                String roleId = role.getRoleId();
                pdto = new ParticipantDto();
                pdto.setId(roleId);
                pdto.setName(roleName);
                pdto.setChildren(new ArrayList<ActivityTypeDto>());
            }
            if ((atd = this.getActivity(pdto, activityDefId)).getAssignments() == null) {
                atd.setAssignments(new ArrayList<String>());
            }
            atd.getAssignments().addAll(this.getAssigments(activityRedirection, atd.isGroup(), atd.getAssignments()));
            if (!this.isGroup(activityRedirection)) continue;
            atd.setGroup(true);
        }
        return procs;
    }

    private boolean isGroup(ActivityRedirection activityRedirection) {
        return activityRedirection.getTargetGroups() != null && !activityRedirection.getTargetGroups().isEmpty();
    }

    private ActivityTypeDto getActivity(ParticipantDto pdto, String activityDefId) {
        for (ActivityTypeDto atd : pdto.getChildren()) {
            if (!atd.getActivityDefId().equals(activityDefId)) continue;
            return atd;
        }
        return null;
    }

    private ParticipantDto getPart(ProcessTypeDto ptd, Role role) {
        for (ParticipantDto p : ptd.getChildren()) {
            if (!p.getId().equals(role.getRoleId())) continue;
            return p;
        }
        return null;
    }

    private ProcessTypeDto getByProcDefId(String processDefId, List<ProcessTypeDto> procs) {
        for (ProcessTypeDto processTypeDto : procs) {
            if (!processTypeDto.getProcessDefId().equals(processDefId)) continue;
            return processTypeDto;
        }
        return null;
    }

    private List<String> getAssigments(ActivityRedirection ar, boolean isGroup, List<String> assigments) {
        ArrayList<String> list = new ArrayList<String>();
        if (ar.getTargetUsers() != null && !ar.getTargetUsers().isEmpty()) {
            for (User user : ar.getTargetUsers()) {
                if (assigments.contains(user.getUserName())) continue;
                list.add(user.getUserName());
            }
        } else {
            for (UserGroup group : ar.getTargetGroups()) {
                if (assigments.contains(group.getName())) continue;
                list.add(group.getName());
            }
        }
        return list;
    }

    @ResponseBody
    @RequestMapping(value={"deactivate/extratransfers"}, method={RequestMethod.GET})
    public List<ExtraTransfer> getExtraTransfers(Locale locale) {
        LinkedList<ExtraTransfer> extraTransfers = new LinkedList<ExtraTransfer>();
        ((DeactivationHook)this.hookRegistry.invoke(DeactivationHook.class)).onWindowOpen(locale, extraTransfers);
        return extraTransfers;
    }

    @ResponseBody
    @RequestMapping(value={"activate"}, method={RequestMethod.GET})
    public JsonMessage activate(@RequestParam String userName) {
        this.userService.activateUser(userName);
        return new JsonMessage();
    }

    @ResponseBody
    @RequestMapping(value={"emptyTaskUser"})
    public List<User> getEmptyTaskUser(@RequestParam(required=false) String userToDeactivate) {
        String[] usersName;
        String defaultUserName = "admin";
        ArrayList<User> users = new ArrayList<User>();
        String emptyTaskUsersName = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.EMPTY_TASK_USER_NAME);
        if (StringUtils.isBlank((String)emptyTaskUsersName)) {
            emptyTaskUsersName = defaultUserName;
        }
        for (String userName : usersName = emptyTaskUsersName.split(";")) {
            if (!StringUtils.equals((String)userName, (String)userToDeactivate) || StringUtils.isBlank((String)userToDeactivate)) {
                User u = this.userService.getUser(userName, new String[0]);
                if (u != null) {
                    users.add(u);
                    continue;
                }
                log.warn("U\u017cytkownik " + userName + " podany w parametrze emptyTaskUserName nie istnieje w systemie. Pomijam.");
                continue;
            }
            log.warn("U\u017cytkownik " + userName + " podany w parametrze emptyTaskUserName jest u\u017cytkownikiem, kt\u00f3rego dezaktywujemy. Pomijam.");
        }
        if (users.isEmpty()) {
            users.add(this.userService.getUser(defaultUserName, new String[0]));
        }
        return users;
    }

    @RequestMapping(value={"processTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProcessTypeDto> getProcessTypesForUser(@RequestParam String userName) {
        List procTypes = this.processService.getAllProcessTypes(true);
        ArrayList<ProcessTypeDto> processes = new ArrayList<ProcessTypeDto>();
        List allAcitvitiesAssignedToUser = this.activityFinder.findActivitiesAssignedToUser(userName, new String[]{"process", "processDefinition"});
        for (ProcessType processType : procTypes) {
            ProcessTypeDto ptd = new ProcessTypeDto(processType);
            List parts = this.processService.getParticipantsFromProcess(ptd.getProcessDefId());
            List<ParticipantDto> parDto = this.convertToParticipantDto(userName, ptd.getProcessDefId(), parts, allAcitvitiesAssignedToUser);
            ptd.setChildren(parDto);
            processes.add(ptd);
        }
        return processes;
    }

    private List<ParticipantDto> convertToParticipantDto(String userName, String processDefId, List<WfParticipant> parts, List<Activity> allAcitvitiesAssignedToUser) {
        Map acts = this.processService.getRoleActivityMap(processDefId);
        ArrayList<ParticipantDto> pd = new ArrayList<ParticipantDto>();
        for (WfParticipant wfParticipant : parts) {
            ParticipantDto pp = new ParticipantDto(wfParticipant);
            List activityTypes = DeactivationUtils.getActivityTypes((WfParticipant)wfParticipant, (Map)acts);
            List<ActivityTypeDto> atd = this.convertToActivityTypeDto(processDefId, activityTypes, allAcitvitiesAssignedToUser);
            pp.setChildren(atd);
            pd.add(pp);
        }
        return pd;
    }

    private List<ActivityTypeDto> convertToActivityTypeDto(String processDefId, List<ActivityType> acts, List<Activity> allAcitvitiesAssignedToUser) {
        ArrayList<ActivityTypeDto> list = new ArrayList<ActivityTypeDto>();
        for (ActivityType at : acts) {
            boolean assing = this.doesUserAssignToActivity(processDefId, at.getActivityDefId(), allAcitvitiesAssignedToUser);
            ActivityTypeDto atd = new ActivityTypeDto(at, assing);
            list.add(atd);
        }
        return list;
    }

    private void updateActivityRedirections(DeactivationDto deactivation) {
        ArrayList<ActivityRedirection> list = new ArrayList<ActivityRedirection>();
        String userName = deactivation.getUserName();
        User user = this.userService.getUser(userName, new String[0]);
        for (ProcessTypeDto ptd : deactivation.getProcesses()) {
            for (ParticipantDto pd : ptd.getChildren()) {
                for (ActivityTypeDto atd : pd.getChildren()) {
                    ActivityRedirection ar = this.buildActivityRedirection(user, ptd.getProcessDefId(), atd);
                    list.add(ar);
                }
            }
        }
        this.activityRedirectonService.updateActivityRedirections(list, userName);
    }

    private ActivityRedirection buildActivityRedirection(User user, String processDefId, ActivityTypeDto atd) {
        List<String> assignments = null;
        assignments = atd.getAssignments();
        ActivityRedirection ar = new ActivityRedirection();
        if (atd.isGroup()) {
            ar.setTargetGroups(this.getGroups(assignments));
        } else {
            ar.setTargetUsers(this.getUsers(assignments));
        }
        ar.setProcessDefId(processDefId);
        ar.setSourceUser(user);
        ar.setActivityDefId(atd.getActivityDefId());
        return ar;
    }

    private Set<UserGroup> getGroups(List<String> groupNames) {
        DetachedCriteria dc = DetachedCriteria.forClass(UserGroup.class);
        if (groupNames.isEmpty()) {
            return Collections.emptySet();
        }
        dc.add(Restrictions.in((String)"name", groupNames));
        List groups = this.userGroupFinder.findByCriteria(dc);
        return new HashSet<UserGroup>(groups);
    }

    private Set<User> getUsers(List<String> userNames) {
        DetachedCriteria dc = DetachedCriteria.forClass(User.class);
        dc.add(Restrictions.in((String)"userName", userNames));
        List users = this.userFinder.findByCriteria(dc);
        return new HashSet<User>(users);
    }

    private void transferActivities(DeactivationDto deactivation) {
        if (deactivation.getProcesses() == null) {
            return;
        }
        String userName = deactivation.getUserName();
        for (ProcessTypeDto ptd : deactivation.getProcesses()) {
            for (ParticipantDto pd : ptd.getChildren()) {
                for (ActivityTypeDto atd : pd.getChildren()) {
                    if (atd.isGroup()) {
                        this.assignmentService.transferToGroups(ptd.getProcessDefId(), atd.getActivityDefId(), userName, atd.getAssignments(), deactivation.getSkipSubstitutions().booleanValue(), deactivation.getSkipNotifications().booleanValue());
                        continue;
                    }
                    this.assignmentService.transferToUsersAndReturnAssignments(ptd.getProcessDefId(), atd.getActivityDefId(), userName, atd.getAssignments(), null, deactivation.getSkipSubstitutions().booleanValue(), deactivation.getSkipNotifications().booleanValue());
                }
            }
        }
    }

    private boolean doesUserAssignToActivity(String processDefId, String activityDefId, List<Activity> allAcitvitiesAssignedToUser) {
        return allAcitvitiesAssignedToUser.stream().anyMatch(activity -> activityDefId.equals(activity.getActivityDefinitionId()) && processDefId.equals(activity.getProcess().getProcessDefinition().getProcessDefinitionId()));
    }

    @ResponseBody
    @Transactional
    @RequestMapping(value={"assignments/count"}, method={RequestMethod.GET})
    public int assignmentsCount(@RequestParam String userName) {
        return this.assignmentService.getAssignmentsCount(userName);
    }
}

