/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.systemMessages;

import com.google.common.collect.ImmutableMap;
import com.suncode.plugin.dashboard.web.support.RestResult;
import com.suncode.pwfl.administration.systemMessage.SystemMessage;
import com.suncode.pwfl.administration.systemMessage.SystemMessageNotFoundException;
import com.suncode.pwfl.administration.systemMessage.SystemMessageReadHistoryService;
import com.suncode.pwfl.administration.systemMessage.SystemMessageService;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.web.dto.administration.systemMessages.AddSystemMessageDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/systemMessage"})
public class SystemMessageController {
    private static final Logger log = LoggerFactory.getLogger(SystemMessageController.class);
    @Autowired
    private SystemMessageService systemMessageService;
    @Autowired
    private SystemMessageReadHistoryService systemMessageReadHistoryService;
    @Autowired
    private AuthorizationHelper authorizationHelper;

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.GET})
    private CountedResult<SystemMessage> getSystemMessages(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="id") String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.systemMessageService.getSystemMessages(start, limit, orderBy, orderDirection);
    }

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.POST})
    private void addSystemMessage(@RequestBody AddSystemMessageDto addSystemMessageDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_SYSTEM_MESSAGE).params(addSystemMessageDto.getAuditParams());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            SystemMessage systemMessage = addSystemMessageDto.toEntity();
            this.systemMessageService.save((Object)systemMessage);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    private void deleteMessage(@PathVariable long id, HttpServletRequest request) throws SystemMessageNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_SYSTEM_MESSAGE).params((Map)ImmutableMap.of((Object)"SYSTEM_MESSAGE_ID", (Object)id));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            SystemMessage systemMessage = this.systemMessageService.get(Long.valueOf(id));
            this.systemMessageService.delete((Object)systemMessage);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PATCH})
    private ResponseEntity<?> updateMessageStatus(@PathVariable long id, @RequestParam boolean enabled, HttpServletRequest request) throws SystemMessageNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CHANGE_STATUS_SYSTEM_MESSAGE).params((Map)ImmutableMap.of((Object)"SYSTEM_MESSAGE_ID", (Object)id, (Object)"SYSTEM_MESSAGE_ENABLED", (Object)enabled));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            SystemMessage systemMessage = this.systemMessageService.get(Long.valueOf(id));
            systemMessage.setEnabled(enabled);
            this.systemMessageService.update((Object)systemMessage);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/{messageId}/read"}, method={RequestMethod.POST})
    public ResponseEntity<?> markMessageAsRead(@PathVariable long messageId, @RequestParam(required=false) Boolean lastMessage, HttpServletRequest request) throws SystemMessageNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_READ_SYSTEM_MESSAGE);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("SYSTEM_MESSAGE_ID", messageId);
        auditBuilder.params(params);
        try {
            SystemMessage systemMessage = this.systemMessageService.get(Long.valueOf(messageId));
            params.put("SYSTEM_MESSAGE", systemMessage.getMessage());
            auditBuilder.params(params);
            this.systemMessageReadHistoryService.markAsRead(systemMessage, UserContext.current().getUser().getUserName());
            if (lastMessage.booleanValue()) {
                request.getSession().removeAttribute("showSystemMessages");
            }
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/sanitize"}, method={RequestMethod.POST})
    public ResponseEntity<?> sanitizeMessage(@RequestBody String message) {
        return new ResponseEntity((Object)this.systemMessageService.sanitizeMessage(message), HttpStatus.OK);
    }

    @ExceptionHandler(value={SystemMessageNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleNotFoundException(Exception e) {
        return new RestResult(false, e.getMessage());
    }
}

