/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.position;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.structure.exception.PositionAlreadyExistException;
import com.suncode.pwfl.administration.structure.exception.PositionNotFoundException;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.CollatorInstance;
import com.suncode.pwfl.util.exception.EmptyPropertyException;
import com.suncode.pwfl.web.dto.administration.RoleDto;
import com.suncode.pwfl.web.dto.administration.structure.position.AddPositionDto;
import com.suncode.pwfl.web.dto.administration.structure.position.PositionDto;
import com.suncode.pwfl.web.dto.administration.structure.position.StructurePositionDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"positions"})
public class PositionController {
    private final PositionFinder positionFinder;
    private final StructureService structureService;
    private final UserService userService;
    private final AuthorizationHelper authorizationHelper;
    private final ExportService exportService;
    private final RoleService roleService;
    private final MessageHelperBean messageHelper;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<StructurePositionDto> getPositions(HttpServletRequest request, @RequestParam(required=false) String name, @RequestParam(required=false) String symbol, @RequestParam(required=false) String overName, @RequestParam(required=false) String overSymbol, @RequestParam(required=false) String orgName, @RequestParam(required=false) String orgSymbol, @RequestParam(required=false) Long role, @RequestParam(required=false) String userName, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) boolean isSearch) {
        CountedResult positions;
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SEARCH_POSITION);
        auditBuilder.params((Map)ImmutableMap.of((Object)"positionName", (Object)StringUtils.defaultString((String)name), (Object)"positionSymbol", (Object)StringUtils.defaultString((String)symbol), (Object)"positionHigherPosition", (Object)StringUtils.defaultString((String)overName), (Object)"positionOrganizationalUnit", (Object)StringUtils.defaultString((String)orgName)));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            positions = this.structureService.getPositions(name, symbol, overName, overSymbol, orgName, orgSymbol, role, userName, Pagination.create((Sorter)new Sorter(sortBy, sortDirection), (Integer)start, (Integer)limit));
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        if (isSearch) {
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        List positionDtos = positions.getData().stream().map(StructurePositionDto::from).collect(Collectors.toList());
        return new CountedResult(positions.getTotal(), positionDtos);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public RestResult addPosition(HttpServletRequest request, @RequestBody AddPositionDto position) throws PositionAlreadyExistException, EmptyPropertyException, PositionNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_POSITION);
        Map<String, Object> params = this.initAddPositionAuditParams(position);
        auditBuilder.params(params);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            Position newPosition = new Position(position.getPositionName().trim(), position.getPositionSymbol().trim());
            this.addDirectorAndOrganizationalUnit(position, newPosition);
            this.structureService.validatePosition(newPosition);
            Long positionId = this.structureService.createPosition(newPosition);
            Map<String, Object> allParams = this.updateAddPositionIdAuditParams(params, positionId);
            auditBuilder.params(allParams);
            if (!Objects.isNull(position.getRolesId()) && position.getRolesId().size() != 0) {
                List<Long> roleIds = position.getRolesId();
                this.roleService.addRoles(positionId, roleIds);
                auditBuilder.params(this.updateAddPositionRolesAuditParams(allParams, roleIds.stream().map(roleId -> this.roleService.getRole(roleId)).collect(Collectors.toList())));
            }
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    private Map<String, Object> updateAddPositionRolesAuditParams(Map<String, Object> params, List<Role> roles) {
        return ImmutableMap.builder().putAll(params).put((Object)"positionRoles", (Object)roles.stream().map(role -> String.valueOf(role.getId())).collect(Collectors.joining(";"))).put((Object)"positionRolesName", (Object)roles.stream().map(Role::getRoleName).collect(Collectors.joining(", "))).build();
    }

    private Map<String, Object> updateAddPositionIdAuditParams(Map<String, Object> params, Long positionId) {
        return ImmutableMap.builder().putAll(params).put((Object)"positionId", (Object)positionId).build();
    }

    private Map<String, Object> initAddPositionAuditParams(AddPositionDto position) {
        Position higherPosition = null;
        OrganizationalUnit organizationalUnit = null;
        if (Objects.nonNull(position.getHigherPositionId())) {
            higherPosition = this.structureService.getPosition(position.getHigherPositionId(), new String[0]);
        }
        if (Objects.nonNull(position.getOrganizationalUnitId())) {
            organizationalUnit = this.structureService.getOrganizationalUnit(position.getOrganizationalUnitId(), new String[0]);
        }
        String higherPositionId = higherPosition != null ? String.valueOf(higherPosition.getId()) : "";
        String organizationalUnitId = organizationalUnit != null ? String.valueOf(organizationalUnit.getId()) : "";
        String organizationalUnitName = organizationalUnit != null ? organizationalUnit.getSymbol() + " - " + organizationalUnit.getName() : "";
        String higherPositionName = higherPosition != null ? higherPosition.getSymbol() + " - " + higherPosition.getName() : "";
        return ImmutableMap.builder().put((Object)"positionName", (Object)position.getPositionName()).put((Object)"positionSymbol", (Object)position.getPositionSymbol()).put((Object)"positionHigherPosition", (Object)higherPositionId).put((Object)"positionHigherPositionName", (Object)higherPositionName).put((Object)"positionOrganizationalUnit", (Object)organizationalUnitId).put((Object)"positionOrganizationalUnitName", (Object)organizationalUnitName).build();
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResult changePosition(HttpServletRequest request, @PathVariable Long id, @RequestBody AddPositionDto positionDto) throws PositionNotFoundException, PositionAlreadyExistException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_POSITION);
        Map<String, Object> idParam = this.updatePositionIdAuditParams(id);
        auditBuilder.params(idParam);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        Position oldPosition = this.structureService.getPosition(id, new String[]{"organizationalUnit", "higherPosition"});
        if (Objects.isNull(oldPosition)) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new PositionNotFoundException(this.messageHelper.getMessage("Stanowisko_o_podanym_id_nie_istnieje"));
        }
        auditBuilder.params(this.updatePositionAuditParams(positionDto, oldPosition, idParam));
        try {
            List positionRoles = this.roleService.getRolesForPosition(id, "roleId", SortDirection.ASC).stream().map(Role::getId).collect(Collectors.toList());
            Position position = new Position(positionDto.getPositionName().trim(), positionDto.getPositionSymbol().trim());
            position.setId(id);
            position.setUser(oldPosition.getUser());
            this.addDirectorAndOrganizationalUnit(positionDto, position);
            this.structureService.changePosition(position);
            if (positionRoles.size() > 0) {
                this.roleService.detachAllRoles(id);
                this.roleService.addRoles(id, positionRoles);
            }
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    private Map<String, Object> updatePositionAuditParams(AddPositionDto positionDto, Position oldPosition, Map<String, Object> idParam) {
        OrganizationalUnit orgUnit = null;
        Position higherPosition = null;
        if (!Objects.isNull(positionDto.getOrganizationalUnitId())) {
            orgUnit = this.structureService.getOrganizationalUnit(positionDto.getOrganizationalUnitId(), new String[0]);
        }
        if (!Objects.isNull(positionDto.getHigherPositionId())) {
            higherPosition = this.structureService.getPosition(positionDto.getHigherPositionId(), new String[0]);
        }
        String oldOrgUnitName = oldPosition.getOrganizationalUnit() != null ? oldPosition.getOrganizationalUnit().getSymbol() + " - " + oldPosition.getOrganizationalUnit().getName() : "";
        String oldHigherPositionName = oldPosition.getHigherPosition() != null ? oldPosition.getHigherPosition().getSymbol() + " - " + oldPosition.getHigherPosition().getName() : "";
        String higherPositionName = higherPosition != null ? higherPosition.getSymbol() + " - " + higherPosition.getName() : "";
        String orgUnitName = orgUnit != null ? orgUnit.getSymbol() + " - " + orgUnit.getName() : "";
        return ImmutableMap.builder().putAll(idParam).put((Object)"positionName", (Object)(oldPosition.getName() + ";" + positionDto.getPositionName())).put((Object)"positionSymbol", (Object)(oldPosition.getSymbol() + " > " + positionDto.getPositionSymbol())).put((Object)"positionHigherPosition", (Object)(oldHigherPositionName + ";" + higherPositionName)).put((Object)"positionOrganizationalUnit", (Object)(oldOrgUnitName + ";" + orgUnitName)).build();
    }

    private Map<String, Object> updatePositionIdAuditParams(Long id) {
        return ImmutableMap.builder().put((Object)"positionId", (Object)StringUtils.defaultString((String)String.valueOf(id))).build();
    }

    private void addDirectorAndOrganizationalUnit(AddPositionDto positionDto, Position position) {
        if (!Objects.isNull(positionDto.getHigherPositionId())) {
            position.setHigherPosition(this.structureService.getPosition(positionDto.getHigherPositionId(), new String[0]));
        }
        if (!Objects.isNull(positionDto.getOrganizationalUnitId())) {
            position.setOrganizationalUnit(this.structureService.getOrganizationalUnit(positionDto.getOrganizationalUnitId(), new String[0]));
        }
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deletePosition(HttpServletRequest request, @PathVariable Long id) throws PositionNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_POSITION);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("positionId", id);
        auditBuilder.params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        Position positionToDelete = this.structureService.getPosition(id, new String[0]);
        if (Objects.isNull(positionToDelete)) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new PositionNotFoundException(this.messageHelper.getMessage("Stanowisko_o_podanym_id_nie_istnieje"));
        }
        auditParams.put("positionName", this.structureService.getPositionTranslation(positionToDelete.getId(), TranslatedFieldType.NAME));
        auditParams.put("positionSymbol", positionToDelete.getSymbol());
        auditBuilder.params(auditParams);
        try {
            this.roleService.detachAllRoles(id);
            this.structureService.deletePosition(id);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @RequestMapping(value={"export/{extension}"}, method={RequestMethod.GET})
    public void export(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false) String name, @RequestParam(required=false) String symbol, @RequestParam(required=false) String overName, @RequestParam(required=false) String overSymbol, @RequestParam(required=false) String orgName, @RequestParam(required=false) String orgSymbol, @RequestParam(required=false) Long role, @RequestParam(required=false) String userName, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<StructurePositionDto> positionDtos = this.structureService.getPositions(name, symbol, overName, overSymbol, orgName, orgSymbol, role, userName, Pagination.create((Sorter)new Sorter(sortBy, sortDirection), null, null)).getData().stream().map(StructurePositionDto::from).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(this.buildExportColumn(this.messageHelper.getMessage("Nazwa"), positionDtos, StructurePositionDto::getPositionName), this.buildExportColumn(this.messageHelper.getMessage("Symbol"), positionDtos, StructurePositionDto::getPositionSymbol), this.buildExportColumn(this.messageHelper.getMessage("Stanowisko_nadrzedne"), positionDtos, structurePositionDto -> !Objects.isNull(structurePositionDto.getHigherPosition()) ? structurePositionDto.getHigherPosition().getSymbol() + " - " + structurePositionDto.getHigherPosition().getName() : ""), this.buildExportColumn(this.messageHelper.getMessage("Jednostka_organizacyjna"), positionDtos, structurePositionDto -> !Objects.isNull(structurePositionDto.getOrganizationalUnit()) ? structurePositionDto.getOrganizationalUnit().getSymbol() + " - " + structurePositionDto.getOrganizationalUnit().getName() : ""), this.buildExportColumn(this.messageHelper.getMessage("Role"), positionDtos, structurePositionDto -> structurePositionDto.getRoles().size() != 0 ? structurePositionDto.getRoles().stream().map(RoleDto::getRoleId).collect(Collectors.joining(",")) : ""), this.buildExportColumn(this.messageHelper.getMessage("Uzytkownik"), positionDtos, structurePositionDto -> !Objects.isNull(structurePositionDto.getUser()) ? structurePositionDto.getUser().getUserName() : ""));
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Positions")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private ExportColumn buildExportColumn(String name, List<StructurePositionDto> data, Function<StructurePositionDto, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    @ResponseBody
    @RequestMapping(value={"available"})
    public CountedResult<PositionDto> getAllIlike(@RequestParam(required=false, defaultValue="") String nameQuery, @RequestParam(required=false, defaultValue="") String symbolQuery, @RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        CountedResult foundPositions = this.structureService.getAvailablePositions(nameQuery, symbolQuery, Pagination.create((Sorter)new Sorter(sortBy, sortDirection), (Integer)start, (Integer)limit));
        List positions = foundPositions.getData().stream().map(position -> PositionDto.builder().id(position.getId()).name(this.structureService.getPositionTranslation(position.getId(), TranslatedFieldType.NAME)).symbol(position.getSymbol()).build()).collect(Collectors.toList());
        return new CountedResult(foundPositions.getTotal(), positions);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"assign"}, method={RequestMethod.POST})
    public void assignUserToPosition(HttpServletRequest request, @RequestParam Long userId, @RequestParam Long positionId) {
        User user = this.userService.getUser(userId, new String[]{"groups"});
        Position position = this.structureService.getPosition(positionId, new String[0]);
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ASSIGN_POSITION_TO_USER).params((Map)ImmutableMap.of((Object)"userId", (Object)user.getUserName(), (Object)"positionName", (Object)position.getName()));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        try {
            this.structureService.addPositionToUser(user.getUserName(), positionId);
            request.setAttribute("audit", (Object)builder.buildSuccess());
        }
        catch (Exception ex) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            throw ex;
        }
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"detach"}, method={RequestMethod.POST})
    public void detachUserFromPosition(HttpServletRequest request, @RequestParam Long positionId) {
        Position position = this.structureService.getPosition(positionId, new String[]{"user"});
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DETACH_POSITION).params((Map)ImmutableMap.of((Object)"positionName", (Object)position.getName(), (Object)"userId", (Object)position.getUser().getUserName()));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        try {
            this.structureService.detachPositionFromUser(positionId);
            request.setAttribute("audit", (Object)builder.buildSuccess());
        }
        catch (Exception ex) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            throw ex;
        }
    }

    @ResponseBody
    @RequestMapping(value={"user"})
    public List<PositionDto> getPositionsFromUser(@RequestParam Long userId) {
        return this.userService.getUser(userId, new String[]{"positions"}).getPositions().stream().map(PositionDto::fromDomain).sorted(Comparator.comparing(PositionDto::getName, CollatorInstance.get())).collect(Collectors.toList());
    }

    @ExceptionHandler(value={PositionAlreadyExistException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handlePositionAlreadyExistException(PositionAlreadyExistException e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={EmptyPropertyException.class})
    @ResponseStatus(value=HttpStatus.PARTIAL_CONTENT)
    @ResponseBody
    public RestResult handleEmptyPropertyException(EmptyPropertyException e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={PositionNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handlePositionNotFoundException(PositionNotFoundException e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"positionFinder", "structureService", "userService", "authorizationHelper", "exportService", "roleService", "messageHelper"})
    @Autowired
    public PositionController(PositionFinder positionFinder, StructureService structureService, UserService userService, AuthorizationHelper authorizationHelper, ExportService exportService, RoleService roleService, MessageHelperBean messageHelper) {
        this.positionFinder = positionFinder;
        this.structureService = structureService;
        this.userService = userService;
        this.authorizationHelper = authorizationHelper;
        this.exportService = exportService;
        this.roleService = roleService;
        this.messageHelper = messageHelper;
    }
}

