/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.email;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.email.oauth.OAuth2Service;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2AuthenticationMethod;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2Client;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2ClientService;
import com.suncode.pwfl.administration.email.oauth.connection.OAuth2Connection;
import com.suncode.pwfl.administration.email.oauth.connection.OAuth2ConnectionService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/oauth/connections"})
public class OAuth2ConnectionController {
    @Autowired
    private OAuth2ConnectionService oAuth2ConnectionService;
    @Autowired
    private OAuth2ClientService oAuth2ClientService;
    @Autowired
    private OAuth2Service oAuth2Service;
    @Autowired
    private AuthorizationHelper authorizationHelper;

    @ResponseBody
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> delete(@PathVariable Long id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_OAUTH2_CONNECTION);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        auditBuilder.params((Map)ImmutableMap.of((Object)"OAUTH2_CONNECTION_ID", (Object)id));
        try {
            OAuth2Connection oAuth2Connection = (OAuth2Connection)this.oAuth2ConnectionService.get((Serializable)id);
            if (this.oAuth2ConnectionService.isConnectionInUse(oAuth2Connection)) {
                request.setAttribute("audit", (Object)auditBuilder.buildFailure());
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
            this.oAuth2ConnectionService.delete((Object)oAuth2Connection);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> connect(@RequestParam Long clientId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        OAuth2Client client = (OAuth2Client)this.oAuth2ClientService.get((Serializable)clientId, new String[]{"connections"});
        if (client.getAuthenticationMethod() != OAuth2AuthenticationMethod.CLIENT_CREDENTIALS) {
            return new ResponseEntity((Object)"Wrong client authentication method", HttpStatus.BAD_REQUEST);
        }
        if (client.getConnections().size() != 0) {
            return new ResponseEntity((Object)"This client can only have one connection", HttpStatus.BAD_REQUEST);
        }
        OAuth2Connection connection = this.oAuth2Service.addNewConnection(client);
        return new ResponseEntity((Object)connection, HttpStatus.OK);
    }

    @RequestMapping(value={"/refresh"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> refreshConnection(@RequestParam Long connectionId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        OAuth2Connection oAuth2Connection = (OAuth2Connection)this.oAuth2ConnectionService.get((Serializable)connectionId);
        OAuth2Client client = (OAuth2Client)this.oAuth2ClientService.get((Serializable)oAuth2Connection.getClientId());
        if (client.getAuthenticationMethod() != OAuth2AuthenticationMethod.CLIENT_CREDENTIALS) {
            return new ResponseEntity((Object)"Wrong client authentication method", HttpStatus.BAD_REQUEST);
        }
        this.oAuth2Service.refreshConnection(oAuth2Connection);
        return new ResponseEntity(HttpStatus.OK);
    }
}

