/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.license.LicenseService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"mobile"})
public class MobileSupportController {
    private static final Logger log = LoggerFactory.getLogger(MobileSupportController.class);
    private static final int MOBILE_API_VERSION = 2;
    private static final String MOBILE_FEATURE_NAME = "com.suncode.plusworkflow_mobile";
    @Autowired
    private LicenseService licenseService;

    @ResponseBody
    @RequestMapping(value={"version"})
    public Map<String, Integer> getRestApiVersion() {
        return ImmutableMap.of((Object)"version", (Object)2);
    }

    @ResponseBody
    @RequestMapping(value={"license"})
    public ResponseEntity<?> isLicenseLoaded() {
        if (this.licenseService.hasFeature(MOBILE_FEATURE_NAME)) {
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_ACCEPTABLE);
    }
}

