/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.util.Authorization;
import com.plusmpm.util.HttpHeaders;
import com.plusmpm.util.MimeTypeResolver;
import com.plusmpm.util.Tools;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassAssociationService;
import com.suncode.pwfl.archive.DocumentSearchCache;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.security.XSSContentTypeProvider;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.archiver.ZipArchiverManager;
import com.suncode.pwfl.workflow.cipher.CipherManager;
import com.suncode.pwfl.workflow.support.AdditionalFileRights;
import com.suncode.pwfl.workflow.support.MSWordFileCustomProperties;
import com.suncode.pwfl.workflow.support.OpenedFileContext;
import com.suncode.pwfl.workflow.support.ReadFileEventManager;
import com.suncode.pwfl.workflow.support.ViewFileEventManager;
import com.suncode.pwfl.workflow.support.exception.ReadFileEventException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowFileAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(ShowFileAction.class);
    public String m_sFileId = null;
    private final XSSContentTypeProvider xssContentTypeProvider = (XSSContentTypeProvider)SpringContext.getBean(XSSContentTypeProvider.class);
    private final List<String> xssProneContentTypes = this.xssContentTypeProvider.getXSSProneContentTypes();
    private final FileService fileService = (FileService)SpringContext.getBean(FileService.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            boolean hasRightsToNewestVersion;
            log.info("*********************ShowFileAction******************");
            HttpSession session = request.getSession(false);
            String userName = (String)session.getAttribute("username");
            String fileId = null;
            String encodedFileId = request.getParameter("fileName");
            if (StringUtils.isBlank((String)encodedFileId)) {
                if (!StringUtils.isNotBlank((String)this.m_sFileId)) {
                    log.info("Brak parametru fileId");
                    request.setAttribute("message", (Object)(MessageHelper.getMessage((String)"Dokument_nie_istnieje") + "!"));
                    request.setAttribute("messageType", (Object)"error");
                    return mapping.findForward("showFileMessage");
                }
                log.info("Pobieram zewn\u0119trzne id o pliku:" + this.m_sFileId);
                fileId = this.m_sFileId;
                fileId = Tools.decodeStringBase64((String)fileId);
            } else {
                fileId = Tools.decodeStringBase64((String)encodedFileId);
            }
            if (fileId == null) {
                log.warn("B\u0142\u0105d podczas dekodowania fileId");
                request.setAttribute("message", (Object)(MessageHelper.getMessage((String)"Dokument_nie_istnieje") + "!"));
                request.setAttribute("messageType", (Object)"error");
                return mapping.findForward("showFileMessage");
            }
            String processId = request.getParameter("processId");
            String activityId = request.getParameter("activityId");
            FileService fs = ServiceFactory.getFileService();
            WfFile wfFile = fs.getFile(new Long(fileId), new String[]{"documentClass", "version"});
            DocumentClass docClass = wfFile.getDocumentClass();
            if (docClass == null) return mapping.findForward("showFile");
            String processRightKey = request.getParameter("key");
            boolean hasRights = ((DocumentSearchCache)SpringContext.getBean(DocumentSearchCache.class)).containsFileIdForUser(userName, Long.valueOf(fileId)) || Authorization.hasRightsToReadFile((String)userName, (Long)Long.valueOf(fileId), (String)processRightKey);
            Long newestVersionFileId = wfFile.getVersion().getNewestFile().getId();
            boolean bl = hasRightsToNewestVersion = ((DocumentSearchCache)SpringContext.getBean(DocumentSearchCache.class)).containsFileIdForUser(userName, newestVersionFileId) || Authorization.hasRightsToReadFile((String)userName, (Long)newestVersionFileId, (String)processRightKey);
            if (!hasRights && !hasRightsToNewestVersion) {
                log.info("Brak praw do wy\u015bwietlenia dokumentu - u\u017cytkownik: " + userName);
                request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Brak_uprawnien"));
                request.setAttribute("messageType", (Object)"warning");
                return mapping.findForward("showFileMessage");
            }
            try {
                boolean condition = this.checkAdditionalRights(userName, fileId, processId);
                if (!condition) {
                    request.setAttribute("message", (Object)(MessageHelper.getMessage((String)"Nie_masz_dostepu_do_tego_pliku") + "."));
                    request.setAttribute("messageType", (Object)"warning");
                    return mapping.findForward("showFileMessage");
                }
            }
            catch (IllegalArgumentException e) {
                log.error("Podana klasa w pliku konfiguracyjnym do sprawdzania dodatkowych uprawnie\u0144 musi implementowa\u0107 interfejs AdditionalFileRights");
                request.setAttribute("message", (Object)(MessageHelper.getMessage((String)"Wystapil_nieoczekiwany_blad") + "!"));
                request.setAttribute("messageType", (Object)"error");
                return mapping.findForward("showFileMessage");
            }
            catch (ClassNotFoundException e) {
                log.error("Podana klasa w pliku konfiguracyjnym do sprawdzania dodatkowych uprawnie\u0144 nie istnieje. Najprawdopodobniej podana jest b\u0142\u0119dna \u015bcie\u017cka lub nazwa klasy.");
                request.setAttribute("message", (Object)(MessageHelper.getMessage((String)"Wystapil_nieoczekiwany_blad") + "!"));
                request.setAttribute("messageType", (Object)"error");
                return mapping.findForward("showFileMessage");
            }
            String applet = request.getParameter("applet");
            log.info("Pobieram info o pliku o ID:" + fileId);
            if (wfFile == null) return mapping.findForward("showFile");
            Long fileSize = wfFile.getSize();
            String fileName = wfFile.getSystemFileName();
            String orgFileName = wfFile.getFileName();
            String mimeType = MimeTypeResolver.resolve((String)wfFile.getFileName());
            String userAgent = request.getHeader("User-Agent");
            String sExtension = "";
            String[] sExt = orgFileName.split("[.]");
            if (sExt.length > 0) {
                sExtension = sExt[sExt.length - 1];
            }
            log.info("Wczytano plik - id: " + fileId + " fileName: " + fileName + " orgFileName: " + orgFileName + " size: " + fileSize);
            String sPath = wfFile.getPath();
            if (!sPath.endsWith("/")) {
                sPath = sPath + "/";
            }
            String filePath = wfFile.getFullPath();
            if (applet == null) {
                log.info("Wy\u015bwietlam plik (applet == null)");
                request.setAttribute("fileId", (Object)fileId);
                request.setAttribute("originalFilename", (Object)StringEscapeUtils.escapeEcmaScript((String)orgFileName).replaceAll("/", "_").replaceAll("\\\\", "_").replace("'", "\\'"));
                request.setAttribute("extension", (Object)sExtension.toLowerCase());
                boolean isBuildAssociatedDocumentsTab = this.isBuildAssociatedDocumentsPanel(Long.valueOf(fileId));
                UserSettingsService userSettingsService = ServiceFactory.getUserSettingsService();
                String pageSize = "";
                if (StringUtils.isNotBlank((String)userName)) {
                    pageSize = userSettingsService.getSetting(userName, UserSettingsService.UserSetting.PAGE_SIZE);
                } else {
                    isBuildAssociatedDocumentsTab = false;
                }
                pageSize = StringUtils.isNotBlank((String)pageSize) ? pageSize : "20";
                request.setAttribute("pageSize", (Object)pageSize);
                request.setAttribute("processId", (Object)processId);
                request.setAttribute("activityId", (Object)activityId);
                request.setAttribute("processRightKey", (Object)processRightKey);
                request.setAttribute("docClassId", (Object)docClass.getId().toString());
                request.setAttribute("isBuildAssociatedDocumentsTab", (Object)isBuildAssociatedDocumentsTab);
                request.setAttribute("sandboxed", (Object)this.getSandBoxParameter(wfFile, processId, activityId));
                return mapping.findForward("showFile");
            }
            log.info("Pobieranie do zmiany (applet == true)");
            File file1 = new File(filePath);
            InputStream fileInputStream = new FileInputStream(file1);
            fileInputStream = ZipArchiverManager.uncompress((InputStream)fileInputStream, (WfFile)wfFile);
            fileInputStream = CipherManager.decryptFile((InputStream)fileInputStream, (WfFile)wfFile);
            String sMimeType = Tools.MIMETYPES_FILE_TYPE_MAP.getContentType(file1);
            OpenedFileContext fileContext = ReadFileEventManager.execute((InputStream)fileInputStream, (WfFile)wfFile, (String)sMimeType, (String)processId, (String)activityId, (String)userName);
            fileInputStream = fileContext.getInputStream();
            fileInputStream = MSWordFileCustomProperties.addProperties((InputStream)fileInputStream, (WfFile)wfFile);
            ServletOutputStream outputStream = response.getOutputStream();
            this.setupResponseHeader(response, fileContext.getExtension(), orgFileName.replaceAll("[<>:\"/\\\\|?*]", "_"), fileInputStream.available());
            if (userAgent.contains("MSIE 8.0") || userAgent.contains("MSIE 7.0")) {
                response.setHeader("Cache-Control", "public");
            }
            int j = 0;
            while (true) {
                if ((j = fileInputStream.read()) == -1) {
                    outputStream.flush();
                    outputStream.close();
                    fileInputStream.close();
                    if (fileContext.getInputStream() == null) return null;
                    fileContext.getInputStream().close();
                    return null;
                }
                outputStream.write(j);
            }
        }
        catch (ReadFileEventException rfee) {
            log.warn(rfee.getMessage());
            response.setContentType("text/plain");
            request.setAttribute("message", (Object)rfee.getMessage());
            request.setAttribute("messageType", (Object)"error");
            return mapping.findForward("showFileMessage");
        }
        catch (NumberFormatException e1) {
            log.info("Przes\u0142any parametr jest niepoprawny!");
            request.setAttribute("message", (Object)(MessageHelper.getMessage((String)"Dokument_nie_istnieje") + "!"));
            request.setAttribute("messageType", (Object)"error");
            return mapping.findForward("showFileMessage");
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            request.setAttribute("message", (Object)(MessageHelper.getMessage((String)"Wystapil_nieoczekiwany_blad") + "!"));
            request.setAttribute("messageType", (Object)"error");
            return mapping.findForward("showFileMessage");
        }
    }

    private void setupResponseHeader(HttpServletResponse response, String extension, String orgFileName, int fileSize) {
        if (extension.compareToIgnoreCase("pdf") == 0) {
            response.setContentLength(fileSize);
            response.setContentType("application/pdf");
            response.addHeader("Accept-Header", String.valueOf(fileSize));
        } else if (extension.compareToIgnoreCase("xml") == 0) {
            response.setContentType("application/xhtml+xml");
        } else if (extension.compareToIgnoreCase("doc") == 0) {
            response.setContentType("application/msword");
        } else if (extension.compareToIgnoreCase("txt") == 0) {
            response.setContentType("text/plain");
        } else if (extension.compareToIgnoreCase("html") == 0) {
            response.setContentType("text/html");
        } else if (extension.compareToIgnoreCase("jpeg") == 0) {
            response.setContentType("image/jpeg");
        } else if (extension.compareToIgnoreCase("jpg") == 0) {
            response.setContentType("image/jpeg");
        } else if (extension.compareToIgnoreCase("xls") == 0) {
            response.setContentType("application/vnd.ms-excel");
        } else if (extension.compareToIgnoreCase("rtf") == 0) {
            response.setContentType("application/rtf");
        } else {
            response.setContentType("APPLICATION/OCTET-STREAM");
            response.setCharacterEncoding("ASCII");
        }
        response.setHeader("Content-Disposition", HttpHeaders.getContentDisposition((String)(FilenameUtils.getBaseName((String)orgFileName) + "." + extension), (boolean)false));
    }

    private boolean checkAdditionalRights(String username, String fileId, String processId) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> cls;
        String additionalFileRights = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.ADDITIONAL_FILE_RIGHTS);
        if (StringUtils.isEmpty((String)additionalFileRights)) {
            return true;
        }
        String callPlace = "process";
        if (StringUtils.isEmpty((String)processId)) {
            callPlace = "archive";
        }
        if (!AdditionalFileRights.class.isAssignableFrom(cls = Class.forName(additionalFileRights))) {
            throw new IllegalArgumentException();
        }
        AdditionalFileRights sfc = (AdditionalFileRights)cls.newInstance();
        return sfc.checkAdditionalRights(username, fileId, callPlace);
    }

    private boolean isBuildAssociatedDocumentsPanel(Long documentId) {
        return (Boolean)TransactionWrapper.get().doInHibernateTransaction(session -> {
            DocumentClassAssociationService documentClassAssociationService = (DocumentClassAssociationService)SpringContext.getBean(DocumentClassAssociationService.class);
            Long documentClassId = ServiceFactory.getDocumentService().getDocument(documentId).getDocumentClassId();
            List parentAssociations = documentClassAssociationService.findByProperty("parentClass.id", (Object)documentClassId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), new String[0]);
            List childAssociations = documentClassAssociationService.findByProperty("childClass.id", (Object)documentClassId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), new String[0]);
            return !parentAssociations.isEmpty() || !childAssociations.isEmpty();
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getSandBoxParameter(WfFile wfFile, String processId, String activityId) {
        String mimeType = MimeTypeResolver.resolve((String)wfFile.getFileName());
        String username = UserContext.current().getUser().getUserName();
        try (InputStream is = this.fileService.getFileInputStream(Long.valueOf(wfFile.getId()));){
            OpenedFileContext fileContext = ReadFileEventManager.execute((InputStream)is, (WfFile)wfFile, (String)mimeType, (String)processId, (String)activityId, (String)username);
            OpenedFileContext viewFileContext = ViewFileEventManager.execute((OpenedFileContext)fileContext);
            if (viewFileContext.getSandbox() != null) {
                boolean bl2 = viewFileContext.getSandbox();
                return bl2;
            }
            boolean bl = this.xssProneContentTypes.stream().anyMatch(type -> type.equals(viewFileContext.getMimeType()));
            return bl;
        }
        catch (Exception e) {
            log.error("Couldn't resolve if file is save to display in iframe. Sandbox will be enabled.");
            log.error(e.getMessage(), (Throwable)e);
            return true;
        }
    }
}

