/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.struts.form.VariableListForm;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.DocumentData;
import com.plusmpm.util.UsersManagement;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentSearchCache;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkIndex;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.dto.archive.LinkIndexDto;
import com.suncode.pwfl.web.util.SessionUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.util.ParamEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchLinksAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(SearchLinksAction.class);
    private final LinkService linkService = (LinkService)SpringContext.getBean(LinkService.class);
    private final DocumentClassService documentClassService = (DocumentClassService)SpringContext.getBean(DocumentClassService.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String name;
        log.info("******************************SearchLinksAction********************");
        HttpSession session = request.getSession(false);
        request.setAttribute("activeTab", (Object)"ShowArchiveViews.do");
        if (session == null || session.getAttribute("username") == null) {
            return mapping.findForward("welcome");
        }
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        Date started = new Date();
        boolean isExcelExport = false;
        String username = (String)session.getAttribute("username");
        int sortColumnNumber = 0;
        int sortOrderType = 0;
        boolean tableRequest = Boolean.parseBoolean(request.getParameter("tableRequest"));
        ArrayList<String> searchedDocumentClasses = new ArrayList<String>();
        DynaActionForm searchVariableForm = (DynaActionForm)form;
        if (tableRequest) {
            searchVariableForm = (DynaActionForm)session.getAttribute("searchLinkForm");
        }
        session.setAttribute("searchLinkForm", (Object)searchVariableForm);
        VariableListForm[] variableListForm = (VariableListForm[])searchVariableForm.get("lines");
        VariableListForm[] documentClassesListForm = (VariableListForm[])searchVariableForm.get("docclasses");
        String linkId = variableListForm[0].VarValue;
        String dateStart = (String)searchVariableForm.get("dateStart");
        String dateFinish = (String)searchVariableForm.get("dateFinish");
        boolean showDate = "on".equals(searchVariableForm.get("showDate"));
        if (documentClassesListForm != null) {
            for (VariableListForm listForm : documentClassesListForm) {
                if (listForm.VarID == null) break;
                if (listForm.VarValue == null || listForm.VarValue.compareToIgnoreCase("on") != 0) continue;
                searchedDocumentClasses.add(listForm.VarID);
            }
        }
        boolean isExport = false;
        int maxPageSize = 0;
        int offset = 0;
        int pageNumber = 0;
        DBManagement dbm = new DBManagement();
        int pageSize = UsersManagement.getUserDefinedPageSize((String)username);
        try {
            String pageNr = new ParamEncoder("task").encodeParameterName("p");
            log.info("pageNr:" + pageNr);
            String value = request.getParameter(pageNr);
            log.info("value:" + value);
            pageNumber = Integer.parseInt(value);
            offset = (pageNumber - 1) * pageSize;
            if (offset < 0) {
                offset = 0;
            }
        }
        catch (Exception e) {
            log.info("Blad, Brak paging");
        }
        String exportType = "";
        String exportTypeValue = "";
        try {
            exportType = new ParamEncoder("task").encodeParameterName("e");
            log.info("exportType:" + exportType);
            exportTypeValue = request.getParameter(exportType);
            log.info("value:" + exportTypeValue);
            if (exportTypeValue != null) {
                isExport = true;
            }
        }
        catch (Exception e) {
            log.info("Blad, brak exportu");
        }
        try {
            String order = new ParamEncoder("task").encodeParameterName("o");
            String sortColumnNr = new ParamEncoder("task").encodeParameterName("s");
            log.info("order:" + order);
            String orderValue = request.getParameter(order);
            String sortColumnNrValue = request.getParameter(sortColumnNr);
            log.info("orderValue:" + (String)orderValue);
            if (orderValue != null) {
                sortOrderType = Integer.parseInt(orderValue);
                sortColumnNumber = Integer.parseInt(sortColumnNrValue);
            }
        }
        catch (Exception e) {
            log.info("Blad, brak sort");
        }
        log.info("pageNumber:" + pageNumber + ", offset" + offset + ", sortOrderType" + sortOrderType + ", sortColumnNumber" + sortColumnNumber);
        Link link = this.linkService.getLink(Long.valueOf(linkId), new String[0]);
        List linkIndices = this.linkService.getLinkIndicesForLink(Long.valueOf(linkId));
        for (LinkIndex linkIndex : linkIndices) {
            linkIndex.setName(this.linkService.getLinkIndexTranslation(linkIndex.getId(), TranslatedFieldType.NAME));
            linkIndex.setDescription(this.linkService.getLinkIndexTranslation(linkIndex.getId(), TranslatedFieldType.DESCRIPTION));
            linkIndex.setLink(link);
        }
        ArrayList<LinkIndexDto> showIndices = new ArrayList<LinkIndexDto>();
        block12: for (int i = 1; i < variableListForm.length && (name = variableListForm[i].getVarName()) != null; ++i) {
            if (variableListForm[i].VarShow == null || variableListForm[i].VarShow.compareToIgnoreCase("on") != 0) continue;
            for (LinkIndex linkIndex : linkIndices) {
                if (!linkIndex.getId().toString().equals(name)) continue;
                showIndices.add(LinkIndexDto.from(linkIndex));
                continue block12;
            }
        }
        List documents = new ArrayList();
        if (!searchedDocumentClasses.isEmpty()) {
            CountedResult foundDocuments;
            int tempPageSize = isExport ? -1 : pageSize;
            int tempOffset = isExport ? -1 : offset;
            try {
                foundDocuments = dbm.searchLinkCounted(variableListForm, username, dateStart, dateFinish, tempPageSize, tempOffset, sortOrderType, sortColumnNumber, searchedDocumentClasses, showDate, true);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                request.setAttribute("linkId", (Object)linkId);
                request.setAttribute("errorMessage", (Object)MessageHelper.getMessage((String)"Bledna_konfiguracja_powiazan_indeksow"));
                return mapping.findForward("showLinkSearchError");
            }
            maxPageSize = (int)foundDocuments.getTotal();
            documents = foundDocuments.getData();
            if (isExport) {
                offset = 0;
                pageSize = maxPageSize;
                String exportTitle = String.format("%s: %s", MessageHelper.getMessage((String)"Nazwa_zestawu"), link.getName());
                auditParams.put("exportTitle", exportTitle);
                String dateColumn = showDate ? ";" + MessageHelper.getMessage((String)"Data") : "";
                String exportColumns = "Lp.;" + MessageHelper.getMessage((String)"Klasa_dokumentow") + ";" + showIndices.stream().map(LinkIndexDto::getTranslatedIndexName).collect(Collectors.joining(";")) + dateColumn;
                auditParams.put("exportColumns", exportColumns);
                String extension = MediaTypeEnum.fromCode((int)Integer.parseInt(exportTypeValue)).getName();
                if (extension.equalsIgnoreCase("excel")) {
                    extension = "xls";
                    isExcelExport = true;
                }
                auditParams.put("fileExtension", extension);
            }
        }
        Set foundFileIds = documents.stream().map(DocumentData::getLFileId).collect(Collectors.toSet());
        ((DocumentSearchCache)SpringContext.getBean(DocumentSearchCache.class)).put(username, foundFileIds);
        List linkIndexDtos = linkIndices.stream().map(LinkIndexDto::from).collect(Collectors.toList());
        try {
            HashMap<String, Long> rightMap = new HashMap<String, Long>();
            for (String id : searchedDocumentClasses) {
                long printRights = Authorization.checkRight((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)id).printing().build(), (String)username, (boolean)false, (boolean)false);
                rightMap.put(id, printRights);
            }
            if (rightMap.containsValue(1L) || rightMap.containsValue(0L)) {
                request.setAttribute("canPrint", (Object)"TRUE");
                if (rightMap.containsValue(-1L)) {
                    ArrayList<String> documentClassesNames = new ArrayList<String>();
                    for (String id : rightMap.entrySet().stream().filter(entry -> ((Long)entry.getValue()).equals(-1L)).map(Map.Entry::getKey).collect(Collectors.toList())) {
                        documentClassesNames.add(this.documentClassService.getDocumentClassTranslation(Long.valueOf(id), TranslatedFieldType.NAME));
                    }
                    request.setAttribute("noPrintingRightsClassesName", (Object)String.join((CharSequence)", ", documentClassesNames));
                }
            } else {
                request.setAttribute("canPrint", (Object)"FALSE");
            }
        }
        catch (SQLException ex) {
            request.setAttribute("canPrint", (Object)"FALSE");
            log.warn("B\u0142\u0105d po\u0142\u0105czenia z baz\u0105 danych podczas odczytu uprawnie\u0144", (Throwable)ex);
        }
        request.setAttribute("linkName", (Object)this.linkService.getLinkTranslation(link.getId(), TranslatedFieldType.NAME));
        request.setAttribute("linkId", (Object)linkId);
        request.setAttribute("alDocuments", documents);
        request.setAttribute("documentCount", (Object)documents.size());
        request.setAttribute("alIndecies", showIndices);
        request.setAttribute("indexFilters", linkIndexDtos);
        request.setAttribute("iMaxPageSize", (Object)new Integer(maxPageSize).toString());
        request.setAttribute("iPageSize", (Object)new Integer(pageSize).toString());
        request.setAttribute("iOffset", (Object)offset);
        request.setAttribute("auditSuccess", (Object)true);
        request.setAttribute("searchLinkForm", (Object)searchVariableForm);
        session.setAttribute("searchLinkSortColumn", (Object)sortColumnNumber);
        session.setAttribute("searchLinkSortOrder", (Object)sortOrderType);
        if (isExport) {
            boolean success = !isExcelExport || documents.size() <= 65535;
            ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_EXPORT).username(SessionUtils.getLoggedUserName()).success(success).params(auditParams).started(started).stopped(new Date()).build().log();
        }
        if (tableRequest) {
            return mapping.findForward("showSearchLinkResultTable");
        }
        return mapping.findForward("showSearchLinksResult");
    }
}

