/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.struts.form.SearchPositionForm;
import com.plusmpm.util.RoleIdNameList;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleFinder;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetOrgStructDataListAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(GetOrgStructDataListAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info("******************************GetOrgStructDataListAction********************");
        boolean bFiltering = false;
        ActionForward actionForward = mapping.findForward("showShortOrgStructDataList");
        try {
            SearchPositionForm searchStructForm;
            HttpSession session = request.getSession(false);
            if (session == null || session.getAttribute("username") == null) {
                return mapping.findForward("disconnect");
            }
            String sourceType = request.getParameter("type");
            String filtering = request.getParameter("filtering");
            if (StringUtils.isNotBlank((CharSequence)filtering)) {
                bFiltering = Boolean.valueOf(filtering);
            }
            if (StringUtils.isBlank((CharSequence)(searchStructForm = (SearchPositionForm)form).getSearchPositionName())) {
                searchStructForm.setSearchPositionName("");
            }
            if (StringUtils.isBlank((CharSequence)searchStructForm.getSearchPositionSymbol())) {
                searchStructForm.setSearchPositionSymbol("");
            }
            if (sourceType == null) {
                return actionForward;
            }
            String trimmedSourceType = sourceType.trim();
            OrganizationalUnitFinder ous = FinderFactory.getOrganizationalUnitFinder();
            PositionFinder ps = FinderFactory.getPositionFinder();
            StructureService structureService = ServiceFactory.getStructureService();
            if (trimmedSourceType.equalsIgnoreCase("roleList")) {
                this.buildRoleList(request, sourceType, false, searchStructForm, bFiltering);
            } else if (trimmedSourceType.equalsIgnoreCase("orgUnitList") || trimmedSourceType.equalsIgnoreCase("orgUnitListSymbol")) {
                String orgUnitName = StringUtils.defaultString((String)searchStructForm.getSearchOrgUnitName());
                String orgUnitSymbol = StringUtils.defaultString((String)searchStructForm.getSearchOrgUnitSymbol());
                DetachedCriteria dc = DetachedCriteria.forClass(OrganizationalUnit.class);
                this.addNameAndSymbolSearchCriteria(dc, orgUnitName, orgUnitSymbol);
                List organizationalUnitsTableAList = ous.findByCriteria(dc);
                for (OrganizationalUnit organizationalUnitsTable : organizationalUnitsTableAList) {
                    organizationalUnitsTable.setName(structureService.getOrganizationalUnitTranslation(organizationalUnitsTable.getId(), TranslatedFieldType.NAME));
                }
                request.setAttribute("OrgUnitList", (Object)organizationalUnitsTableAList);
                request.setAttribute("sourceType", (Object)sourceType);
                request.setAttribute("filtering", (Object)bFiltering);
            } else if (trimmedSourceType.equalsIgnoreCase("higherOrgUnitList") || trimmedSourceType.equalsIgnoreCase("higherOrgUnitSymbolList")) {
                String orgUnitName = StringUtils.defaultString((String)searchStructForm.getSearchOrgUnitName());
                String orgUnitSymbol = StringUtils.defaultString((String)searchStructForm.getSearchOrgUnitSymbol());
                DetachedCriteria dc = DetachedCriteria.forClass(OrganizationalUnit.class);
                this.addNameAndSymbolSearchCriteria(dc, orgUnitName, orgUnitSymbol);
                dc.add(Restrictions.isNotNull((String)"subOus"));
                List organizationalUnitsTableAList = ous.findByCriteria(dc);
                for (OrganizationalUnit organizationalUnitsTable : organizationalUnitsTableAList) {
                    organizationalUnitsTable.setName(structureService.getOrganizationalUnitTranslation(organizationalUnitsTable.getId(), TranslatedFieldType.NAME));
                }
                request.setAttribute("OrgUnitList", (Object)organizationalUnitsTableAList);
                request.setAttribute("sourceType", (Object)sourceType);
                request.setAttribute("filtering", (Object)bFiltering);
            } else if (trimmedSourceType.equalsIgnoreCase("positionList")) {
                String searchPositionName = searchStructForm.getSearchPositionName();
                String searchPositionSymbol = searchStructForm.getSearchPositionSymbol();
                DetachedCriteria dc = DetachedCriteria.forClass(Position.class);
                this.addNameAndSymbolSearchCriteria(dc, searchPositionName, searchPositionSymbol);
                List positionsTableAList = ps.findByCriteria(dc);
                for (Position positionsTable : positionsTableAList) {
                    positionsTable.setName(structureService.getPositionTranslation(positionsTable.getId(), TranslatedFieldType.NAME));
                }
                request.setAttribute("PositionsList", (Object)positionsTableAList);
                request.setAttribute("sourceType", (Object)sourceType);
                request.setAttribute("filtering", (Object)bFiltering);
            } else if (trimmedSourceType.equalsIgnoreCase("higherPositionList") || trimmedSourceType.equalsIgnoreCase("higherPositionSymbolList")) {
                String searchPositionName = searchStructForm.getSearchPositionName();
                String searchPositionSymbol = searchStructForm.getSearchPositionSymbol();
                DetachedCriteria dc = DetachedCriteria.forClass(Position.class);
                this.addNameAndSymbolSearchCriteria(dc, searchPositionName, searchPositionSymbol);
                dc.add(Restrictions.isNotEmpty((String)"subPositions"));
                List positionsTableAList = ps.findByCriteria(dc);
                for (Position positionsTable : positionsTableAList) {
                    positionsTable.setName(structureService.getPositionTranslation(positionsTable.getId(), TranslatedFieldType.NAME));
                }
                request.setAttribute("PositionsList", (Object)positionsTableAList);
                request.setAttribute("sourceType", (Object)sourceType);
                request.setAttribute("filtering", (Object)bFiltering);
            } else if (trimmedSourceType.equalsIgnoreCase("directorPositionList") || trimmedSourceType.equalsIgnoreCase("directorPositionSymbolList")) {
                String searchPositionName = searchStructForm.getSearchPositionName();
                String searchPositionSymbol = searchStructForm.getSearchPositionSymbol();
                DetachedCriteria dc = DetachedCriteria.forClass(Position.class);
                this.addNameAndSymbolSearchCriteria(dc, searchPositionName, searchPositionSymbol);
                dc.add(Restrictions.isNotEmpty((String)"directoredUnits"));
                List positionsTableAList = ps.findByCriteria(dc);
                for (Position positionsTable : positionsTableAList) {
                    positionsTable.setName(structureService.getPositionTranslation(positionsTable.getId(), TranslatedFieldType.NAME));
                }
                request.setAttribute("PositionsList", (Object)positionsTableAList);
                request.setAttribute("sourceType", (Object)sourceType);
                request.setAttribute("filtering", (Object)bFiltering);
            } else if (trimmedSourceType.equalsIgnoreCase("positionListTab")) {
                String searchPositionName = searchStructForm.getSearchPositionName();
                String searchPositionSymbol = searchStructForm.getSearchPositionSymbol();
                DetachedCriteria dc = DetachedCriteria.forClass(Position.class);
                this.addNameAndSymbolSearchCriteria(dc, searchPositionName, searchPositionSymbol);
                dc.add(Restrictions.isNull((String)"user"));
                List positionsTableAList = ps.findByCriteria(dc);
                for (Position positionsTable : positionsTableAList) {
                    positionsTable.setName(structureService.getPositionTranslation(positionsTable.getId(), TranslatedFieldType.NAME));
                }
                request.setAttribute("PositionsList", (Object)positionsTableAList);
                request.setAttribute("sourceType", (Object)sourceType);
                request.setAttribute("filtering", (Object)bFiltering);
            } else if (trimmedSourceType.equalsIgnoreCase("positionListUserAdd")) {
                String searchPositionName = searchStructForm.getSearchPositionName();
                String searchPositionSymbol = searchStructForm.getSearchPositionSymbol();
                DetachedCriteria dc = DetachedCriteria.forClass(Position.class);
                this.addNameAndSymbolSearchCriteria(dc, searchPositionName, searchPositionSymbol);
                dc.add(Restrictions.isNull((String)"user"));
                List positionsTableAList = ps.findByCriteria(dc);
                for (Position positionsTable : positionsTableAList) {
                    positionsTable.setName(structureService.getPositionTranslation(positionsTable.getId(), TranslatedFieldType.NAME));
                }
                request.setAttribute("PositionsList", (Object)positionsTableAList);
                request.setAttribute("sourceType", (Object)sourceType);
                request.setAttribute("filtering", (Object)bFiltering);
            } else if (trimmedSourceType.equalsIgnoreCase("roleListTab")) {
                this.buildRoleList(request, sourceType, true, searchStructForm, bFiltering);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return actionForward;
    }

    private void buildRoleList(HttpServletRequest request, String sourceType, boolean tab, SearchPositionForm searchStructForm, Boolean filtering) {
        String searchRoleName = StringUtils.defaultString((String)searchStructForm.getSearchRoleName());
        String searchPackageName = StringUtils.defaultString((String)searchStructForm.getSearchPackageName());
        String searchProcessName = StringUtils.defaultString((String)searchStructForm.getSearchProcessName());
        Boolean filterByProcess = StringUtils.isNotEmpty((CharSequence)searchProcessName);
        RoleFinder roleFinder = FinderFactory.getRoleFinder();
        List roleIdNameList = roleFinder.getAll(new String[0]).stream().filter(role -> StringUtils.containsIgnoreCase((CharSequence)role.getRoleName(), (CharSequence)searchRoleName)).map(role -> {
            Long id = role.getId();
            String roleName = role.getRoleName();
            RoleIdNameList roleIdNameListTMP = RoleIdNameList.convertFromRole((Role)role);
            if (tab) {
                roleIdNameListTMP.setLink("<a href=\"javascript://nop/\" onclick='SetRoleIdNameTab(\"" + id + "\"); return false;'>" + MessageHelper.getMessage((String)"Dodaj") + "</a>");
            } else {
                roleIdNameListTMP.setLink("<a href=\"javascript://nop/\" onclick='SetRoleIdName(\"" + id + "\", \"" + roleName + "\"); return false;'>" + MessageHelper.getMessage((String)"Dodaj") + "</a>");
            }
            return roleIdNameListTMP;
        }).filter(role -> StringUtils.containsIgnoreCase((CharSequence)role.getPackageName(), (CharSequence)searchPackageName)).filter(role -> {
            if (filterByProcess.booleanValue()) {
                return StringUtils.containsIgnoreCase((CharSequence)role.getProcessName(), (CharSequence)searchProcessName);
            }
            return true;
        }).collect(Collectors.toList());
        request.setAttribute("RoleIdNameList", roleIdNameList);
        request.setAttribute("sourceType", (Object)sourceType);
        request.setAttribute("filtering", (Object)filtering);
    }

    private void addNameAndSymbolSearchCriteria(DetachedCriteria dc, String nameValue, String symbolValue) {
        if (DBUtils.isConjunctionSearch((String)nameValue)) {
            dc.add((Criterion)this.conjunctionSearchCriteria(nameValue, "name"));
        } else {
            dc.add(Restrictions.ilike((String)"name", (Object)("%" + nameValue.replaceAll(" +", "%") + "%")));
        }
        if (DBUtils.isConjunctionSearch((String)symbolValue)) {
            dc.add((Criterion)this.conjunctionSearchCriteria(symbolValue, "name"));
        } else {
            dc.add(Restrictions.ilike((String)"symbol", (Object)("%" + symbolValue.replaceAll(" +", "%") + "%")));
        }
    }

    private Conjunction conjunctionSearchCriteria(String value, String propertyName) {
        Conjunction conjunction = Restrictions.conjunction();
        List searchValues = DBUtils.searchCriteriaForConjunctionLike((List)DBUtils.conjunctionValuesForLike((String)value));
        searchValues.forEach(searchValue -> conjunction.add(Restrictions.ilike((String)propertyName, (Object)searchValue)));
        return conjunction;
    }
}

