/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.files.DocumentSearch;
import com.plusmpm.database.files.ExtendedDocumentData;
import com.plusmpm.struts.action.SearchDocClassesAction;
import com.plusmpm.struts.form.VariableListForm;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

public class DeleteSearchedDocumentsAction
extends Action {
    public static Logger log = Logger.getLogger(DeleteSearchedDocumentsAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info((Object)"******************************DeleteSearchedDocumentsAction********************");
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("username") == null) {
            return mapping.findForward("welcome");
        }
        String sUserName = (String)session.getAttribute("username");
        DynaActionForm searchVariableForm = (DynaActionForm)form;
        DynaActionForm searchVariableForm1 = (DynaActionForm)session.getAttribute("searchBeanDocClass");
        Object variableListForm = null;
        if (searchVariableForm1 != null) {
            searchVariableForm = searchVariableForm1;
        }
        ArrayList additionalCols = new ArrayList();
        DocumentSearch documentSearch = DocumentSearch.buildFromDynaForm((DynaActionForm)searchVariableForm, (String)sUserName, (long)0L, (int)0, (int)0, (int)0, (int)0, (boolean)false, additionalCols);
        documentSearch.addOrder(0, String.format("%s.id", documentSearch.getIndexesTableName()));
        documentSearch.addOrder(0, "pm_files.file_date");
        documentSearch.addOrder(0, "pm_file_versions.version");
        List documentList = documentSearch.list();
        Collections.sort(documentList, new Comparator<ExtendedDocumentData>(){

            @Override
            public int compare(ExtendedDocumentData o1, ExtendedDocumentData o2) {
                return o1.getFileVersions().getVersion().compareTo(o2.getFileVersions().getVersion());
            }
        });
        FileService fs = (FileService)SpringContext.getBean(FileService.class);
        int iDocDeletedCnt = 0;
        ArrayList<String> deletedFilesId = new ArrayList<String>();
        for (ExtendedDocumentData document : documentList) {
            try {
                long fileId = document.getLFileId();
                fs.deleteFile(Long.valueOf(fileId));
                if (deletedFilesId.size() <= 50) {
                    deletedFilesId.add(String.valueOf(fileId));
                }
                ++iDocDeletedCnt;
            }
            catch (Exception exception) {}
        }
        String auditParams = this.prepareAuditExtraParams(deletedFilesId, searchVariableForm);
        request.setAttribute("auditExtraParam", (Object)auditParams);
        request.setAttribute("DocDeletedCnt", (Object)(iDocDeletedCnt + ""));
        request.setAttribute("additionalCols", additionalCols);
        request.setAttribute("message", (Object)(MessageHelper.getMessage((String)"Znalezione_dokumenty_zostaly_usuniete") + ".<br>" + MessageHelper.getMessage((String)"Liczba_usunietych_dokumentow") + ": " + iDocDeletedCnt));
        request.setAttribute("messageType", (Object)"success");
        request.setAttribute("auditSuccess", (Object)true);
        SearchDocClassesAction searchDocClassesAction = new SearchDocClassesAction();
        searchDocClassesAction.allDocumentsDeleted = true;
        return searchDocClassesAction.execute(mapping, form, request, response);
    }

    private String prepareAuditExtraParams(List<String> deletedFilesId, DynaActionForm form) {
        StringBuilder message = new StringBuilder();
        message.append("ids=").append(deletedFilesId.toString().replaceAll("([\\[\\]])", ""));
        if (deletedFilesId.size() >= 50) {
            message.append("...");
        }
        message.append("@AUDIT_PARAM@");
        message.append(this.addParam("dateStart", form.get("dateStart")));
        message.append(this.addParam("dateFinish", form.get("dateFinish")));
        message.append(this.addParam("author", form.get("author")));
        message.append(this.addParam("versionFrom", form.get("versionFrom")));
        message.append(this.addParam("versionTo", form.get("versionTo")));
        message.append(this.addParam("documentState", form.get("documentState")));
        message.append(this.addParam("checkoutDateFrom", form.get("checkoutDateFrom")));
        message.append(this.addParam("checkoutDateTo", form.get("checkoutDateTo")));
        message.append(this.addParam("checkOutUser", form.get("checkOutUser")));
        message.append(this.addParam("comment", form.get("comment")));
        message.append(this.addParam("showOrgFileName", form.get("showOrgFileName")));
        message.append(this.addParam("showAllVersions", form.get("showAllVersions")));
        message.append(this.addParam("indexes", this.getIndexes((VariableListForm[])form.get("lines"))));
        return message.toString();
    }

    private String addParam(String param, Object object) {
        StringBuilder sb = new StringBuilder();
        sb.append(param).append("=").append(object).append("@AUDIT_PARAM@");
        return sb.toString();
    }

    private String getIndexes(VariableListForm[] lines) {
        StringBuilder sb = new StringBuilder();
        if (lines != null && lines.length > 0 && lines[0] != null && lines[0].VarName != null && lines[0].VarName.compareToIgnoreCase("DocClassId") == 0) {
            Map<String, String> indexes = this.getIndexes(Long.valueOf(lines[0].getVarValue()));
            for (int i = 1; i < lines.length; ++i) {
                VariableListForm var = lines[i];
                String id = var.getVarID();
                String value = var.getVarValue();
                if (StringUtils.isBlank((String)id) || StringUtils.isBlank((String)value)) break;
                sb.append("<b>").append(indexes.get(id)).append("</b> = ").append(value).append("<br>");
            }
        }
        return sb.toString();
    }

    private Map<String, String> getIndexes(Long classId) {
        HashMap<String, String> result = new HashMap<String, String>();
        DocumentClassService dcs = ServiceFactory.getDocumentClassService();
        DocumentClass clazz = (DocumentClass)dcs.get((Serializable)classId, new String[]{"indexes"});
        Set indices = clazz.getIndexes();
        for (DocumentClassIndex idx : indices) {
            result.put(idx.getId().toString(), idx.getName());
        }
        return result;
    }
}

