/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import co.elastic.clients.elasticsearch._types.FieldValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.collect.Iterables;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.UserSearchViewTable;
import com.plusmpm.database.authorization.Right;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.i18n.I18N;
import com.plusmpm.struts.form.AdvanceVariableForm;
import com.plusmpm.util.ActivityVariable;
import com.plusmpm.util.AdvanceSearchResult;
import com.plusmpm.util.AdvanceVariableListComp;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.DisplaytagExportController;
import com.plusmpm.util.ProcesType;
import com.plusmpm.util.ProcessSearchExtras;
import com.plusmpm.util.SearchProcessVariable;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.UsersManagement;
import com.plusmpm.util.workflowData.ActivityData;
import com.suncode.plugin.framework.web.WebFragmentsManager;
import com.suncode.plugin.framework.web.support.MenuItem;
import com.suncode.plugin.framework.web.support.Section;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.elastic.search.ElasticValueSearchModelConverter;
import com.suncode.pwfl.elastic.search.model.ElasticSearchModel;
import com.suncode.pwfl.elastic.search.model.ElasticSearchSort;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.experimental.ExperimentalFeature;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.indexer.workflow.activity.model.ActivityModel;
import com.suncode.pwfl.indexer.workflow.process.model.ProcessModel;
import com.suncode.pwfl.search.AdvanceProcessSearchService;
import com.suncode.pwfl.search.AdvanceVariableFormBuilder;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.search.elastic.ElasticAdvanceProcessSearchResults;
import com.suncode.pwfl.search.elastic.ElasticAdvanceProcessSearchService;
import com.suncode.pwfl.search.elastic.ElasticResultConverterParameters;
import com.suncode.pwfl.search.elastic.ElasticResultToAdvanceSearchResultConverter;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.ShaKey;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.view.ViewService;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.search.model.VariableSearchModelDto;
import com.suncode.pwfl.web.support.distinction.DistinctionUtil;
import com.suncode.pwfl.web.support.form.cache.SearchFormCache;
import com.suncode.pwfl.web.ui.section.SectionHolder;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialActivityCache;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialActivityProvider;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialCacheKeyId;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialCacheSourceType;
import com.suncode.pwfl.workflow.activity.sequential.cache.view.SequentialActivityViewMapper;
import com.suncode.pwfl.workflow.activity.sequential.cache.view.SequentialCacheKeyViewId;
import com.suncode.pwfl.workflow.search.ActivitySearchQuery;
import com.suncode.pwfl.workflow.search.ProcessSearchQuery;
import com.suncode.pwfl.workflow.search.SearchQuery;
import com.suncode.pwfl.workflow.search.SearchResultActionSection;
import com.suncode.pwfl.workflow.view.ExtendedViewEvaluator;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.util.ParamEncoder;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataType;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvanceProcessSearchAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(AdvanceProcessSearchAction.class);
    private static WebFragmentsManager webFragmentsManager = (WebFragmentsManager)SpringContext.getBean(WebFragmentsManager.class);
    private static AdvanceVariableFormBuilder advanceVariableFormBuilder = (AdvanceVariableFormBuilder)SpringContext.getBean(AdvanceVariableFormBuilder.class);
    private static SectionHolder sectionHolder = (SectionHolder)SpringContext.getBean(SectionHolder.class);
    public static org.apache.log4j.Logger performanceLog = org.apache.log4j.Logger.getLogger((String)"PerformanceLog");
    public static org.apache.log4j.Logger securityLog = org.apache.log4j.Logger.getLogger((String)"Security");
    private static SequentialActivityCache sequentialActivityCache = (SequentialActivityCache)SpringContext.getBean(SequentialActivityCache.class);
    private static final SearchFormCache searchFormCache = (SearchFormCache)SpringContext.getBean(SearchFormCache.class);
    private static ShaKey processKey = (ShaKey)SpringContext.getBean(ShaKey.class);
    private static final ElasticAdvanceProcessSearchService elasticAdvanceProcessSearchService = (ElasticAdvanceProcessSearchService)SpringContext.getBean(ElasticAdvanceProcessSearchService.class);
    private static final ElasticResultToAdvanceSearchResultConverter elasticResultToAdvanceSearchResultConverter = (ElasticResultToAdvanceSearchResultConverter)SpringContext.getBean(ElasticResultToAdvanceSearchResultConverter.class);
    private static final Experimental experimental = (Experimental)SpringContext.getBean(Experimental.class);
    private static final ElasticValueSearchModelConverter elasticValueSearchModelConverter = (ElasticValueSearchModelConverter)SpringContext.getBean(ElasticValueSearchModelConverter.class);
    private static final SequentialActivityViewMapper sequentialActivityViewMapper = (SequentialActivityViewMapper)SpringContext.getBean(SequentialActivityViewMapper.class);
    private static final ExtendedViewEvaluator viewEvaluator = (ExtendedViewEvaluator)SpringContext.getBean(ExtendedViewEvaluator.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.debug("******************************AdvanceProcessSearchAction********************");
        Date dt = new Date();
        I18N oMessage = new I18N(request);
        boolean bShowSearchResultOnResult = Boolean.FALSE;
        boolean bActivitiesSearch = Boolean.FALSE;
        boolean isElasticFeatureEnabled = experimental.hasFeature(ExperimentalFeature.ELASTIC) && SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.ELASTIC_ENABLED) != false;
        request.setAttribute("activeTab", (Object)"SearchForm.do");
        try {
            boolean isFormCached;
            boolean bExport = false;
            String sSource = request.getParameter("source");
            boolean isSourcePresent = StringUtils.isNotBlank((String)sSource);
            boolean isFilterSearch = isSourcePresent && sSource.equalsIgnoreCase("filter");
            int iPageSize = 20;
            int iMaxPageSize = 0;
            int iOffset = 0;
            int iPageNr = 0;
            int iSortColumnNr = 0;
            int iSortOrderType = 0;
            String sSortColumnName = "";
            String sView_Name = "";
            HttpSession session = request.getSession(false);
            String userName = (String)session.getAttribute("username");
            AdvanceVariableForm[] advanceSearchVariables = null;
            AdvanceVariableForm[] advanceSearchExtras = null;
            String encodedSearchFormModel = request.getParameter("searchFormModel");
            boolean isNewFrontendSearch = StringUtils.isNotBlank((String)encodedSearchFormModel);
            String searchId = request.getParameter("searchId");
            if (StringUtils.isBlank((String)searchId)) {
                searchId = (String)request.getAttribute("searchId");
            }
            Cache<String, String> cache = searchFormCache.getCache(session);
            ConcurrentMap sessionCache = cache.asMap();
            boolean bl = isFormCached = StringUtils.isNotBlank((String)searchId) && sessionCache.containsKey(searchId);
            if (!isFormCached && !isNewFrontendSearch) {
                request.setAttribute("message", (Object)oMessage.getString("Niepoprawne_kryteria_wyszukiwania"));
                return mapping.findForward("showErrorMessage");
            }
            if (isNewFrontendSearch) {
                if (!isFormCached) {
                    searchId = UUID.randomUUID().toString();
                }
                cache.put((Object)searchId, (Object)encodedSearchFormModel);
            }
            List<Object> searchAfterSorters = Collections.emptyList();
            boolean isAdvancedSearch = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.ADVANCED_SEARCH);
            boolean isAggregateArrayVariablesEnabled = isAdvancedSearch && SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.AGGREGATE_ARRAY_VARIABLES_ENABLED) != false;
            HashMap<String, Integer> hmVariables = new HashMap<String, Integer>();
            HashMap<String, String> hmVariablesViewName = new HashMap<String, String>();
            HashMap<String, String> hmVariablesTypes = new HashMap<String, String>();
            HashMap<String, String> hmVariablesSubTypes = new HashMap<String, String>();
            HashMap<String, String[]> hmVariablesListValues = new HashMap<String, String[]>();
            HashMap<String, String[]> hmVariablesListKeys = new HashMap<String, String[]>();
            ArrayList displayedInOneRowTableVariables = new ArrayList();
            List<Object> tableVariables = new ArrayList();
            hmVariables.put("processType", 0);
            hmVariables.put("procName", 1);
            hmVariables.put("procDescr", 2);
            hmVariables.put("procInitiator", 3);
            hmVariables.put("procStateSelect", 4);
            hmVariables.put("realizationPercent", 5);
            hmVariables.put("procStart", 6);
            hmVariables.put("procFinish", 7);
            hmVariables.put("processDeadline", 8);
            hmVariables.put("taskName", 9);
            hmVariables.put("taskStateSelect", 10);
            hmVariables.put("taskUser", 11);
            hmVariables.put("taskStart", 12);
            hmVariables.put("taskFinish", 13);
            hmVariables.put("taskDeadline", 14);
            hmVariables.put("onlyActiveTask", 15);
            hmVariables.put("onlyLoggedUserTask", 16);
            hmVariables.put("procDefId", 17);
            hmVariables.put("taskDeadlineName", 18);
            hmVariables.put("resultsInOneRow", 19);
            hmVariablesViewName.put("processType", oMessage.getString("Typ_procesu"));
            hmVariablesViewName.put("procName", oMessage.getString("Nazwa_procesu"));
            hmVariablesViewName.put("procDescr", oMessage.getString("Opis_procesu"));
            hmVariablesViewName.put("procInitiator", oMessage.getString("Inicjator"));
            hmVariablesViewName.put("procStateSelect", oMessage.getString("Status_procesu"));
            hmVariablesViewName.put("realizationPercent", oMessage.getString("Procent_realizacji"));
            hmVariablesViewName.put("procStart", oMessage.getString("Data_rozpoczecia"));
            hmVariablesViewName.put("procFinish", oMessage.getString("Data_zakonczenia"));
            hmVariablesViewName.put("processDeadline", oMessage.getString("Przekroczenie_terminu_w_dn"));
            hmVariablesViewName.put("taskName", oMessage.getString("Nazwa_zadania"));
            hmVariablesViewName.put("taskStateSelect", oMessage.getString("Status_zadania"));
            hmVariablesViewName.put("taskUser", oMessage.getString("Wykonawca"));
            hmVariablesViewName.put("taskStart", oMessage.getString("Data_rozpoczecia"));
            hmVariablesViewName.put("taskFinish", oMessage.getString("Data_zakonczenia"));
            hmVariablesViewName.put("taskDeadline", oMessage.getString("Przekroczenie_terminu_zadania_w_dn"));
            hmVariablesViewName.put("onlyActiveTask", oMessage.getString("Tylko_zadania_do_wykonania"));
            hmVariablesViewName.put("onlyLoggedUserTask", oMessage.getString("Tylko_moje_zadania"));
            hmVariablesViewName.put("procDefId", oMessage.getString("n_a"));
            hmVariablesViewName.put("taskDeadlineName", oMessage.getString("Nazwa_terminu_ostatecznego"));
            hmVariablesViewName.put("resultsInOneRow", MessageHelper.getMessage((String)"Wyswietl_wyniki_zmiennych__tabelarycznych_w_jednym_wierszu"));
            hmVariablesTypes.put("processType", "STRING");
            hmVariablesTypes.put("procName", "STRING");
            hmVariablesTypes.put("procDescr", "STRING");
            hmVariablesTypes.put("procInitiator", "STRING");
            hmVariablesTypes.put("procStateSelect", "STRING");
            hmVariablesTypes.put("realizationPercent", "STRING");
            hmVariablesTypes.put("procStart", "DATE");
            hmVariablesTypes.put("procFinish", "DATE");
            hmVariablesTypes.put("processDeadline", "INTEGER");
            hmVariablesTypes.put("taskName", "STRING");
            hmVariablesTypes.put("taskStateSelect", "STRING");
            hmVariablesTypes.put("taskUser", "STRING");
            hmVariablesTypes.put("taskStart", "DATE");
            hmVariablesTypes.put("taskFinish", "DATE");
            hmVariablesTypes.put("taskDeadline", "INTEGER");
            hmVariablesTypes.put("procDefId", "STRING");
            hmVariablesTypes.put("taskDeadlineName", "STRING");
            hmVariablesTypes.put("resultsInOneRow", "STRING");
            hmVariablesSubTypes.put("procStateSelect", "LISTBOX");
            hmVariablesSubTypes.put("taskStateSelect", "LISTBOX");
            hmVariablesSubTypes.put("processType", "LISTBOX");
            hmVariablesListValues.put("procStateSelect", new String[]{oMessage.getString("Uruchomiony"), oMessage.getString("Oczekujacy_na_uruchomienie"), oMessage.getString("Zawieszony"), oMessage.getString("Zakonczony"), oMessage.getString("Przerwany"), oMessage.getString("Anulowany")});
            hmVariablesListValues.put("taskStateSelect", new String[]{oMessage.getString("Uruchomione"), oMessage.getString("Oczekujace_na_uruchomienie"), oMessage.getString("Zawieszone"), oMessage.getString("Otwarte"), oMessage.getString("Zakonczone"), oMessage.getString("Przerwane"), oMessage.getString("Anulowane")});
            hmVariablesListKeys.put("procStateSelect", new String[]{"open.running", "open.not_running.not_started", "open.not_running.suspended", "closed.completed", "closed.terminated", "closed.aborted"});
            hmVariablesListKeys.put("taskStateSelect", new String[]{"open.running", "open.not_running.not_started", "open.not_running.suspended", "open%", "closed.completed", "closed.terminated", "closed.aborted"});
            ArrayList alProcTypes = SearchProcessVariable.SearchProcessesTypes((HttpServletRequest)request);
            HashMap<String, Right> userRights = new HashMap<String, Right>();
            ArrayList<Map<String, Right>> groupRights = new ArrayList<Map<String, Right>>();
            ArrayList<String> userGroups = new ArrayList<String>();
            TransactionWrapper.get().doInJdbcConnection(connection -> {
                userGroups.addAll(Authorization.GetGroups((Connection)connection, (String)userName));
                Map resourceRights = Authorization.getResourceRights((Connection)connection, (String)userName, (boolean)false);
                userRights.putAll(resourceRights);
                for (String group : userGroups) {
                    groupRights.add(Authorization.getResourceRights((Connection)connection, (String)group, (boolean)true));
                }
            });
            List<ProcesType> alNewProcTypes = this.filterUnauthorizedProcesses(alProcTypes, userName, userRights, groupRights, userGroups);
            String[] processTypeValues = new String[alNewProcTypes.size()];
            String[] processTypeKeys = new String[alNewProcTypes.size()];
            for (int i = 0; i < processTypeValues.length; ++i) {
                processTypeValues[i] = alNewProcTypes.get(i).getSProcTypeName();
                processTypeKeys[i] = alNewProcTypes.get(i).getSProcTypeId();
            }
            hmVariablesListValues.put("processType", processTypeValues);
            hmVariablesListKeys.put("processType", processTypeKeys);
            if (isSourcePresent && sSource.compareToIgnoreCase("displaytag") == 0) {
                bShowSearchResultOnResult = Boolean.TRUE;
            } else {
                session.setAttribute("sSortColumnName", null);
                session.setAttribute("iSortOrderType", null);
            }
            iPageSize = UsersManagement.getUserDefinedPageSize((String)userName);
            String requestParamViewId = request.getParameter("viewId");
            String sViewId = requestParamViewId != null ? requestParamViewId : "";
            UserSearchViewTable userSearchViewTable = null;
            DBManagement dbManagement = new DBManagement();
            DynaActionForm advanceSearchForm = form != null ? (DynaActionForm)form : new DynaActionForm();
            SearchFormModelDto searchFormModelDto = null;
            if (request.getMethod().equals("GET")) {
                searchFormCache.getValueFromCache(session, searchId);
                Optional<String> cachedEncodedSearchModel = searchFormCache.getValueFromCache(session, searchId);
                if (cachedEncodedSearchModel.isPresent()) {
                    byte[] decodedBytes = Base64.getDecoder().decode(cachedEncodedSearchModel.get().getBytes(StandardCharsets.UTF_8));
                    String searchModelForm = new String(decodedBytes, StandardCharsets.UTF_8);
                    searchFormModelDto = (SearchFormModelDto)new ObjectMapper().readValue(searchModelForm, SearchFormModelDto.class);
                    advanceSearchVariables = advanceVariableFormBuilder.buildAdvanceFormVariables(searchFormModelDto);
                    advanceSearchExtras = advanceVariableFormBuilder.buildAdvanceVariableFormExtras(searchFormModelDto.getExtrasSearchModel());
                    boolean showResultsInOneRow = true;
                    tableVariables = searchFormModelDto.getProcessVariablesSearchModel().getVariables().stream().filter(variable -> StringUtils.isNotBlank((String)variable.getValue().getSubType())).map(VariableSearchModelDto::getId).collect(Collectors.toList());
                    displayedInOneRowTableVariables = tableVariables;
                    advanceSearchForm.getMap().put("variable", advanceSearchVariables);
                    advanceSearchForm.getMap().put("extra", advanceSearchExtras);
                    request.setAttribute("encodedSearchFormModel", (Object)cachedEncodedSearchModel.get());
                    request.setAttribute("searchId", (Object)searchId);
                }
            }
            if (isFilterSearch) {
                session.setAttribute("m_bFilterSearch", null);
                session.setAttribute("filterVariableListForm", null);
                session.setAttribute("iOffset", null);
                session.setAttribute("iSortOrderType", null);
                session.setAttribute("sSortColumnName", null);
                session.setAttribute("advanceSearchBean", null);
                bShowSearchResultOnResult = Boolean.TRUE;
            }
            int iAdmRight = Authorization.checkRight((String)"System", (String)userName, (boolean)false, (boolean)false);
            if (sViewId != null && sViewId.compareToIgnoreCase("") != 0) {
                userSearchViewTable = dbManagement.getUserSearchView(sViewId);
                if (userSearchViewTable != null) {
                    String sShowSearchResultOnResult;
                    if (iAdmRight != 0) {
                        ArrayList alUserViews = dbManagement.GetAllUserSearchViewsForUserSource(userName, "advanceSearch");
                        String viewId = sViewId;
                        boolean check = alUserViews.stream().anyMatch(userView -> userView.getId().toString().equals(viewId));
                        if (!check) {
                            securityLog.warn((Object)("Pr\u00f3ba dost\u0119pu do chronionego widoku: u\u017cytkownik: " + userName + ", idWidoku: " + sViewId));
                            request.setAttribute("message", (Object)oMessage.getString("Brak_uprawnien"));
                            return mapping.findForward("showErrorMessage");
                        }
                    }
                    sView_Name = userSearchViewTable.getViewName();
                    log.debug("Nazwa widoku " + sView_Name);
                    String sShowForm = userSearchViewTable.getShowFormOnResult();
                    if (sShowForm != null && sShowForm.compareToIgnoreCase("true") == 0) {
                        request.setAttribute("showForm", (Object)"TRUE");
                    }
                    if ((sShowSearchResultOnResult = userSearchViewTable.getShowSearchResultOnResult()) != null && sShowSearchResultOnResult.compareToIgnoreCase("true") == 0) {
                        bShowSearchResultOnResult = Boolean.TRUE;
                    }
                }
            } else {
                bShowSearchResultOnResult = Boolean.TRUE;
            }
            if (advanceSearchForm != null) {
                SortDirection direction;
                DisplaytagExportController dec;
                DisplaytagExportController.DisplaytagExportControlResult decRes;
                String operationSource;
                String viewName;
                boolean showLimitExceededMessage;
                String pageNr = new ParamEncoder("task").encodeParameterName("p");
                log.debug("pageNr:" + pageNr);
                String pageNrValue = request.getParameter(pageNr);
                log.debug("pageNrValue:" + pageNrValue);
                try {
                    iPageNr = pageNrValue != null ? Integer.parseInt(pageNrValue) : 1;
                }
                catch (Exception e) {
                    log.error("B\u0142\u0105d przy okre\u015blaniu pagingu : ", (Throwable)e);
                    iPageNr = 1;
                }
                iOffset = (iPageNr - 1) * iPageSize;
                if (iOffset < 0) {
                    iOffset = 0;
                }
                if (request.getMethod().equals("POST")) {
                    StringBuilder redirectUrlBuilder = new StringBuilder();
                    redirectUrlBuilder.append("AdvanceProcessSearch.do?");
                    redirectUrlBuilder.append(pageNr).append("=").append(iPageNr);
                    if (isSourcePresent) {
                        redirectUrlBuilder.append("&").append("source").append("=").append(sSource);
                    }
                    if (StringUtils.isNotBlank((String)searchId)) {
                        redirectUrlBuilder.append("&searchId=").append(searchId);
                    }
                    if (StringUtils.isNotBlank((String)sViewId)) {
                        session.removeAttribute("viewId");
                        redirectUrlBuilder.append("&viewId=").append(sViewId);
                    }
                    return new ActionForward(redirectUrlBuilder.toString(), true);
                }
                try {
                    String exportType = new ParamEncoder("task").encodeParameterName("e");
                    log.debug("exportType:" + exportType);
                    String sVal = request.getParameter(exportType);
                    log.debug("sVal:" + sVal);
                    if (sVal != null) {
                        bExport = true;
                    }
                }
                catch (Exception e) {
                    log.debug("Blad, brak exportu");
                }
                ArrayList<AdvanceVariableForm> alVariableList = new ArrayList<AdvanceVariableForm>();
                AdvanceVariableForm[] searchVariable = (AdvanceVariableForm[])advanceSearchForm.get("variable");
                for (int i = 0; i < searchVariable.length && (i == 19 || searchVariable[i] != null && searchVariable[i].getName() != null); ++i) {
                    alVariableList.add(searchVariable[i]);
                }
                AdvanceVariableListComp avc = new AdvanceVariableListComp();
                Collections.sort(alVariableList, avc);
                try {
                    String sOrder = new ParamEncoder("task").encodeParameterName("o");
                    String sSortColumnNr = new ParamEncoder("task").encodeParameterName("s");
                    log.debug("sOrder:" + sOrder);
                    String sOrderVal = request.getParameter(sOrder);
                    String sSortColumnNrVal = request.getParameter(sSortColumnNr);
                    log.debug("sOrderVal:" + sOrderVal);
                    if (sOrderVal != null) {
                        iSortOrderType = Integer.parseInt(sOrderVal);
                        try {
                            iSortColumnNr = Integer.parseInt(sSortColumnNrVal);
                            AdvanceVariableForm var = (AdvanceVariableForm)alVariableList.get(iSortColumnNr / 2);
                            sSortColumnName = var.getName();
                        }
                        catch (NumberFormatException numberEx) {
                            sSortColumnName = sSortColumnNrVal;
                        }
                    } else {
                        sSortColumnName = (String)session.getAttribute("sSortColumnName");
                        if (sSortColumnName != null) {
                            AdvanceVariableForm sortVariable = (AdvanceVariableForm)alVariableList.get(0);
                            Integer ISortOrderType = 1;
                            if (sortVariable != null) {
                                ISortOrderType = sortVariable.getSortType() != null & sortVariable.getSortType().equalsIgnoreCase("ASC") ? 2 : 1;
                            }
                            if (ISortOrderType != null) {
                                iSortOrderType = new Integer(ISortOrderType);
                            } else {
                                sOrder = new ParamEncoder("task").encodeParameterName("o");
                                sOrderVal = request.getParameter(sOrder);
                                if (sOrderVal != null) {
                                    iSortOrderType = Integer.parseInt(sOrderVal);
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    sSortColumnName = (String)session.getAttribute("sSortColumnName");
                    if (sSortColumnName != null) {
                        Integer ISortOrderType = (Integer)session.getAttribute("iSortOrderType");
                        if (ISortOrderType != null) {
                            iSortOrderType = new Integer(ISortOrderType);
                        } else {
                            String sOrder = new ParamEncoder("task").encodeParameterName("o");
                            String sOrderVal = request.getParameter(sOrder);
                            if (sOrderVal != null) {
                                iSortOrderType = Integer.parseInt(sOrderVal);
                            }
                        }
                    }
                    log.debug("Blad, brak sort ");
                }
                if (bExport) {
                    iOffset = 0;
                    iPageSize = 0;
                }
                Long viewId = StringUtils.isNotBlank((String)sViewId) ? Long.valueOf(Long.parseLong(sViewId)) : null;
                Vector vCountQuery = new Vector();
                HashMap<String, String> hmExTypeVariables = new HashMap<String, String>();
                WorkflowProcess wp = null;
                int processRights = -1;
                for (int i = 0; i < searchVariable.length; ++i) {
                    ExtendedAttribute ea;
                    DataField dataField;
                    AdvanceVariableForm advSearchVariable = searchVariable[i];
                    if (advSearchVariable == null) continue;
                    String sVariableName = advSearchVariable.getName();
                    String sValue = advSearchVariable.getValue();
                    String sValue2 = advSearchVariable.getValue2();
                    String sActive = advSearchVariable.getActive();
                    String variableViewName = "";
                    String variableType = "";
                    String variableSubType = "";
                    if (sVariableName == null) break;
                    if (!(bActivitiesSearch || sVariableName.compareToIgnoreCase("taskName") != 0 && sVariableName.compareToIgnoreCase("taskStateSelect") != 0 && sVariableName.compareToIgnoreCase("taskUser") != 0 && sVariableName.compareToIgnoreCase("taskStart") != 0 && sVariableName.compareToIgnoreCase("taskFinish") != 0 && sVariableName.compareToIgnoreCase("taskDeadline") != 0 && sVariableName.compareToIgnoreCase("onlyActiveTask") != 0 && sVariableName.compareToIgnoreCase("onlyLoggedUserTask") != 0 && sVariableName.compareToIgnoreCase("taskDeadlineName") != 0 || Tools.isNullOrEmpty((String)sValue) && Tools.isNullOrEmpty((String)sValue2) && (sActive == null || sActive.compareToIgnoreCase("on") != 0))) {
                        bActivitiesSearch = Boolean.TRUE;
                    }
                    if (sVariableName.compareToIgnoreCase("processType") == 0) {
                        WorkflowProcess proc = StringUtils.isNotBlank((String)sValue) ? SharkFunctions.getWorkflowProcessByDefId((String)sValue) : null;
                        int n = processRights = processRights == 0 ? processRights : this.checkProcessRights(userName, proc);
                    }
                    if (sVariableName.compareToIgnoreCase("procDefId") == 0) {
                        wp = StringUtils.isNotBlank((String)sValue) ? SharkFunctions.getWorkflowProcessByDefId((String)sValue) : null;
                        int n = processRights = processRights == 0 ? processRights : this.checkProcessRights(userName, wp);
                    }
                    if (wp == null || (dataField = wp.getDataField(sVariableName)) == null) continue;
                    hmVariables.put(sVariableName, i);
                    variableViewName = dataField.getName();
                    hmVariablesViewName.put(sVariableName, variableViewName);
                    ExtendedAttributes variableExtendedAttributes = dataField.getExtendedAttributes();
                    DataType dtType = dataField.getDataType();
                    variableType = dtType.getDataTypes().getBasicType().getType();
                    hmVariablesTypes.put(sVariableName, variableType);
                    if (variableExtendedAttributes.containsElement("SUBTYPE")) {
                        ea = variableExtendedAttributes.getFirstExtendedAttributeForName("SUBTYPE");
                        variableSubType = ea.getVValue();
                    }
                    if (variableExtendedAttributes.containsElement("EXTYPE")) {
                        ea = variableExtendedAttributes.getFirstExtendedAttributeForName("EXTYPE");
                        hmExTypeVariables.put(sVariableName, ea.getVValue());
                    }
                    if (variableExtendedAttributes.containsElement("VALUES")) {
                        ea = variableExtendedAttributes.getFirstExtendedAttributeForName("VALUES");
                        String sValues = ea.getVValue();
                        String[] sVal = sValues.split("\n");
                        if (sValues.indexOf(60) == 0 && sValues.indexOf(62) == sValues.length() - 1) {
                            variableSubType = "";
                        } else {
                            hmVariablesListValues.put(sVariableName, sVal);
                            hmVariablesListKeys.put(sVariableName, sVal);
                        }
                    }
                    hmVariablesSubTypes.put(sVariableName, variableSubType);
                }
                ArrayList alResult = null;
                ElasticSearchModel elasticSearchModel = null;
                String sortDirection = null;
                if (iSortOrderType == 2 || iSortOrderType == 1) {
                    sortDirection = iSortOrderType == 2 ? "ASC" : "DESC";
                }
                boolean checkProcessesRight = isElasticFeatureEnabled && (userSearchViewTable == null || userName.equalsIgnoreCase(userSearchViewTable.getUserName()));
                boolean emptyProcessDefSearch = AdvanceProcessSearchService.checkEmptyProcessDef((SearchFormModelDto)searchFormModelDto);
                boolean openAndMyActivitiesCheckboxes = AdvanceProcessSearchService.checkOpenAndMyActivitiesCheckboxes((SearchFormModelDto)searchFormModelDto);
                boolean openAndUsernameTagActivities = AdvanceProcessSearchService.checkOpenAndUsernameTagActivities((SearchFormModelDto)searchFormModelDto);
                log.debug("checkProcessesRight: " + checkProcessesRight + " emptyProcessDefSearch: " + emptyProcessDefSearch + " openAndMyActivitiesCheckboxes: " + openAndMyActivitiesCheckboxes + " openAndUsernameTagActivities: " + openAndUsernameTagActivities);
                boolean doNotCheckRights = !checkProcessesRight && !emptyProcessDefSearch || openAndMyActivitiesCheckboxes || openAndUsernameTagActivities;
                List<String> authorizedProcessDefIds = doNotCheckRights ? null : Arrays.asList(processTypeKeys);
                ElasticResultConverterParameters.ElasticResultConverterParametersBuilder elasticResultConverterParametersBuilder = ElasticResultConverterParameters.builder();
                if (isElasticFeatureEnabled && !doNotCheckRights && CollectionUtils.isEmpty(authorizedProcessDefIds)) {
                    alResult = null;
                    iMaxPageSize = 0;
                } else if (isElasticFeatureEnabled) {
                    try {
                        elasticSearchModel = elasticValueSearchModelConverter.fromSearchModel(searchFormModelDto, sSortColumnName, sortDirection, !doNotCheckRights, authorizedProcessDefIds);
                        Map<String, String> sorters = elasticSearchModel.getSorters().stream().filter(sorter -> sorter.getFieldId() != null).collect(Collectors.toMap(ElasticSearchSort::getFieldId, ElasticSearchSort::getSortDirection));
                        elasticResultConverterParametersBuilder.searchFormModelDto(searchFormModelDto).alVariableList(alVariableList).isExport(bExport).viewId(viewId).acceptManyTasks(BooleanUtils.toBoolean((String)userSearchViewTable.getAcceptManyTasks())).searchId(searchId).source(sSource).userRights(userRights).userGroupRights(groupRights).hmSubTypeVariables(hmVariablesSubTypes).hmTypeVariables(hmVariablesTypes).processKey(processKey).tableVariables(tableVariables).displayedInOneRowTableVariables(displayedInOneRowTableVariables).sorters(sorters).hmExTypeVariables(hmExTypeVariables).userName(userName);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        alResult = null;
                        iMaxPageSize = 0;
                    }
                }
                long currentSearchResultCount = iPageNr * iPageSize;
                long EFFECTIVE_ELASTIC_LIMIT = SystemProperties.getLong((DefinedSystemParameter)DefinedSystemParameter.ELASTIC_MAX_RESULT_WINDOW);
                if (bShowSearchResultOnResult == Boolean.TRUE) {
                    ElasticAdvanceProcessSearchResults elasticAdvanceProcessSearchResults;
                    if (bExport) {
                        String exportTypeParamName = new ParamEncoder("task").encodeParameterName("e");
                        String exportType = request.getParameter(exportTypeParamName);
                        if (SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.USE_SYSTEM_ADVANCE_SEARCH_EXCEL_EXPORT).booleanValue() && exportType.equalsIgnoreCase(String.valueOf(MediaTypeEnum.EXCEL.getCode()))) {
                            int resultsCount = this.doExcelExport(searchVariable, userName, iSortOrderType, sSortColumnName, Tools.isNullOrEmpty((String)sViewId), request, response, isElasticFeatureEnabled, elasticResultConverterParametersBuilder, elasticSearchModel);
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            if (userSearchViewTable != null) {
                                params.put("viewId", userSearchViewTable.getId());
                                params.put("viewName", userSearchViewTable.getViewName());
                            }
                            params.put("resultsCount", resultsCount);
                            request.setAttribute("audit", (Object)AuditBuilder.getInstance().type(AuditTypes.AUDIT_SEARCH_EXCEL_EXPORT).params(params).buildSuccess());
                            return null;
                        }
                        if (SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.USE_SYSTEM_ADVANCE_SEARCH_CSV_EXPORT).booleanValue() && exportType.equalsIgnoreCase(String.valueOf(MediaTypeEnum.CSV.getCode()))) {
                            this.doCsvExport(searchVariable, userName, iSortOrderType, sSortColumnName, Tools.isNullOrEmpty((String)sViewId), request, response, isElasticFeatureEnabled, elasticSearchModel, elasticResultConverterParametersBuilder);
                            return null;
                        }
                    }
                    if (bExport) {
                        ArrayList partialResults;
                        int packSize = SystemProperties.getLong((DefinedSystemParameter)DefinedSystemParameter.PACK_SIZE_IN_ADVANCE_SEARCH_EXPORT).intValue();
                        int offset = 0;
                        int iterations = 0;
                        alResult = new ArrayList();
                        if (isElasticFeatureEnabled) {
                            try {
                                elasticAdvanceProcessSearchResults = elasticAdvanceProcessSearchService.search(elasticSearchModel, searchAfterSorters, packSize);
                                searchAfterSorters = this.resolveSearchAfterSorters(elasticAdvanceProcessSearchResults);
                                iMaxPageSize = (int)elasticAdvanceProcessSearchResults.getCount();
                                elasticResultConverterParametersBuilder.elasticAdvanceProcessSearchResults(elasticAdvanceProcessSearchResults);
                                partialResults = (ArrayList)elasticResultToAdvanceSearchResultConverter.convert(elasticResultConverterParametersBuilder.build());
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                                partialResults = null;
                                iMaxPageSize = 0;
                            }
                        } else {
                            partialResults = dbManagement.AdavanceProcessSearch(searchVariable, userName, packSize, offset, iSortOrderType, sSortColumnName, vCountQuery, Tools.isNullOrEmpty((String)sViewId), true, request, false, false, viewId);
                        }
                        while (CollectionUtils.isNotEmpty(partialResults)) {
                            log.info("Iteracja: " + ++iterations);
                            offset = iterations * packSize;
                            alResult.addAll(partialResults);
                            if (isElasticFeatureEnabled) {
                                try {
                                    elasticAdvanceProcessSearchResults = elasticAdvanceProcessSearchService.search(elasticSearchModel, searchAfterSorters, packSize);
                                    searchAfterSorters = this.resolveSearchAfterSorters(elasticAdvanceProcessSearchResults);
                                    iMaxPageSize = (int)elasticAdvanceProcessSearchResults.getCount();
                                    elasticResultConverterParametersBuilder.elasticAdvanceProcessSearchResults(elasticAdvanceProcessSearchResults);
                                    partialResults = (ArrayList)elasticResultToAdvanceSearchResultConverter.convert(elasticResultConverterParametersBuilder.build());
                                }
                                catch (Exception e) {
                                    log.error(e.getMessage(), (Throwable)e);
                                    partialResults = null;
                                    iMaxPageSize = 0;
                                }
                                continue;
                            }
                            partialResults = dbManagement.AdavanceProcessSearch(searchVariable, userName, packSize, offset, iSortOrderType, sSortColumnName, vCountQuery, Tools.isNullOrEmpty((String)sViewId), true, request, false, false, viewId);
                        }
                    } else if (isElasticFeatureEnabled && currentSearchResultCount <= EFFECTIVE_ELASTIC_LIMIT && Objects.nonNull(elasticSearchModel)) {
                        try {
                            elasticAdvanceProcessSearchResults = elasticAdvanceProcessSearchService.search(elasticSearchModel, iOffset, iPageSize);
                            iMaxPageSize = (int)elasticAdvanceProcessSearchResults.getCount();
                            elasticResultConverterParametersBuilder.elasticAdvanceProcessSearchResults(elasticAdvanceProcessSearchResults);
                            alResult = (ArrayList)elasticResultToAdvanceSearchResultConverter.convert(elasticResultConverterParametersBuilder.build());
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                            alResult = null;
                            iMaxPageSize = 0;
                        }
                    } else if (!isElasticFeatureEnabled || isElasticFeatureEnabled && currentSearchResultCount > EFFECTIVE_ELASTIC_LIMIT) {
                        if (!checkProcessesRight) {
                            checkProcessesRight = emptyProcessDefSearch && !openAndMyActivitiesCheckboxes && !openAndUsernameTagActivities;
                        }
                        alResult = dbManagement.AdavanceProcessSearch(searchVariable, userName, iPageSize, iOffset, iSortOrderType, sSortColumnName, vCountQuery, checkProcessesRight, bExport, request, viewId);
                    }
                }
                if (!isElasticFeatureEnabled || currentSearchResultCount > EFFECTIVE_ELASTIC_LIMIT) {
                    if (CollectionUtils.isNotEmpty(alResult)) {
                        String sCountQuery = (String)vCountQuery.get(0);
                        iMaxPageSize = dbManagement.getSizeAdavanceProcessSearch(searchVariable, userName, sCountQuery);
                    } else {
                        iMaxPageSize = 0;
                    }
                }
                boolean messageNotInSession = StringUtils.isEmpty((String)((String)session.getAttribute("message")));
                boolean bl2 = showLimitExceededMessage = isElasticFeatureEnabled && (long)iMaxPageSize > EFFECTIVE_ELASTIC_LIMIT && iPageNr == 1 && messageNotInSession;
                if (showLimitExceededMessage) {
                    long slowerSearchPageNumber = Math.floorDiv(EFFECTIVE_ELASTIC_LIMIT, (long)iPageSize) + 1L;
                    request.setAttribute("message", (Object)MessageHelper.getMessage((String)"effective_elastic_limit_exceeded", (Object[])new Object[]{EFFECTIVE_ELASTIC_LIMIT, slowerSearchPageNumber}));
                    request.setAttribute("messageType", (Object)"info");
                }
                if (bExport) {
                    iPageSize = iMaxPageSize;
                }
                boolean isAnyProcessVariableActive = false;
                for (int i = 0; i < alVariableList.size(); ++i) {
                    AdvanceVariableForm advSearchVariable = (AdvanceVariableForm)alVariableList.get(i);
                    String sName = advSearchVariable.getName();
                    if (advSearchVariable.getActive() != null && advSearchVariable.getActive().compareTo("on") == 0) {
                        String sType = "STRING";
                        String sSubType = "";
                        String sViewName = "";
                        String[] asValueList = null;
                        String[] asKeyList = null;
                        if (hmVariables.containsKey(sName)) {
                            if ((Integer)hmVariables.get(sName) > 19) {
                                isAnyProcessVariableActive = true;
                            }
                            sViewName = (String)hmVariablesViewName.get(sName);
                            advSearchVariable.setViewname(sViewName);
                            sType = (String)hmVariablesTypes.get(sName);
                            sSubType = (String)hmVariablesSubTypes.get(sName);
                            log.debug("sName:" + sName);
                            asValueList = (String[])hmVariablesListValues.get(sName);
                            asKeyList = (String[])hmVariablesListKeys.get(sName);
                        }
                        ActivityVariable actVar = new ActivityVariable(sName, sViewName, "");
                        actVar.setM_sSubType(sSubType);
                        actVar.setM_sVariableType(sType);
                        actVar.setM_sValueList(asValueList);
                        actVar.setM_sKeyList(asKeyList);
                        actVar.setProcDefId(searchVariable[17].getValue());
                    }
                    if (!isAggregateArrayVariablesEnabled || !isAnyProcessVariableActive || !"resultsInOneRow".equals(sName)) continue;
                    request.setAttribute("resultsInOneRow", (Object)advSearchVariable.getValue());
                    request.setAttribute("advancedSearch", (Object)true);
                }
                if (iAdmRight == 0 || processRights == 0) {
                    request.setAttribute("adminMode", (Object)"TRUE");
                } else {
                    request.setAttribute("adminMode", (Object)"FALSE");
                }
                request.setAttribute("showForm", (Object)"FALSE");
                if (bActivitiesSearch) {
                    request.setAttribute("activitiesSearch", (Object)"TRUE");
                } else {
                    request.setAttribute("activitiesSearch", (Object)"FALSE");
                }
                if (bShowSearchResultOnResult) {
                    request.setAttribute("showSearchResultOnResult", (Object)"TRUE");
                } else {
                    request.setAttribute("showSearchResultOnResult", (Object)"FALSE");
                }
                ViewService viewService = ServiceFactory.getViewService();
                String string = viewName = StringUtils.isNotBlank((String)sViewId) ? viewService.getViewTranslation(Long.valueOf(sViewId), TranslatedFieldType.NAME) : "";
                if (StringUtils.isNotBlank((String)viewName)) {
                    request.setAttribute("viewName", (Object)viewName);
                    operationSource = sView_Name;
                } else {
                    operationSource = "";
                    request.setAttribute("viewName", (Object)MessageHelper.getMessage((String)"Wyszukiwanie"));
                }
                request.setAttribute("operation_source", (Object)operationSource);
                log.debug("Ilo\u015b\u0107 wynik\u00f3w wyszukiwania:" + iMaxPageSize);
                String sAcceptManyTasks = (String)session.getAttribute("acceptManyTasks");
                if (sAcceptManyTasks != null && sAcceptManyTasks.compareToIgnoreCase("true") == 0 && StringUtils.isNotBlank((String)sViewId)) {
                    request.setAttribute("acceptManyTasks", (Object)"TRUE");
                    String acceptFromAllPages = userSearchViewTable.getAcceptFromAllPages();
                    if (acceptFromAllPages != null && acceptFromAllPages.equalsIgnoreCase("true")) {
                        request.setAttribute("acceptFromAllPages", (Object)"TRUE");
                    } else {
                        request.setAttribute("acceptFromAllPages", (Object)"FALSE");
                    }
                    request.setAttribute("confirmButton", (Object)"TRUE");
                    ActivityData activityData = new ActivityData();
                    String activityNameTMP = searchVariable[9].getValue();
                    String processDefIdTMP1 = searchVariable[17].getValue();
                    String processDefIdTMP2 = searchVariable[0].getValue();
                    String processDefIdTMP = "";
                    if (processDefIdTMP1 != null && processDefIdTMP2 != null && processDefIdTMP1.length() > 0 && processDefIdTMP2.length() > 0 && processDefIdTMP1.compareTo(processDefIdTMP2) == 0) {
                        processDefIdTMP = processDefIdTMP.concat(processDefIdTMP1);
                    } else if (processDefIdTMP1 != null && processDefIdTMP1.length() > 0 && (processDefIdTMP2 == null || processDefIdTMP2 != null && processDefIdTMP2.length() <= 0)) {
                        processDefIdTMP = processDefIdTMP.concat(processDefIdTMP1);
                    } else if (processDefIdTMP2 != null && processDefIdTMP2.length() > 0 && (processDefIdTMP1 == null || processDefIdTMP1 != null && processDefIdTMP1.length() <= 0)) {
                        processDefIdTMP = processDefIdTMP.concat(processDefIdTMP2);
                    }
                    if (DBUtils.isExactQuery((String)activityNameTMP)) {
                        activityNameTMP = DBUtils.getExactQueryValue((String)activityNameTMP);
                    }
                    List alAdditionalButtons = activityData.GetActivityAdditionalButtonsByActivityName(processDefIdTMP, activityNameTMP);
                    request.setAttribute("alAdditionalButtons", (Object)alAdditionalButtons);
                    if (alAdditionalButtons == null) {
                        request.setAttribute("confirmButton", (Object)"FALSE");
                        request.setAttribute("acceptManyTasks", (Object)"FALSE");
                        request.setAttribute("acceptFromAllPages", (Object)"FALSE");
                        request.setAttribute("message", (Object)MessageHelper.getMessage((String)"acceptManyTasksDisabled"));
                        request.setAttribute("messageType", (Object)"warning");
                    } else if (alAdditionalButtons.size() > 0) {
                        request.setAttribute("confirmButton", (Object)"FALSE");
                    }
                } else {
                    request.setAttribute("acceptManyTasks", (Object)"FALSE");
                    request.setAttribute("acceptFromAllPages", (Object)"FALSE");
                }
                if (userSearchViewTable == null && !Tools.isNullOrEmpty((String)sViewId)) {
                    userSearchViewTable = dbManagement.getUserSearchView(sViewId);
                }
                if (userSearchViewTable != null) {
                    request.setAttribute("showFormOnResult", (Object)userSearchViewTable.getShowFormOnResult());
                }
                if (bExport && !(decRes = (dec = new DisplaytagExportController(oMessage)).control((List)alResult)).isSuccess()) {
                    request.setAttribute("errorMessage", (Object)decRes.getErrorMessage());
                }
                if (CollectionUtils.isNotEmpty((Collection)alResult) && StringUtils.isNotEmpty((String)sViewId) && !bExport) {
                    try {
                        DistinctionUtil.distinguishValues((List)alResult, (String)sViewId);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (!bExport) {
                    ProcessSearchExtras extras = new ProcessSearchExtras();
                    extras.resolve((AdvanceVariableForm[])advanceSearchForm.get("extra"), (List)alResult, userName);
                }
                request.setAttribute("alResult", (Object)alResult);
                request.setAttribute("iMaxPageSize", (Object)new Integer(iMaxPageSize).toString());
                request.setAttribute("iPageSize", (Object)new Integer(iPageSize).toString());
                String requestViewId = request.getParameter("viewId");
                String sessionId = session.getId();
                SortDirection sortDirection2 = direction = iSortOrderType == 1 ? SortDirection.DESC : SortDirection.ASC;
                if (StringUtils.isNotBlank((String)requestViewId) && CollectionUtils.isNotEmpty((Collection)alResult)) {
                    long viewIdParam = Long.parseLong(requestViewId);
                    if (isFilterSearch || StringUtils.isNotBlank((String)sSortColumnName)) {
                        sequentialActivityCache.invalidate(request.getSession(false).getId());
                    }
                    SequentialCacheKeyViewId sequentialCacheKeyViewId = new SequentialCacheKeyViewId(request.getSession(false).getId(), Long.valueOf(viewIdParam));
                    String finalSSortColumnName = sSortColumnName;
                    SequentialActivityProvider sequentialActivityProvider = (begin, end) -> sequentialActivityViewMapper.map(viewEvaluator.evaluate(Long.valueOf(viewIdParam), begin.intValue(), end.intValue(), new Sorter(finalSSortColumnName, direction), Arrays.asList(searchVariable), Boolean.valueOf(false)));
                    sequentialActivityCache.cacheResults((SequentialCacheKeyId)sequentialCacheKeyViewId, SequentialCacheSourceType.VIEW, sequentialActivityProvider, iOffset, iPageSize, sequentialActivityViewMapper.map((List)alResult));
                } else {
                    sequentialActivityCache.invalidate(sessionId);
                }
                int lastPageNo = (int)Math.ceil((double)iMaxPageSize / (double)iPageSize);
                int n = lastPageNo = lastPageNo > 0 ? lastPageNo : 1;
                if (iPageNr > lastPageNo && !bExport) {
                    StringBuilder redirectUrlBuilder = new StringBuilder();
                    redirectUrlBuilder.append("AdvanceProcessSearch.do?");
                    redirectUrlBuilder.append(pageNr).append("=").append(lastPageNo);
                    if (StringUtils.isNotBlank((String)searchId)) {
                        redirectUrlBuilder.append("&searchId=").append(searchId);
                    }
                    if (StringUtils.isNotBlank((String)sViewId)) {
                        redirectUrlBuilder.append("&viewId=").append(sViewId);
                    }
                    return new ActionForward(redirectUrlBuilder.toString(), true);
                }
                request.setAttribute("menu", this.generateMenu(userName, sViewId, searchVariable, iMaxPageSize, bActivitiesSearch, searchId, sSortColumnName, direction));
                session.setAttribute("iAmount", (Object)new Integer(iMaxPageSize).toString());
                session.setAttribute("iOffset", (Object)iOffset);
                session.setAttribute("iSortOrderType", (Object)iSortOrderType);
                session.setAttribute("sSortColumnName", (Object)sSortColumnName);
                session.setAttribute("advanceSearchBean", (Object)advanceSearchForm);
            }
            Date dt4 = new Date();
            performanceLog.debug((Object)("|AdavanceProcessSearch|" + userName + "|" + sView_Name + "|" + (dt4.getTime() - dt.getTime()) + "|"));
            Object auditDeleteSuccess = request.getAttribute("auditDeleteSuccess");
            if (this.deleteActionFail(auditDeleteSuccess)) {
                request.setAttribute("auditSuccess", (Object)false);
            } else {
                request.setAttribute("auditSuccess", (Object)true);
            }
            String redirectUrl = request.getRequestURL() + "?" + request.getQueryString();
            request.setAttribute("redirectUrl", (Object)redirectUrl);
            return mapping.findForward("showResult");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return mapping.findForward("showSearchForm");
        }
    }

    private boolean deleteActionFail(Object auditDeleteSuccess) {
        return auditDeleteSuccess != null && (Boolean)auditDeleteSuccess == false;
    }

    private int checkProcessRights(String userName, WorkflowProcess proc) throws SQLException {
        if (proc != null) {
            return Authorization.checkRight((String)RightTreeBuilder.builder().system().workflow().processes().delete().custom((Object)proc.getId()).build(), (String)userName, (boolean)false, (boolean)false);
        }
        return -1;
    }

    private List<MenuItem> generateMenu(String user, String viewId, AdvanceVariableForm[] form, int count, boolean activitiesSearch, String searchId, String externalSortProperty, SortDirection externalSortDirection) {
        ActivitySearchQuery query = activitiesSearch ? new ActivitySearchQuery(user, form, externalSortProperty, externalSortDirection) : new ProcessSearchQuery(user, form, externalSortProperty, externalSortDirection);
        SearchResultActionSection.SearchType type = activitiesSearch ? SearchResultActionSection.SearchType.ACTIVITY : SearchResultActionSection.SearchType.PROCESS;
        SearchResultActionSection section = new SearchResultActionSection(viewId, type, (SearchQuery)query, count);
        sectionHolder.save((Section)section, searchId);
        sectionHolder.save((Section)section);
        return webFragmentsManager.getMenu("system.search.result.menu").applyConditions((Section)section).getItems();
    }

    private int doExcelExport(AdvanceVariableForm[] searchVariable, String userName, int iSortOrderType, String sSortColumnName, boolean checkRights, HttpServletRequest request, HttpServletResponse response, boolean isElasticFeatureEnabled, ElasticResultConverterParameters.ElasticResultConverterParametersBuilder elasticResultConverterParametersBuilder, ElasticSearchModel elasticSearchModel) throws Exception {
        DBManagement dbm = null;
        ArrayList results = null;
        SXSSFWorkbook wb = null;
        SXSSFSheet sheet = null;
        SXSSFRow row = null;
        Cell cell = null;
        CellStyle headerStyle = null;
        Font bold = null;
        CellStyle dateCellStyle = null;
        CellStyle leftAlignment = null;
        int iIterations = 0;
        Integer packSize = SystemProperties.getLong((DefinedSystemParameter)DefinedSystemParameter.PACK_SIZE_IN_ADVANCE_SEARCH_EXPORT).intValue();
        int offset = 0;
        int rowNum = 0;
        int colNum = 0;
        boolean checkTextAsNumber = false;
        int noOfColumns = 0;
        int resultsCount = 0;
        ServletOutputStream os = null;
        try {
            dbm = new DBManagement();
            wb = new SXSSFWorkbook(200);
            wb.setCompressTempFiles(true);
            sheet = wb.createSheet("-");
            sheet.trackAllColumnsForAutoSizing();
            headerStyle = wb.createCellStyle();
            headerStyle.setFillPattern(FillPatternType.FINE_DOTS);
            headerStyle.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.BLUE_GREY.getIndex());
            bold = wb.createFont();
            bold.setBold(true);
            bold.setColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
            headerStyle.setFont(bold);
            long count = 0L;
            Vector vCountQuery = new Vector();
            ElasticAdvanceProcessSearchResults elasticAdvanceProcessSearchResults = null;
            List<Object> searchAfterSorters = Collections.emptyList();
            if (isElasticFeatureEnabled) {
                try {
                    elasticAdvanceProcessSearchResults = elasticAdvanceProcessSearchService.search(elasticSearchModel, searchAfterSorters, packSize.intValue());
                    searchAfterSorters = this.resolveSearchAfterSorters(elasticAdvanceProcessSearchResults);
                    elasticResultConverterParametersBuilder.elasticAdvanceProcessSearchResults(elasticAdvanceProcessSearchResults);
                    results = (ArrayList)elasticResultToAdvanceSearchResultConverter.convert(elasticResultConverterParametersBuilder.build());
                    count = elasticAdvanceProcessSearchResults.getCount();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    results = null;
                    count = 0L;
                }
            } else {
                results = dbm.AdavanceProcessSearch(searchVariable, userName, packSize.intValue(), offset, iSortOrderType, sSortColumnName, vCountQuery, checkRights, true, request, false, false, null);
            }
            row = sheet.createRow(rowNum++);
            cell = row.createCell(colNum++);
            cell.setCellValue((RichTextString)new XSSFRichTextString("Lp."));
            cell.setCellStyle(headerStyle);
            for (Object var : ((AdvanceSearchResult)results.get(0)).getAlVariables()) {
                cell = row.createCell(colNum++);
                cell.setCellValue((RichTextString)new XSSFRichTextString(var.getViewname()));
                cell.setCellStyle(headerStyle);
            }
            noOfColumns = row.getLastCellNum();
            if (results != null) {
                CreationHelper createHelper = wb.getCreationHelper();
                dateCellStyle = wb.createCellStyle();
                dateCellStyle.setDataFormat(createHelper.createDataFormat().getFormat("yyyy-MM-dd hh-mm-ss"));
                checkTextAsNumber = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.CHECK_TEXT_AS_NUMBER_IN_ADVANCE_SEARCH_EXPORT);
                leftAlignment = wb.createCellStyle();
                leftAlignment.setAlignment(HorizontalAlignment.LEFT);
                while (results != null && results.size() > 0 || (long)resultsCount < count) {
                    resultsCount += results.size();
                    log.info("Iteracja: " + ++iIterations + " - wyniki od lp: " + (1 + offset) + " do lp: " + (offset + results.size()));
                    for (AdvanceSearchResult result : results) {
                        row = sheet.createRow(rowNum++);
                        colNum = 0;
                        cell = row.createCell(colNum++);
                        cell.setCellValue((double)(rowNum - 1));
                        for (AdvanceSearchResult.AdvanceVariable var : result.getAlVariables()) {
                            cell = row.createCell(colNum++);
                            this.writeCell(dateCellStyle, checkTextAsNumber, leftAlignment, var.getDisplayValue(), var.getType(), cell);
                        }
                    }
                    offset = iIterations * packSize;
                    if (isElasticFeatureEnabled) {
                        try {
                            elasticAdvanceProcessSearchResults = elasticAdvanceProcessSearchService.search(elasticSearchModel, searchAfterSorters, packSize.intValue());
                            searchAfterSorters = this.resolveSearchAfterSorters(elasticAdvanceProcessSearchResults);
                            elasticResultConverterParametersBuilder.elasticAdvanceProcessSearchResults(elasticAdvanceProcessSearchResults);
                            results = (ArrayList)elasticResultToAdvanceSearchResultConverter.convert(elasticResultConverterParametersBuilder.build());
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                            results = null;
                            count = 0L;
                        }
                        continue;
                    }
                    results = dbm.AdavanceProcessSearch(searchVariable, userName, packSize.intValue(), offset, iSortOrderType, sSortColumnName, vCountQuery, checkRights, true, request, false, false, null);
                }
            }
            for (int i = 0; i <= noOfColumns; ++i) {
                sheet.autoSizeColumn(i);
            }
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.addHeader("Content-Disposition", "attachment; filename=\"eksport.xlsx\"");
            response.addHeader("6578706f7274", "true");
            os = response.getOutputStream();
            wb.write((OutputStream)os);
            os.flush();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (wb != null) {
                    wb.close();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return resultsCount;
    }

    private void writeCell(CellStyle dateCellStyle, boolean checkTextAsNumber, CellStyle leftAlignment, String value, String type, Cell cell) {
        if (type.equalsIgnoreCase("float") || type.equalsIgnoreCase("integer")) {
            try {
                value = value.replace(",", ".").replace(" ", "");
                Number num = (Number)this.getNumberClassObject(value);
                cell.setCellValue(num.doubleValue());
            }
            catch (Exception e) {
                cell.setCellValue((RichTextString)new XSSFRichTextString(this.escapeExcelColumnValue(value)));
            }
        } else if (type.equalsIgnoreCase("date") && StringUtils.isNotBlank((String)value)) {
            try {
                cell.setCellValue(new SimpleDateFormat("yyyy-MM-dd hh-mm-ss").parse(value));
                cell.setCellStyle(dateCellStyle);
            }
            catch (Exception e) {
                cell.setCellValue((RichTextString)new XSSFRichTextString(this.escapeExcelColumnValue(value)));
            }
        } else {
            if (checkTextAsNumber) {
                String replacedValue = value.replace(",", ".").replace(" ", "");
                if (NumberUtils.isNumber((String)replacedValue) && replacedValue.matches("^-?[0-9.]+") && value.length() <= 16) {
                    Number num = (Number)this.getNumberClassObject(replacedValue);
                    cell.setCellValue(num.doubleValue());
                } else {
                    cell.setCellValue((RichTextString)new XSSFRichTextString(this.escapeExcelColumnValue(value)));
                }
            } else {
                cell.setCellValue((RichTextString)new XSSFRichTextString(this.escapeExcelColumnValue(value)));
            }
            cell.setCellStyle(leftAlignment);
        }
    }

    private String escapeExcelColumnValue(Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        String returnString = ObjectUtils.toString((Object)rawValue);
        returnString = StringEscapeUtils.escapeJava((String)StringUtils.trimToEmpty((String)returnString));
        returnString = StringUtils.replace((String)StringUtils.trim((String)returnString), (String)"\\t", (String)"    ");
        returnString = StringUtils.replace((String)StringUtils.trim((String)returnString), (String)"\\r", (String)" ");
        returnString = StringEscapeUtils.unescapeJava((String)returnString);
        return returnString;
    }

    private Object getNumberClassObject(String sTest) {
        try {
            Integer.parseInt(sTest);
            return new Integer(sTest);
        }
        catch (NumberFormatException nfe1) {
            try {
                Long.parseLong(sTest);
                return new Long(sTest);
            }
            catch (NumberFormatException nfe2) {
                try {
                    Double.parseDouble(sTest);
                    return new Double(sTest);
                }
                catch (NumberFormatException nfe3) {
                    try {
                        Float.parseFloat(sTest);
                        return new Float(sTest);
                    }
                    catch (NumberFormatException nfe4) {
                        return sTest;
                    }
                }
            }
        }
    }

    private void doCsvExport(AdvanceVariableForm[] searchVariable, String userName, int iSortOrderType, String sSortColumnName, boolean checkRights, HttpServletRequest request, HttpServletResponse response, boolean isElasticFeatureEnabled, ElasticSearchModel elasticSearchModel, ElasticResultConverterParameters.ElasticResultConverterParametersBuilder elasticResultConverterParametersBuilder) throws Exception {
        DBManagement dbm = null;
        ArrayList results = null;
        int iSize = 0;
        int iIterations = 0;
        int offset = 0;
        int iPackSize = SystemProperties.getLong((DefinedSystemParameter)DefinedSystemParameter.PACK_SIZE_IN_ADVANCE_SEARCH_EXPORT).intValue();
        int rowNum = 0;
        StringBuffer stringBuffer = new StringBuffer();
        ServletOutputStream os = null;
        String coma = ",";
        String enter = System.getProperty("line.separator");
        ArrayList<String> line = new ArrayList<String>();
        try {
            dbm = new DBManagement();
            Vector vCountQuery = new Vector();
            long count = 0L;
            ElasticAdvanceProcessSearchResults elasticAdvanceProcessSearchResults = null;
            List<Object> searchAfterSorters = Collections.emptyList();
            if (isElasticFeatureEnabled) {
                try {
                    elasticAdvanceProcessSearchResults = elasticAdvanceProcessSearchService.search(elasticSearchModel, searchAfterSorters, iPackSize);
                    searchAfterSorters = this.resolveSearchAfterSorters(elasticAdvanceProcessSearchResults);
                    elasticResultConverterParametersBuilder.elasticAdvanceProcessSearchResults(elasticAdvanceProcessSearchResults);
                    results = (ArrayList)elasticResultToAdvanceSearchResultConverter.convert(elasticResultConverterParametersBuilder.build());
                    count = elasticAdvanceProcessSearchResults.getCount();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    results = null;
                    count = 0L;
                }
            } else {
                results = dbm.AdavanceProcessSearch(searchVariable, userName, iPackSize, offset, iSortOrderType, sSortColumnName, vCountQuery, checkRights, true, request, false, false, null);
            }
            iSize = results.size();
            log.info("Ilosc wynikow: " + iSize);
            if (results != null) {
                line.add(this.escapeCsvColumnValue("Lp."));
                for (AdvanceSearchResult.AdvanceVariable var : ((AdvanceSearchResult)results.get(0)).getAlVariables()) {
                    line.add(this.escapeCsvColumnValue(var.getViewname()));
                }
                stringBuffer.append(StringUtils.join((Object[])line.toArray(new String[0]), (String)coma));
                long resultsCount = 0L;
                while (results != null && results.size() > 0 || resultsCount < count) {
                    resultsCount += (long)results.size();
                    log.info("Iteracja: " + ++iIterations + " - wyniki od lp: " + (1 + offset) + " do lp: " + (offset + results.size()));
                    for (AdvanceSearchResult result : results) {
                        stringBuffer.append(enter);
                        line = new ArrayList();
                        line.add(this.escapeCsvColumnValue(String.valueOf(++rowNum)));
                        for (AdvanceSearchResult.AdvanceVariable var : result.getAlVariables()) {
                            line.add(this.escapeCsvColumnValue(var.getDisplayValue()));
                        }
                        stringBuffer.append(StringUtils.join((Object[])line.toArray(new String[0]), (String)coma));
                    }
                    offset = iIterations * iPackSize;
                    if (isElasticFeatureEnabled) {
                        try {
                            elasticAdvanceProcessSearchResults = elasticAdvanceProcessSearchService.search(elasticSearchModel, searchAfterSorters, iPackSize);
                            searchAfterSorters = this.resolveSearchAfterSorters(elasticAdvanceProcessSearchResults);
                            elasticResultConverterParametersBuilder.elasticAdvanceProcessSearchResults(elasticAdvanceProcessSearchResults);
                            results = (ArrayList)elasticResultToAdvanceSearchResultConverter.convert(elasticResultConverterParametersBuilder.build());
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                            results = null;
                            count = 0L;
                        }
                        continue;
                    }
                    results = dbm.AdavanceProcessSearch(searchVariable, userName, iPackSize, offset, iSortOrderType, sSortColumnName, vCountQuery, checkRights, true, request, false, false, null);
                }
            }
            response.setContentType("text/csv; charset=UTF-8");
            response.addHeader("Content-Disposition", "attachment; filename=\"eksport.csv\"");
            response.addHeader("6578706f7274", "true");
            os = response.getOutputStream();
            os.write(239);
            os.write(187);
            os.write(191);
            IOUtils.write((byte[])stringBuffer.toString().getBytes("UTF-8"), (OutputStream)os);
            os.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private String escapeCsvColumnValue(String value) {
        if (value == null) {
            return "''";
        }
        value = value.replaceAll("\r", "");
        value = value.replaceAll("\n", " ");
        value = StringUtils.trim((String)value);
        if (!StringUtils.containsNone((String)value, (char[])new char[]{'\n', ','})) {
            return "'" + StringUtils.replace((String)value, (String)"\"", (String)"\\\"") + "'";
        }
        return "'" + value + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProcesType> filterUnauthorizedProcesses(List<ProcesType> processes, String username, Map<String, Right> userRights, List<Map<String, Right>> groupRights, List<String> userGroups) throws SQLException {
        Connection connection = null;
        try {
            connection = DBUtils.connectToDB();
            ArrayList<ProcesType> authorized = new ArrayList<ProcesType>();
            for (ProcesType process : processes) {
                String level = RightTreeBuilder.builder().system().workflow().processes().view().custom((Object)process.getSProcTypeId()).build();
                if (Authorization.checkRight((String)level, userRights, groupRights) != 0) continue;
                authorized.add(process);
            }
            ArrayList<ProcesType> arrayList = authorized;
            return arrayList;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    private List<FieldValue> resolveSearchAfterSorters(ElasticAdvanceProcessSearchResults elasticAdvanceProcessSearchResults) {
        if (CollectionUtils.isEmpty((Collection)elasticAdvanceProcessSearchResults.getProcessDetails()) && CollectionUtils.isEmpty((Collection)elasticAdvanceProcessSearchResults.getActivityDetails())) {
            return Collections.emptyList();
        }
        return elasticAdvanceProcessSearchResults.isActivitySearch() ? ((ActivityModel)Iterables.getLast((Iterable)elasticAdvanceProcessSearchResults.getActivityDetails())).getSearchAfterSorters() : ((ProcessModel)Iterables.getLast((Iterable)elasticAdvanceProcessSearchResults.getProcessDetails())).getSearchAfterSorters();
    }
}

