/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.util.XpdlPackageUtils;
import com.suncode.pwfl.administration.configuration.SystemParameterFinder;
import com.suncode.pwfl.util.LzStringUtils;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.dto.administration.SystemParameterDto;
import com.suncode.pwfl.workflow.form.FormBuilderService;
import com.suncode.pwfl.xpdl.PackageCacheService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.enhydra.shark.Shark;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class ActivityFormPreviewAction
extends Action {
    public static Logger log = Logger.getLogger(ActivityFormPreviewAction.class);
    private static ObjectMapper mapper = new ObjectMapper();

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.info((Object)"******************************ActivityFormPreviewAction********************");
        HttpSession session = request.getSession(false);
        String userName = (String)session.getAttribute("username");
        String originalUserName = (String)session.getAttribute("originalusername");
        if (userName == null) {
            session.setAttribute("domain", (Object)request.getParameter("domain"));
        }
        String packageId = request.getParameter("packageId");
        String processDefId = request.getParameter("processDefId");
        String activityDefId = request.getParameter("activityDefId");
        String activityName = request.getParameter("activityName");
        String xpdl = request.getParameter("xpdl");
        String formTemplate = request.getParameter("formTemplate");
        String devMode = request.getParameter("devMode");
        String contextJson = request.getParameter("contextMap");
        String compressed = request.getParameter("compressed");
        String showButtonsParam = request.getParameter("showButtons");
        String numberfieldEmptyValue = request.getParameter("numberfieldEmptyValue");
        if (Boolean.valueOf(compressed).booleanValue()) {
            xpdl = LzStringUtils.decompressFromBase64((String)xpdl);
            formTemplate = LzStringUtils.decompressFromBase64((String)formTemplate);
        }
        Package pack = XpdlPackageUtils.parseXpdlToPackage((String)xpdl);
        WorkflowProcess process = pack.getWorkflowProcess(processDefId);
        UUID uuid = this.cacheXpdl(pack);
        boolean showButtons = this.parseShowButton(showButtonsParam, true);
        String realName = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserRealName(userName);
        FormBuilderService formBuilderService = (FormBuilderService)SpringContext.getBean(FormBuilderService.class);
        request.setAttribute("realusername", (Object)realName);
        request.setAttribute("taskusername", (Object)userName);
        request.setAttribute("originaltaskusername", (Object)originalUserName);
        request.setAttribute("packageId", (Object)packageId);
        request.setAttribute("processDefId", (Object)processDefId);
        request.setAttribute("activityDefId", (Object)activityDefId);
        Map<String, String> context = this.parseContext(contextJson);
        request.setAttribute("processId", (Object)context.get("ProccessId"));
        request.setAttribute("activityId", (Object)context.get("ActivityId"));
        request.setAttribute("activityName", (Object)activityName);
        request.setAttribute("processName", (Object)process.getName());
        request.setAttribute("suncodeForm", (Object)formBuilderService.buildPreview(processDefId, activityDefId, contextJson, xpdl, formTemplate, userName, showButtons, numberfieldEmptyValue));
        request.setAttribute("devMode", (Object)Boolean.valueOf(devMode));
        request.setAttribute("uuid", (Object)uuid.toString());
        request.setAttribute("systemParameters", (Object)this.getSystemParametersJson());
        return mapping.findForward("showActivityFormPreview");
    }

    private PackageCacheService getCacheService() {
        return (PackageCacheService)SpringContext.getBean(PackageCacheService.class);
    }

    private UUID cacheXpdl(Package pack) {
        UUID randomUuid = UUID.randomUUID();
        this.getCacheService().cache(randomUuid, pack);
        return randomUuid;
    }

    private boolean parseShowButton(String showButtonsParam, boolean defaultValue) {
        return StringUtils.isNotBlank((CharSequence)showButtonsParam) ? Boolean.valueOf(showButtonsParam) : defaultValue;
    }

    private String getSystemParametersJson() {
        List parameters = ((SystemParameterFinder)SpringContext.getBean(SystemParameterFinder.class)).getPublicSystemParameters(new String[0]);
        List parametersDto = parameters.stream().map(param -> SystemParameterDto.create(param)).sorted().collect(Collectors.toList());
        return StringEscapeUtils.escapeJavaScript((String)mapper.writeValueAsString(parametersDto));
    }

    private Map<String, String> parseContext(String context) {
        if (StringUtils.isNotBlank((CharSequence)context)) {
            try {
                return (Map)mapper.readValue(context, (TypeReference)new TypeReference<Map<String, String>>(){});
            }
            catch (Exception e) {
                log.warn((Object)"Could not parse context for activity preview.");
            }
        }
        return new HashMap<String, String>();
    }
}

