/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.notifications;

import com.google.gson.Gson;
import com.plusmpm.database.notifications.NotificationConfiguration;
import com.plusmpm.database.notifications.NotificationConfigurationDAO;
import com.plusmpm.util.json.extjs.gson.GsonFactory;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class NotificationConfigurationGridServlet
extends HttpServlet {
    private static final long serialVersionUID = -517564114010892629L;
    private static Logger log = Logger.getLogger(NotificationConfigurationGridServlet.class);

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String xaction = req.getParameter("xaction");
            if (xaction.equals("read")) {
                List configurations;
                String processDefId = req.getParameter("processId");
                String type = req.getParameter("type");
                log.info((Object)("Pobieranie konfiguracji dla procesu: " + processDefId));
                if (type != null && type.equals("empty")) {
                    configurations = NotificationConfigurationDAO.createEmptyConfiguration((String)processDefId);
                } else {
                    configurations = NotificationConfigurationDAO.get((String)processDefId);
                    if (!configurations.isEmpty()) {
                        configurations.addAll(NotificationConfigurationDAO.addMissingNotificationLocales((List)configurations, (String)processDefId));
                    }
                }
                HashMap<String, List> result = new HashMap<String, List>();
                result.put("records", configurations);
                String gsoned = GsonFactory.getGson().toJson(result);
                log.info((Object)gsoned);
                resp.getWriter().write(gsoned);
            }
            if (xaction.equals("update")) {
                AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_USER_NOTIFICATIONS);
                HashMap<String, String> params = new HashMap<String, String>();
                String gsoned = req.getParameter("records");
                log.info((Object)"Zapisywanie konfiguracji");
                log.info((Object)gsoned);
                Gson gson = GsonFactory.getGson();
                NotificationConfiguration configuration = (NotificationConfiguration)gson.fromJson(gsoned, NotificationConfiguration.class);
                NotificationConfiguration oldNotification = NotificationConfigurationDAO.get((String)configuration.getProcessDefId()).stream().filter(notificationConfiguration -> notificationConfiguration.getLang().equals(configuration.getLang())).findFirst().orElseThrow(() -> new IllegalArgumentException("No notification found for given processDefId"));
                params.put("processDefId", configuration.getProcessDefId());
                params.put("lang", configuration.getLang());
                params.put("processEnd", this.ensureAuditParamNotNull(oldNotification.getProcessEnd()) + " > " + configuration.getProcessEnd());
                params.put("activityEnd", this.ensureAuditParamNotNull(oldNotification.getActivityEnd()) + " > " + configuration.getActivityEnd());
                params.put("activityDeliver", this.ensureAuditParamNotNull(oldNotification.getActivityDeliver()) + " > " + configuration.getActivityDeliver());
                builder.params(params);
                NotificationConfigurationDAO.save((NotificationConfiguration)configuration);
                log.info((Object)"Zapisano");
                log.info((Object)"Budowanie odpowiedzi");
                HashMap<String, Boolean> result = new HashMap<String, Boolean>();
                result.put("success", true);
                String serializedResponse = gson.toJson(result);
                log.info((Object)serializedResponse);
                req.setAttribute("audit", (Object)builder.buildSuccess());
                resp.getWriter().write(serializedResponse);
            }
            if (xaction.equals("destroy")) {
                long recordId = Long.valueOf(req.getParameter("records"));
                log.info((Object)"Usuwanie konfiguracji");
                log.info((Object)recordId);
                NotificationConfigurationDAO.delete((Long)recordId);
                log.info((Object)"Zapisano");
                log.info((Object)"Budowanie odpowiedzi");
                HashMap<String, Boolean> result = new HashMap<String, Boolean>();
                result.put("success", true);
                String serializedResponse = GsonFactory.getGson().toJson(result);
                log.info((Object)serializedResponse);
                req.setAttribute("auditSuccess", (Object)true);
                resp.getWriter().write(serializedResponse);
            }
            if (xaction.equals("globalConfig")) {
                log.info((Object)"Zmiana ustawie\u0144");
                String value = req.getParameter("value");
                List configurations = NotificationConfigurationDAO.get((String)"default_configuration");
                if (!configurations.isEmpty()) {
                    configurations.addAll(NotificationConfigurationDAO.addMissingNotificationLocales((List)configurations, (String)"default_configuration"));
                }
                if (value.equals("enable")) {
                    for (NotificationConfiguration notificationConfiguration2 : configurations) {
                        notificationConfiguration2.setEnabled(Boolean.valueOf(true));
                        NotificationConfigurationDAO.save((NotificationConfiguration)notificationConfiguration2);
                    }
                    req.setAttribute("auditSuccess", (Object)true);
                }
                if (value.equals("disable")) {
                    for (NotificationConfiguration notificationConfiguration2 : configurations) {
                        notificationConfiguration2.setEnabled(Boolean.valueOf(false));
                        NotificationConfigurationDAO.save((NotificationConfiguration)notificationConfiguration2);
                    }
                    req.setAttribute("auditSuccess", (Object)true);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            log.info((Object)"Budowanie odpowiedzi");
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            result.put("success", false);
            String serializedResponse = GsonFactory.getGson().toJson(result);
            log.info((Object)serializedResponse);
            resp.setStatus(500);
        }
    }

    private String ensureAuditParamNotNull(Object auditParam) {
        return auditParam != null ? auditParam.toString() : "";
    }
}

