Ext.namespace( 'Ext.ux.plusmpm' );

/**
 * Wymagane parametry: renderTo - wskazuje do jakiego elementu ma zostać
 * wyrenderowany menadżer
 */
Ext.ux.plusmpm.PackageManager = function( config ) {

    var treePanel = new Ext.ux.plusmpm.PackageManagerTreePanel( {
        region: 'west',
        split: true,
        collapsible: true,
        ref: 'treePanel'
    } );

    this.rootFormsPanel = new Ext.ux.plusmpm.PackageManagerRootFormsPanel( {
        hidden: false,
        border: false
    } );

    this.packageFormPanel = new Ext.ux.plusmpm.PackageManagerPackagePanel( {
        hidden: true,
        border: false
    } );
    this.packageVersionPanel = new Ext.ux.plusmpm.PackageManagerPackageVersionPanel( {
        hidden: true,
        border: false
    } );

    var centerPanel = new Ext.Panel( {
        ref: 'centerPanel',
        region: 'center',
        frame: false,
        border: true,
        items: [ this.rootFormsPanel, this.packageFormPanel, this.packageVersionPanel ]
    } );

    config = Ext.apply( {
        id: 'package_manager',
        layout: 'border',
        height: 600,
        frame: false,
        border: false,
        style: "text-align: left;",
        items: [ treePanel, centerPanel ]
    }, config );

    Ext.ux.plusmpm.PackageManager.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.PackageManager constructor

Ext.extend( Ext.ux.plusmpm.PackageManager, Ext.Panel, {
    successText: PW.t('successText'),
    errorText: PW.t('errorText'),
    clearUnusedPackagesText: PW.t('clearUnusedPackagesText'),
    packageClosedSuccessText: PW.t('packageClosedSuccessText'),
    packageUpdateSuccessText: PW.t('packageUpdateSuccessText'),
    checkText: PW.t('checkText'),
    differencesUpdateText: PW.t('differencesUpdateText'),
    noDifferencesText: PW.t('noDifferencesText'),
    differencesText: PW.t('differencesText'),
    differencesLabelText: PW.t('differencesLabelText'),
    firstVerText: PW.t('firstVerText'),
    secondVerText: PW.t('secondVerText'),
    selectText: PW.t('selectText'),
    checkDiffLabelText: PW.t('checkDiffLabelText'),
    warningText: PW.t('warningText'),
    downloadChangesText: PW.t('Pobierz_zmiany'),

    onAfterRenderEventHandler: function() {
        this.treePanel.getSelectionModel().on( "selectionchange", this.onNodeSelectionChangeEventHandler, this );
    },

    onNodeSelectionChangeEventHandler: function( selectionModel, node ) {
        this.centerPanel.items.each( function( index ) {
            this.hide();
        } );

        if ( !node || node.id == "root" ) // rootNode
        {
            this.rootFormsPanel.show();
        }
        else
            if ( node.attributes.type == "PACKAGE" ) {
                this.packageFormPanel.currentNode = node;
                this.packageFormPanel.show();
            }
            else
                if ( node.attributes.type == "PACKAGE_VERSION" ) {
                    var packageVersions = new Array();

                    node.parentNode.childNodes.each( function( item ) {
                        if ( item.attributes.version != node.attributes.version ) {
                            packageVersions.push( {
                                version: item.attributes.version
                            } );
                        }
                    } );

                    this.packageVersionPanel.currentNode = node;
                    this.packageVersionPanel.packageVersions = packageVersions;

                    this.packageVersionPanel.show();
                    this.packageVersionPanel.loadProcessData();
                }

    },

    refreshTreePanel: function() {
        this.treePanel.refresh();
    },

    closePackageVersion: function( packageId, packageVersion ) {

        var params = {
            actionType: 'closePackage',
            packageId: packageId,
            packageVersion: packageVersion
        };

        this.performPackageAction( params, this.packageClosedCompleteHandler );
    },

    updatePackage: function( packageId ) {
        var params = {
            actionType: 'updatePackage',
            packageId: packageId,
            updateFilledTables: true
        };

        this.performPackageAction( params, this.packageUpdateCompleteHandler );
    },

    refreshPackageCache: function() {
        var params = {
            actionType: 'updatePackageCache'
        };
        this.performPackageAction( params, this.standardRequestCompletedHandler );
    },

    packageDifferences: function( packageId ) {
		var params = {
            actionType: 'packageVersions',
            packageId: packageId
        };
		this.performPackageAction( params, this.onShowPackageDifferences );

    },

    clearUnusedPackages: function( packageId ) {
        var params = {
            actionType: 'clearPackage',
            packageId: packageId
        };
        this.performPackageAction( params, function( response ) {
            var resp = Ext.util.JSON.decode( response.responseText );

            var msg = this.clearUnusedPackagesText + resp.count;
            PW.ui.MessageBox.show( {
                title: this.successText,
                msg: msg,
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.INFO
            } );

            this.refreshTreePanel();
        } );
    },

    packageClosedCompleteHandler: function( response ) {
        var resp = Ext.util.JSON.decode( response.responseText );
        if ( resp.success ) {
            PW.ui.MessageBox.show( {
                title: this.successText,
                msg: this.packageClosedSuccessText,
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.INFO
            } );
            this.refreshTreePanel();
        }
        else {
            PW.ui.MessageBox.show( {
                title: this.errorText,
                msg: resp.msg,
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            } );
        }
    },

    packageUpdateCompleteHandler: function( response ) {
        var resp = Ext.util.JSON.decode( response.responseText );
        if ( resp.success ) {
        	var panelInfo = new Ext.Panel({
        		border: false,
				frame: false,
				layout: 'form',
		        autoEl: {
					children: [
						{tag: 'center', html: this.packageUpdateSuccessText, style: 'margin: 10px; margin-bottom: 20px'},
				        {tag: 'center', style: 'margin-top: 5px', cn:[{tag: 'a', href: '#', html: this.checkText + " "}, {tag: 'span', html: this.differencesUpdateText}]}
				    ]
				},
				listeners:{
					scope: this,
					afterrender: function(comp){
						if (resp.isempty) {
							comp.el.select('a').on('click', function(e,t,o) {
																PW.ui.MessageBox.show( {
													                title: o.successText,
													                msg: o.noDifferencesText,
													                buttons: Ext.Msg.OK,
													                icon: Ext.MessageBox.INFO
													            } )
															}, null, {successText : this.successText, noDifferencesText : this.noDifferencesText});
						}
						else {
							comp.el.select('a').on('click', this.onShowDifferencesWindow, this, {
                                diff : resp.errors,
                                packageId: resp.packageId,
                                basePackageVersion: resp.basePackageVersion,
                                newPackageVersion: resp.newPackageVersion,
                            }  );
						}
					}
				}
        	});

        	var panel = new Ext.Panel({
        		frame: false,
        		border: false,
        		layout: 'form',
        		items: [panelInfo],
        		buttonAlign: 'center',
        		buttons:
        		[{
        			text: Ext.MessageBox.buttonText.ok,
		            handler: function(){
		 				win.close();
		            }
        		}]
        	});

        	var win = new Ext.Window({
        		title: this.successText,
        		layout: 'fit',
        		modal: true,
        		border: false,
        		frame: false,
        		resizable: false,
        		height: 260,
        		width: 300,
        		items: panel
        	});

        	win.show();
            this.refreshTreePanel();
        }
        else {
            PW.ui.MessageBox.show( {
                title: this.errorText,
                msg: resp.msg,
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            } );
        }
    },

    onShowDifferencesWindow: function(p,t,o){
    	var errorsTpl = new Ext.XTemplate( '<tpl for=".">{.}</tpl>' ).apply( o.diff );
        var panel = new Ext.Panel({
	        	layout:'vbox',
	            height: 300,
	            layoutConfig: {
					align : 'stretch',
					pack  : 'start'
				},
				frame: false,
				items: [
					new Ext.Panel({
						padding:5,
						html: this.differencesText,
						bodyStyle: 'font-size: larger',
						height: 40,
						frame: false
					}),
				    new Ext.Panel({
						padding:'0 0 0 10',
						html: errorsTpl,
						flex: 1,
						autoScroll: true,
						frame: false
					})
				]
			})

		var win = new Ext.Window({
			title: this.differencesLabelText,
			layout: 'fit',
			width: 600,
    		cls: 'package-error-message',
			items: panel,
            buttonAlign: 'left',
            buttons: [
                {
                    text: this.downloadChangesText,
                    handler: function () {
                        const packageId = o.packageId
                        const basePackageVersion = o.basePackageVersion
                        const newPackageVersion = o.newPackageVersion

                        window.location.href = Suncode.getAbsolutePath(`api/xpdlDifference?packageId=${packageId}&basePackageVersion=${basePackageVersion}&newPackageVersion=${newPackageVersion}`)
                    }
                },
                '->',
				{
			    	text: Ext.MessageBox.buttonText.ok,
			        handler: function(){
                        win.close()
			                 }
				}],
			scope: this
		});

        win.show();
    },

    standardRequestCompletedHandler: function( response ) {
        var resp = Ext.util.JSON.decode( response.responseText );
        if ( resp.success ) {
            this.refreshTreePanel();
        }
        else {
            PW.ui.MessageBox.show( {
                title: this.errorText,
                msg: resp.msg,
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            } );
        }
    },

    onShowPackageDifferences : function ( response ) {
    	var resp = Ext.util.JSON.decode( response.responseText );
	    var store = new Ext.data.ArrayStore({
		    fields: [{
		    	name: 'version',
                type: 'int'
            }],
            data: resp.versions
		});
		var combo = new Ext.form.ComboBox({
		    store: store,
		    width: 75,
		    listWidth: 75,
		    fieldLabel: this.firstVerText,
		    valueField: 'version',
		    displayField:'version',
		    typeAhead: true,
		    mode: 'local',
		    triggerAction: 'all',
		    selectOnFocus:true
		});

		var combo2 = new Ext.form.ComboBox({
		    store: store,
		    width: 75,
		    listWidth: 75,
		    fieldLabel: this.secondVerText,
		    displayField:'version',
		    typeAhead: true,
		    mode: 'local',
		    triggerAction: 'all',
		    selectOnFocus:true
		});

		combo.setValue(resp.versions[0]);
		combo2.setValue(resp.versions[0]);

		var panelCombo = new Ext.Panel({
			border: false,
			frame: false,
			layout: 'form',
			bodyStyle: 'padding: 0 0 0 65px',
			items: [combo, combo2]
		});

		var panelText = new Ext.Panel({
			border: false,
			frame: false,
			bodyStyle: 'padding: 5px 0 20px 0',
			layout: 'form',
			html: '<center>' + this.selectText + '</center>'
		});

		var panel = new Ext.Panel({
			frame: false,
            border: false,
			buttonAlign: 'center',
			layout: 'form',
			items: [panelText, panelCombo],
			buttons:
        		[{
        			text: Ext.MessageBox.buttonText.ok,
		            handler: function(){
		 				var params = {
				            actionType: 'packageDifferences',
				            packageId: resp.packageid,
				            firstPackageVersion: combo.getValue(),
				            secondPackageVersion: combo2.getValue()
				        };
		 				this.performPackageAction( params, this.packageDifferencesCompleteHandler );

		            },
		            scope: this
        		},
        		{
        			text: Ext.MessageBox.buttonText.cancel,
        			handler: function() {
        				win.close();
        			}
        		}]
		});

    	var win = new Ext.Window({
	        border: false,
	        frame: false,
	        modal: true,
	        layout: 'fit',
	        title: this.checkDiffLabelText,
	        width: 300,
	        height: 350,
	        resizable: false,
	        scope: this,
    		items: panel

    	});
    	win.show();

    },

    packageDifferencesCompleteHandler : function( response ) {
    	var resp = Ext.util.JSON.decode( response.responseText );
    	if (resp.isempty) {
			PW.ui.MessageBox.show( {
                title: this.successText,
                msg: this.noDifferencesText,
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.INFO
            } )
    	}
    	else {
	    	var errorsTpl = new Ext.XTemplate( '<tpl for=".">{.}</tpl>' ).apply( resp.errors);
	        var panel = new Ext.Panel({
		        	layout:'vbox',
		            height: 300,
                    padding: 10,
		            layoutConfig: {
						align : 'stretch',
						pack  : 'start'
					},
					frame: false,
                    border: false,
					items: [
						new Ext.Panel({
							padding:5,
							html: this.differencesLabelText + ' ' + resp.firstver + ' & ' + resp.secondver,
							bodyStyle: 'font-size: larger',
							height: 40,
                            border: false,
							frame: false
						}),
					    new Ext.Panel({
							padding:'0 0 0 10',
							html: errorsTpl,
							flex: 1,
							autoScroll: true,
                            border: false,
							frame: false
						})
					]
				})

			var win = new Ext.Window({
				title: this.differencesLabelText,
				layout: 'fit',
				width: 600,
	    		cls: 'package-error-message',
				items: panel,
                buttonAlign: 'left',
                buttons: [
                    {
                        text: this.downloadChangesText,
                        handler: function () {
                            const packageId = resp.packageId
                            const basePackageVersion = resp.firstver
                            const newPackageVersion = resp.secondver

                            window.location.href = Suncode.getAbsolutePath(`api/xpdlDifference?packageId=${packageId}&basePackageVersion=${basePackageVersion}&newPackageVersion=${newPackageVersion}`)
                        }
                    },
                    '->',
					{
				    	text: Ext.MessageBox.buttonText.ok,
				        handler: function(){
                            win.close()
				                 }
					}],
				scope: this
			});

            win.show();
    	}
    },

    performPackageAction: function( params, successHandler ) {

        this.body.mask( Ext.LoadMask.prototype.msg, 'x-mask-loading' );

        Ext.Ajax.request( {
            url: 'com.plusmpm.servlet.packages.PackageManagementServlet.customServlet',
            method: 'POST',
            callback: function( options, success, response ) {
                this.body.unmask();
            },
            success: successHandler,
            params: params,
            scope: this
        } );
    },

    initComponent: function() {

        this.on( "afterrender", this.onAfterRenderEventHandler, this );
        Ext.ux.plusmpm.PackageManager.superclass.initComponent.call( this );
    }
} ); // end of Ext.extend

/**
 * Wymagane parametry:
 */
Ext.ux.plusmpm.PackageManagerTreePanel = function( config ) {

    var loader = new Ext.tree.TreeLoader( {
        dataUrl: 'com.plusmpm.servlet.packages.PackageInformationServlet.customServlet',
        requestMethod: 'GET'
    } );
    loader.on( "beforeload", function( treeLoader, node ) {
        if ( node.attributes.type )
            this.baseParams.type = node.attributes.type;
    } );

    config = Ext.apply( {
        autoScroll: true,
        animate: true,
        width: 300,
        loader: loader,

        root: new Ext.tree.AsyncTreeNode( {
            expanded: true,
            leaf: false,
            text: this.rootText,
            id: "root"
        } ),

        tools: [ {
            id: 'refresh',
            handler: this.onRefresh,
            scope: this
        } ]
    }, config );

    Ext.ux.plusmpm.PackageManagerTreePanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.PackageManagerTreePanel constructor

Ext.extend( Ext.ux.plusmpm.PackageManagerTreePanel, Ext.tree.TreePanel, {

    title: PW.t('packageViewerTitle'),
    rootText: PW.t('rootText'),

    onRefresh: function() {
        this.refresh();
    },

    saveTreeState: function() {
        var root = this.getRootNode();
        var expanded = [];

        if ( root.expanded )
            expanded.push( root.id );

        root.childNodes.each( function( item ) {
            if ( item.isExpanded() === true ) {
                expanded.push( item.id );
            }
        }, this );

        var selectedNode = this.getSelectionModel().getSelectedNode();
        var selectedId = selectedNode ? selectedNode.id : undefined;

        var state = {
            selected: selectedId,
            expanded: expanded
        };

        return state;
    },

    refresh: function() {
        var state = this.saveTreeState();

        this.root.loaded = false;
        this.getSelectionModel().select( this.root );
        this.expandNodes( this.root, state.expanded, state.selected );
    },

    expandNodes: function( startNode, nodesToExpand, nodeToSelect ) {

        if ( startNode.id == nodeToSelect ) {
            this.getSelectionModel().select( startNode );
        }

        if ( startNode.isLeaf() == true ) {
            return;
        }

        startNode.reload( function( node ) {
            if ( nodesToExpand.indexOf( startNode.id ) > -1 ) {
                node.expand( false, false );
            }
            else {
                node.collapse( true, false );
            }
        }, this );
    },

    initComponent: function() {

        Ext.ux.plusmpm.PackageManagerTreePanel.superclass.initComponent.call( this );
    }

} ); // end of Ext.extend

/**
 * Wymagane parametry:
 */
Ext.ux.plusmpm.PackageManagerRootXpdlFormPanel = function( config ) {

    config = Ext.apply( {
        fileUpload: false,
        frame: false,
        bodyCssClass: 'x-panel-mc',
        items: [ {
            xtype: 'compositefield',
            invalidClass: null,
            items: [ {
                fieldLabel: this.fileNameText,
                xtype: 'combo',
                triggerAction: 'all',
                width: 400,
                store: {
                    xtype: 'jsonstore',
                    autoDestroy: true,
                    proxy: new Ext.data.HttpProxy( {
                        method: 'GET',
                        url: 'com.plusmpm.servlet.packages.PackageManagementServlet.customServlet'
                    } ),
                    root: 'files',
                    idProperty: 'name',
                    fields: [ 'name' ]
                },

                displayField: 'name',
                valueField: 'name',
                name: 'xpdlname',
                regex: new RegExp( '^(.)*(.xpdl)$' ),
                allowBlank: false
            }, {
                xtype: 'button',
                text: this.loadPackageText,
                handler: this.submitButtonHandler,
                iconCls: 'dvnt-icon-folder-plus',
                scope: this
            } ]
        } ]
    }, config );

    Ext.ux.plusmpm.PackageManagerRootXpdlFormPanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.PackageManagerTreePanel constructor

Ext.extend( Ext.ux.plusmpm.PackageManagerRootXpdlFormPanel, Ext.form.FormPanel, {

    loadPackageText: PW.t('loadPackageText'),
    resetFieldsText: PW.t('resetFieldsText'),
    fileNameText: PW.t('fileNameText'),
    progressText: PW.t('progressText'),
    checkXpdFilenameErrorText : PW.t('checkXpdFilenameErrorText'),
    refreshConfirmationTitleText : PW.t('refreshConfirmationTitleText'),
    refreshConfirmationMessageText : PW.t('refreshConfirmationMessageText'),
    yesText : PW.t('yesText'),
    noText : PW.t('noText'),

    initComponent: function() {
        Ext.ux.plusmpm.PackageManagerRootXpdlFormPanel.superclass.initComponent.call( this );
    },
    
    uploadPackage: function() {
    	this.getForm().submit( {
            url: 'com.plusmpm.servlet.packages.PackageManagementServlet.customServlet',
            waitTitle: this.progressTitle,
            waitMsg: this.progressText,
            params: {
                actionType: 'loadPackage'
            },
            scope: this,
            timeout: 30,
            success: function( form, action ) {
                Ext.getCmp( 'package_manager' ).refreshTreePanel();
                this.getForm().reset();
            },
            failure: function( form, action ) {
                PW.ui.MessageBox.show( {
                    title: Ext.ux.plusmpm.PackageManager.prototype.errorText,
                    msg: action.result.msg,
                    buttons: Ext.Msg.OK,
                    icon: Ext.MessageBox.ERROR
                } );
                this.getForm().reset();
            }
        });
    },

    showCheckXpdlFilenameError: function() {
        PW.ui.MessageBox.show( {
            title: Ext.ux.plusmpm.PackageManager.prototype.errorText,
            msg: this.checkXpdFilenameErrorText,
            buttons: Ext.Msg.OK,
            icon: Ext.MessageBox.ERROR
        } );
        this.getForm().reset();
    },

    submitButtonHandler: function( button, eventObject ) {
    	var me = this;

        if ( this.getForm().isValid() ) {
            this.ownerCt.body.mask( Ext.LoadMask.prototype.msg, 'x-mask-loading' );

            var filename = this.getForm().getValues().xpdlname;

            Ext.Ajax.request({
                url: 'api/xpdlInfo/checkLoaded',
                method: 'GET',
                timeout: 3600000,
                params: {
                	xpdlFilename: filename
                },
                callback: function() {
                	this.ownerCt.body.unmask();
                },
                success: function( response ) {
                    var resp = Ext.decode( response.responseText );
                    if(resp.success) {
                        if ( resp.loaded ) {
                        	
                        	PW.ui.MessageBox.show( {
                                title: this.refreshConfirmationTitleText,
                                msg: this.refreshConfirmationMessageText,
                                buttons: {
                                    yes: this.yesText,
                                    no: this.noText
                                },
                                fn: function( buttonId ) {
                                    switch ( buttonId ) {
                                        case 'yes':
                                        	me.checkDatabaseIncompatibilities(resp.packageId, filename);
                                            break;
                                        default:
                                            break;
                                    }
                                },
                                icon: Ext.Msg.QUESTION
                            } );
                        	
                        }
                        else {
                        	this.uploadPackage();
                        }	
                    }
                    else {
                    	this.showCheckXpdlFilenameError();
                    }
                },
                failure: function() {
                	this.showCheckXpdlFilenameError();
                },
                scope: this
            } );
        }
    },

    checkDatabaseIncompatibilities: function(packageId, filename) {
        this.ownerCt.body.mask( Ext.LoadMask.prototype.msg, 'x-mask-loading' );

        Ext.Ajax.request({
            url: 'api/xpdlInfo/databaseChanges/filename',
            method: 'GET',
            timeout: 3600000,
            params: {
                xpdlFilename: filename
            },
            callback: function() {
                this.ownerCt.body.unmask();
            },
            success: function( response ) {
                var incompatibilities = Ext.decode( response.responseText );

                if(incompatibilities.length > 0) {
                    var window = new Ext.ux.plusmpm.PackageManagerIncompatibilitiesWindow({
                        packageId: packageId,
                        incompatibilities: incompatibilities
                    });
                    window.show();
                }
                else {
                	Ext.getCmp( 'package_manager' ).updatePackage( packageId );
                }
            },
            failure: function() {
                this.showCheckCompatibilityError();
            },
            scope: this
        } );
    },

    showCheckCompatibilityError: function() {
        PW.ui.MessageBox.show( {
            title: PW.t('error.unexpected'),
            msg: PW.t('checkCompatibilityError'),
            buttons: Ext.Msg.OK,
            icon: Ext.MessageBox.ERROR
        } );
        this.getForm().reset();
    }
} ); // end of Ext.extend

Ext.ux.plusmpm.PackageManagerIncompatibilitiesWindow = function( config ) {
    var store = new Ext.data.JsonStore({
        fields:['processDefId', 'variableId'],
        data: config.incompatibilities
    })

    config = Ext.apply( {
        id: 'incompatiblesWindow',
        title: PW.t('warningTitle'),
        width: 500,
        autoHeight: true,
        layout: 'fit',
        items: [{
            xtype: 'label',
            autoHeight: true,
            style:'display:block; padding:5px 5px 5px 5px; text-align: justify;',
            text: PW.t('incompatibleColumnTypes')
        },
        {
            xtype: 'grid',
            stripeRows: true,
            autoHeight: true,
            store: store,
            columns: [{
                header: PW.t('processId'),
                dataIndex: 'processDefId',
                name: 'processDefId'
            },
            {
                header: PW.t('variableId'),
                dataIndex: 'variableId',
                name: 'variableId'
            }],
            viewConfig: {
                forceFit: true
            }
        }],
        buttons: [{
            text: 'Zatwierdź',
            handler: function() {
                Ext.getCmp('incompatiblesWindow').close();
                Ext.getCmp( 'package_manager' ).updatePackage( config.packageId );
            }
        },
        {
            text: PW.t('cancelText'),
            handler: function() {
                Ext.getCmp('incompatiblesWindow').close();
            }
        }]
    }, config );

    Ext.ux.plusmpm.PackageManagerIncompatibilitiesWindow.superclass.constructor.call( this, config );
}

Ext.extend( Ext.ux.plusmpm.PackageManagerIncompatibilitiesWindow, Ext.Window);

/**
 * Wymagane parametry:
 */
 Ext.ux.plusmpm.PackageManagerRootZipFormPanel = function( config ) {

    config = Ext.apply( {
        fileUpload: true,

        frame: false,
        bodyCssClass: 'x-panel-mc',
        items: [ {
            xtype: 'compositefield',
            invalidClass: null,
            items: [ {
                xtype: 'fileuploadfield',
                fieldLabel: this.chooseZipFileText,
                buttonText: this.browseText,
                width: 400,
                name: 'file',
                regex: new RegExp('.zip$', 'i'),
                allowBlank: false
            }, {
                xtype: 'button',
                text: this.loadPackageText,
                handler: this.submitButtonHandler,
                iconCls: 'dvnt-icon-folder-plus',
                scope: this
            } ]
        } ]
    }, config );

    Ext.ux.plusmpm.PackageManagerRootZipFormPanel.superclass.constructor.call( this, config );

};

Ext.extend( Ext.ux.plusmpm.PackageManagerRootZipFormPanel, Ext.form.FormPanel, {

    loadPackageText: PW.t('loadPackageText'),
    chooseZipFileText: PW.t('Wybierz_plik_zip'),
    browseText: PW.t('Przegladaj'),
    pweNotExistsText: PW.t('Funkcja_importu_zip_wymaga_nowszej_wersji_PWE'),
    progressText: PW.t('progressText'),

    initComponent: function() {
        Ext.ux.plusmpm.PackageManagerRootZipFormPanel.superclass.initComponent.call( this );
    },

    submitButtonHandler: function( button, eventObject ) {
    	if ( this.getForm().isValid() ) {
            this.ownerCt.body.mask( Ext.LoadMask.prototype.msg, 'x-mask-loading' );

            Ext.Ajax.request({
                url: 'plugin/com.suncode.plugin-pwe/api/xpdl/exportZip',
                method: 'POST',
                timeout: 3600000,
                form: this.getForm().getEl(),
                isUpload: true,
                callback: function() {
                    this.ownerCt.body.unmask();
                    this.getForm().reset();
                    Ext.getCmp( 'package_manager' ).refreshTreePanel();
                },
                success: function( responseObj ) {
                    var responseRaw = responseObj.responseText;

                    var i = responseRaw.indexOf('<pre>');
                    var j = responseRaw.indexOf('</pre>');
                    if (i == 0 && j > 0) {
                        responseRaw = responseRaw.substring(i + 5, j);
                    }

                    var response;
                    try {
                        response = Ext.decode(responseRaw);
                    } catch (e) {
                        response = {};
                    }
                    
                    if (response.success === undefined) {
                        PW.ui.MessageBox.show( {
                            title: Ext.ux.plusmpm.PackageManager.prototype.errorText,
                            msg: this.pweNotExistsText,
                            buttons: Ext.Msg.OK,
                            icon: Ext.MessageBox.ERROR
                        } );
                    }
                    else if (response.success === false) {
                        PW.ui.MessageBox.show( {
                            title: Ext.ux.plusmpm.PackageManager.prototype.errorText,
                            msg: response.errorMessage,
                            buttons: Ext.Msg.OK,
                            icon: Ext.MessageBox.ERROR
                        } );
                    }
                },
                scope: this
            } );
        }
    }
    
} ); // end of Ext.extend

/**
 * Wymagane parametry:
 */
Ext.ux.plusmpm.PackageManagerRootFormsPanel = function( config ) {

    this.rootXpdlFormPanel = new Ext.ux.plusmpm.PackageManagerRootXpdlFormPanel( {
        hidden: false,
        border: false,
        bodyStyle: "padding-bottom: 5px"
    } );

    this.rootZipFormPanel = new Ext.ux.plusmpm.PackageManagerRootZipFormPanel( {
        hidden: false,
        border: false
    } );

    config = Ext.apply( {
        id: 'packageManagerRootFormsPanel',
        frame: false,
        bodyCssClass: 'x-panel-mc',
        bodyStyle: "padding: 8px",
        layout: 'auto',
        items: [ this.rootXpdlFormPanel, this.rootZipFormPanel ]
    }, config );

    Ext.ux.plusmpm.PackageManagerRootFormsPanel.superclass.constructor.call( this, config );

};

Ext.extend( Ext.ux.plusmpm.PackageManagerRootFormsPanel, Ext.Panel, {

    title: PW.t('loadingPackageTitle'),

    initComponent: function() {
        this.on( 'afterrender', this.onAfterRenderEventHandler, this );
        Ext.ux.plusmpm.PackageManagerRootFormsPanel.superclass.initComponent.call( this );
    },

    onAfterRenderEventHandler: function() {
        this.setHeight( this.ownerCt.getInnerHeight() );
    },
    
} ); // end of Ext.extend

/**
 * Wymagane parametry:
 */
Ext.ux.plusmpm.PackageManagerPackagePanel = function( config ) {

    var container = new Ext.Panel( {
        title: this.containerTitle,
        layout: 'fit',
        border: false,
        ref: 'container',
        bodyCssClass: 'x-panel-mc',
        bodyStyle: "padding: 4px",
        tbar: [ {
            text: this.refreshPackageText,
            iconCls: 'dvnt-icon-rotation-right',
            handler: this.refreshPackage,
            scope: this
        }, {
            text: this.clearUnusedText,
            iconCls: 'dvnt-icon-delete',
            handler: this.clearUnusedPackages,
            scope: this
        }, {
            text: this.refreshPackageCacheText,
            iconCls: 'dvnt-icon-rotation-right',
            handler: this.refreshPackageCache,
            tooltip: this.xpdlCacheTooltipText,
            scope: this
        }, {
            text: this.checkDifferencesText,
            iconCls: 'dvnt-icon-search',
            handler: this.packageDifferences,
            scope: this
        } ]
    } );

    config = Ext.apply( {
        layout: 'fit',
        items: [ container ]
    }, config );

    Ext.ux.plusmpm.PackageManagerPackagePanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.PackageManagerPackagePanel constructor

Ext
                .extend(
                                Ext.ux.plusmpm.PackageManagerPackagePanel,
                                Ext.Panel,
                                {

                                    containerTitle: PW.t('containerTitle'),
                                    clearUnusedText: PW.t('clearUnusedText'),
                                    refreshPackageText: PW.t('refreshPackageText'),
                                    refreshPackageCacheText: PW.t('refreshPackageCacheText'),
                                    xpdlCacheTooltipText: PW.t('xpdlCacheTooltipText'),
                                    checkDifferencesText: PW.t('checkDifferencesText'),
                                    // Aktualny liść drzewa powiązany z panelem
                                    currentNode: null,

                                    initComponent: function() {
                                        this.on( 'afterrender', this.onAfterRenderEventHandler, this );
                                        Ext.ux.plusmpm.PackageManagerPackagePanel.superclass.initComponent.call( this );
                                    },

                                    onAfterRenderEventHandler: function() {
                                        this.setHeight( this.ownerCt.getInnerHeight() );
                                    },

                                    refreshPackage: function() {
                                        var packageId = this.currentNode.attributes.packageId;
                                        this.checkDatabaseIncompatibilities(packageId);
                                    },

                                    refreshPackageCache: function() {
                                        Ext.getCmp( 'package_manager' ).refreshPackageCache();
                                    },

                                    checkDatabaseIncompatibilities: function( packageId ) {
                                        this.body.mask( Ext.LoadMask.prototype.msg, 'x-mask-loading' );
                                        Ext.Ajax.request({
                                            url: 'api/xpdlInfo/databaseChanges/id',
                                            method: 'GET',
                                            timeout: 3600000,
                                            params: {
                                                packageId: packageId
                                            },
                                            callback: function() {
                                                this.body.unmask();
                                            },
                                            success: function( response ) {
                                                var incompatibilities = Ext.decode( response.responseText );

                                                if(incompatibilities.length > 0) {
                                                    var window = new Ext.ux.plusmpm.PackageManagerIncompatibilitiesWindow({
                                                        packageId: packageId,
                                                        incompatibilities: incompatibilities
                                                    });
                                                    window.show();
                                                }
                                                else {
                                                	Ext.getCmp( 'package_manager' ).updatePackage( packageId );
                                                }
                                            },
                                            failure: function() {
                                                this.showCheckCompatibilityError();
                                            },
                                            scope: this
                                        } );
                                    },

                                    showCheckCompatibilityError: function() {
                                        PW.ui.MessageBox.show( {
                                            title: PW.t('error.unexpected'),
                                            msg: PW.t('checkCompatibilityError'),
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.MessageBox.ERROR
                                        } );
                                    },

                                    clearUnusedPackages: function() {
                                        Ext.getCmp( 'package_manager' ).clearUnusedPackages( this.currentNode.attributes.packageId );
                                    },

                                    packageDifferences: function() {
                                        Ext.getCmp( 'package_manager' ).packageDifferences( this.currentNode.attributes.packageId );
                                    }

                                } ); // end of Ext.extend

/**
 * Wymagane parametry:
 */
Ext.ux.plusmpm.PackageManagerPackageVersionPanel = function( config ) {

    this.processGrid = new Ext.ux.plusmpm.PackageManagerGridPanel();
    this.processGrid.store.on( "beforeload", this.onStoreBeforeLoad, this );
    this.processGrid.store.on( "load", this.onStoreLoad, this );

    var gridWrap = new Ext.Panel( {
        layout: 'fit',
        frame: false,
        border: false,
        items: [ this.processGrid ]
    } );

    var container = new Ext.Panel( {
        title: this.containerTitle,
        border: false,
        layout: 'fit',
        ref: 'gridContainer',
        tbar: [ {
            ref: '../btnClosePackage',
            text: this.closePackageText,
            iconCls: 'dvnt-icon-delete',
            handler: this.closePackage,
            scope: this
        }, {
            ref: '../btnClosePackageErrorMessage',
            xtype: 'tbtext',
            text: this.closePackageErrorText,
            scope: this
        } ],
        items: [ gridWrap ]
    } );

    config = Ext.apply( {
        layout: 'fit',
        border: false,
        items: [ container ]
    }, config );

    Ext.ux.plusmpm.PackageManagerPackageVersionPanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.PackageManagerPackageVersionPanel constructor

Ext.extend( Ext.ux.plusmpm.PackageManagerPackageVersionPanel, Ext.Panel, {

    containerTitle: PW.t('packageVersionManagement'),
    closePackageText: PW.t('closePackageText'),
    closePackageErrorText: PW.t('closePackageErrorText'),

    // Node aktualnie powiązany z oknem
    currentNode: null,

    initComponent: function() {
        this.on( 'afterrender', this.onAfterRenderEventHandler, this );
        Ext.ux.plusmpm.PackageManagerPackageVersionPanel.superclass.initComponent.call( this );
    },

    onAfterRenderEventHandler: function() {
        this.setHeight( this.ownerCt.getInnerHeight() );
    },

    closePackage: function() {
        var packageId = this.currentNode.attributes.packageId;
        var packageVersion = this.currentNode.attributes.version;
        Ext.getCmp( 'package_manager' ).closePackageVersion( packageId, packageVersion );
    },

    loadProcessData: function() {
        this.processGrid.currentNode = this.currentNode;
        this.processGrid.packageVersions = this.packageVersions;
        this.processGrid.loadProcessData();
    },

    onStoreBeforeLoad: function( store ) {
        this.body.mask( Ext.LoadMask.prototype.msg, 'x-mask-loading' );
    },

    onStoreLoad: function( store ) {
        this.body.unmask();
        if ( this.processGrid.store.getTotalCount() == 0 ) {
            this.gridContainer.btnClosePackage.enable();
            this.gridContainer.btnClosePackageErrorMessage.hide();
        }
        else {
            this.gridContainer.btnClosePackage.disable();
            this.gridContainer.btnClosePackageErrorMessage.show();
        }
    },

    isFiltered: function() {
    	var result = false;
    	var filters = this.processGrid.filters.filters.items;
    	filters.each( function(item) {
    		if(item.active) {
    			result = true;
    		}
    	} );
    	return result;
    }

} ); // end of Ext.extend

/**
 * Wymagane parametry:
 */
Ext.ux.plusmpm.PackageManagerGridPanel = function( config ) {

    var store = new Ext.data.JsonStore( {
        autoDestroy: true,
        storeId: 'packageProcesses',
        remoteSort: true,

        proxy: new Ext.data.HttpProxy( {
            method: 'GET',
            url: 'com.plusmpm.servlet.packages.PackageProcessesServlet.customServlet'
        } ),

        root: 'processes',
        totalProperty: 'results',
        idProperty: 'id',
        fields: [ 'id', 'name', 'created', 'description', 'started', 'state', 'lastStateTime', 'procDefId', 'key' ]
    } );

    var createButtonFnc = function( id, record ) {
        new Ext.ux.LinkButton( {
            width: 22,
            style: "margin-left: auto; margin-right: auto;",
            href: "ShowProcessHistory.do",
            target: '_blank',
            baseParams: {
            	ProcessId: record.id,
                key: record.data.key
            },
            iconCls: 'dvnt-icon-time',
            renderTo: id
        } );
    };

    var filters = new Ext.ux.grid.GridFilters({
        encode: true,
    	local: false,
        filters: [{
            type: 'string',
            dataIndex: 'id'
        },{
        	type: 'string',
            dataIndex: 'name'
        }, {
        	type: 'list',
            dataIndex: 'state',
            labelField: 'name',
            options: [
                {id: 'open.running' , name: this.stateFilter[0]},
                {id: 'open.not_running.not_started' , name: this.stateFilter[1]},
                {id: 'open.not_running.suspended' , name: this.stateFilter[2]},
                {id: 'closed.completed' , name: this.stateFilter[3]},
                {id: 'closed.terminated' , name: this.stateFilter[4]},
                {id: 'closed.aborted' , name: this.stateFilter[5]}
            ],
        }]
    });

    var colModel = new Ext.grid.ColumnModel( {
        defaultSortable: true,
        columns: [ {
            id: 'id',
            header: this.columnHeaderId,
            dataIndex: 'id'
        }, {
            header: this.columnHeaderName,
            dataIndex: 'name'
        }, {
            header: this.columnHeaderState,
            dataIndex: 'state'
        }, {
            header: this.columnHeaderCreated,
            dataIndex: 'created'
        }, {
            header: this.columnHeaderStarted,
            dataIndex: 'started'
        }, {
            header: this.columnHeaderLastActive,
            dataIndex: 'lastStateTime'
        }, {
            header: this.columnHeaderHistory,
            editable: false,
            fixed: true,
            width: 90,
            align: 'center',
            renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                var id = Ext.id();
                createButtonFnc.defer( 1, this, [ id, record ] );
                return ( '<div id="' + id + '"></div>' );
            }
        } ]
    } );

    var buttonToolbar = new Ext.Toolbar( {
        items: [ {
            ref: '../btnUpdateProcess',
            text: this.updateProcessText,
            iconCls: 'dvnt-icon-up-straight',
            handler: this.updateProcessesEventHandler,
            disabled: true,
            scope: this
        }, {
            ref: '../btnUpdateAllProcesses',
            text: this.updateAllProcessesText,
            iconCls: 'dvnt-icon-git-merge',
            handler: this.updateAllProcessesEventHandler,
            scope: this
        }, {
            ref: '../btnUpdateActiveProcesses',
            text: this.updateActiveProcessesText,
            iconCls: 'dvnt-icon-git-pull-request',
            handler: this.updateActiveProcessesEventHandler,
            scope: this
        },
            {
                text: this.selectAllText,
                iconCls: 'dvnt-icon-check-symbol',
                handler: this.onSelectAllEventHandler,
                scope: this
            }, {
                text: this.deselectAllText,
                iconCls: 'dvnt-icon-x-symbol',
                handler: this.onDeselectAllEventHandler,
                scope: this
            }, '->', {
            text: this.removeSelectedText,
            iconCls: 'dvnt-icon-x-symbol',
            handler: this.onRemoveSelectedEventHandler,
            scope: this,
            disabled: true,
            ref: '../btnRemoveSelectedProcesses'
        } ]
    } );

    var pagingToolbar = new Ext.PagingToolbar( {
        store: store,
        displayInfo: true,
        pageSize: this.pageSize,
        buttonAlign: 'center'
    } );

    var doubleToolbar = new Ext.Panel( {
        border: false,
        items: [ buttonToolbar, pagingToolbar ],
        plugins: [filters]
    } );

    config = Ext.apply( {
        frame: false,
        border: false,
        autoWidth: true,
        store: store,
        colModel: colModel,
        viewConfig: {
            forceFit: true,
            emptyText: this.emptyGridText
        },
        plugins: [filters],
        bbar: doubleToolbar
    }, config );

    Ext.ux.plusmpm.PackageManagerGridPanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.PackageManagerGridPanel constructor

Ext.extend( Ext.ux.plusmpm.PackageManagerGridPanel, Ext.grid.GridPanel,
                {
                    columnHeaderId: PW.t('columnHeaderId'),
                    columnHeaderName: PW.t('columnHeaderName'),
                    columnHeaderDesc: PW.t('descriptionTitle'),
                    columnHeaderState: PW.t('columnHeaderState'),
                    columnHeaderCreated: PW.t('columnHeaderCreated'),
                    columnHeaderStarted: PW.t('columnHeaderStarted'),
                    columnHeaderLastActive: PW.t('columnHeaderLastActive'),
                    columnHeaderHistory: PW.t('columnHeaderHistory'),
                    stateFilter: [PW.t('running'), PW.t('waiting'), PW.t('suspended'), PW.t('finished'), PW.t('paused'), PW.t('canceled')],
                    title: PW.t('packageProcessTitle'),
                    emptyGridText: PW.t('emptyGridText'),
                    updateProcessText: PW.t('updateProcessText'),
                    updateAllProcessesText: PW.t('updateAllProcessesText'),
                    updateActiveProcessesText: PW.t('updateActiveProcessesText'),
                    selectAllText: PW.t('selectAllOnPage'),
                    deselectAllText: PW.t('deselectAllOnPage'),
                    updateProcessesErrorUnknow: PW.t('updateProcessesErrorUnknow'),
                    updateProcessesAlreadyExecuting: PW.t('updateProcessesAlreadyExecuting'),

                    removeSelectedText: PW.t('removeSelectedText'),
                    removeProcessesSuccessText: PW.t('removeProcessesSuccessText'),
                    processRemove: PW.t('processRemove'),
                    removeConfirmText: PW.t('removeConfirmText'),

                    updateProcessesPackageError: PW.t('updateProcessesPackageError'),
                    sureText: PW.t('sureText'),
                    errorList: PW.t('errorList'),

                    // paginacja - ilość wyników
                    pageSize: 50,

                    initComponent: function() {
                        Ext.ux.plusmpm.PackageManagerGridPanel.superclass.initComponent.call( this );
                        this.getSelectionModel().on( 'selectionchange', this.onSelectionChangeEventHandler, this );
                    },

                    loadProcessData: function() {
                        var packageId = this.currentNode.attributes.packageId;
                        var packageVersion = this.currentNode.attributes.version;

                        this.filters.clearFilters();
                        this.store.baseParams.packageId = packageId;
                        this.store.baseParams.packageVersion = packageVersion;
                        this.store.load( {
                            params: {
                                start: 0,
                                limit: this.pageSize
                            }
                        } );
                    },

                    onRemoveSelectedEventHandler: function( btn ) {
                        PW.ui.CaptchaConfirmation.show({
                            title: this.processRemove,
                            msg: this.removeConfirmText,
                            requiresCaptcha: window.requiresCaptcha,
                            fn: this.onRemoveSelectedProcesses,
                            scope: this
                        });
                    },

                    onRemoveSelectedProcesses: function( buttonId ) {
                        var processList = new Array();
                        this.getSelectionModel().getSelections().each( function( item ) {
                            var obj = {
                                id: item.id,
                                procDefId: item.data.procDefId
                            };
                            processList.push( obj );
                        } );

                        var processes = Ext.util.JSON.encode( processList );

                        this.removeProcesses( processes );
                    },

                    removeProcesses: function( processes ) {
                        var params = {
                            actionType: 'remove',
                            processes: processes
                        };

                        this.body.mask( Ext.LoadMask.prototype.msg, 'x-mask-loading' );

                        Ext.Ajax.request( {
                            url: ' com.plusmpm.servlet.packages.PackageProcessesServlet.customServlet',
                            method: 'POST',
                            timeout: 3600000,
                            callback: function( options, success, response ) {
                                this.body.unmask();
                            },
                            success: function( response ) {
                                var resp = Ext.decode( response.responseText );
                                if ( resp.success ) {
                                    this.removeProcessesSuccessMsg( resp.total );
                                    this.store.reload();
                                }
                            },
                            params: params,
                            scope: this
                        } );
                    },

                    removeProcessesSuccessMsg: function( count ) {
                        PW.ui.MessageBox.show( {
                            title: this.processRemove,
                            msg: String.format( this.removeProcessesSuccessText, count ),
                            buttons: Ext.Msg.OK,
                            icon: Ext.MessageBox.INFO
                        } );
                    },

                    onSelectionChangeEventHandler: function( sm ) {
                        this.getBottomToolbar().btnUpdateProcess.setDisabled( sm.getSelected() === undefined );
                        this.getBottomToolbar().btnRemoveSelectedProcesses.setDisabled( sm.getSelected() === undefined );
                    },

                    onSelectAllEventHandler: function() {
                        this.getSelectionModel().selectAll();
                    },

                    onDeselectAllEventHandler: function() {
                        this.getSelectionModel().clearSelections();
                    },

                    updateProcessesEventHandler: function() {
                        var processList = new Array();
                        this.getSelectionModel().getSelections().each( function( item ) {
                            var obj = {
                                id: item.id,
                                procDefId: item.data.procDefId
                            };
                            processList.push( obj );
                        } );

                        this.openUpdateProcessWindow( {
                            processes: processList
		                } );
                    },

                    updateActiveProcessesEventHandler: function () {
                        this.openUpdateProcessWindow(undefined, undefined, true);
                    },

                    updateAllProcessesEventHandler: function () {
                        this.openUpdateProcessWindow();
                    },

                    openUpdateProcessWindow: function (config, resubmit, onlyActive) {
                        var packageId = this.currentNode.attributes.packageId;
                        var packageVersion = this.currentNode.attributes.version;
                        var filters = this.filters;
                        if (onlyActive === true) {
                            filters.getFilter('state').active = true;
                            filters.getFilter('state').menu.selected = ['open.running'];
                        }
                        var filterParam = filters.buildQuery(filters.getFilterData());

                        var dialog = new Ext.ux.plusmpm.PackageManagerUpdateProcessesDialog( Ext.apply( {
                            packageVersion: packageVersion,
                            packageId: packageId,
                            packageVersions: this.packageVersions,
                            filter: filterParam.filter,

                            listeners: {
                                scope: this,
                                success: function() {
                                    if (this.hasActiveFilters()) {
                                        this.filters.clearFilters();
                                    } else {
                                        this.store.load({
                                            params: {
                                                start: 0,
                                                limit: this.pageSize
                                            }
                                        });
                                    }
                                },
                                error: function (errors, params, form) {
                                    if (errors === undefined) {
                                        this.showProcessUpdateError();
                                        form.close();
                                    } else if (errors === "alreadyInitialized") {
                                        this.showProcessUpdateError("alreadyInitialized")
                                    } else {
                                        this.showProcessUpdatePackageError(errors, params, form);
                                    }
                                }
                            }
                        }, config));

                        if (resubmit) {
                            dialog.submitForm(resubmit.params);
                        } else {
                            dialog.show();
                        }
                    },

                    hasActiveFilters: function () {
                        var result = this.filters.filters.items.find(function (filter) {
                            return filter.active;
                        });

                        return !!result;
                    },

                    showProcessUpdateError: function (errors) {
                        let message;
                        switch (errors) {
                            case "alreadyInitialized":
                                message = this.updateProcessesAlreadyExecuting
                                break;
                            default:
                                message = this.updateProcessesErrorUnknow
                                break;
                        }

                        PW.ui.MessageBox.show({
                            title: Ext.ux.plusmpm.PackageManager.prototype.errorText,
                            msg: message,
                            buttons: Ext.Msg.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    },

                    showProcessUpdatePackageError: function (errors, params, form) {

                        var headerTpl = new Ext.Template('<p>{0} {1}</p><h4>{2}</h4>').apply([this.updateProcessesPackageError, this.sureText,
                            this.errorList]);
                        var errorsTpl = new Ext.XTemplate('<tpl for=".">{.}</tpl>').apply(errors);

                        var panel = new Ext.Panel({
                            layout: 'vbox',
                            height: 300,
                            border: false,
                            layoutConfig: {
                                align: 'stretch',
                                pack: 'start'
                            },
                            frame: false,
                            items: [
                                new Ext.Panel({
                                    padding: 10,
                                    html: headerTpl,
                                    height: 100,
                                    frame: false,
                                    border: false,
                                    autoScroll: true
                                }),
                                new Ext.Panel({
                                    padding: '0 0 0 10',
                                    html: errorsTpl,
                                    flex: 1,
                                    autoScroll: true,
                                    frame: false,
                                    border: false
                                })
                            ]
                        })

                        var win=new Ext.Window( {
                            title: Ext.ux.plusmpm.PackageManager.prototype.warningText,
							cls: 'package-error-message',
                            width: 650,
                            layout:'fit',
                            items: panel,
                            modal: true,
                            buttonAlign: 'left',
                            buttons: [
                                {
                                    text: Ext.ux.plusmpm.PackageManager.prototype.downloadChangesText,
                                    handler: function () {
                                        const packageId = params.packageId
                                        const basePackageVersion = params.packageVersion

                                        const formValues = form.formPanel.getForm().getValues()
                                        const newPackageVersion = formValues.version ?? params.version ?? ''

                                        window.location.href = Suncode.getAbsolutePath(`api/xpdlDifference?packageId=${packageId}&basePackageVersion=${basePackageVersion}&newPackageVersion=${newPackageVersion}`)
                                    }
                                },
                                '->',
		                    	{
		                    		text: Ext.MessageBox.buttonText.yes,
		                    		handler: [
					                    		function() {
									            	form.submitForm( Ext.apply( {
									                force: true
									                }, params ) );
									            },
									            function(){
					                            	win.close()
					                            }]
		                    	},
		                    	{
		                    		text: Ext.MessageBox.buttonText.no,
		                            handler: function(){
		                            	win.close()
		                            }
		                    	}
		                    ],
                            scope: this
                        } );

                        win.show();
                    }

                } ); // end of Ext.extend

/**
 * Wymagane parametry: config.packageVersion config.packageId
 * config.packageVersions config.processes
 */
Ext.ux.plusmpm.PackageManagerUpdateProcessesDialog = function( config ) {

    var isNewest = config.packageVersions[0].version > config.packageVersion ? false : true;

    var combo = new Ext.form.ComboBox( {
        fieldLabel: this.packageVersionText,
        name: 'version',
        disabled: !isNewest,
        triggerAction: 'all',
        forceSelection: true,
        allowBlank: false,
        width: 80,
        mode: 'local',
        store: new Ext.data.ArrayStore( {
            fields: [ {
                name: 'version',
                mapping: 'version',
                type: 'int'
            } ],
            data: config.packageVersions
        } ),
        valueField: 'version',
        displayField: 'version'
    } );

    combo.setValue( config.packageVersions[0].version );

    var formFields = [];
    if ( isNewest == false ) {
        formFields.push( {
            xtype: 'radio',
            name: 'actionType',
            fieldLabel: this.updateToNewestText,
            inputValue: this.updateToNewestType,
            checked: true
        } );

        formFields.push( {
            ref: 'nextVersionRadio',
            xtype: 'radio',
            name: 'actionType',
            fieldLabel: this.updateToNextText,
            inputValue: this.updateToVersionType
        } );
    }

    formFields.push( {
        xtype: 'radio',
        name: 'actionType',
        fieldLabel: this.updateToVersionText,
        inputValue: this.updateToVersionType,
        checked: isNewest,
        listeners: {
            scope: this,
            check: function( radio, checked ) {
                this.formPanel.getForm().findField( 'version' ).setDisabled( !checked );
            }
        }
    } );

    formFields.push( combo );

    this.formPanel = new Ext.form.FormPanel( {
        frame: false,
        border: false,
        labelWidth: 200,
        items: formFields,
        bodyStyle: 'padding: 5px 0 0 15px;',
        buttons: [ {
            text: Ext.MessageBox.buttonText.ok,
            handler: this.submit,
            formBind: true,
            scope: this
        }, {
            text: Ext.MessageBox.buttonText.cancel,
            handler: function() {
                this.close();
            },
            scope: this
        } ]
    } );

    config = Ext.apply( {
        width: 450,
        modal: true,
        items: [ this.formPanel ],
        processes: config.processes,
        packageId: config.packageId
    }, config );

    Ext.ux.plusmpm.PackageManagerUpdateProcessesDialog.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.PackageManagerUpdateProcessesDialog constructor

Ext.extend( Ext.ux.plusmpm.PackageManagerUpdateProcessesDialog, Ext.Window, {

    title: PW.t('upgradingProcesses'),
    packageVersionText: PW.t('packageVersionText'),
    updateToNewestText: PW.t('updateToNewestText'),
    updateToNextText: PW.t('updateToNextText'),
    updateToVersionText: PW.t('updateToVersionText'),
    progressTitle: PW.t('progressTitle'),
    progressMessage: PW.t('progressMessage'),

    processes: null,

    updateToNewestType: 'newest',

    updateToVersionType: 'version',

    initComponent: function() {
        Ext.ux.plusmpm.PackageManagerUpdateProcessesDialog.superclass.initComponent.call( this );

        this.addEvents( 'success', 'error' );
    },

    submit: function() {

        var params = {
            packageId: this.packageId,
            packageVersion: this.packageVersion,
            filter: this.filter
        };

        if ( this.formPanel.nextVersionRadio && this.formPanel.nextVersionRadio.getValue() ) {
            params.version = this.packageVersions[0];
            Ext.each( this.packageVersions, function( item, index ) {
                if ( item.version > this.packageVersion ) {
                    params.version = item.version;
                }
            }, this );
        }

        if ( this.processes !== undefined )
            params.processes = Ext.util.JSON.encode( this.processes );

        if ( this.force === true ) {
            params.force = true;
        }

        this.submitForm( params );
    },

    submitForm: function( params ) {
        var me = this;

        this.formPanel.getForm().submit( {
            url: 'com.plusmpm.servlet.packages.PackageProcessesServlet.customServlet',
            method: 'POST',
            scope: this,
            success: function( form, action ) {
            	  if ( Ext.isDefined( action.result.failureIds ) && action.result.failureIds.length > 0) {                     
            		  var updateFailureIds = action.result.failureIds;
            		  var message = PW.t('failureWithProcessUpdate') + '<br><br><ul>';
            		  for(i = 0; i< updateFailureIds.length; i++){
            			  message = message + '<li style=\"list-style: disc; padding-left: 10px;\">' + updateFailureIds[i] + '</li>';
            		  }
            		  message += '</ul>'
                      PW.ui.MessageBox.show( {
                          title: Ext.ux.plusmpm.PackageManager.prototype.warningText,
                          msg: message,
                          width: 400,
                          buttons: Ext.Msg.OK,
                          icon: Ext.MessageBox.INFO
                      } );             
                  }
                this.fireEvent( 'success' );
                this.close();
            },
            failure: function( form, action ) {
                if ( Ext.isDefined( action.result ) ) {
                    // serwer odpowiedział
                    if ( action.result.reason == 'timeout' ) {
                        // timeout
                        this.submitForm( Ext.apply(params, {
                            actionType: 'check',
                            task: action.result.key
                        }));
                    }
                    else {
                        this.fireEvent( 'error', action.result.errors, params, this );
                    }
                }
                else
                    if ( action.response.isTimeout ) {
                        // timeout
                        this.submitForm( Ext.apply(params, {
                            actionType: 'check'
                        }));
                    }
            },
            params: params,
            waitTitle: this.progressTitle,
            waitMsg: this.progressMessage
        } );
    }
} ); // end of Ext.extend
