(function (Ext) {
    Ext.define('Suncode.deactivateUsers.view.TasksSection', {
        extend: 'Ext.form.FieldSet',
        alias: 'widget.tasks-section',
        title: PW.t('assign-fieldset'),
        cls: 'fieldset',
        id: 'tasks-section',
        collapsible: true,
        defaults: {margin: '10 0 0 0'},
        initComponent: function () {

            Ext.apply(this, {
                items: [{
                    xtype: 'tasks-grid',
                    height: 300
                }, {
                    xtype: 'tasks-assignment'
                },{
                    xtype: 'fieldset',
                    cls: 'fieldset',
                    collapsible: false,
                    layout: 'column',
                    border: false,
                    items: [{
                        border: false,
                        items: [{
                            xtype: 'container',
                            layout: {
                                type: 'vbox',
                                align: 'left'
                            }, items: [{
                                xtype: 'checkbox',
                                store: new Suncode.deactivateUsers.store.UsersStore(),
                                itemId: 'skipSubstitutions',
                                width: 400,
                                labelWidth: 150,
                                margin: 0,
                                fieldLabel: PW.t('skip-substitutions'),
                                margin: '0 0 20 0'
                            }]
                        }]
                    }, {
                        border: false,
                        items: [{
                            xtype: 'container',
                            layout: {
                                type: 'vbox',
                                align: 'stretch'
                            }, items: [{
                                xtype: 'checkbox',
                                store: new Suncode.deactivateUsers.store.UsersStore(),
                                itemId: 'skipNotifications',
                                width: 400,
                                labelWidth: 150,
                                margin: 0,
                                fieldLabel: PW.t('skip-notifications'),
                                margin: '0 0 20 0'
                            }]
                        }]
                    }]
                }]
            });

            this.callParent();
        }
    });
}(this.Ext4));