(function (Ext) {
  Ext.define('Favourites.settings.view.FavouriteWindow', {
    extend: 'Favourites.settings.view.FavouriteBaseWindow',
    xtype: 'favourites-favouritewindow',
    itemId: 'favourites-window',
    cls: 'favourites-window',
    requires: ['Favourites.model.Favourite', 'Favourites.store.FavouriteDefinitions'],

    initComponent: function () {
      let store = Ext4.create('Favourites.store.FavouriteDefinitions');

      Ext.apply(this, {
        width: 1200,
        height: 600,
        items: [
          {
            store: store,
            xtype: 'treepanel',
            flex: 1,
            rootVisible: false,
            listeners: {
              selectionchange: this.bindSelectedElement,
              scope: this,
            },
            columns: {
              defaults: {
                hideable: false,
                sortable: false,
                lockable: false,
              },
              items: [
                {
                  xtype: 'treecolumn',
                  text: Favourites.I18N.m('name'),
                  dataIndex: 'displayName',
                  width: 250,
                  locked: true,
                },
                {
                  text: Favourites.I18N.m('count'),
                  dataIndex: 'countable',
                  width: 70,
                  renderer: function (value, meta) {
                    meta.innerCls = 'favourite-element-count';
                    return (
                      '<img src="' +
                      Ext.BLANK_IMAGE_URL +
                      '" class="' +
                      (value ? 'dvnt-icon-check-symbol dvnt-green-icon' : 'dvnt-icon-x-symbol dvnt-red-icon') +
                      '"/>'
                    );
                  },
                },
                {
                  text: Favourites.I18N.m('type'),
                  dataIndex: 'typeDescription',
                  width: 200,
                },
                {
                  text: Favourites.I18N.m('details'),
                  dataIndex: 'description',
                  width: 350,
                },
              ],
            },
          },
          {
            xtype: 'form',
            layout: 'form',
            width: 350,
            frame: true,
            defaults: {
              xtype: 'textfield',
              labelAlign: 'top',
            },
            items: [
              {
                fieldLabel: Favourites.I18N.m('name'),
                name: 'name',
                allowBlank: false,
                disabled: true,
              },
              {
                xtype: 'checkbox',
                labelAlign: 'left',
                fieldLabel: Favourites.I18N.m('customName'),
                name: 'customName',
                listeners: {
                  change: this.handleCustomNameCheckboxChange,
                },
              },
              {
                name: 'displayNameMode',
                allowBlank: false,
                hidden: true,
              },
              {
                fieldLabel: Favourites.I18N.m('type'),
                name: 'typeDescription',
                readOnly: true,
              },
              {
                fieldLabel: Favourites.I18N.m('parameter'),
                itemId: 'parameter',
                name: 'parameter',
                allowBlank: true,
                hidden: true,
                maxLength: 250,
              },
              {
                xtype: 'checkbox',
                labelAlign: 'left',
                fieldLabel: Favourites.I18N.m('countresults'),
                name: 'counted',
                hidden: true,
              },
            ],
            buttons: [
              {
                text: Favourites.I18N.m('add'),
                formBind: true,
                iconCls: 'dvnt-icon-plus-circle',
                handler: this.addElement,
                scope: this,
              },
              {
                text: Favourites.I18N.m('exit'),
                iconCls: 'dvnt-icon-x-symbol',
                handler: () => {
                  this.close();
                },
              },
            ],
          },
        ],
      });

      this.callParent(arguments);
      this.treePanel = this.down('treepanel');
      this.form = this.down('form');
      this.nameField = this.form.down('textfield[name="name"]');
      this.countField = this.form.down('checkbox[name="counted"]');
      this.customNameField = this.form.down('checkbox[name="customName"]');
      this.displayNameModeField = this.form.down('textfield[name="displayNameMode"]');
    },

    show: function () {
      // reset
      this.nameField.originalValue = null
      this.form.getForm().reset();
      this.treePanel.getSelectionModel().deselectAll();
      this.treePanel.collapseAll();
      this.callParent(arguments);
    },

    addElement: function () {
      let favourite = this.form.getRecord();

      this.form.updateRecord(favourite);
      let parameterField = this.form.query('#parameter')[0];
      if (parameterField.isVisible() && parameterField.getValue()) {
        favourite.set('description', favourite.get('parameter'));
      }
      if (this.form.isValid()) {
        this.fireEvent('addFavourite', favourite);
        this.nameField.originalValue = null
        this.form.getForm().reset();
      }
    },

    bindSelectedElement: function (tree, selected) {
      let definition = selected[0];

      if (definition && definition.data.supported) {
        let parameter = definition.get('parameter');
        let favourite = Ext.create('Favourites.model.Favourite', {
          name: definition.get('name'),
          type: definition.get('type'),
          typeDescription: definition.get('typeDescription'),
          parameter: parameter ? parameter.value : null,
          description: definition.get('description'),
          displayNameMode: definition.get('displayNameMode'),
        });

        this.bindFavouriteBase(favourite, parameter);

        this.customNameField.setValue(false);
        this.nameField.focus(true, true);
        this.countField.setVisible(definition.get('countable'));
        this.countField.setValue(false);
        this.displayNameModeField.setValue('SYSTEM');
      }
    },
  });
})(window.Ext4);
