<%@page language="Java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="/tags/struts-bean" prefix="bean"%>
<%@ taglib uri="/tags/struts-html" prefix="html"%>
<%@ taglib uri="/tags/struts-logic" prefix="logic"%>
<%@ taglib uri="/tags/c" prefix="c"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display"%>

<%@page import="com.plusmpm.util.*"%>
<%@page import="java.util.*"%>
<%@page import="com.plusmpm.util.ReportResult.*"%>
<%@page import="com.plusmpm.struts.form.FilterVariableForm"%>
<%@page import="org.springframework.context.i18n.LocaleContextHolder"%>

<script type="text/javascript" src="scripts/calendar.js"></script>
<script type="text/javascript" src="scripts/lang/calendar-<%=LocaleContextHolder.getLocale().getLanguage()%>.js"></script>
<script type="text/javascript" src="scripts/calendar-setup.js"></script>
<link rel="stylesheet" type="text/css" media="all" href="style/calendar-system.css" title="win2k-cold-1" />

<%
    // inicjalizacja niezbednych zmiennych javowych
    int index = -1;
    FilterVariableForm[] filter = (FilterVariableForm[]) request.getAttribute( "filter" );

	String toggleIcon = "dvnt-icon-down-straight";
	String collapsedCls = "collapsed";
	String showFormOnResult = (String) request.getAttribute("showForm");
	Boolean canFilter = Boolean.parseBoolean((String) request.getAttribute("canFilter"));
	if("true".equalsIgnoreCase( showFormOnResult )) {
		toggleIcon = "dvnt-icon-up-straight";
		collapsedCls = "";
	}
%>


<div class="content-container">
	<div class="content-header">
		<p>
			<bean:message key="Wyniki_raportu" />
			<c:if test='${!empty reportName}'>
				- <c:out value="${reportName}" />
			</c:if>
		</p>
	</div>
	<c:if test="${canFilter}">
		<div id="portlet_3" class="portlet-panel report-filter-portlet <%=collapsedCls%>">
			<div id="portlet_3Tools" class="portlet-panel-tools">
				<div id="portlet_3Refresh" onclick="PW.ui.Portlet.resetForm('portlet_3')" class="portlet-panel-refresh dvnt-icon-refresh"></div>
				<div id="portlet_3Size" onclick="javascript: PW.ui.Portlet.toggle('portlet_3');" class="portlet-panel-size <%=toggleIcon%>"></div>
			</div>
			<div id="portlet_3Title" onclick="javascript: PW.ui.Portlet.toggle('portlet_3');" class="portlet-panel-title"><bean:message key="Filtruj_wyniki_raportu"/></div>
			<div id="portlet_3Content" class="portlet-panel-content" <c:if test='<%=!"true".equals(showFormOnResult)%>'>style="display: none;"</c:if> >
				<html:form action="/ReportFilter.do?source=filter" method="POST"
						   styleId="varForm">
					<TABLE class="form-table reports-form-table highlight">

						<tr class="clear-highlight text-bold">
							<td class="checkbox-column empty">
								<bean:message key="Uzyj_pola" />
							</td>
							<td class="text-column">
								<bean:message key="Nazwa_zmiennej"/>
							</td>
							<td class="text-column">
								<bean:message key="Nazwa_pola" />
							</td>
							<td class="value-column">
								<bean:message key="Ograniczenia"/>
							</td>
							<td class="combobox-column">
								<bean:message key="Sortowanie" />
							</td>
							<td class="combobox-column">
								<bean:message key="Pozycja" />
							</td>
						</tr>
						<c:forEach var="filterVar" items="${filter}">
							<%
								// indeks, bo petla musi dzialac i na html i na javie -- zeby podawac indeksy strutsom
								index++;

								// wartosci pol formularza - ustalone (jesli nie ma tego, nawet w hidden, wstawiaja sie nulle w formularzu)
								String sName = filter[index].getName();
								String sType = filter[index].getType();
								String sSubType = filter[index].getSubType();
								String sSubTypeValues = filter[index].getSubTypeValues();
								String sVisible = filter[index].getVisible();
								if ( sVisible == null )
									sVisible = "off";

								String sNameProperty = "filter[" + index + "].name";
								String sTypeProperty = "filter[" + index + "].type";
								String sSubTypeProperty = "filter[" + index + "].subType";
								String sSubTypeValuesProperty = "filter[" + index + "].subTypeValues";

								// FilterVariableForm properties
								String sVarName = filter[index].getName();
								String sVarViewName = filter[index].getViewName();
								String sVarValue = filter[index].getValue();
								String sVarValue2 = filter[index].getValue2();
								String sVarPosition = filter[index].getPosition();
								String sVarSort = filter[index].getSortType();

								// wartosci pol formularza - zmienne
								String sVisibleProperty = "filter[" + index + "].visible";
								String sViewNameProperty = "filter[" + index + "].viewName";
								String sProperty = "filter[" + index + "].value";
								String sProperty2 = "filter[" + index + "].value2";
								String sSortProperty = "filter[" + index + "].sortType";
								String sPositionProperty = "filter[" + index + "].position";
							%>
							<tr>

								<!-- Wszystko to, co nie bedzie widoczne -->
								<TD class="checkbox-column empty">
									<html:hidden property="<%=sNameProperty%>"
												 styleId="<%=sVarName%>" value="<%=sName%>" />
									<html:hidden property="<%=sTypeProperty%>"
												 styleId="<%=sVarName%>" value="<%=sType%>" />
									<html:hidden property="<%=sSubTypeProperty%>"
												 styleId="<%=sVarName%>" value="<%=sSubType%>" />
									<html:hidden property="<%=sSubTypeValuesProperty%>"
												 styleId="<%=sVarName%>" value="<%=sSubTypeValues%>" />

									<!-- Czy wyswietlac -->
									<html:checkbox property="<%=sVisibleProperty%>"
												   styleId="<%=sVarName%>"
												   onchange="if(this.checked == 'checked' || this.checked == true) this.value = 'on'; else this.value = 'off';" />
								</TD>

								<!-- Nazwa zmiennej -->
								<TD class="text-column break-long-words">
									<c:out value="${filterVar.name}" />
								</TD>

								<!-- Wyświetlana nazwa -->
								<TD class="text-column">
									<html:text property="<%=sViewNameProperty%>"
											   styleId="<%=sVarName%>" styleClass="not-resettable" value="<%=sVarViewName%>" />
								</TD>


								<!-- Ograniczenia -->
								<TD class="value-column">
									<c:choose>
										<c:when test='${filterVar.type == "STRING"}'>
											<c:choose>
												<c:when test='${filterVar.subType == "LISTBOX"}'>
													<html:select property="<%=sProperty%>"
																 styleId="<%=sVarName%>" value="<%=sVarValue%>">
														<html:option value=""></html:option>
														<c:forEach var="element" items="${filterVar.subTypeValues}">
															<html:option value="${element}">
																<c:out value="${element}" />
															</html:option>
														</c:forEach>
													</html:select>
												</c:when>
												<c:when test='${filterVar.subType == "RADIOBUTTON"}'>
													<c:forEach var="element" items="${filterVar.subTypeValues}">
														<html:radio property="<%=sProperty%>" value="${element}"
																	styleId="<%=sVarName%>"></html:radio>
														<c:out value="${element}" />
													</c:forEach>
												</c:when>
												<c:otherwise>
													<html:text property="<%=sProperty%>" styleId="<%=sVarName%>"
															   value="<%=sVarValue%>" />
												</c:otherwise>
											</c:choose>
										</c:when>

										<c:when test='${filterVar.type == "DATE" || filterVar.type == "SYSTEMDATE"}'>
											<table class="inner-form-table">
												<tr>
													<td>
														<table class="labeled">
															<tr>
																<td>
																	<div class="label"><bean:message key="Od" /></div>
																</td>
																<td class="triggers">
																	<a href="#" id="img<%=index%>" class="trigger date-trigger"></a>
																	<html:text property="<%=sProperty%>"
																			   styleId="<%=sVarName + '1'%>" styleClass="date"
																			   value="<%=sVarValue%>" />
																	<script type="text/javascript">
																		Calendar.setup({
																			inputField     :    "<c:out value='${filterVar.name}'/>1",     // id of the input field
																			ifFormat       :    "%Y-%m-%d",      // format of the input field
																			button         :    "img<%=index%>",  // trigger for the calendar (button ID)
																			align          :    "Tr",           // alignment (defaults to "Bl")
																			singleClick    :    true
																		});
																	</script>
																</td>
															</tr>
														</table>
													</td>
													<td>
														<table class="labeled">
															<tr>
																<td>
																	<div class="label"><bean:message key="Do" /></div>
																</td>
																<td class="triggers">
																	<a href="#" id="img2_<%=index%>" class="trigger date-trigger"></a>
																	<html:text property="<%=sProperty2%>"
																			   styleId="<%=sVarName + '2'%>" styleClass="date"
																			   value="<%=sVarValue2%>" />
																	<script type="text/javascript">
																		Calendar.setup({
																			inputField     :    "<c:out value='${filterVar.name}'/>2",     // id of the input field
																			ifFormat       :    "%Y-%m-%d",      // format of the input field
																			button         :    "img2_<%=index%>",  // trigger for the calendar (button ID)
																			align          :    "Tr",           // alignment (defaults to "Bl")
																			singleClick    :    true
																		});
																	</script>
																</td>
															</tr>
														</table>
													</td>
												</tr>
											</table>
										</c:when>

										<c:when
												test='${filterVar.type =="INTEGER" || filterVar.type =="FLOAT"}'>
											<table class="inner-form-table">
												<tr>
													<td>
														<table class="labeled">
															<tr>
																<td>
																	<div class="label"><bean:message key="Od" /></div>
																</td>
																<td>
																	<html:text property="<%=sProperty%>" styleId="<%=sVarName%>"
																			   value="<%=sVarValue%>" styleClass="date" />
																</td>
															</tr>
														</table>
													</td>
													<td>
														<table class="labeled">
															<tr>
																<td>
																	<div class="label"><bean:message key="Do" /></div>
																</td>
																<td>
																	<html:text property="<%=sProperty2%>"
																			   styleId="<%=sVarName + '2'%>" value="<%=sVarValue2%>"
																			   styleClass="date" />
																</td>
															</tr>
														</table>
													</td>
												</tr>
											</table>
										</c:when>
									</c:choose>
								</TD>

								<!-- Sortowanie -->
								<TD class="combobox-column">
									<html:select property="<%=sSortProperty%>"
												 styleId="sort_<%=sVarName%>" value="<%=sVarSort%>">
										<html:option value="">
											<bean:message key="brak" />
										</html:option>
										<html:option value="asc">
											<bean:message key="Rosnaco" />
										</html:option>
										<html:option value="desc">
											<bean:message key="Malejaco" />
										</html:option>
									</html:select>
								</TD>

								<!-- Pozycja -->
								<TD class="combobox-column">
									<html:select property="<%=sPositionProperty%>"
												 styleId="poz_<%=sVarName%>" value="<%=sVarPosition%>">
										<html:option value="999">
											<bean:message key="brak" />
										</html:option>
										<%
											for ( int z = 1; z <= filter.length; z++ )
											{
												String zStr = Integer.toString( z );
										%>
										<html:option value="<%=zStr%>"><%=z%></html:option>
										<%
											}
										%>
									</html:select>
								</TD>
							</tr>
						</c:forEach>
						<tr class="buttons clear-highlight">
							<td colspan="6" class="text-center empty">
								<bean:define id="Filtruj"><bean:message key="Filtruj"/></bean:define>
								<input type="submit" name=<%=Filtruj%> value=<%=Filtruj%> class="form-button">
							</td>
						</tr>
					</table>
					<!-- nie wiem co to to -->
				</html:form>

			</div>
		</div>
	</c:if>

<%
    int iPageSize = ( new Integer( (String) request.getAttribute( "iPageSize" ) ) ).intValue();
    Integer size1 = new Integer( (String) request.getAttribute( "iMaxPageSize" ) );
%>

<%
    if ( size1.intValue() > 0 )
    {
%>

<div class="scrollable scrollable-report">
	<display:table name="alResult" excludedParams="*" export="true"
		sort="external" pagesize="<%=iPageSize%>" partialList="true"
		size="<%=size1%>" requestURI="ReportFilter.do" uid="task"
		class="data-table" decorator="com.plusmpm.util.TableDecoratorWrapper">
		<bean:define id="Lp"><bean:message key="Lp"/></bean:define>
		<display:column title="<%=Lp%>">
			<c:out value="${task_rowNum}" />
		</display:column>

        <c:forEach items="${task.variables}" var="reportResult">
            <c:set var="viewNameTemp" value="${reportResult.displayName}"></c:set>
            <%String sViewNameTemp = (String)pageContext.getAttribute("viewNameTemp");%>
            <display:column title="<%=sViewNameTemp%>" sortable="true">
                ${reportResult.displayValue}
            </display:column>
        </c:forEach>

		<display:setProperty name="export.pdf" value="true" />
		<display:setProperty name="export.amount" value="list" />
		<display:setProperty name="export.pdf.description"><bean:message key="Wyniki_raportu"/>: <c:out value="${reportName}" /></display:setProperty>
    	<display:setProperty name="export.pdf.user">${username}</display:setProperty>
	</display:table>
</div>
</div>

<%
    }
%>
