<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>
<%@ taglib uri="/tags/c" prefix="c" %>
<%@page language="Java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib uri="http://ajaxtags.org/tags/ajax" prefix="ajax" %>

<script>
    if (editIndexApp && !editIndexApp._isDestroyed) {
        editIndexApp.$destroy();
    }
    var canEdit = <%=request.getAttribute( "canEdit" )%>;
    if ( canEdit == null ) canEdit = true;

    var message = '<%=request.getAttribute( "message" )%>';
    var editIndexApp = new Vue({
        el: '#index-form',

        data: {
            documentClassId: '<%=request.getAttribute( "docclassId" )%>',
            id: '',
            indexName: '',
            indexDescription: '',
            indexType: 'integer',
            indexPatterns: [],
            indexValues: [],
            isUpdate: false,
            buttonMessage: PW.t('Dodaj_index'),
            canEdit: canEdit,
			message: message
        },

        computed: {
            isValid: function () {
                if (!this.indexName) {
                    return false;
                }

                if (this.indexType == 'list') {
                    if (this.indexValues.length == 0) {
                        return false;
                    }

                    for (var i = 0; i < this.indexValues.length; i++) {
                        if (!this.indexValues[i].value) {
                            return false;
                        }
                        else if (!this.isValueValid(this.indexValues[i])) {
                            return false;
                        }
                    }
                }

                for (var i = 0; i < this.indexPatterns.length; i++) {
                    if (!this.indexPatterns[i].pattern) {
                        return false;
                    }
                    else if (!this.isPatternValid(this.indexPatterns[i])) {
                        return false;
                    }
                }

                return true;
            },
        },

        mounted: function () {
            var indexDto = JSON.parse('<%=request.getAttribute( "indexDto" )%>');
            if (indexDto) {
                this.isUpdate = true;
                this.buttonMessage = PW.t('Zmien_index');
                this.rewriteIndex(indexDto);
            }
	
        	if (canEdit){
	            this.initToolTips();
        	}
        	
        	if(this.isUpdate && this.canEdit)
			{
				this.message = PW.t("Zmiana_typu_indeksu_spowoduje_utrate_danych_zawartym_w_tym_indeksie");
			}
        },

        methods: {
            initToolTips: function () {
                Ext.QuickTips.init();
                Ext.apply(Ext.QuickTips.getQuickTip(), {
                    showDelay: 500
                });

                var tip = new Ext.Tip({
                    html: PW.t("Index_pattern_replacement") + "</br>\
                    <ul>\
                    </br>\
                    <li>- " + PW.t("Index_pattern_replacement_char_array") + "\
                    </br>" + PW.t("Index_pattern_replacement_example", "c_", "c?", "indexc_c_val", "indexc?c?val" ) + "\
                    </li>\
                    </br>\
                    <li>- " + PW.t("Index_pattern_replacement_regex") + "\
                    </br>" + PW.t("Index_pattern_replacement_example", "\\d+", "_", "123val456", "_val_" ) + "\
                    </li>\
                    </ul>"
                });

                var el = Ext.get(this.$refs.valueReplacement);
                el.on('mouseenter', function() {
                    tip.showBy(el, 'br');
                });

                el.on('mouseleave', function() {
                    tip.hide();
                });
            },

            rewriteIndex: function (indexDto) {
                this.id = indexDto.id;
                this.indexName = indexDto.name;
                this.indexDescription = indexDto.description;
                this.indexType = indexDto.type;

                var me = this;
                me.indexPatterns.splice(0, me.indexPatterns.length);
                indexDto.indexPatterns.forEach(function (patternDto) {
                    me.indexPatterns.push({
                        id: patternDto.id,
                        pattern: patternDto.pattern,
                        replace: patternDto.replace,
                        patternType: patternDto.isRegex ? 'regex' : 'charArray'
                    });
                });

                me.indexValues.splice(0, me.indexValues.length);
                indexDto.values.forEach(function (indexValue) {
                    me.indexValues.push({
                        value: indexValue
                    })
                });
            },

            addIndexValue: function () {
                this.indexValues.push({
                    value: ''
                });
            },

            deleteIndexValue: function (indexValue) {
                var indexInList = this.indexValues.indexOf(indexValue);
                if (indexInList >= 0) {
                    this.indexValues.splice(indexInList, 1);
                }
            },

            onValuePaste: function(event, focusedValue) {
              var me = this;

              if(!focusedValue.value) {
                  var values = event.clipboardData.getData('text')
                      .split("\n")
                      .map(function(value) {
                          return value.trim();
                      })
                      .filter(function(value) {
                          return !!value;
                      });

                  if(values.length > 0) {
                      var indexInList = me.indexValues.indexOf(focusedValue);
                      values.forEach(function(value) {
                          me.indexValues.splice(indexInList++, 0, {
                              value: value
                          });
                      });

                      me.deleteIndexValue(focusedValue);
                      event.preventDefault();
                  }
              }
            },

            addPattern: function () {
                this.indexPatterns.push({
                    pattern: '',
                    replace: '',
                    patternType: 'charArray'
                });
            },

            deletePattern: function (indexPattern) {
                var indexInList = this.indexPatterns.indexOf(indexPattern);
                if (indexInList >= 0) {
                    this.indexPatterns.splice(indexInList, 1);
                }
            },

            isPatternValid: function (indexPattern) {
                if (!indexPattern.pattern) {
                    return false;
                }

                var currentIndex = this.indexPatterns.indexOf(indexPattern);
                for (var i = 0; i < this.indexPatterns.length; i++) {
                    if (i != currentIndex && indexPattern.pattern == this.indexPatterns[i].pattern) {
                        return false;
                    }
                }

                return true;
            },

            isValueValid: function (indexValue) {
                if (!indexValue.value) {
                    return false;
                }

                var currentIndex = this.indexValues.indexOf(indexValue);
                for (var i = 0; i < this.indexValues.length; i++) {
                    if (i != currentIndex && indexValue.value == this.indexValues[i].value) {
                        return false;
                    }
                }

                return true;
            },

            submit: function () {
                var me = this;
                var indexDto = {
                    id: this.id,
                    name: this.indexName,
                    description: this.indexDescription,
                    type: this.indexType,
                };

                if (this.indexType == 'list' || this.indexType == 'string') {
                    indexDto.indexPatterns = this.indexPatterns.map(function (indexPattern) {
                        return {
                            pattern: indexPattern.pattern,
                            replace: indexPattern.replace,
                            isRegex: indexPattern.patternType == 'charArray' ? false : true
                        }
                    });

                    if (this.indexType == 'list') {
                        indexDto.values = this.indexValues.map(function (indexValue) {
                            return indexValue.value;
                        });
                    }
                }

                var url = 'api/documents/classes/' + this.documentClassId + '/indexes/add';
                if (this.isUpdate) {
                    url = 'api/documents/classes/' + this.documentClassId + '/indexes/update';
                }

                jQuery.ajax({
                    method: 'POST',
                    url: url,
                    contentType: 'application/json; charset=utf-8',
                    data: JSON.stringify(indexDto),
                    success: function (response) {
                        if (me.isUpdate) {
                            PW.ui.Message.success(PW.t('Indeks_zostal_zmieniony'));
                            me.rewriteIndex(response);
                        }
                        else {
                            PW.ui.Message.success(PW.t('Indeks_zostal_dodany'));
                        }
                        new AjaxJspTag.PreFunctionUpdateInvoke({href: "Indecies.do?docclassId=" + me.documentClassId,
                	        id: "tabContent3"
                        });
                    },
                    error: function (event) {
                        var response = event.responseJSON;
                        if (response && response.message) {
                            PW.ui.Message.error(response.message);
                        }
                        else {
                            PW.ui.Message.error(PW.t('unkownErrorText'));
                        }
                    }
                })
            }
        }
    });
</script>

<div id="index-form">
	    <div v-if="isUpdate" class="message-box warning">
	        <label>{{message}}</label>
	    </div>
	    <table class="form-table">
	        <tr>
	            <td><label><bean:message key="Nazwa_indeksu"/></label></td>
	            <td><input v-model="indexName" name="indexName" type="text"/></td>
	        </tr>
	        <tr>
	            <td><label><bean:message key="Opis_indeksu"/></label></td>
	            <td><input v-model="indexDescription" name="indexDescription" type="text"></td>
	        </tr>
	        <tr>
	            <td><label><bean:message key="Typ_indeksu"/></label></td>
	            <td>
	                <SELECT v-model="indexType" name="indexType" :disabled="isUpdate && !canEdit">
	                    <OPTION value="integer"><bean:message key="Calkowity"/></OPTION>
	                    <OPTION value="float"><bean:message key="Zmiennoprzecinkowy"/></OPTION>
	                    <OPTION value="string"><bean:message key="Tekstowy"/></OPTION>
	                    <OPTION value="date"><bean:message key="Data"/></OPTION>
	                    <OPTION value="dateTime"><bean:message key="Data_i_czas"/></OPTION>
	                    <OPTION value="list"><bean:message key="Lista_wartosci"/></OPTION>
	                    <OPTION value="boolean"><bean:message key="IndexType.boolean"/></OPTION>
	                </SELECT>
	            </td>
	        </tr>
	        <tr v-if="indexType == 'list'">
	            <td><bean:message key="Wartosci"/></td>
	            <td>
	                <div style="display: flex" v-for="indexValue in indexValues">
	                    <input type="text"
	                           placeholder="<bean:message key="Wpisz_wartosc" />"
	                           v-model="indexValue.value"
	                           :class="{'invalid-input': !isValueValid(indexValue)}"
	                           @paste="onValuePaste($event, indexValue)"/>
	                    <div @click="deleteIndexValue(indexValue)" class="dvnt-icon-minus-circle dvnt-red-icon index-delete-form-trigger"></div>
	                </div>
	                <div @click="addIndexValue" class="index-form-trigger dvnt-icon-plus-circle dvnt-green-icon"/>
	            </td>
	        </tr>
	        <tr v-show="indexType == 'list' || indexType == 'string'">
	            <td>
	                <span><bean:message key="Podmiana_wartosci_indeksu"/></span>
	                <div ref="valueReplacement" class="tooltip-image"></div>
	            </td>
	            <td>
	                <div v-for="indexPattern in indexPatterns" class="flex-container">
	                    <select v-model="indexPattern.patternType">
	                        <option value="charArray"><bean:message key="Ciag_znakow"/></option>
	                        <option value="regex"><bean:message key="Wyrazenie_regularne"/></option>
	                    </select>
	                    <input type="text"
	                           placeholder="<bean:message key="Wzorzec"/>"
	                           v-model="indexPattern.pattern"
	                           :class="{'invalid-input': !isPatternValid(indexPattern)}"/>
	                    <input type="text"
	                           placeholder="<bean:message key="Podstawienie"/>"
	                           v-model="indexPattern.replace"/>
	                    <div @click="deletePattern(indexPattern)" class="dvnt-icon-minus-circle dvnt-red-icon index-delete-form-trigger"></div>
	                </div>
	                <div @click="addPattern" class="index-form-trigger dvnt-icon-plus-circle dvnt-green-icon"/>
	            </td>
	        </tr>
	        <tr class="buttons">
	            <td></td>
	            <td>
	                <button class="form-button" @click="submit"
	                        :disabled="!isValid"
	                        :class="{ 'form-button-disabled' : !isValid }">
	                    {{buttonMessage}}
	                </button>
	            </td>
	        </tr>
	    </table>
</div>