/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support;

import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.XpdlKey;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.plusmpm.util.documents.handlers.DocumentHandlerTypes;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassAction;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.archive.ActionSourceDto;
import com.suncode.pwfl.web.dto.archive.ActionTypeDto;
import com.suncode.pwfl.web.dto.archive.ActionValueDto;
import com.suncode.pwfl.web.dto.archive.CreateDocumentClassActionDto;
import com.suncode.pwfl.web.dto.archive.DocumentClassActionDto;
import com.suncode.pwfl.web.dto.archive.DocumentClassActionMappingDto;
import com.suncode.pwfl.web.dto.archive.ReadDocumentClassDto;
import com.suncode.pwfl.web.dto.archive.UpdateDocumentClassActionDto;
import com.suncode.pwfl.web.support.DocumentClassMapper;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessType;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class DocumentClassActionMapper {
    private final ProcessService processService;
    private final DocumentClassService documentClassService;
    private final DocumentClassMapper documentClassMapper;
    private final MessageHelperBean messageHelper;

    public DocumentClassAction toEntity(CreateDocumentClassActionDto createDocClassActionDto) {
        DocumentClassAction documentClassAction = new DocumentClassAction();
        String errorMessage = this.messageHelper.getMessage("Jedno_z_wymaganych_pol_jest_puste");
        Assert.notNull((Object)createDocClassActionDto.getName(), (String)errorMessage);
        Assert.notNull((Object)createDocClassActionDto.getSource(), (String)errorMessage);
        Assert.notNull((Object)createDocClassActionDto.getType(), (String)errorMessage);
        Assert.notNull((Object)createDocClassActionDto.getValue(), (String)errorMessage);
        documentClassAction.setName(createDocClassActionDto.getName().trim());
        documentClassAction.setSource(createDocClassActionDto.getSource().getValue());
        documentClassAction.setInvokeForNewVersion(createDocClassActionDto.getInvokeForNewVersion());
        documentClassAction.setType(createDocClassActionDto.getType().getValue());
        documentClassAction.setValue(createDocClassActionDto.getValue().getValue());
        String value2 = this.joinMappings(createDocClassActionDto.getMappings());
        documentClassAction.setValue2(value2);
        return documentClassAction;
    }

    public DocumentClassAction toEntity(UpdateDocumentClassActionDto updateDocClassActionDto) {
        DocumentClassAction documentClassAction = new DocumentClassAction();
        String errorMessage = this.messageHelper.getMessage("Jedno_z_wymaganych_pol_jest_puste");
        Assert.notNull((Object)updateDocClassActionDto.getName(), (String)errorMessage);
        Assert.notNull((Object)updateDocClassActionDto.getSource(), (String)errorMessage);
        Assert.notNull((Object)updateDocClassActionDto.getType(), (String)errorMessage);
        Assert.notNull((Object)updateDocClassActionDto.getValue(), (String)errorMessage);
        DocumentClass documentClass = (DocumentClass)this.documentClassService.get((Serializable)updateDocClassActionDto.getDocumentClassId());
        Assert.notNull((Object)documentClass, (String)this.messageHelper.getMessage("Nie_znaleziono_klasy_dokumentow", new Object[]{updateDocClassActionDto.getDocumentClassId()}));
        documentClassAction.setDocumentClass(documentClass);
        documentClassAction.setId(updateDocClassActionDto.getId());
        documentClassAction.setName(updateDocClassActionDto.getName().trim());
        documentClassAction.setSource(updateDocClassActionDto.getSource().getValue());
        documentClassAction.setInvokeForNewVersion(updateDocClassActionDto.getInvokeForNewVersion());
        documentClassAction.setType(updateDocClassActionDto.getType().getValue());
        documentClassAction.setValue(updateDocClassActionDto.getValue().getValue());
        String value2 = this.joinMappings(updateDocClassActionDto.getMappings());
        documentClassAction.setValue2(value2);
        return documentClassAction;
    }

    public DocumentClassActionDto toDocumentClassActionDto(DocumentClassAction entity) {
        ArrayList<DocumentClassActionMappingDto> mappings = StringUtils.isNotBlank((CharSequence)entity.getValue2()) ? this.prepareActionMappings(entity.getValue2(), entity.getValue()) : new ArrayList<DocumentClassActionMappingDto>();
        DocumentEventTypes documentEventType = Arrays.stream(DocumentEventTypes.values()).filter(type -> type.value.equals(entity.getSource())).findFirst().orElseThrow(() -> new IllegalArgumentException(this.messageHelper.getMessage("Nieobslugiwany_typ_zdarzenia")));
        DocumentHandlerTypes documentHandlerType = Arrays.stream(DocumentHandlerTypes.values()).filter(handlerType -> handlerType.value.equals(entity.getType())).findFirst().orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Nieprawidlowa_nazwa_typu_akcji", new Object[]{entity.getType()})));
        ReadDocumentClassDto documentClassDto = entity.getDocumentClass() != null ? this.documentClassMapper.toReadDocumentClassDto(entity.getDocumentClass()) : null;
        return DocumentClassActionDto.builder().id(entity.getId()).name(entity.getName()).source(this.toActionSourceDto(documentEventType)).invokeForNewVersion(entity.getInvokeForNewVersion()).type(this.toActionTypeDto(documentHandlerType)).value(this.toActionValueDto(entity)).mappings(mappings).documentClass(documentClassDto).build();
    }

    public String getFormattedMappings(List<DocumentClassActionMappingDto> mappings) {
        if (CollectionUtils.isEmpty(mappings)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        mappings.forEach(mapping -> stringBuilder.append(String.format("%s -> %s;", mapping.getTranslatedIndexName(), mapping.getTranslatedVariableName())));
        return stringBuilder.toString();
    }

    public ActionSourceDto toActionSourceDto(DocumentEventTypes documentEventType) {
        List<ActionTypeDto> allowedActionTypes = documentEventType.allowedActionTypes.stream().map(this::toActionTypeDto).collect(Collectors.toList());
        return ActionSourceDto.builder().name(this.messageHelper.getMessage(documentEventType.value)).value(documentEventType).allowedActionTypes(allowedActionTypes).build();
    }

    private ActionTypeDto toActionTypeDto(DocumentHandlerTypes documentHandlerType) {
        return ActionTypeDto.builder().name(this.messageHelper.getMessage(documentHandlerType.value)).value(documentHandlerType).build();
    }

    private ActionValueDto toActionValueDto(DocumentClassAction entity) {
        Optional<ProcessType> processType;
        String value = entity.getValue();
        if (!entity.getHandlerType().equals((Object)DocumentHandlerTypes.RUN_SCRIPT) && (processType = this.processService.getAllProcessTypes(false).stream().filter(procType -> procType.getProcessDefId().equals(entity.getValue())).findFirst()).isPresent()) {
            I18Nxpdl i18Nxpdl = new I18Nxpdl();
            value = i18Nxpdl.getString(XpdlKey.forPackage((String)processType.get().getPackageId()).forProcess(processType.get().getProcessDefId()).getKey());
        }
        return ActionValueDto.builder().name(value).value(entity.getValue()).build();
    }

    private List<DocumentClassActionMappingDto> prepareActionMappings(String mappings, String processDefId) {
        if (StringUtils.isBlank((CharSequence)mappings)) {
            return Collections.emptyList();
        }
        Package pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(processDefId);
        if (pack == null) {
            return Collections.emptyList();
        }
        WorkflowProcess workflowProcess = pack.getWorkflowProcess(processDefId);
        if (workflowProcess == null) {
            return Collections.emptyList();
        }
        I18Nxpdl i18Nxpdl = new I18Nxpdl();
        return Arrays.stream(mappings.split("&")).map(mapping -> {
            Long documentClassIndexId = Long.valueOf(mapping.substring(0, mapping.indexOf("=")));
            String variableId = mapping.substring(mapping.indexOf("=") + 1);
            String translatedIndexName = StringEscapeUtils.escapeXml((String)this.documentClassService.getDocumentClassIndexTranslation(documentClassIndexId, TranslatedFieldType.NAME));
            DataField dataField = workflowProcess.getDataField(variableId);
            String translatedVariableName = dataField != null ? i18Nxpdl.getString(XpdlKey.forPackage((String)pack.getId()).forProcess(processDefId).forDataField(dataField.getId()).getKey()) : variableId;
            return DocumentClassActionMappingDto.builder().indexId(documentClassIndexId).variableId(variableId).translatedIndexName(StringUtils.isNotBlank((CharSequence)translatedIndexName) ? translatedIndexName : documentClassIndexId.toString()).translatedVariableName(translatedVariableName).build();
        }).collect(Collectors.toList());
    }

    private String joinMappings(List<DocumentClassActionMappingDto> mappings) {
        return mappings != null ? mappings.stream().map(mapping -> String.format("%s=%s", mapping.getIndexId(), mapping.getVariableId())).collect(Collectors.joining("&")) : "";
    }

    @ConstructorProperties(value={"processService", "documentClassService", "documentClassMapper", "messageHelper"})
    @Autowired
    public DocumentClassActionMapper(ProcessService processService, DocumentClassService documentClassService, DocumentClassMapper documentClassMapper, MessageHelperBean messageHelper) {
        this.processService = processService;
        this.documentClassService = documentClassService;
        this.documentClassMapper = documentClassMapper;
        this.messageHelper = messageHelper;
    }
}

