/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.filter;

import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class HttpHeaderSecurity
extends OncePerRequestFilter {
    protected void doFilterInternal(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain) throws ServletException, IOException {
        String referrerPolicy;
        String contentSecurityPolicy;
        if (!SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.HTTP_HEADER_SECURITY_SAMEORIGIN_DISABLED).booleanValue()) {
            httpResponse.setHeader("X-Frame-Options", "SAMEORIGIN");
        }
        if (StringUtils.isNotBlank((CharSequence)(contentSecurityPolicy = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.HTTP_HEADER_SECURITY_CONTENT_SECURITY_POLICY)))) {
            httpResponse.setHeader("Content-Security-Policy", contentSecurityPolicy);
        }
        if (!SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.HTTP_HEADER_SECURITY_NOSNIFF_DISABLED).booleanValue()) {
            httpResponse.setHeader("X-Content-Type-Options", "nosniff");
        }
        if (StringUtils.isNotBlank((CharSequence)(referrerPolicy = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.HTTP_HEADER_SECURITY_REFERRER_POLICY)))) {
            httpResponse.setHeader("Referrer-Policy", referrerPolicy);
        }
        filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }
}

