/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.filter;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.user.UserInfoCache;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.filter.urllist.UrlListItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UrlPathHelper;

public class AnonymousUserFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AnonymousUserFilter.class);
    private static final List<UrlListItem> WHITELIST = new ArrayList<UrlListItem>(){
        {
            this.add(UrlListItem.basicUrlItem("/UserDashboard.do"));
            this.add(UrlListItem.basicUrlItem("/CreateProcess.do"));
            this.add(UrlListItem.basicUrlItem("/ProcesActivity.do"));
            this.add(UrlListItem.basicUrlItem("/ViewProcessesToStart.do"));
            this.add(UrlListItem.basicUrlItem("/Login.do"));
            this.add(UrlListItem.basicUrlItem("/LoginManual.do"));
            this.add(UrlListItem.basicUrlItem("/Logout.do"));
            this.add(UrlListItem.basicUrlItem("/ShowGadget.do"));
            this.add(UrlListItem.basicUrlItem("/ShowUserDefaultView.do"));
            this.add(UrlListItem.basicUrlItem("/default.do"));
            this.add(UrlListItem.basicUrlItem("/"));
            this.add(UrlListItem.basicUrlItem("/com.plusmpm.servlet.GetDataChooserContentServlet.customServlet"));
            this.add(UrlListItem.basicUrlItem("/ShowFile.do"));
            this.add(UrlListItem.basicUrlItem("/ShowDocumentInformation.do"));
            this.add(UrlListItem.basicUrlItem("/WorkflowViews.do"));
            this.add(UrlListItem.basicUrlItem("/NewAdvanceProcessSearchView.do"));
            this.add(UrlListItem.basicUrlItem("/SearchAdvanceUserView.do"));
            this.add(UrlListItem.basicUrlItem("/ShowWorkListAction.do"));
            this.add(UrlListItem.basicUrlItem("/CUF.ImportDTFromExcel.customServlet"));
            this.add(UrlListItem.basicUrlItem("/CUF.ExportDTToExcel.customServlet"));
            this.add(UrlListItem.basicUrlItem("/com.plusmpm.servlet.DocumentInformationServlet.customServlet"));
            this.add(UrlListItem.basicUrlItem("/api/*"));
            this.add(UrlListItem.basicUrlItem("/plugin/*"));
            this.add(UrlListItem.basicUrlItem("/style/*"));
            this.add(UrlListItem.basicUrlItem("/resources/*"));
            this.add(UrlListItem.basicUrlItem("/scripts/*"));
            this.add(UrlListItem.basicUrlItem("/ShowDocumentFromArchive.do"));
        }
    };
    private static final List<UrlListItem> BLACKLIST = new ArrayList<UrlListItem>(){
        {
            this.add(UrlListItem.basicUrlItem("/api/activities/advanced/my/*"));
        }
    };

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpSession session = httpServletRequest.getSession();
        String username = (String)session.getAttribute("username");
        if (username != null && UserInfoCache.get().get(username).isAnonymous()) {
            UrlPathHelper pathHelper = new UrlPathHelper();
            String requestUrl = pathHelper.getPathWithinApplication(httpServletRequest);
            Optional<UrlListItem> whiteListItem = this.getWhiteListItem(requestUrl);
            if (whiteListItem.isPresent() && this.isActionPermitted(whiteListItem.get(), httpServletRequest, username)) {
                if (this.getBlackListItem(requestUrl).isPresent()) {
                    ((HttpServletResponse)servletResponse).setStatus(400);
                    servletResponse.getWriter().write("Access Denied ");
                } else {
                    filterChain.doFilter(servletRequest, servletResponse);
                }
            } else {
                ((HttpServletResponse)servletResponse).setStatus(400);
                servletResponse.getWriter().write("Access Denied ");
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private boolean isActionPermitted(UrlListItem whiteListItem, HttpServletRequest httpServletRequest, String username) {
        String documentClassName;
        String type;
        if (whiteListItem.getUrl().startsWith("/ShowDocumentFromArchive.do") && "docclass".equals(type = httpServletRequest.getParameter("type")) && StringUtils.isNotBlank((CharSequence)(documentClassName = httpServletRequest.getParameter("objectName")))) {
            DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
            DocumentClass documentClass = documentClassService.getDocumentClass(documentClassName, new String[0]);
            int checkRight = Authorization.checkRight((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)documentClass.getId()).build(), (String)username, (boolean)false, (boolean)false);
            return checkRight == 0 || checkRight == 1;
        }
        return true;
    }

    private Optional<UrlListItem> getWhiteListItem(String url) {
        return this.getListItem(url, WHITELIST);
    }

    private Optional<UrlListItem> getBlackListItem(String url) {
        return this.getListItem(url, BLACKLIST);
    }

    private Optional<UrlListItem> getListItem(String url, List<UrlListItem> list) {
        return list.stream().filter(item -> this.isUrlOnWhitelist(item.getUrl(), url)).findFirst();
    }

    private boolean isUrlOnWhitelist(String whitelistUrl, String url) {
        return whitelistUrl.endsWith("*") ? url.contains(whitelistUrl.substring(0, whitelistUrl.length() - 1)) : url.equals(whitelistUrl);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

