/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.archive;

import com.plusmpm.database.files.ExtendedDocumentData;
import com.plusmpm.util.DocumentData;
import com.plusmpm.util.IndexData;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.archive.LinkIndex;
import com.suncode.pwfl.archive.WfDocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class DocumentDto {
    private Long documentId;
    private Long fileId;
    private Long documentClassId;
    private List<IndexInfo> indexes = new ArrayList<IndexInfo>();
    private Integer associatedDocumentsCount;

    public static DocumentDto fromDocumentClass(ExtendedDocumentData doc, Set<DocumentClassIndex> indexDefinitions) {
        DocumentDto dto = new DocumentDto();
        dto.setDocumentId(doc.getLDocumentId());
        dto.setFileId(doc.getLFileId());
        dto.setDocumentClassId(doc.getLDocClassId());
        dto.setIndexes(DocumentDto.buildIndexes(doc.getAlIndecies(), indexDefinitions));
        return dto;
    }

    private static List<IndexInfo> buildIndexes(List<IndexData> indexes, Set<DocumentClassIndex> indexesDefinition) {
        ArrayList<IndexInfo> idxs = new ArrayList<IndexInfo>();
        for (IndexData index : indexes) {
            DocumentClassIndex definition = DocumentDto.getDocClassIndexDefinition(index.getId(), indexesDefinition);
            IndexType type = definition.getType();
            IndexInfo idx = new IndexInfo(Long.valueOf(index.getId()), definition.getName(), DocumentDto.resolveValue(type.parse(index.getValue()), type), type);
            idxs.add(idx);
        }
        return idxs;
    }

    public static DocumentDto fromDocument(WfDocument document) {
        DocumentDto dto = new DocumentDto();
        dto.setDocumentId(document.getId());
        dto.setFileId(document.getFile().getId());
        dto.setDocumentClassId(document.getDocumentClassId());
        dto.setIndexes(document.getIndexes());
        return dto;
    }

    private static DocumentClassIndex getDocClassIndexDefinition(Long indexId, Set<DocumentClassIndex> indexesDefinition) {
        for (DocumentClassIndex index : indexesDefinition) {
            if (!index.getId().equals(indexId)) continue;
            return index;
        }
        return null;
    }

    public static DocumentDto fromLink(DocumentData doc, List<LinkIndex> indexDefinitions) {
        DocumentDto dto = new DocumentDto();
        dto.setDocumentId(doc.getLDocumentId());
        dto.setFileId(doc.getLFileId());
        dto.setDocumentClassId(doc.getLDocClassId());
        dto.setIndexes(DocumentDto.buildLinkIndexes(doc.getAlIndecies(), indexDefinitions));
        return dto;
    }

    private static List<IndexInfo> buildLinkIndexes(List<IndexData> indexes, List<LinkIndex> indexDefinitions) {
        ArrayList<IndexInfo> idxs = new ArrayList<IndexInfo>();
        for (IndexData index : indexes) {
            Optional<LinkIndex> indexDefinition = DocumentDto.getLinkIndexDefinition(index.getId(), indexDefinitions);
            if (!indexDefinition.isPresent()) continue;
            IndexType type = IndexType.getType((String)indexDefinition.get().getType());
            IndexInfo idx = new IndexInfo(Long.valueOf(index.getId()), indexDefinition.get().getName(), DocumentDto.resolveValue(type.parse(index.getValue()), type), type);
            idxs.add(idx);
        }
        return idxs;
    }

    private static Optional<LinkIndex> getLinkIndexDefinition(Long indexId, List<LinkIndex> indexDefinitions) {
        return indexDefinitions.stream().filter(linkIndex -> linkIndex.getId().equals(indexId)).findFirst();
    }

    private static Object resolveValue(Object value, IndexType type) {
        if (type == IndexType.DATE && value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            return date.toString("yyyy-MM-dd");
        }
        if (type == IndexType.DATETIME && value instanceof LocalDateTime) {
            LocalDateTime date = (LocalDateTime)value;
            return date.toString("yyyy-MM-dd HH:mm:ss");
        }
        return value;
    }

    public Long getDocumentId() {
        return this.documentId;
    }

    public Long getFileId() {
        return this.fileId;
    }

    public Long getDocumentClassId() {
        return this.documentClassId;
    }

    public List<IndexInfo> getIndexes() {
        return this.indexes;
    }

    public Integer getAssociatedDocumentsCount() {
        return this.associatedDocumentsCount;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public void setDocumentClassId(Long documentClassId) {
        this.documentClassId = documentClassId;
    }

    public void setIndexes(List<IndexInfo> indexes) {
        this.indexes = indexes;
    }

    public void setAssociatedDocumentsCount(Integer associatedDocumentsCount) {
        this.associatedDocumentsCount = associatedDocumentsCount;
    }
}

