/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.process;

import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.experimental.ExperimentalFeature;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.EntityRestResult;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.workflow.process.protections.ProcessProtectionDto;
import com.suncode.pwfl.workflow.process.protections.ProcessProtectionService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"processes/definition/{processDefId}/protections"})
public class ProcessProtectionController {
    @Autowired
    private ProcessProtectionService processProtectionService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private MessageHelperBean messageHelper;
    @Autowired
    private ExportService exportService;
    @Autowired
    private Experimental experimental;

    @ResponseBody
    @RequestMapping(value={"global"}, method={RequestMethod.GET})
    public ProcessProtectionDto getGlobalProtection(@PathVariable String processDefId, @RequestParam String resourceId, @RequestParam boolean isGroup) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.processProtectionService.getGlobalProcessProtection(processDefId, resourceId, isGroup);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    public CountedResult<ProcessProtectionDto> getProcessProtections(@PathVariable String processDefId, @RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false, defaultValue="resourceId") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List processProtections = this.processProtectionService.getProcessProtectionsForProcess(processDefId).stream().sorted(DtoComparator.of(ProcessProtectionDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        return Paginator.forAll(processProtections).pageByOffset(start, limit);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public RestResult addProcessProtection(HttpServletRequest request, @RequestBody ProcessProtectionDto processProtectionDto, @PathVariable String processDefId) {
        Map processProtections;
        Map<String, Object> params = this.createAddProtectionAudit(processProtectionDto);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_PROCESS_PROTECTION).params(params);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        if (StringUtils.isBlank((String)processProtectionDto.getProcessDefId()) || !processProtectionDto.getProcessDefId().equals(processDefId)) {
            throw new ServiceException(this.messageHelper.getMessage("Nieprawidlowa_definicja_procesu"));
        }
        processProtectionDto.setIsGlobal(Boolean.valueOf(false));
        try {
            processProtections = this.processProtectionService.addProcessProtection(processProtectionDto);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw new ServiceException((Throwable)e);
        }
        auditBuilder.buildSuccess(request);
        return EntityRestResult.success((Object)processProtections);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.PUT})
    public RestResult editProcessProtection(HttpServletRequest request, @RequestBody ProcessProtectionDto processProtectionDto, @PathVariable String processDefId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_PROCESS_PROTECTION);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        if (StringUtils.isBlank((String)processProtectionDto.getProcessDefId()) || !processProtectionDto.getProcessDefId().equals(processDefId)) {
            throw new ServiceException(this.messageHelper.getMessage("Nieprawidlowa_definicja_procesu"));
        }
        ProcessProtectionDto protectionToChange = this.processProtectionService.getProcessProtectionsForProcess(processProtectionDto.getProcessDefId()).stream().filter(protection -> protection.getResourceId().equals(processProtectionDto.getResourceId()) && protection.getIsGroup().equals(processProtectionDto.getIsGroup())).filter(protection -> protection.getIsGlobal() == false).findFirst().orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Nie_znaleziono_uprawnien_do_zmiany")));
        auditBuilder.params(this.createEditProtectionAudit(protectionToChange, processProtectionDto));
        processProtectionDto.setIsGlobal(Boolean.valueOf(false));
        try {
            this.processProtectionService.editProcessProtection(processProtectionDto);
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw new ServiceException((Throwable)e);
        }
    }

    private Map<String, Object> createAddProtectionAudit(ProcessProtectionDto processProtectionDto) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("userName", processProtectionDto.getResourceId());
        auditParams.put("isGroup", BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getIsGroup()));
        auditParams.put("procTypeId", processProtectionDto.getProcessDefId());
        auditParams.put("viewProcess", BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getHasPreviewRight()));
        auditParams.put("createProcess", BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getHasCreatingRight()));
        auditParams.put("deleteProcess", BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getHasDeletingRight()));
        auditParams.put("statsProcess", BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getHasStatisticsRight()));
        auditParams.put("historyProcess", BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getHasProcessHistoriesRight()));
        auditParams.put("historyCommentsProcess", BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getHasHistoryCommentsRight()));
        if (this.experimental.hasFeature(ExperimentalFeature.PROCESS_DASHBOARDS)) {
            auditParams.put("processDashboardAccessProcess", BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getHasProcessDashboardAccessRight()));
        }
        return auditParams;
    }

    private Map<String, Object> createEditProtectionAudit(ProcessProtectionDto protectionToChange, ProcessProtectionDto processProtectionDto) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("userName", processProtectionDto.getResourceId());
        auditParams.put("isGroup", BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getIsGroup()));
        auditParams.put("procTypeId", processProtectionDto.getProcessDefId());
        auditParams.put("viewProcess", String.format("%s;%s", BooleanUtils.toStringTrueFalse((Boolean)protectionToChange.getHasPreviewRight()), BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getHasPreviewRight())));
        auditParams.put("createProcess", String.format("%s;%s", BooleanUtils.toStringTrueFalse((Boolean)protectionToChange.getHasCreatingRight()), BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getHasCreatingRight())));
        auditParams.put("deleteProcess", String.format("%s;%s", BooleanUtils.toStringTrueFalse((Boolean)protectionToChange.getHasDeletingRight()), BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getHasDeletingRight())));
        auditParams.put("statsProcess", String.format("%s;%s", BooleanUtils.toStringTrueFalse((Boolean)protectionToChange.getHasStatisticsRight()), BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getHasStatisticsRight())));
        auditParams.put("historyProcess", String.format("%s;%s", BooleanUtils.toStringTrueFalse((Boolean)protectionToChange.getHasProcessHistoriesRight()), BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getHasProcessHistoriesRight())));
        auditParams.put("historyCommentsProcess", String.format("%s;%s", BooleanUtils.toStringTrueFalse((Boolean)protectionToChange.getHasHistoryCommentsRight()), BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getHasHistoryCommentsRight())));
        if (this.experimental.hasFeature(ExperimentalFeature.PROCESS_DASHBOARDS)) {
            auditParams.put("processDashboardAccessProcess", String.format("%s;%s", BooleanUtils.toStringTrueFalse((Boolean)protectionToChange.getHasProcessDashboardAccessRight()), BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getHasProcessDashboardAccessRight())));
        }
        return auditParams;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.DELETE})
    public RestResult deleteProcessProtection(HttpServletRequest request, @RequestBody ProcessProtectionDto processProtectionDto, @PathVariable String processDefId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PROCESS_PROTECTION);
        HashMap<String, String> auditParams = new HashMap<String, String>();
        auditParams.put("userId", StringUtils.defaultString((String)processProtectionDto.getResourceId()));
        auditParams.put("isGroup", BooleanUtils.toStringTrueFalse((Boolean)processProtectionDto.getIsGroup()));
        auditParams.put("procTypeId", StringUtils.defaultString((String)processProtectionDto.getProcessDefId()));
        auditBuilder.params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        if (StringUtils.isBlank((String)processProtectionDto.getProcessDefId()) || !processProtectionDto.getProcessDefId().equals(processDefId)) {
            throw new ServiceException(this.messageHelper.getMessage("Nieprawidlowa_definicja_procesu"));
        }
        try {
            this.processProtectionService.deleteProcessProtection(processProtectionDto);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @RequestMapping(value={"export/{extension}"}, method={RequestMethod.GET})
    public void exportProcessProtections(HttpServletResponse response, @PathVariable String processDefId, @PathVariable String extension, @RequestParam(required=false, defaultValue="resourceId") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<ProcessProtectionDto> processProtections = this.processProtectionService.getProcessProtectionsForProcess(processDefId).stream().sorted(DtoComparator.of(ProcessProtectionDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        ArrayList<ExportColumn> columns = new ArrayList<ExportColumn>(Arrays.asList(this.buildExportColumn(this.messageHelper.getMessage("Nazwa_uzytkownika_grupy"), processProtections, ProcessProtectionDto::getResourceId), this.buildExportColumn(this.messageHelper.getMessage("Grupa"), processProtections, processProtection -> this.getBooleanTranslation(processProtection.getIsGroup())), this.buildExportColumn(this.messageHelper.getMessage("Podglad"), processProtections, processProtection -> this.getBooleanTranslation(processProtection.getHasPreviewRight())), this.buildExportColumn(this.messageHelper.getMessage("Tworzenie"), processProtections, processProtection -> this.getBooleanTranslation(processProtection.getHasCreatingRight())), this.buildExportColumn(this.messageHelper.getMessage("Usuwanie"), processProtections, processProtection -> this.getBooleanTranslation(processProtection.getHasDeletingRight())), this.buildExportColumn(this.messageHelper.getMessage("Statystyki"), processProtections, processProtection -> this.getBooleanTranslation(processProtection.getHasStatisticsRight())), this.buildExportColumn(this.messageHelper.getMessage("Historie_wszystkich_procesow"), processProtections, processProtection -> this.getBooleanTranslation(processProtection.getHasProcessHistoriesRight())), this.buildExportColumn(this.messageHelper.getMessage("Komentowanie_zadania_na_dowolnym_etapie"), processProtections, processProtection -> this.getBooleanTranslation(processProtection.getHasHistoryCommentsRight()))));
        if (this.experimental.hasFeature(ExperimentalFeature.PROCESS_DASHBOARDS)) {
            columns.add(this.buildExportColumn(this.messageHelper.getMessage("Dostep_do_pulpitu_procesowego"), processProtections, processProtection -> this.getBooleanTranslation(processProtection.getHasProcessDashboardAccessRight())));
        }
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Uprawnienia")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private String getBooleanTranslation(boolean bool) {
        return bool ? this.messageHelper.getMessage("Tak") : this.messageHelper.getMessage("Nie");
    }

    private ExportColumn buildExportColumn(String name, List<ProcessProtectionDto> data, Function<ProcessProtectionDto, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsExceptionException(NotFullRightsException e) {
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ExceptionHandler(value={ServiceException.class, IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(Exception e) {
        return new RestResult(false, e.getMessage());
    }
}

