/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.process;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.AdvanceSearchVariableTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.util.CoreTools;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.substitution.SubstitutionHook;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.form.dto.history.HistoryDto;
import com.suncode.pwfl.form.service.HistoryService;
import com.suncode.pwfl.hook.HookRegistry;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.i18n.xpdl.PackageTranslationHelper;
import com.suncode.pwfl.language.LanguageUtils;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.CollatorInstance;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.SharkUtils;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.view.ViewService;
import com.suncode.pwfl.view.dto.ViewDto;
import com.suncode.pwfl.web.controller.api.workflow.process.ActivityDefinitionIdAndNameDto;
import com.suncode.pwfl.web.dto.archive.ProcessTypeDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NoRightsException;
import com.suncode.pwfl.web.support.ajax.ResponseMessageLevel;
import com.suncode.pwfl.web.support.ajax.RestResponse;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.assignment.WfParticipant;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessDataService;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessType;
import com.suncode.pwfl.workflow.process.util.CreateProcessResult;
import com.suncode.pwfl.workflow.process.util.ProcessBuilderDefinition;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/processes"})
public class ProcessController {
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ProcessDataService processDataService;
    @Autowired
    private ExportService exportService;
    @Autowired
    private MessageHelperBean messageHelper;
    @Autowired
    private ViewService viewService;
    @Autowired
    private HookRegistry hookRegistry;
    private Map<UUID, List<ProcessType>> exportCache = new HashMap<UUID, List<ProcessType>>();

    @RequestMapping(value={"{processDefId}/participants"})
    @ResponseBody
    public List<WfParticipant> getProcessParticipants(@PathVariable String processDefId) {
        return this.processService.getParticipantsFromProcess(processDefId);
    }

    @RequestMapping(value={"{processId}/history"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<List<HistoryDto>> get(@PathVariable String processId, @RequestParam(required=false) String rightKey, @RequestParam(required=false, defaultValue="true") boolean showSystemTasks) {
        return this.authorizationHelper.ensureProcessAccess(processId, rightKey, () -> this.historyService.getForProcess(processId, showSystemTasks));
    }

    @RequestMapping(value={"/definition/{processDefinitionId}/activities"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<List<ActivityDefinitionIdAndNameDto>> getActivitiesByProcessDefinitionId(@PathVariable String processDefinitionId) {
        Package pack = XpdlPackageManager.getInstance().getPackageByProcessDefinitionId(processDefinitionId);
        if (pack == null) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        WorkflowProcess workflowProcess = pack.getWorkflowProcess(processDefinitionId);
        ArrayList activities = workflowProcess.getActivities().toElements();
        List definitions = activities.stream().map(activity -> this.mapActivitytoDefinitionIdAndName((Activity)activity, pack, processDefinitionId)).collect(Collectors.toList());
        return new ResponseEntity(definitions, HttpStatus.OK);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    @ResponseBody
    public CreateProcessResult get(HttpServletRequest request, @RequestBody ProcessBuilderDefinition definition) {
        CreateProcessResult processResult;
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_PROCESS);
        HashMap<String, String> auditParameters = new HashMap<String, String>();
        if (StringUtils.isBlank((String)definition.getProcessDefId()) || StringUtils.isBlank((String)definition.getPackageId())) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Nie_podano_wymaganych_parametrow"));
        }
        ProcessDefinition processDefinition = this.processService.getProcessDefinition(definition.getProcessDefId());
        if (processDefinition == null || !processDefinition.getPackageId().equals(definition.getPackageId())) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Niepoprawne_dane_procesu"));
        }
        String rightsPath = RightTreeBuilder.builder().system().workflow().processes().create().custom((Object)definition.getProcessDefId()).build();
        this.authorizationHelper.assertFullOrPartRights(rightsPath, () -> {
            auditParameters.put("ERROR_MESSAGE", this.messageHelper.getMessage("Brak_uprawnien_aby_utworzyc_proces"));
            auditBuilder.params(auditParameters);
            auditBuilder.buildFailure(request);
        });
        definition.setCreator(SessionUtils.getLoggedUserName());
        try {
            processResult = this.processService.createProcessWithResult(definition);
        }
        catch (Exception e) {
            auditParameters.put("ERROR_MESSAGE", e.getCause().getLocalizedMessage());
            auditBuilder.params(auditParameters);
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditParameters.put("processId", definition.getProcessDefId());
        auditParameters.put("processPackageId", definition.getPackageId());
        auditParameters.put("procesName", this.processService.getProcess(processResult.getProcessId(), new String[0]).getName());
        auditBuilder.params(auditParameters);
        auditBuilder.buildSuccess(request);
        return processResult;
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public RestResponse<?> deleteProcess(HttpServletRequest request, @RequestParam String processId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PROCESS);
        auditBuilder.params(this.getAuditParams(processId));
        String processDefinitionId = SharkFunctions.getProcessDefId((String)processId);
        String rightsPath = RightTreeBuilder.builder().system().workflow().processes().delete().custom((Object)processDefinitionId).build();
        this.authorizationHelper.assertFullOrPartRights(rightsPath, () -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            String message = this.prepareProcessActionSuccessMessage(processId, processDefinitionId, this.messageHelper.getMessage("zostal_usuniety"), new I18Nxpdl(request));
            this.processService.deleteProcess(processId);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @RequestMapping(value={"/abort"})
    @ResponseBody
    public RestResponse<?> abortProcess(HttpServletRequest request, @RequestParam String processId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ABORT_PROCESS);
        auditBuilder.params(this.getAuditParams(processId));
        String processDefinitionId = SharkFunctions.getProcessDefId((String)processId);
        String rightsPath = RightTreeBuilder.builder().system().workflow().processes().delete().custom((Object)processDefinitionId).build();
        this.authorizationHelper.assertFullOrPartRights(rightsPath, () -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            this.processService.abort(processId, false);
            String message = this.prepareProcessActionSuccessMessage(processId, processDefinitionId, this.messageHelper.getMessage("zostal_anulowany"), new I18Nxpdl(request));
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @RequestMapping(value={"types"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProcessType> getTypes(@RequestParam(required=false, defaultValue="false") boolean isMobile) {
        return this.getTypesList(isMobile);
    }

    private List<ProcessType> getTypesList(boolean isMobile) {
        List processTypesList = this.processService.getProcessTypesForUser(SessionUtils.getLoggedUserName());
        if (isMobile) {
            processTypesList.removeIf(processType -> {
                String allowMobileTextValue = this.processDataService.getProcessData(processType.getProcessDefId(), "", "allowMobile");
                boolean allowMobile = true;
                if (StringUtils.isNotBlank((String)allowMobileTextValue)) {
                    allowMobile = Boolean.parseBoolean(allowMobileTextValue);
                }
                return !allowMobile;
            });
        }
        return processTypesList.stream().sorted(DtoComparator.of(ProcessType.class, (String)"name", (SortDirection)SortDirection.ASC).withIgnoreCase(true)).collect(Collectors.toList());
    }

    @RequestMapping(value={"types/export/{extension}"})
    public void typesExport(HttpServletResponse response, @RequestParam(value="query", required=false, defaultValue="") String rawQuery, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) UUID id, @PathVariable String extension) throws IOException {
        List<ProcessType> sortedProcessTypesList = id == null ? this.getProcessTypesFromQuery(rawQuery, sortBy, sortDirection) : this.getProcessTypesFromCache(id);
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_procesu")).data(sortedProcessTypesList).by(ProcessType::getName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis_procesu")).data(sortedProcessTypesList).by(ProcessType::getDescription).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Procesy")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"types/export/{extension}"}, method={RequestMethod.POST})
    @ResponseBody
    public URI typesExport(HttpServletRequest request, @RequestBody List<ProcessType> processTypesToExport, @PathVariable String extension, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws URISyntaxException {
        UUID id;
        while (this.exportCache.containsKey(id = UUID.randomUUID())) {
        }
        this.exportCache.put(id, processTypesToExport);
        URI redirectUri = URI.create(request.getRequestURI());
        redirectUri = redirectUri.getQuery() != null ? URI.create(request.getRequestURI() + String.format("&id=%s", id)) : URI.create(request.getRequestURI() + String.format("?id=%s", id));
        return redirectUri;
    }

    private List<ProcessType> getProcessTypesFromQuery(String rawQuery, String sortBy, SortDirection sortDirection) {
        boolean exactSearch = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.EXACT_SEARCH);
        String query = exactSearch ? rawQuery.trim() : rawQuery.trim().toLowerCase();
        List<ProcessType> processTypesList = exactSearch ? this.exactFilterTypes(this.getTypesList(false), query) : this.filterTypes(this.getTypesList(false), query);
        List<ProcessType> sortedProcessTypesList = processTypesList.stream().sorted(this.comparatorFor(sortBy, sortDirection)).collect(Collectors.toList());
        return sortedProcessTypesList;
    }

    private List<ProcessType> getProcessTypesFromCache(UUID id) {
        List<ProcessType> processTypes = this.exportCache.get(id);
        this.exportCache.remove(processTypes);
        return processTypes;
    }

    private List<ProcessType> filterTypes(List<ProcessType> types, String query) {
        return types.stream().filter(type -> type.getName().toLowerCase().contains(query) || type.getDescription().toLowerCase().contains(query)).collect(Collectors.toList());
    }

    private List<ProcessType> exactFilterTypes(List<ProcessType> types, String query) {
        return types.stream().filter(type -> type.getName().equals(query) || type.getDescription().equals(query)).collect(Collectors.toList());
    }

    private Comparator<ProcessType> comparatorFor(String sortBy, SortDirection sortDirection) {
        Comparator<ProcessType> comparator;
        Collator collator = CollatorInstance.get();
        switch (sortBy) {
            case "name": {
                comparator = Comparator.comparing(ProcessType::getName, collator);
                break;
            }
            case "description": {
                comparator = Comparator.comparing(ProcessType::getDescription, collator);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (sortDirection == SortDirection.DESC) {
            return comparator.reversed();
        }
        return comparator;
    }

    @ResponseBody
    @RequestMapping(value={"types/search"})
    public ResponseEntity<List<ProcessType>> getSearchProcessTypes() {
        return this.authorizationHelper.ensureSearchAccess(this::getAllProcessTypes);
    }

    @ResponseBody
    @RequestMapping(value={"types/search/{viewId}"})
    public ResponseEntity<List<ProcessType>> getSearchProcessTypes(@PathVariable String viewId) {
        if (StringUtils.isNotBlank((String)viewId) && NumberUtils.isParsable((String)viewId)) {
            AdvanceSearchVariableTable processTypeVariable;
            String processTypes;
            ViewDto view = this.viewService.getView(Long.valueOf(viewId));
            if (!view.getOwnerUsername().equals(SessionUtils.getLoggedUserName()) && StringUtils.isNotBlank((String)(processTypes = (processTypeVariable = CoreTools.getAdvanceSearchVariableByNameAndViewId((String)"processType", (String)viewId)).getValue()))) {
                List<String> viewProcessTypes = Arrays.asList(processTypes.split(";"));
                List permittedProcessTypes = this.processService.getAllProcessTypes(false).stream().filter(processType -> viewProcessTypes.contains(processType.getProcessDefId())).collect(Collectors.toList());
                return new ResponseEntity(permittedProcessTypes, HttpStatus.OK);
            }
            return new ResponseEntity(this.getAllProcessTypes(), HttpStatus.OK);
        }
        return this.authorizationHelper.ensureSearchAccess(this::getAllProcessTypes);
    }

    @RequestMapping(value={"/context"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> getContext(@RequestParam String processId) {
        return this.authorizationHelper.ensureProcessAccess(processId, null, () -> this.processService.getProcessContext(processId));
    }

    private ActivityDefinitionIdAndNameDto mapActivitytoDefinitionIdAndName(Activity activity, Package pack, String processDefinitionId) {
        String activityDefinitionId = activity.getId();
        String activityName = PackageTranslationHelper.getActivityName((String)pack.getId(), (String)processDefinitionId, (String)activityDefinitionId);
        return new ActivityDefinitionIdAndNameDto(activityDefinitionId, activityName);
    }

    @RequestMapping(value={"/types/all"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProcessTypeDto> getAllTypes(HttpServletRequest request) {
        return this.getProcessTypeDtos(request).stream().sorted((proc1, proc2) -> proc1.getTranslatedName().compareToIgnoreCase(proc2.getTranslatedName())).collect(Collectors.toList());
    }

    private List<ProcessTypeDto> getProcessTypeDtos(HttpServletRequest request) {
        I18Nxpdl xpdlTranslator = new I18Nxpdl(request);
        return this.processService.getAllProcessTypes(false).stream().map(processType -> ProcessTypeDto.of(processType, xpdlTranslator)).collect(Collectors.toList());
    }

    @RequestMapping(value={"/types/all/counted-result"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ProcessTypeDto> getAllTypesCountedResult(HttpServletRequest request, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="name") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        List processTypeDtos = this.getProcessTypeDtos(request).stream().sorted(DtoComparator.of(ProcessTypeDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        return Paginator.forAll(processTypeDtos).pageByOffset(start, limit);
    }

    @RequestMapping(value={"/types/forSubstitutions"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProcessTypeDto> getProcessTypeForSubstitutions(HttpServletRequest request, @RequestParam(required=false) String username) {
        String login = StringUtils.defaultString((String)username, (String)UserContext.current().getUser().getUserName());
        I18Nxpdl xpdlTranslator = new I18Nxpdl(request);
        return ((SubstitutionHook)this.hookRegistry.invoke(SubstitutionHook.class)).filterProcesses(login, this.processService.getAllProcessTypes(false)).stream().map(processType -> ProcessTypeDto.of(processType, xpdlTranslator)).sorted((Comparator<ProcessTypeDto>)DtoComparator.of(ProcessTypeDto.class, (String)"translatedName", (SortDirection)SortDirection.ASC).withIgnoreCase(true)).collect(Collectors.toList());
    }

    private List<ProcessType> getAllProcessTypes() {
        return this.processService.getAllProcessTypes(false).stream().filter(processType -> this.authorizationHelper.hasSearchProcessAccess(processType.getProcessDefId())).sorted((proc1, proc2) -> proc1.getName().compareToIgnoreCase(proc2.getName())).collect(Collectors.toList());
    }

    private String prepareProcessActionSuccessMessage(String processId, String processDefinitionId, String suffix, I18Nxpdl xpdl) {
        String translatedProcessName;
        try {
            WfProcess wfProcess = SharkUtils.getExecutionAdministration().getProcess(processId);
            String processName = wfProcess.name();
            translatedProcessName = LanguageUtils.getProcessName((I18Nxpdl)xpdl, (String)processName, (String)processDefinitionId);
        }
        catch (Exception e) {
            translatedProcessName = processId;
        }
        StringBuilder messageBuilder = new StringBuilder();
        String EMPTY_CHAR = " ";
        return messageBuilder.append(this.messageHelper.getMessage("Proces")).append(EMPTY_CHAR).append(translatedProcessName).append(EMPTY_CHAR).append(suffix).toString();
    }

    @ExceptionHandler(value={NoRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResponse<?> handleNoRightsException(NoRightsException e) {
        return new RestResponse(this.messageHelper.getMessage("process.action.error.forbidden.message"), ResponseMessageLevel.ERROR);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResponse<?> handleIllegalArgumentException(IllegalArgumentException e) {
        return new RestResponse(e.getMessage(), ResponseMessageLevel.ERROR);
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public RestResponse<?> handleServiceException(ServiceException e) {
        return new RestResponse(e.getMessage(), ResponseMessageLevel.ERROR);
    }

    private Map<String, Object> getAuditParams(String processId) {
        Process process = this.processService.getProcess(processId, new String[]{"processDefinition"});
        return ImmutableMap.builder().put((Object)"processId", (Object)processId).put((Object)"processDefId", (Object)process.getProcessDefinition().getProcessDefinitionId()).put((Object)"package_name", (Object)process.getProcessDefinition().getPackageId()).put((Object)"process_name", (Object)process.getRawName()).build();
    }
}

