/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.process;

import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.web.dto.activity.CommentDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/comments"})
public class CommentController {
    private final CommentService commentService;
    private final ActivityService activityService;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public CommentDto add(@RequestBody Comment comment) {
        this.authorizationHelper.assertProcessAccess(comment.getProcessId(), () -> {});
        String userId = SessionUtils.getLoggedUserName();
        comment.setUserId(userId);
        comment.setTimestamp(Long.valueOf(new Date().getTime()));
        if (this.isActivityClosed(comment.getProcessId(), comment.getActivityId())) {
            throw new RuntimeException("Cannot add comment. Activity is closed.");
        }
        Long commentId = this.commentService.createComment(comment);
        return commentId != null ? new CommentDto(comment) : null;
    }

    private boolean isActivityClosed(String processId, String activityId) {
        Activity activity = this.activityService.getActivity(processId, activityId, new String[0]);
        return !ActivityState.isOpen((ActivityState)activity.getState());
    }

    @Transactional
    @RequestMapping(value={"query"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CommentDto> query(@RequestParam(required=false) String processId, @RequestParam(required=false) String activityId) {
        if (StringUtils.isNotBlank((CharSequence)processId)) {
            this.authorizationHelper.assertProcessAccess(processId, () -> {});
        }
        if (StringUtils.isBlank((CharSequence)processId) && StringUtils.isBlank((CharSequence)activityId)) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Nie_podano_wymaganych_parametrow"));
        }
        if (StringUtils.isNotBlank((CharSequence)activityId)) {
            List comments = this.commentService.getCommentsForActivity(activityId);
            return this.commentsToDto(comments);
        }
        List comments = this.commentService.getCommentsForProcess(processId);
        return this.commentsToDto(comments);
    }

    private List<CommentDto> commentsToDto(List<Comment> comments) {
        return comments.stream().map(CommentDto::new).collect(Collectors.toList());
    }

    @RequestMapping(value={"/{commentId}"}, method={RequestMethod.GET})
    @ResponseBody
    @Transactional
    public CommentDto get(@PathVariable Long commentId) {
        Comment comment = (Comment)this.commentService.get((Serializable)commentId);
        if (comment == null) {
            return null;
        }
        this.authorizationHelper.assertProcessAccess(comment.getProcessId(), () -> {});
        return new CommentDto(comment);
    }

    @RequestMapping(value={"/{commentId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@PathVariable Long commentId) {
        Comment comment = (Comment)this.commentService.get((Serializable)commentId);
        this.authorizationHelper.assertProcessAccess(comment.getProcessId(), () -> {});
        this.commentService.deleteById(commentId);
    }

    @ConstructorProperties(value={"commentService", "activityService", "authorizationHelper", "messageHelper"})
    @Autowired
    public CommentController(CommentService commentService, ActivityService activityService, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.commentService = commentService;
        this.activityService = activityService;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }
}

