/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.archive;

import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Device;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.archive.DeviceDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.DeviceMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"devices"})
public class DeviceController {
    private static final Logger log = LoggerFactory.getLogger(DeviceController.class);
    private final ArchiveStorageService archiveStorageService;
    private final ExportService exportService;
    private final DeviceMapper deviceMapper;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DeviceDto> getDevices(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="id") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List devices = this.archiveStorageService.getAllDevices(new String[0]).stream().map(this.deviceMapper::fromEntity).sorted((Comparator<DeviceDto>)DtoComparator.of(DeviceDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        return Paginator.forAll(devices).viewPageByOffset(start, limit);
    }

    @RequestMapping(value={"/{deviceId}/directories"})
    @ResponseBody
    public List<BasicDirectoryDto> getDirectoriesForDevice(@PathVariable Long deviceId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.archiveStorageService.getDirectoriesForDevice(deviceId, new String[0]).stream().map(directory -> new BasicDirectoryDto(directory.getId(), directory.getDirectoryName())).collect(Collectors.toList());
    }

    @RequestMapping(value={"list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Device> getDevicesList() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.archiveStorageService.getAllDevices(new String[0]);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public DeviceDto getDevice(@PathVariable Long id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Device device = Optional.ofNullable(this.archiveStorageService.getDeviceById(id, new String[0])).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Urzadzenie_o_podanym_id_nie_istnieje")));
        return this.deviceMapper.fromEntity(device);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteDevice(@PathVariable Long id, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("deviceId", (Object)id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_DEVICE).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        Device device = this.archiveStorageService.getDeviceById(id, new String[0]);
        if (device == null) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(this.messageHelper.getMessage("Urzadzenie_o_podanym_id_nie_istnieje"));
        }
        auditParamsBuilder.param("deviceName", (Object)device.getDeviceName());
        auditParamsBuilder.param("devicePath", (Object)device.getDevicePath());
        auditParamsBuilder.param("deviceSize", (Object)device.getDeviceSize());
        auditBuilder.params(auditParamsBuilder.build());
        try {
            this.archiveStorageService.deleteDevice(id);
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    private ExportColumn buildExportColumn(String name, List<DeviceDto> data, Function<DeviceDto, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    @RequestMapping(value={"export/{extension}"}, method={RequestMethod.GET})
    public void export(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false, defaultValue="id") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<DeviceDto> devices = this.archiveStorageService.getAllDevices(new String[0]).stream().map(this.deviceMapper::fromEntity).sorted((Comparator<DeviceDto>)DtoComparator.of(DeviceDto.class, (String)sortBy, (SortDirection)sortDirection)).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(this.buildExportColumn(this.messageHelper.getMessage("Nazwa_urzadzenia"), devices, DeviceDto::getDeviceName), this.buildExportColumn(this.messageHelper.getMessage("Sciezka_urzadzenia"), devices, DeviceDto::getDevicePath), this.buildExportColumn(this.messageHelper.getMessage("Rozmiar_MB"), devices, deviceDto -> String.valueOf(deviceDto.getDeviceSize())), this.buildExportColumn(this.messageHelper.getMessage("Wolne_miejsce_MB"), devices, deviceDto -> String.valueOf(deviceDto.getDeviceFreeSpace())));
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Urzadzenia")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public RestResult addDevice(HttpServletRequest request, @RequestBody DeviceDto device) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("deviceName", (Object)device.getDeviceName()).param("devicePath", (Object)device.getDevicePath()).param("deviceSize", (Object)device.getDeviceSize());
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_DEVICE).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            Long deviceId = this.archiveStorageService.addDevice(this.deviceMapper.toEntity(device));
            auditParamsBuilder.param("deviceId", (Object)deviceId);
            auditBuilder.params(auditParamsBuilder.build());
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResult updateDevice(HttpServletRequest request, @PathVariable Long id, @RequestBody DeviceDto device) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("deviceId", (Object)id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_DEVICE).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        Device oldDevice = this.archiveStorageService.getDeviceById(id, new String[0]);
        if (oldDevice == null) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(this.messageHelper.getMessage("Urzadzenie_o_podanym_id_nie_istnieje"));
        }
        auditParamsBuilder.param("deviceName", (Object)String.format("%s;%s", oldDevice.getDeviceName(), device.getDeviceName()));
        auditParamsBuilder.param("devicePath", (Object)String.format("%s", oldDevice.getDevicePath()));
        auditParamsBuilder.param("deviceSize", (Object)String.format("%s;%s", oldDevice.getDeviceSize(), device.getDeviceSize()));
        auditBuilder.params(auditParamsBuilder.build());
        try {
            this.archiveStorageService.updateDevice(id, this.deviceMapper.toEntity(device));
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(ServiceException e) {
        return new RestResult(false, e.getMessage());
    }

    @ConstructorProperties(value={"archiveStorageService", "exportService", "deviceMapper", "authorizationHelper", "messageHelper"})
    @Autowired
    public DeviceController(ArchiveStorageService archiveStorageService, ExportService exportService, DeviceMapper deviceMapper, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.archiveStorageService = archiveStorageService;
        this.exportService = exportService;
        this.deviceMapper = deviceMapper;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }

    private class BasicDirectoryDto {
        private Long id;
        private String directoryName;

        public Long getId() {
            return this.id;
        }

        public String getDirectoryName() {
            return this.directoryName;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setDirectoryName(String directoryName) {
            this.directoryName = directoryName;
        }

        @ConstructorProperties(value={"id", "directoryName"})
        public BasicDirectoryDto(Long id, String directoryName) {
            this.id = id;
            this.directoryName = directoryName;
        }
    }
}

