/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.activity.advanced;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.XpdlKey;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.Exceptions;
import com.suncode.pwfl.web.controller.api.workflow.activity.advanced.ActivityMetaDto;
import com.suncode.pwfl.web.dto.archive.ProcessTypeDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.activity.ActivitiesCounter;
import com.suncode.pwfl.workflow.activity.ActivitiesProvider;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.FinishedUserActivityState;
import com.suncode.pwfl.workflow.activity.OpenUserActivityState;
import com.suncode.pwfl.workflow.activity.internal.dto.UserActivityDto;
import com.suncode.pwfl.workflow.activity.internal.dto.UserActivityStatus;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialActivityCache;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialActivityProvider;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialCacheKeyId;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialCacheSourceType;
import com.suncode.pwfl.workflow.activity.sequential.cache.activities.SequentialActivityUserActivitiesMapper;
import com.suncode.pwfl.workflow.activity.sequential.cache.activities.SequentialCacheKeyUserActivities;
import com.suncode.pwfl.workflow.activity.sequential.cache.activities.UserActivitySequentialMeta;
import com.suncode.pwfl.workflow.activity.util.UserActivityMapper;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/activities/advanced"})
public class AdvancedActivityController {
    private static final Logger log = LoggerFactory.getLogger(AdvancedActivityController.class);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private UserActivityMapper userActivityMapper;
    @Autowired
    private ExportService exportService;
    @Autowired
    private MessageHelperBean messageHelper;
    @Autowired
    private SequentialActivityCache sequentialActivityCache;
    @Autowired
    private SequentialActivityUserActivitiesMapper sequentialActivityUserActivitiesMapper;
    private Map<UUID, List<UserActivityDto>> exportCache = new HashMap<UUID, List<UserActivityDto>>();

    @RequestMapping(value={"my/open/{state}"})
    @ResponseBody
    public CountedResult<UserActivityDto> getOpenActivitiesAssignedToUserForState(HttpServletRequest request, @PathVariable String state, @RequestParam(required=false, defaultValue="") List<String> processDefinitionIds, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="activityDate") String sortBy, @RequestParam(required=false, defaultValue="DESC") SortDirection sortDirection, @RequestParam(required=false) boolean gadget) {
        boolean isCacheRequest;
        List result;
        CountedResult activities;
        ActivitiesProvider provider;
        OpenUserActivityState activityState = Arrays.stream(OpenUserActivityState.values()).filter(stateEnum -> stateEnum.getPath().equalsIgnoreCase(state)).findFirst().orElseThrow(IllegalArgumentException::new);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_OPEN_USER_ACTIVITIES).params(this.getOpenActivitiesAuditParams(activityState, processDefinitionIds, sortBy, sortDirection));
        switch (activityState) {
            case OPEN: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getOpenActivitiesAssignedToUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case NEW: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getNewActivitiesAssignedToUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case RUNNING: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getRunningActivitiesAssignedToUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case WAITING_TO_START: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getWaitingToStartActivitiesAssignedToUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case IN_SUBSTITUTION: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getActivitiesInSubstitutionAssignedToUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case EXCEEDED_DEADLINE: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getOpenActivitiesWithExceededDeadlineAssignedToUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            default: {
                auditBuilder.buildFailure(request);
                throw new IllegalArgumentException("Unsupported enum value " + activityState);
            }
        }
        String userName = SessionUtils.getLoggedUserName();
        try {
            activities = provider.getActivities(userName, processDefinitionIds, start, limit, sortBy, sortDirection);
            Locale locale = LocaleContextHolder.getLocale();
            result = activities.getData().parallelStream().map(userActivity -> this.userActivityMapper.toUserActivityDto(userActivity, locale)).collect(Collectors.toList());
        }
        catch (Exception e) {
            if (!gadget) {
                auditBuilder.buildFailure(request);
            }
            throw e;
        }
        boolean bl = isCacheRequest = limit != null && limit >= 1000;
        if (!isCacheRequest && !gadget) {
            auditBuilder.buildSuccess(request);
        }
        CountedResult results = new CountedResult(activities.getTotal(), result);
        SequentialActivityProvider sequentialActivityProvider = (begin, end) -> this.sequentialActivityUserActivitiesMapper.mapOpenActivities((List)Exceptions.sneakyThrows(() -> provider.getActivities(userName, processDefinitionIds, begin, end, sortBy, sortDirection).getData()));
        this.cacheSequentialActivities((CountedResult<UserActivityDto>)results, start, limit, request.getSession(false).getId(), sequentialActivityProvider, true);
        return results;
    }

    @RequestMapping(value={"my/open/{state}/count"})
    @ResponseBody
    public Long countOpenActivitiesAssignedToUserForState(@PathVariable String state, @RequestParam(required=false, defaultValue="") List<String> processDefinitionIds) {
        ActivitiesCounter counter;
        OpenUserActivityState activityState = Arrays.stream(OpenUserActivityState.values()).filter(stateEnum -> stateEnum.getPath().equalsIgnoreCase(state)).findFirst().orElseThrow(IllegalArgumentException::new);
        switch (activityState) {
            case OPEN: {
                counter = (arg_0, arg_1) -> ((ActivityService)this.activityService).countOpenActivitiesAssignedToUser(arg_0, arg_1);
                break;
            }
            case NEW: {
                counter = (arg_0, arg_1) -> ((ActivityService)this.activityService).countNewActivitiesAssignedToUser(arg_0, arg_1);
                break;
            }
            case RUNNING: {
                counter = (arg_0, arg_1) -> ((ActivityService)this.activityService).countRunningActivitiesAssignedToUser(arg_0, arg_1);
                break;
            }
            case WAITING_TO_START: {
                counter = (arg_0, arg_1) -> ((ActivityService)this.activityService).countWaitingToStartActivitiesAssignedToUser(arg_0, arg_1);
                break;
            }
            case IN_SUBSTITUTION: {
                counter = (arg_0, arg_1) -> ((ActivityService)this.activityService).countActivitiesInSubstitutionAssignedToUser(arg_0, arg_1);
                break;
            }
            case EXCEEDED_DEADLINE: {
                counter = (arg_0, arg_1) -> ((ActivityService)this.activityService).countOpenActivitiesWithExceededDeadlineAssignedToUser(arg_0, arg_1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported enum value " + activityState);
            }
        }
        String userName = SessionUtils.getLoggedUserName();
        return counter.countActivities(userName, processDefinitionIds);
    }

    @RequestMapping(value={"my/finished/{state}"})
    @ResponseBody
    public CountedResult<UserActivityDto> getFinishedActivitiesForUserAndState(HttpServletRequest request, @PathVariable String state, @RequestParam(required=false, defaultValue="") List<String> processDefinitionIds, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="activityDate") String sortBy, @RequestParam(required=false, defaultValue="DESC") SortDirection sortDirection) {
        boolean isCacheRequest;
        List result;
        CountedResult activities;
        ActivitiesProvider provider;
        FinishedUserActivityState finishedActivityState = Arrays.stream(FinishedUserActivityState.values()).filter(stateEnum -> stateEnum.getPath().equalsIgnoreCase(state)).findFirst().orElseThrow(IllegalArgumentException::new);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_OPEN_USER_FINISHED_ACTIVITIES).params(this.getFinishedActivitiesAuditParams(finishedActivityState, processDefinitionIds, sortBy, sortDirection));
        switch (finishedActivityState) {
            case FINISHED: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getAllFinishedActivitiesForUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case FAILED: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getFailedFinishedActivitiesForUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case SUCCESSFUL: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getSuccessfulFinishedActivitiesForUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case PROCESSING: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getProcessingFinishedActivitiesForUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            default: {
                auditBuilder.buildFailure(request);
                throw new IllegalArgumentException("Unsupported enum value " + finishedActivityState);
            }
        }
        String userName = SessionUtils.getLoggedUserName();
        try {
            activities = provider.getActivities(userName, processDefinitionIds, start, limit, sortBy, sortDirection);
            Locale locale = LocaleContextHolder.getLocale();
            result = activities.getData().parallelStream().map(userActivity -> this.userActivityMapper.toUserActivityDto(userActivity, locale)).collect(Collectors.toList());
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        boolean bl = isCacheRequest = limit != null && limit >= 1000;
        if (!isCacheRequest) {
            auditBuilder.buildSuccess(request);
        }
        CountedResult results = new CountedResult(activities.getTotal(), result);
        SequentialActivityProvider sequentialActivityProvider = (begin, end) -> this.sequentialActivityUserActivitiesMapper.mapFinishedActivities((List)Exceptions.sneakyThrows(() -> provider.getActivities(userName, processDefinitionIds, begin, end, sortBy, sortDirection).getData()));
        this.cacheSequentialActivities((CountedResult<UserActivityDto>)results, start, limit, request.getSession(false).getId(), sequentialActivityProvider, false);
        return results;
    }

    @RequestMapping(value={"my/finished/{state}/count"})
    @ResponseBody
    public Long countFinishedActivitiesForUserAndState(@PathVariable String state, @RequestParam(required=false, defaultValue="") List<String> processDefinitionIds) {
        ActivitiesCounter counter;
        FinishedUserActivityState finishedActivityState = Arrays.stream(FinishedUserActivityState.values()).filter(stateEnum -> stateEnum.getPath().equalsIgnoreCase(state)).findFirst().orElseThrow(IllegalArgumentException::new);
        switch (finishedActivityState) {
            case FINISHED: {
                counter = (arg_0, arg_1) -> ((ActivityService)this.activityService).countAllFinishedActivitiesForUser(arg_0, arg_1);
                break;
            }
            case FAILED: {
                counter = (arg_0, arg_1) -> ((ActivityService)this.activityService).countFailedFinishedActivitiesForUser(arg_0, arg_1);
                break;
            }
            case SUCCESSFUL: {
                counter = (arg_0, arg_1) -> ((ActivityService)this.activityService).countSuccessfulFinishedActivitiesForUser(arg_0, arg_1);
                break;
            }
            case PROCESSING: {
                counter = (arg_0, arg_1) -> ((ActivityService)this.activityService).countProcessingFinishedActivitiesForUser(arg_0, arg_1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported enum value " + finishedActivityState);
            }
        }
        String userName = SessionUtils.getLoggedUserName();
        return counter.countActivities(userName, processDefinitionIds);
    }

    @RequestMapping(value={"my/open/{state}/processTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProcessTypeDto> getProcessTypesForActivities(HttpServletRequest request, @PathVariable String state) {
        ActivitiesProcessDefIdsProvider provider;
        OpenUserActivityState activityState = Arrays.stream(OpenUserActivityState.values()).filter(stateEnum -> stateEnum.getPath().equalsIgnoreCase(state)).findFirst().orElseThrow(IllegalArgumentException::new);
        switch (activityState) {
            case OPEN: {
                provider = arg_0 -> ((ActivityService)this.activityService).getProcessDefIdsForOpenActivitiesAssignedToUser(arg_0);
                break;
            }
            case NEW: {
                provider = arg_0 -> ((ActivityService)this.activityService).getProcessDefIdsForNewActivitiesAssignedToUser(arg_0);
                break;
            }
            case RUNNING: {
                provider = arg_0 -> ((ActivityService)this.activityService).getProcessDefIdsForRunningActivitiesAssignedToUser(arg_0);
                break;
            }
            case WAITING_TO_START: {
                provider = arg_0 -> ((ActivityService)this.activityService).getProcessDefIdsForWaitingToStartActivitiesAssignedToUser(arg_0);
                break;
            }
            case IN_SUBSTITUTION: {
                provider = arg_0 -> ((ActivityService)this.activityService).getProcessDefIdsForActivitiesInSubstitutionAssignedToUser(arg_0);
                break;
            }
            case EXCEEDED_DEADLINE: {
                provider = arg_0 -> ((ActivityService)this.activityService).getProcessDefIdsForActivitiesWithExceededDeadlineAssignedToUser(arg_0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported enum value " + activityState);
            }
        }
        String userName = SessionUtils.getLoggedUserName();
        List<String> processDefIds = provider.getProcessDefIds(userName);
        I18Nxpdl xpdlTranslator = new I18Nxpdl(request);
        return this.processService.getProcessTypesForProcessDefIds(processDefIds).stream().map(processType -> {
            String translatedName = xpdlTranslator.getString(XpdlKey.forPackage((String)processType.getPackageId()).forProcess(processType.getProcessDefId()).getKey());
            String translatedDescription = xpdlTranslator.getString(XpdlKey.forPackage((String)processType.getPackageId()).forProcess(processType.getProcessDefId()).getKeyDesc());
            return ProcessTypeDto.builder().name(processType.getName()).translatedName(translatedName).description(processType.getDescription()).translatedDescription(translatedDescription).packageId(processType.getPackageId()).processDefId(processType.getProcessDefId()).abbreviation(processType.getTranslatedAbbreviation()).color(processType.getIconColor()).build();
        }).sorted((proc1, proc2) -> proc1.getTranslatedName().compareToIgnoreCase(proc2.getTranslatedName())).collect(Collectors.toList());
    }

    @RequestMapping(value={"my/finished/{state}/processTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProcessTypeDto> getProcessTypesForFinishedActivities(HttpServletRequest request, @PathVariable String state) {
        FinishedActivitiesProcessDefIdsProvider provider;
        FinishedUserActivityState finishedActivityState = Arrays.stream(FinishedUserActivityState.values()).filter(stateEnum -> stateEnum.getPath().equalsIgnoreCase(state)).findFirst().orElseThrow(IllegalArgumentException::new);
        switch (finishedActivityState) {
            case FINISHED: {
                provider = arg_0 -> ((ActivityService)this.activityService).getProcessDefIdsForAllFinishedActivities(arg_0);
                break;
            }
            case FAILED: {
                provider = arg_0 -> ((ActivityService)this.activityService).getProcessDefIdsForFailedFinishedActivities(arg_0);
                break;
            }
            case SUCCESSFUL: {
                provider = arg_0 -> ((ActivityService)this.activityService).getProcessDefIdsForSuccessfulFinishedActivities(arg_0);
                break;
            }
            case PROCESSING: {
                provider = arg_0 -> ((ActivityService)this.activityService).getProcessDefIdsForProcessingFinishedActivities(arg_0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported enum value " + finishedActivityState);
            }
        }
        String userName = SessionUtils.getLoggedUserName();
        List<String> processDefIds = provider.getProcessDefIds(userName);
        I18Nxpdl xpdlTranslator = new I18Nxpdl(request);
        return this.processService.getProcessTypesForProcessDefIds(processDefIds).stream().map(processType -> {
            String translatedName = xpdlTranslator.getString(XpdlKey.forPackage((String)processType.getPackageId()).forProcess(processType.getProcessDefId()).getKey());
            String translatedDescription = xpdlTranslator.getString(XpdlKey.forPackage((String)processType.getPackageId()).forProcess(processType.getProcessDefId()).getKeyDesc());
            return ProcessTypeDto.builder().name(processType.getName()).translatedName(translatedName).description(processType.getDescription()).translatedDescription(translatedDescription).packageId(processType.getPackageId()).processDefId(processType.getProcessDefId()).abbreviation(processType.getTranslatedAbbreviation()).color(processType.getIconColor()).build();
        }).sorted((proc1, proc2) -> proc1.getTranslatedName().compareToIgnoreCase(proc2.getTranslatedName())).collect(Collectors.toList());
    }

    @RequestMapping(value={"my/open/{state}/export/{extension}", "my/finished/{state}/export/{extension}"}, method={RequestMethod.POST})
    @ResponseBody
    public URI exportOpenActivities(HttpServletRequest request, @RequestBody List<UserActivityDto> activities, @PathVariable String state, @PathVariable String extension) {
        return this.getRedirectUri(request, activities);
    }

    @RequestMapping(value={"my/open/{state}/export/{extension}"})
    @ResponseBody
    public void exportOpenActivitiesAssignedToUser(HttpServletResponse response, @PathVariable String state, @PathVariable String extension, @RequestParam(required=false, defaultValue="") List<String> processDefinitionIds, @RequestParam(required=false, defaultValue="activityDate") String sortBy, @RequestParam(required=false, defaultValue="DESC") SortDirection sortDirection, @RequestParam(required=false) UUID id) throws IOException {
        List<Object> activities;
        ActivitiesProvider provider;
        OpenUserActivityState activityState = Arrays.stream(OpenUserActivityState.values()).filter(stateEnum -> stateEnum.getPath().equalsIgnoreCase(state)).findFirst().orElseThrow(IllegalArgumentException::new);
        switch (activityState) {
            case OPEN: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getOpenActivitiesAssignedToUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case NEW: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getNewActivitiesAssignedToUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case RUNNING: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getRunningActivitiesAssignedToUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case WAITING_TO_START: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getWaitingToStartActivitiesAssignedToUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case IN_SUBSTITUTION: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getActivitiesInSubstitutionAssignedToUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case EXCEEDED_DEADLINE: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getOpenActivitiesWithExceededDeadlineAssignedToUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported enum value " + activityState);
            }
        }
        if (id == null) {
            String userName = SessionUtils.getLoggedUserName();
            Locale locale = LocaleContextHolder.getLocale();
            CountedResult countedResult = provider.getActivities(userName, processDefinitionIds, null, null, sortBy, sortDirection);
            activities = countedResult.getData().parallelStream().map(userActivity -> this.userActivityMapper.toUserActivityDto(userActivity, locale)).collect(Collectors.toList());
        } else {
            activities = this.getCachedActivities(id);
        }
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_procesu")).data(activities).by(UserActivityDto::getProcessName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis_procesu")).data(activities).by(UserActivityDto::getProcessDescription).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Zadanie")).data(activities).by(UserActivityDto::getActivityName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Pola_procesu")).data(activities).by(activity -> this.userActivityMapper.formatProcessFields(activity.getProcessFields(), extension)).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Data_przyjscia")).data(activities).by(activity -> this.dateFormat.format(activity.getActivityDate())).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Wykonawca")).data(activities).by(activity -> this.userActivityMapper.formatAssignees(activity.getAssignees())).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Twoje_zadania")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"my/finished/{state}/export/{extension}"})
    @ResponseBody
    public void exportFinishedActivitiesAssignedToUser(HttpServletResponse response, @PathVariable String state, @PathVariable String extension, @RequestParam(required=false, defaultValue="") List<String> processDefinitionIds, @RequestParam(required=false, defaultValue="activityDate") String sortBy, @RequestParam(required=false, defaultValue="DESC") SortDirection sortDirection, @RequestParam(required=false) UUID id) throws IOException {
        List<Object> activities;
        ActivitiesProvider provider;
        FinishedUserActivityState finishedActivityState = Arrays.stream(FinishedUserActivityState.values()).filter(stateEnum -> stateEnum.getPath().equalsIgnoreCase(state)).findFirst().orElseThrow(IllegalArgumentException::new);
        switch (finishedActivityState) {
            case FINISHED: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getAllFinishedActivitiesForUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case FAILED: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getFailedFinishedActivitiesForUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case SUCCESSFUL: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getSuccessfulFinishedActivitiesForUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            case PROCESSING: {
                provider = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ActivityService)this.activityService).getProcessingFinishedActivitiesForUser(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported enum value " + finishedActivityState);
            }
        }
        if (id == null) {
            String userName = SessionUtils.getLoggedUserName();
            Locale locale = LocaleContextHolder.getLocale();
            CountedResult countedResult = provider.getActivities(userName, processDefinitionIds, null, null, sortBy, sortDirection);
            activities = countedResult.getData().parallelStream().map(userActivity -> this.userActivityMapper.toUserActivityDto(userActivity, locale)).collect(Collectors.toList());
        } else {
            activities = this.getCachedActivities(id);
        }
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_procesu")).data(activities).by(UserActivityDto::getProcessName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis_procesu")).data(activities).by(UserActivityDto::getProcessDescription).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Zadanie")).data(activities).by(UserActivityDto::getActivityName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Status_zadania")).data(activities).by(activity -> this.messageHelper.getMessage("UserActivityStatus_" + activity.getStatus().name())).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Pola_procesu")).data(activities).by(activity -> this.userActivityMapper.formatProcessFields(activity.getProcessFields(), extension)).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Data")).data(activities).by(activity -> this.dateFormat.format(activity.getActivityDate())).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Twoje_zadania")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @ResponseBody
    @RequestMapping(value={"next/update"}, method={RequestMethod.PUT})
    public RestResult updatePlusNextCache(HttpServletRequest request, @RequestBody List<ActivityMetaDto> activities) {
        try {
            SequentialCacheKeyUserActivities sequentialCacheKeyId = new SequentialCacheKeyUserActivities(request.getSession(false).getId());
            if (this.sequentialActivityCache.isCached((SequentialCacheKeyId)sequentialCacheKeyId, SequentialCacheSourceType.USER_ACTIVITIES).booleanValue()) {
                this.sequentialActivityCache.invalidate((SequentialCacheKeyId)sequentialCacheKeyId, SequentialCacheSourceType.USER_ACTIVITIES);
            }
            if (!activities.isEmpty()) {
                this.sequentialActivityCache.cacheResults((SequentialCacheKeyId)sequentialCacheKeyId, SequentialCacheSourceType.USER_ACTIVITIES, null, 0, activities.size(), this.sequentialActivityUserActivitiesMapper.map(activities.stream().map(activity -> new UserActivitySequentialMeta(activity.getProcessId(), activity.getActivityId(), this.isActivityOpen(activity.getActivityState()))).collect(Collectors.toList())));
            }
            return new RestResult(true);
        }
        catch (Exception e) {
            log.error("Wystapi\u0142 b\u0142\u0105d podczas wczytawania danych dla wtyczki PlusNext", (Throwable)e);
            return new RestResult(false);
        }
    }

    private URI getRedirectUri(HttpServletRequest request, List<UserActivityDto> activities) {
        UUID id;
        while (this.exportCache.containsKey(id = UUID.randomUUID())) {
        }
        this.exportCache.put(id, activities);
        URI redirectUri = URI.create(request.getRequestURI());
        redirectUri = redirectUri.getQuery() != null ? URI.create(request.getRequestURI() + String.format("&id=%s", id)) : URI.create(request.getRequestURI() + String.format("?id=%s", id));
        return redirectUri;
    }

    private List<UserActivityDto> getCachedActivities(UUID id) {
        List<UserActivityDto> activitiesToExport = this.exportCache.get(id);
        this.exportCache.remove(id);
        return activitiesToExport;
    }

    private boolean isActivityOpen(String status) {
        UserActivityStatus userActivityStatus = UserActivityStatus.valueOf((String)status);
        return userActivityStatus == UserActivityStatus.OPEN_NOT_STARTED || userActivityStatus == UserActivityStatus.OPEN_RUNNING;
    }

    private void cacheSequentialActivities(CountedResult<UserActivityDto> results, Integer start, Integer limit, String sessionId, SequentialActivityProvider provider, boolean isOpen) {
        SequentialCacheKeyUserActivities sequentialCacheKeyId = new SequentialCacheKeyUserActivities(sessionId);
        if (this.sequentialActivityCache.isCached((SequentialCacheKeyId)sequentialCacheKeyId, SequentialCacheSourceType.USER_ACTIVITIES).booleanValue()) {
            this.sequentialActivityCache.invalidate((SequentialCacheKeyId)sequentialCacheKeyId, SequentialCacheSourceType.USER_ACTIVITIES);
        }
        if (results.getTotal() > 1000L) {
            this.sequentialActivityCache.cacheResults((SequentialCacheKeyId)sequentialCacheKeyId, SequentialCacheSourceType.USER_ACTIVITIES, provider, start.intValue(), limit.intValue(), this.sequentialActivityUserActivitiesMapper.map(results.getData().stream().map(activity -> new UserActivitySequentialMeta(activity.getProcessId(), activity.getActivityId(), isOpen)).collect(Collectors.toList())));
        }
    }

    private ImmutableMap<String, Object> getOpenActivitiesAuditParams(OpenUserActivityState activityState, List<String> processDefinitionIds, String sortBy, SortDirection sortDirection) {
        return ImmutableMap.of((Object)"state", (Object)activityState.name(), (Object)"processDefinitionIds", processDefinitionIds, (Object)"sortBy", (Object)sortBy, (Object)"sortDirection", (Object)sortDirection);
    }

    private Map<String, Object> getFinishedActivitiesAuditParams(FinishedUserActivityState finishedActivityState, List<String> processDefinitionIds, String sortBy, SortDirection sortDirection) {
        return ImmutableMap.of((Object)"state", (Object)finishedActivityState.name(), (Object)"processDefinitionIds", processDefinitionIds, (Object)"sortBy", (Object)sortBy, (Object)"sortDirection", (Object)sortDirection);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleIllegalArgumentException(Exception e) {
        return new RestResult(false, e.getMessage());
    }

    @FunctionalInterface
    static interface FinishedActivitiesProcessDefIdsProvider {
        public List<String> getProcessDefIds(String var1);
    }

    @FunctionalInterface
    static interface ActivitiesProcessDefIdsProvider {
        public List<String> getProcessDefIds(String var1);
    }
}

