/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.activity;

import com.plusmpm.enhydra.shark.WfActivityManager;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.struts.form.AdvanceVariableForm;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.search.AdvanceVariableFormBuilder;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.dto.activity.AcceptAllActivityDto;
import com.suncode.pwfl.web.dto.activity.ProcessIdActivityIdPairDto;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.support.form.cache.SearchFormCache;
import com.suncode.pwfl.web.util.JsonMessage;
import com.suncode.pwfl.workflow.view.ExtendedViewEvaluator;
import com.suncode.pwfl.workflow.view.ViewResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/activities"})
public class AcceptAllActivityController {
    @Autowired
    SearchFormCache searchFormCache;
    @Autowired
    AdvanceVariableFormBuilder advanceVariableFormBuilder;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"accept/view/{viewId}/search/{searchId}"})
    @ResponseBody
    public AcceptAllActivityDto getActivitiesFromView(@PathVariable String viewId, @PathVariable String searchId, HttpServletRequest request) throws IOException {
        void var5_8;
        ExtendedViewEvaluator extendedViewEvaluator = (ExtendedViewEvaluator)SpringContext.getBean(ExtendedViewEvaluator.class);
        if (StringUtils.isNotBlank((CharSequence)searchId)) {
            Optional<SearchFormModelDto> searchForm = this.searchFormCache.getSearchFormFromCache(searchId);
            if (!searchForm.isPresent()) throw new IllegalArgumentException("Search form is not cached");
            List<AdvanceVariableForm> list = Arrays.asList(this.advanceVariableFormBuilder.buildAdvanceFormVariables(searchForm.get()));
        } else {
            ArrayList arrayList = new ArrayList();
        }
        ViewResult viewResult = extendedViewEvaluator.evaluate(Long.valueOf(viewId), 0, 0, null, (List)var5_8, Boolean.valueOf(true));
        List<ProcessIdActivityIdPairDto> data = viewResult.getRows().getData().stream().map(row -> new ProcessIdActivityIdPairDto(row.getProcessId(), row.getActivityId())).distinct().collect(Collectors.toList());
        return new AcceptAllActivityDto(data.size(), data, "");
    }

    @RequestMapping(value={"accept/all"}, method={RequestMethod.POST}, consumes={"application/json"})
    public ResponseEntity<JsonMessage> acceptAllActivities(HttpServletRequest request, @RequestBody AcceptAllActivityDto activitiesToAccept) throws Throwable {
        HttpSession session = request.getSession(false);
        JsonMessage response = new JsonMessage();
        Date started = new Date();
        List<ProcessIdActivityIdPairDto> processIdActivityIdPairs = activitiesToAccept.getProcessIdActivityIdPairs();
        String acceptButtonActionName = activitiesToAccept.getAcceptButtonActionName();
        String processActivityId = "";
        try {
            Assert.notEmpty(processIdActivityIdPairs, (String)"Brak identyfikator\u00f3w [proces;zadanie].");
            Assert.hasLength((String)acceptButtonActionName);
            ProcessIdActivityIdPairDto firstPair = processIdActivityIdPairs.get(0);
            processActivityId = firstPair.getProcessId() + ";" + firstPair.getActivityId();
            String userName = (String)session.getAttribute("username");
            for (ProcessIdActivityIdPairDto processIdActivityIdPair : processIdActivityIdPairs) {
                WfActivityManager wfActivityManager = new WfActivityManager(processIdActivityIdPair.getActivityId(), processIdActivityIdPair.getProcessId(), userName, acceptButtonActionName);
                wfActivityManager.setIgnoreOwnership(true);
                wfActivityManager.setXpdl(new I18Nxpdl(LocaleContextHolder.getLocale()));
                wfActivityManager.acceptActivity();
            }
        }
        catch (Exception e) {
            response.setErrorMsg(MessageHelper.getMessage((String)"Wystapil_blad_podczas_grupowej_akceptacji_zadan"));
            response.setSuccess(false);
            this.logAudit(false, processActivityId, acceptButtonActionName, processIdActivityIdPairs.size(), started);
            return new ResponseEntity((Object)response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        this.logAudit(true, processActivityId, acceptButtonActionName, processIdActivityIdPairs.size(), started);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    private void logAudit(boolean success, String processActivityIds, String buttonName, Integer numberOfAcceptedTasks, Date started) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processActivityIds", processActivityIds);
        params.put("acceptButtonActionName", buttonName);
        params.put("acceptFromAllPages", "TRUE");
        params.put("numberOfAcceptedTasks", numberOfAcceptedTasks);
        ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_ACCEPT_MANY_ACTIVITIES).success(success).params(params).started(started).stopped(new Date()).build().log();
    }
}

