/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.system;

import com.suncode.pwfl.SystemVersion;
import com.suncode.pwfl.administration.system.SystemPropertiesHelper;
import com.suncode.pwfl.web.ui.SkinRegistry;
import com.suncode.pwfl.web.ui.skin.Skin;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"system"})
public class SystemMetadataController {
    @Autowired
    private SystemPropertiesHelper systemPropertiesHelper;
    @Autowired
    private SkinRegistry skinRegistry;

    @ResponseBody
    @RequestMapping(value={"parameters/supportedLanguages"})
    List<String> getSupportedLanguagesParameter() {
        return this.systemPropertiesHelper.getSupportedLanguagesParameter();
    }

    @ResponseBody
    @RequestMapping(value={"parameters/supportedLocales"})
    Map<Locale, String> getSupportedLocales() {
        return this.systemPropertiesHelper.getSupportedLocales();
    }

    @ResponseBody
    @RequestMapping(value={"version"})
    String getSystemVersion() {
        return SystemVersion.getVersionIdentifier();
    }

    @ResponseBody
    @RequestMapping(value={"supportedSkins"})
    Map<String, String> getSupportedSkins() {
        return this.skinRegistry.getAllSkins().stream().collect(Collectors.toMap(Skin::getKey, skin -> skin.getName().get()));
    }
}

