/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks;

import com.plusmpm.database.scheduledTasks.ScheduledTaskHistory;
import com.plusmpm.database.scheduledTasks.dao.ScheduledTaskHistoryDAO;
import com.suncode.pwfl.administration.scheduledtask.file.ScheduledTaskResultFileHelper;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ScheduledTaskHistoryDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"scheduledtasks/history"})
public class ScheduledTaskHistoryController {
    private static final Logger log = LoggerFactory.getLogger(ScheduledTaskHistoryController.class);
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private ScheduledTaskResultFileHelper scheduledTaskResultFileHelper;

    @RequestMapping(value={"by/task"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ScheduledTaskHistoryDto> getHistoryByTaskId(@RequestParam Long taskId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return (CountedResult)TransactionWrapper.get().doInHibernateTransaction(session -> {
            List historyEntries = ScheduledTaskHistoryDAO.getByTaskId((Long)taskId, (int)(start == null ? 0 : start), (int)(limit == null ? 0 : limit));
            List historyDtoList = historyEntries.stream().map(historyEntity -> {
                List resultFiles = this.scheduledTaskResultFileHelper.getResultFiles(historyEntity);
                return new ScheduledTaskHistoryDto((ScheduledTaskHistory)historyEntity, resultFiles);
            }).collect(Collectors.toList());
            Long count = ScheduledTaskHistoryDAO.getByTaskIdCount((Long)taskId);
            return new CountedResult(count.longValue(), historyDtoList);
        });
    }
}

