/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.report;

import com.plusmpm.util.reports.ReportPermissions;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.report.exception.ReportNotFoundException;
import com.suncode.pwfl.report.export.ReportExportService;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"report"})
public class ReportController {
    private static final Logger log = LoggerFactory.getLogger(ReportController.class);
    private final ReportExportService reportExportService;

    @RequestMapping(value={"{reportId}/export/{extension}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> exportReport(HttpServletResponse response, @PathVariable Long reportId, @PathVariable String extension) throws IOException {
        String userName = UserContext.current().getUser().getUserName();
        if (!ReportPermissions.reportPermissions((String)userName, (String)String.valueOf(reportId))) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        try {
            ExportExtension exportExtension = ExportExtension.valueOf((String)extension.toUpperCase());
            String fileName = "raport." + exportExtension.getExtension();
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", fileName));
            this.reportExportService.exportReport(reportId, exportExtension, (OutputStream)response.getOutputStream());
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (ReportNotFoundException e) {
            log.info(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.NOT_FOUND);
        }
    }

    @ConstructorProperties(value={"reportExportService"})
    @Autowired
    public ReportController(ReportExportService reportExportService) {
        this.reportExportService = reportExportService;
    }
}

