/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class AddUserFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(AddUserFormatter.class);
    private final String userIdKey = "userId";
    private final String userFirstNameKey = "userFirstName";
    private final String userLastNameKey = "userLastName";
    private final String userEmailKey = "userEmail";
    private final String userNumberKey = "userNumber";
    private final String userGroupNameKey = "userGroupName";
    private final String userPositionsNameKey = "userPositionsName";
    private final String selfPasswordAssignKey = "selfPasswordAssign";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String userId = map.get("userId");
            String userFirstName = map.get("userFirstName");
            String userLastName = map.get("userLastName");
            String userEmail = map.get("userEmail");
            String userNumber = map.get("userNumber");
            String userGroupName = map.get("userGroupName");
            String userPositionsName = map.get("userPositionsName");
            String selfPasswordAssign = map.get("selfPasswordAssign");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.USERNAME.toString(), userId);
            formattedMap.put(AuditParamsNames.USERFIRSTNAME.toString(), userFirstName);
            formattedMap.put(AuditParamsNames.USERLASTNAME.toString(), userLastName);
            formattedMap.put(AuditParamsNames.USEREMAIL.toString(), userEmail);
            formattedMap.put(AuditParamsNames.USERNUMBER.toString(), userNumber);
            formattedMap.put(AuditParamsNames.USERGROUPNAME.toString(), userGroupName);
            formattedMap.put(AuditParamsNames.USERPOSITIONSNAME.toString(), userPositionsName);
            formattedMap.put(AuditParamsNames.SELFPASSWORDASSIGN.toString(), this.translateBooleanValue(selfPasswordAssign, LocaleContextHolder.getLocale()));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

