/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.workflow.activities.ActivityMisc;
import com.plusmpm.util.ActivityAssignment;
import com.plusmpm.util.UsersManagement;
import com.suncode.pwfl.administration.user.UserInfoCache;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.activity.sequential.cache.SequentialActivityCache;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ForwardingActionForward;
import org.displaytag.util.ParamEncoder;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowWorkListAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(ShowWorkListAction.class);
    private static SequentialActivityCache sequentialActivityCache = (SequentialActivityCache)SpringContext.getBean(SequentialActivityCache.class);
    private boolean refreshActivities;
    private String activityState;

    public ShowWorkListAction() {
    }

    public ShowWorkListAction(boolean refreshActivities, String activityState) {
        this.refreshActivities = refreshActivities;
        this.activityState = activityState;
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.trace("******************** ShowWorkListAction ********************");
        HttpSession session = request.getSession(false);
        sequentialActivityCache.invalidate(session.getId());
        String username = (String)session.getAttribute("username");
        if (username != null && UserInfoCache.get().get(username).isAnonymous()) {
            return new ForwardingActionForward("/ShowUserDefaultView.do");
        }
        String redirectParameter = request.getParameter("redirect");
        if (redirectParameter != null && redirectParameter.equals("ShowCalendar.do")) {
            return this.getActionForwardForCalendar(mapping, form, request, response, session);
        }
        request.setAttribute("activeTab", (Object)"ShowWorkListAction.do");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)request.getParameter("refreshActivities")) || this.refreshActivities || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)request.getParameter("activityState")) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.activityState)) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)request.getParameter("refreshActivities")) && request.getParameter("refreshActivities").equalsIgnoreCase("true") || this.refreshActivities) {
                session.setAttribute("refreshActivities", (Object)true);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)request.getParameter("activityState")) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.activityState)) {
                String activityStateValue = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)request.getParameter("activityState")) ? request.getParameter("activityState") : this.activityState;
                session.setAttribute("activityState", (Object)activityStateValue);
            }
            return new ActionForward("/ShowWorkListAction.do", true);
        }
        return mapping.findForward("userActivitiesList");
    }

    private ActionForward getActionForwardForCalendar(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, HttpSession session) throws BaseException {
        String sVal;
        String sExternalClick = (String)session.getAttribute("externalClick");
        if (sExternalClick != null && sExternalClick.compareToIgnoreCase("ShowWorkList") == 0) {
            session.setAttribute("externalClick", null);
        }
        String userName = (String)session.getAttribute("username");
        boolean bExport = false;
        int iPageSize = UsersManagement.getUserDefinedPageSize((String)userName);
        int iMaxPageSize = 0;
        int iOffset = -1;
        int iPageNr = -1;
        int iSortColumnNr = 0;
        int iSortOrderType = 0;
        String sOrderBy = "";
        log.debug("Assignment list starts");
        String activityDefId = request.getParameter("activityId");
        log.debug("activityDefId: " + activityDefId);
        String processDefId = request.getParameter("processKey");
        log.debug("processDefId: " + processDefId);
        String processName = request.getParameter("procName");
        log.debug("processName: " + processName);
        String sDate = request.getParameter("date");
        log.debug("date: " + sDate);
        try {
            String pageNr = new ParamEncoder("task").encodeParameterName("p");
            log.debug("pageNr:" + pageNr);
            sVal = request.getParameter(pageNr);
            log.debug("sVal:" + sVal);
            iPageNr = Integer.parseInt(sVal);
            iOffset = (iPageNr - 1) * iPageSize;
            if (iOffset < 0) {
                iOffset = 0;
            }
        }
        catch (Exception e) {
            log.debug("Blad, Brak paging");
        }
        try {
            String exportType = new ParamEncoder("task").encodeParameterName("e");
            log.debug("exportType:" + exportType);
            sVal = request.getParameter(exportType);
            log.debug("sVal:" + sVal);
            if (sVal != null) {
                bExport = true;
            }
        }
        catch (Exception e) {
            log.debug("Blad, brak exportu");
        }
        try {
            String sOrder = new ParamEncoder("task").encodeParameterName("o");
            String sSortColumnNr = new ParamEncoder("task").encodeParameterName("s");
            log.debug("sOrder:" + sOrder);
            String sOrderVal = request.getParameter(sOrder);
            String sSortColumnNrVal = request.getParameter(sSortColumnNr);
            log.debug("sOrderVal:" + sOrderVal);
            if (sOrderVal != null) {
                iSortOrderType = Integer.parseInt(sOrderVal);
                iSortColumnNr = Integer.parseInt(sSortColumnNrVal);
            } else {
                iSortOrderType = 1;
                iSortColumnNr = 3;
            }
        }
        catch (Exception e) {
            iSortOrderType = 1;
            iSortColumnNr = 3;
            log.warn("Blad, brak sort");
        }
        if (iSortOrderType != 0) {
            switch (iSortColumnNr) {
                case 0: {
                    sOrderBy = " ORDER BY procname ";
                    break;
                }
                case 1: {
                    sOrderBy = " ORDER BY procdescr ";
                    break;
                }
                case 2: {
                    sOrderBy = " ORDER BY actname ";
                    break;
                }
                case 3: {
                    sOrderBy = " ORDER BY actstarttime ";
                }
            }
            if (iSortOrderType == 2) {
                sOrderBy = sOrderBy + "ASC ";
            } else if (iSortOrderType == 1) {
                sOrderBy = sOrderBy + "DESC ";
            }
        }
        ArrayList<ActivityAssignment> assignments = new ArrayList<ActivityAssignment>();
        try {
            long startDate = 0L;
            if (StringUtils.isNotEmpty((String)sDate)) {
                startDate = Long.parseLong(sDate);
            }
            iMaxPageSize = ActivityMisc.countActivitiesAssignedToUser((String)userName, (long)startDate, (String)processDefId, (String)activityDefId);
            if (bExport) {
                iOffset = 0;
                iPageSize = iMaxPageSize;
            }
            List result = ActivityMisc.getActivitiesAssignedToUser((String)userName, (String)sOrderBy, (int)iOffset, (int)iPageSize, (long)startDate, (String)processDefId, (String)activityDefId);
            assignments = new ArrayList(result.size());
            for (Map resultElement : result) {
                String assgid = (String)resultElement.get("activid");
                String procid = (String)resultElement.get("procid");
                String procname = (String)resultElement.get("procname");
                String procdescr = (String)resultElement.get("procdescr");
                String actname = (String)resultElement.get("actname");
                Long actstarttime = (Long)resultElement.get("actstarttime");
                assignments.add(new ActivityAssignment(procid, procname, procdescr, assgid, actname, new Date(actstarttime), "ShowWorkListAction.do"));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.debug("Assignment list complete");
        String sRealName = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserRealName(userName);
        request.setAttribute("iMaxPageSize", (Object)new Integer(iMaxPageSize).toString());
        request.setAttribute("iPageSize", (Object)new Integer(iPageSize).toString());
        request.setAttribute("realusername", (Object)sRealName);
        request.setAttribute("assignments", assignments);
        request.setAttribute("activeTab", (Object)"ShowWorkListAction.do");
        return mapping.findForward("assignmentList");
    }
}

