/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.AdvanceSearchVariableTable;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.UserSearchViewTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.UsersManagement;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.view.ViewService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class GetUserViewsListAction
extends Action {
    public static Logger log = Logger.getLogger(GetUserViewsListAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info((Object)"******************************GetUserViewsListAction********************");
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("username") == null) {
            return mapping.findForward("disconnect");
        }
        String sUserName = (String)session.getAttribute("username");
        String sSource = request.getParameter("source");
        DBManagement dbm = new DBManagement();
        ArrayList<UserSearchViewTable> alUserViews = null;
        int iAdmRight = -1;
        try {
            iAdmRight = Authorization.checkRight((String)"System", (String)sUserName, (boolean)false, (boolean)false);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            iAdmRight = -1;
        }
        if (iAdmRight == 0) {
            alUserViews = dbm.GetAllUserSearchViews();
            request.setAttribute("showAllViews", (Object)true);
        } else {
            alUserViews = this.getFilteredUserViews(sUserName, sSource);
            request.setAttribute("showAllViews", (Object)false);
        }
        ViewService viewService = ServiceFactory.getViewService();
        for (UserSearchViewTable userView : alUserViews) {
            userView.setViewDescr(viewService.getViewTranslation(userView.getId(), TranslatedFieldType.DESCRIPTION));
            userView.setViewName(viewService.getViewTranslation(userView.getId(), TranslatedFieldType.NAME));
        }
        int pageSize = UsersManagement.getUserDefinedPageSize((String)sUserName);
        request.setAttribute("iPageSize", (Object)String.valueOf(pageSize));
        request.setAttribute("iMaxPageSize", (Object)String.valueOf(alUserViews.size()));
        request.setAttribute("alUserViews", alUserViews);
        return mapping.findForward("showUserViewList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<UserSearchViewTable> getFilteredUserViews(String sUserName, String sSource) {
        DBManagement dbm = new DBManagement();
        Connection con = null;
        ArrayList alUserViews = dbm.GetAllUserSearchViewsForUserSource(sUserName, sSource);
        try {
            con = DBUtils.connectToDB();
            for (int i = alUserViews.size() - 1; i >= 0; --i) {
                String sViewId = ((UserSearchViewTable)alUserViews.get(i)).getId().toString();
                AdvanceSearchVariableTable viewVariable = dbm.getAdvanceSearchVariableByNameAndViewId("procDefId", sViewId);
                String viewProcDefId = viewVariable.getValue();
                if (!this.hasRight(viewProcDefId, sUserName, con)) {
                    alUserViews.remove(i);
                    continue;
                }
                viewVariable = dbm.getAdvanceSearchVariableByNameAndViewId("processType", sViewId);
                viewProcDefId = viewVariable.getValue();
                if (this.hasRight(viewProcDefId, sUserName, con)) continue;
                alUserViews.remove(i);
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            DBUtils.closeConnection((Connection)con);
        }
        return alUserViews;
    }

    private boolean hasRight(String viewProcDefId, String sUserName, Connection con) throws SQLException {
        String rightLevel;
        return StringUtils.isEmpty((CharSequence)viewProcDefId) || Authorization.checkRight((Connection)con, (String)(rightLevel = RightTreeBuilder.builder().system().workflow().processes().view().custom((Object)viewProcDefId).build()), (String)sUserName, (boolean)false, (boolean)false) == 0;
    }
}

