/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.struts.action.AdvanceProcessSearchAction;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.language.LanguageUtils;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SharkUtils;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.enhydra.shark.api.client.wfmodel.WfProcess;

public class DeleteProcessAction
extends Action {
    public static Logger log = Logger.getLogger(DeleteProcessAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info((Object)"******************************DeleteProcessAction********************");
        HttpSession session = request.getSession(false);
        String sRealProcessName = "";
        String sProcessName = "";
        String processDefId = "";
        String processId = "";
        try {
            if (session == null || session.getAttribute("username") == null) {
                return mapping.findForward("welcome");
            }
            processId = request.getParameter("ProcessId");
            String userName = (String)session.getAttribute("username");
            processDefId = SharkFunctions.getProcessDefId((String)processId);
            if (this.hasRights(processDefId, userName)) {
                WfProcess wfProcess = SharkUtils.getExecutionAdministration().getProcess(processId);
                sProcessName = wfProcess.name();
                I18Nxpdl xpdl = new I18Nxpdl(request);
                sRealProcessName = LanguageUtils.getProcessName((I18Nxpdl)xpdl, (String)sProcessName, (String)processDefId);
                ProcessService ps = ServiceFactory.getProcessService();
                ps.deleteProcess(processId);
                session.setAttribute("processaction", (Object)"success");
                session.setAttribute("message", (Object)(MessageHelper.getMessage((String)"Proces") + " " + sRealProcessName + " " + MessageHelper.getMessage((String)"zostal_usuniety")));
                request.setAttribute("audit", (Object)this.buildAudit(true, processId, processDefId, sProcessName, new HashMap<String, Object>()));
            } else {
                session.setAttribute("processaction", (Object)"error");
                session.setAttribute("message", (Object)MessageHelper.getMessage((String)"Brak_uprawnien_aby_usunac_proces"));
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("ERROR_MESSAGE", MessageHelper.getMessage((String)"Brak_uprawnien_aby_usunac_proces"));
                request.setAttribute("audit", (Object)this.buildAudit(false, processId, processDefId, sProcessName, params));
                log.info((Object)"Nie mo\u017cna usun\u0105\u0107 procesu z powodu braku uprawnie\u0144 u\u017cytkownika");
            }
        }
        catch (Exception e) {
            log.warn((Object)("Exception:" + e.getLocalizedMessage()));
            session.setAttribute("processaction", (Object)"error");
            session.setAttribute("message", (Object)("" + MessageHelper.getMessage((String)"Blad_usuwania_procesu") + " " + sRealProcessName + ". " + MessageHelper.getMessage((String)"Przyczyna") + ":" + e.getLocalizedMessage()));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ERROR_MESSAGE", e.getLocalizedMessage());
            request.setAttribute("audit", (Object)this.buildAudit(false, processId, processDefId, sProcessName, params));
        }
        AdvanceProcessSearchAction advanceProcessSearchAction = new AdvanceProcessSearchAction();
        return advanceProcessSearchAction.execute(mapping, form, request, response);
    }

    private boolean hasRights(String processDefId, String userName) throws SQLException {
        int userRights = Authorization.checkRight((String)RightTreeBuilder.builder().system().workflow().processes().delete().custom((Object)processDefId).build(), (String)userName, (boolean)false, (boolean)false);
        return userRights >= 0;
    }

    private AuditWrapper buildAudit(boolean success, String processId, String processDefId, String processName, Map<String, Object> params) {
        String packageId = XpdlPackageManager.getInstance().getPackageIdByProcessDefinitionId(processDefId);
        params.put("processId", processId);
        params.put("package_name", packageId);
        params.put("processDefId", processDefId);
        params.put("process_name", processName);
        return AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PROCESS).success(success).params(params).build();
    }
}

